<?php

namespace Illuminate\Database\Eloquent\Relations;

/**
 * @template TRelatedModel of \Illuminate\Database\Eloquent\Model
 */
abstract class Relation
{
    /**
     * Execute the query as a "select" statement.
     *
     * @param array<int, string> $columns
     * @phpstan-return \Illuminate\Database\Eloquent\Collection<int, TRelatedModel>
     */
    public function get($columns = ['*']);


    /**
     * @param array<model-property<TRelatedModel>, mixed> $attributes
     * @phpstan-return TRelatedModel
     */
    public function make(array $attributes = []);
}
