<?php
if (!function_exists('swagger_ui_dist_path')) {
    /**
     * Returns swagger-ui composer dist path.
     *
     * @param string|null $asset
     *
     * @return string|false
     * @throws \Exception
     */
    function swagger_ui_dist_path(?string $asset = null)
    {
        $allowed_files = [
            'favicon-16x16.png',
            'favicon-32x32.png',
            'oauth2-redirect.html',
            'swagger-ui-bundle.js',
            'swagger-ui-bundle.js.map',
            'swagger-ui-standalone-preset.js',
            'swagger-ui-standalone-preset.js.map',
            'swagger-ui.css',
            'swagger-ui.css.map',
            'swagger-ui.js',
            'swagger-ui.js.map',
        ];
        $path          = cms_base_path('vendor/swagger-api/swagger-ui/dist/');
        if (!$asset) {
            return realpath($path);
        }
        if (!in_array($asset, $allowed_files)) {
            throw new \Exception(sprintf('(%s) - this Swagger asset is not allowed', $asset));
        }

        return realpath($path . $asset);
    }
}

if (!function_exists('inside_documentation_swagger_ui_asset')) {
    /**
     * Returns asset to documentation/swagger ui
     *
     * @param $asset string
     *
     * @return string
     * @throws \Exception
     */
    function inside_documentation_swagger_ui_asset(string $asset): string
    {
        $file = swagger_ui_dist_path($asset);
        if ($file === false || !file_exists($file)) {
            throw new \Exception(sprintf('Requested Swagger asset file (%s) does not exists', $asset));
        }

        return route('documentation.asset', ['asset' => $asset]) . '?v=' . md5_file($file);
    }
}
