<?php

namespace Inside\Documentation\Providers;

use Exception;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use Inside\Documentation\Console\Commands\CleanupTestsCommand;
use Inside\Documentation\Console\Commands\DocumentationCommand;
use Inside\Documentation\Services\Cypress;
use Inside\Support\EventServiceProvider;
use Inside\Support\Str;

/**
 * Class DocumentationServiceProvider
 *
 * @package Inside\Documentation\Providers
 */
class DocumentationServiceProvider extends EventServiceProvider
{
    public function boot(): void
    {
    }

    public function register(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        $configPath = __DIR__ . '/../../config/documentation.php';
        $this->mergeConfigFrom($configPath, 'documentation');

        $viewPath = realpath(__DIR__ . '/../../resources/views');

        if ($viewPath === false) {
            throw new Exception('viewPath not found');
        }

        $this->loadViewsFrom($viewPath, 'documentation');

        $this->mergeConfigFrom(__DIR__ . '/../../config/authorized.php', 'authorized');

        $this->app->singleton(
            Cypress::class,
            function ($app) {
                return new Cypress($app);
            }
        );

        $this->app->singleton(
            FakerGenerator::class,
            function ($app, $parameters) {
                $locale = $parameters['locale'] ?? $app['config']->get('app.locale', 'en_US');

                if (strlen($locale) == 2) {
                    $locale = Str::lower($locale) . '_' . Str::upper($locale);
                }

                return FakerFactory::create($locale);
            }
        );

        if ($this->app->runningInConsole() || $GLOBALS['bootDrupal']) {
            $this->app->singleton(
                'command.inside.documentation',
                function () {
                    return new DocumentationCommand();
                }
            );
            $this->app->singleton(
                'command.inside.cleanup.tests',
                function () {
                    return new CleanupTestsCommand();
                }
            );

            // Commands
            $this->commands('command.inside.documentation');
            $this->commands('command.inside.cleanup.tests');
        }
    }
}
