<?php

namespace Inside\Documentation\Http\Controllers;

use Illuminate\Http\Response;
use Laravel\Lumen\Routing\Controller;

/**
 * Class AssetController
 *
 * @package Inside\Documentation\Http\Controllers
 */
class AssetController extends Controller
{
    public function index(string $asset): Response
    {
        $path = swagger_ui_dist_path($asset);

        if ($path === false) {
            throw new \Exception("Invalid Asset $asset");
        }

        $extension = (pathinfo($asset))['extension'] ?? null;

        return (new Response(
            file_get_contents($path),
            200,
            [
                'Content-Type' => $extension === 'css' ?
                    'text/css' : 'application/javascript',
            ]
        ))->setSharedMaxAge(31536000)
            ->setMaxAge(31536000)
            ->setExpires(new \DateTime('+1 year'));
    }
}
