<?php

use Illuminate\Support\Facades\Route;
use Inside\Http\Controllers\Admin\Adminer;
use Inside\Http\Controllers\Fallback;

Route::get(
    '/maintenance',
    [
        'as' => 'maintenance',
        function () {
            return view('frontend.maintenance', []);
        },
    ]
);

Route::get(
    '/adminer',
    [
        'as'         => 'adminer',
        'middleware' => 'auth.role:super_administrator',
        'uses' => Adminer::class,
    ]
);

Route::post(
    '/adminer',
    [
        'as'         => 'adminer',
        'middleware' => 'auth.role:super_administrator',
        'uses' => Adminer::class,
    ]
);

Route::get(
    '/{path:.*}',
    [
        'as' => 'fallback',
        'uses' => Fallback::class,
        'middleware' => [
            'front-check',
        ],
    ]
);
