<?php

return [
    'all_right_reserved' => 'Todos os direitos reservados',
    'empty' => 'Você não tem notificações no momento',
    'markAllAsRead' => 'Marcar tudo como lido',
    'seeAll' => 'Ver todas as notificações',
    'receive' => 'Receber notificações',
    'add' => 'Adicionar uma notificação',
    'edit' => 'Editar',
    'back' => 'Voltar',
    'section' => [
        'web' => 'Web',
        'mail' => 'Mail',
    ],
    'user' => [
        'login' => [
            'first' => [
                'text' => 'Bem-vindo <span class="bold">:author.firstname :author.lastname</span>',
            ],
        ],
    ],
    'content' => [
        'news' => [
            'featured' => [
                'title' => 'Publicação de uma notícia em destaque',
                'text' => 'A notícia <span class="bold">:model.title</span> agora está em destaque',
            ],
        ],
    ],
    'activity' => [
        'create' => [
            'comment' => [
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> comentou a notícia <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> comentou o evento <span class="bold">:model.title</span>',
                ],
            ],
            'documents' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> adicionou o recurso <span class="bold">:model.title</span>',
            ],
            'news' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> adicionou a notícia <span class="bold">:model.title</span>',
            ],
            'events' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> adicionou o evento <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'create' => [
        'news' => [
            'featured' => [
                'title' => 'Publicação de uma notícia em destaque',
                'text' => 'A notícia <span class="bold">:model.title</span> agora está em destaque',
                'mail' => [
                    'title' => 'A publicação online de uma notícia em destaque',
                ],
            ],
            'follow' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> criou a notícia <span class="bold">:model.title</span>',
            ],
            'pending' => [
                'title' => 'Notícia pendente de validação',
            ],
        ],
        'comment' => [
            'content' => [
                'title' => 'Criação de um comentário em um de seus conteúdos.',
                'description' => 'Alguém postou um comentário em um de seus conteúdos.',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> postou um comentário em seu artigo <span class="bold">:model.title</span>',
                'documents' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> postou um comentário em seu documento <span class="bold">:model.title</span>',
                ],
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> postou um comentário em sua notícia <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> postou um comentário em seu evento  <span class="bold">:model.title</span>',
                ],
            ],
            'comment' => [
                'title' => 'Criação de um comentário ou um post em um mural de discussão.',
                'description' => 'Alguém responde a um de seus comentários.',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> respondeu ao seu comentário no artigo <span class="bold">:model.title</span>',
                'documents' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> respondeu ao seu comentário no documento <span class="bold">:model.title</span>',
                ],
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> respondeu ao seu comentário na notícia <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> respondeu ao seu comentário no evento  <span class="bold">:model.title</span>',
                ],
            ],
        ],
        'newsletters' => [
            'sent' => [
                'mail' => [
                    'title' => 'Receber o boletim informativo',
                    'description' => 'Inscreva-se no boletim informativo e receba-o por e-mail a cada publicação',
                ],
            ],
        ],
    ],
    'update' => [
        'news' => [
            'featured' => [
                'title' => 'Uma publicação existente está em destaque',
                'text' => 'A notícia <span class="bold">:model.title</span> agora está em destaque',
                'mail' => [
                    'title' => 'A publicação online de uma notícia em destaque',
                ],
            ],
        ],
    ],
    'comment' => [
        'create' => [
            'title' => 'Criação de um comentário ou um post em um mural de discussão',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> comentou <span class="bold">:model.title</span>',
        ],
        'answer' => [
            'title' => 'Quando alguém responde ao seu comentário.',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> respondeu ao seu comentário <span class="bold">[:model.title]</span>',
        ],
    ],
    'reaction' => [
        'follow' => [
            'title' => 'Quando alguém te segue',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> começou a te seguir',
        ],
        'like' => [
            'title' => 'Quando alguém gosta de um de seus conteúdos',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> gostou de <span class="bold">:model.title</span>',
            'comment' => [
                'title' => 'Quando alguém gosta de um de seus comentários',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> gostou de um de seus comentários',
            ],
        ],
        'join' => [
            'events' => [
                'title' => 'Quando alguém se junta a um evento',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> se juntou ao seu evento <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'custom' => [
        'report' => [
            'comments' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> relatou um comentário inapropriado',
            ],
            'documents' => [
                'title' => 'Quando alguém relata um documento',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> relatou o documento <span class="bold">:model.title</span> como obsoleto',
                'mail' => [
                    'title' => 'Relatar um documento',
                ],
            ],
        ],
    ],
    'group' => [
        'document' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> adicionou um novo documento no grupo <span class="bold">:model.groups.data.0.title</span>',
        ],
        'post' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> adicionou um novo comentário no grupo <span class="bold">:model.groups.data.0.title</span>',
            'answer' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> respondeu ao seu comentário no grupo <span class="bold">:model.groups.data.0.title</span>',
            ],
        ],
        'invited' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> te adicionou no grupo <span class="bold">:model.title</span>',
        ],
        'member' => [
            'pending' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> solicitou para se juntar ao grupo <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'birthday' => [
        'text' => '<span class="bold">:author.firstname :author.lastname</span> te deseja um feliz aniversário',
    ],
];
