<?php

return [
    'all_right_reserved' => 'All rights reserved',
    'empty' => 'You have no notifications at the moment',
    'markAllAsRead' => 'Mark all as read',
    'seeAll' => 'See all notifications',
    'receive' => 'Receive notifications',
    'add' => 'Add a notification',
    'edit' => 'Edit',
    'back' => 'Back',
    'section' => [
        'web' => 'Web',
        'mail' => 'Mail',
    ],
    'user' => [
        'login' => [
            'first' => [
                'text' => 'Welcome <span class="bold">:author.firstname :author.lastname</span>',
            ],
        ],
    ],
    'content' => [
        'news' => [
            'featured' => [
                'title' => 'Publication of a featured news',
                'text' => 'The news <span class="bold">:model.title</span> is now featured',
            ],
        ],
    ],
    'activity' => [
        'create' => [
            'comment' => [
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> commented on the news <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> commented on the event <span class="bold">:model.title</span>',
                ],
            ],
            'documents' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> added the resource <span class="bold">:model.title</span>',
            ],
            'news' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> added the news <span class="bold">:model.title</span>',
            ],
            'events' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> added the event <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'create' => [
        'news' => [
            'featured' => [
                'title' => 'Publication of a featured news',
                'text' => 'The news <span class="bold">:model.title</span> is now featured',
                'mail' => [
                    'title' => 'The publication of a featured news',
                ],
            ],
            'follow' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> created the news <span class="bold">:model.title</span>',
            ],
            'pending' => [
                'title' => 'News pending validation',
            ],
        ],
        'comment' => [
            'content' => [
                'title' => 'Comment created on one of your contents.',
                'description' => 'Someone commented one of your contents.',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> commented the news <span class="bold">:model.title</span>',
                'documents' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> commented the document <span class="bold">:model.title</span>',
                ],
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> commented the news <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> commented the event  <span class="bold">:model.title</span>',
                ],
            ],
            'comment' => [
                'title' => 'Creation of a comment or a post in a discussion wall.',
                'description' => 'Someone responds to one of your comments.',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> replied to your comment on the article <span class="bold">:model.title</span>',
                'documents' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> replied to your comment on the document <span class="bold">:model.title</span>',
                ],
                'news' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> replied to your comment on the news <span class="bold">:model.title</span>',
                ],
                'events' => [
                    'text' => '<span class="bold">:author.firstname :author.lastname</span> replied to your comment on the event  <span class="bold">:model.title</span>',
                ],
            ],
        ],
        'newsletters' => [
            'sent' => [
                'mail' => [
                    'title' => 'Receive the newsletter',
                    'description' => 'Be subscribed to the newsletter and receive it by mail at each publication',
                ],
            ],
        ],
    ],
    'update' => [
        'news' => [
            'featured' => [
                'title' => 'An existing publication is featured',
                'text' => 'The news <span class="bold">:model.title</span> is now featured',
                'mail' => [
                    'title' => 'The online publication of a highlighted news',
                ],
            ],
        ],
    ],
    'comment' => [
        'create' => [
            'title' => 'Publication of a comment or a post on a wall',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> commented on <span class="bold">:model.title</span>',
        ],
        'answer' => [
            'title' => 'When someone responds to your comment.',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> replied to your comment on <span class="bold">[:model.title]</span>',
        ],
    ],
    'reaction' => [
        'follow' => [
            'title' => 'When someone follows you',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> started following you',
        ],
        'like' => [
            'title' => 'When someone likes one of your contents',
            'text' => '<span class="bold">:author.firstname :author.lastname</span> liked <span class="bold">:model.title</span>',
            'comment' => [
                'title' => 'When someone likes one of your comments',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> liked one of your comments',
            ],
        ],
        'join' => [
            'events' => [
                'title' => 'When someone joins an event',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> joined your event <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'custom' => [
        'report' => [
            'comments' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> reported an inappropriate comment',
            ],
            'documents' => [
                'title' => 'When someone reports a document',
                'text' => '<span class="bold">:author.firstname :author.lastname</span> reported the document <span class="bold">:model.title</span> as obsolete',
                'mail' => [
                    'title' => 'Document reported',
                ],
            ],
        ],
    ],
    'group' => [
        'document' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> added a new document in the group <span class="bold">:model.groups.data.0.title</span>',
        ],
        'post' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> posted a new comment in the group <span class="bold">:model.groups.data.0.title</span>',
            'answer' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> replied to your comment in the group <span class="bold">:model.groups.data.0.title</span>',
            ],
        ],
        'invited' => [
            'text' => '<span class="bold">:author.firstname :author.lastname</span> added you in the group <span class="bold">:model.title</span>',
        ],
        'member' => [
            'pending' => [
                'text' => '<span class="bold">:author.firstname :author.lastname</span> requested to join the group <span class="bold">:model.title</span>',
            ],
        ],
    ],
    'birthday' => [
        'text' => '<span class="bold">:author.firstname :author.lastname</span> wishes you a happy birthday',
    ],
];
