<?php
use Carbon\Carbon;
?>
@if($model->content_type === 'events')
    @php
        $startDate = get_date_in_user_timezone($model->date);
        $endDate = $model->end_date ? get_date_in_user_timezone($model->end_date) : null;
        $displayHours = $model->display_hours;

        if ($endDate) {
            $startText = __('inside.notification.event.from') . ' ' . $startDate->translatedFormat('l d F Y') . ' '. ($displayHours ? __('inside.notification.event.hour') . $startDate->translatedFormat(' H:i') : '');
            $endText = __('inside.notification.event.to') . ' ' . $endDate->translatedFormat('l d F Y') . ' ' . ($displayHours ? __('inside.notification.event.hour') . $endDate->translatedFormat(' H:i') : '');
        } else {
            $startText = ucfirst($startDate->translatedFormat('l d F Y')) . ' ' . ($displayHours ? __('inside.notification.event.hour') . $startDate->translatedFormat(' H:i') : '');
            $endText = null;
        }
    @endphp
@endif

<table class="es-content" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse; border-spacing:0px; margin-left:auto; margin-right:auto; width:100%;">
    <tbody>
        <tr style="border-collapse:collapse;">
            <td class="es-m-p20b" style="padding:0; Margin:0;">
                <table class="es-content-body" align="center" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse; border-spacing:0px;">
                    <tbody>
                        <tr style="border-collapse:collapse;">
                            <td style="padding:0; Margin:0; padding-top:5px; text-align: center; width: 100%;">
                                <h3 style="padding:0; Margin:0; text-align: center;">
                                    <a target="_blank" href="{{ $slug }}" class="enhanced-content-title" style="text-decoration: none; font-family:'Arial', 'Times new roman', serif;">
                                        {{ $model->title }}
                                    </a>
                                </h3>
                            </td>
                        </tr>
                        <tr style="height: 20px; width: 100%;"></tr>
                        @if($model->content_type === 'events')
                        <tr style="border-collapse:collapse;">
                                <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;">
                                    <tbody>
                                        <tr style="border-collapse:collapse;">
                                            <td style="width: 23px;" class="mso-hide">
                                                <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 28.3 28.3" style="enable-background:new 0 0 28.3 28.3; fill: {{ config('mail.colors.button') }}; width: 23px;vertical-align: middle;" xml:space="preserve">
                                                    <path class="st0" d="M21.3,6.7h-1.9v-2c0-0.3-0.2-0.5-0.4-0.5c0,0,0,0-0.1,0h-1.6c-0.3,0-0.5,0.2-0.5,0.4c0,0,0,0,0,0.1v2h-5.2v-2 c0-0.2-0.2-0.5-0.4-0.5H9.5c-0.2,0-0.4,0.3-0.4,0.5l0,0v2h-2c-1,0-1.9,0.8-1.9,1.8l0,0v13.8c0.1,1,0.9,1.8,1.9,1.9h14.1 c1,0,1.9-0.9,1.9-1.9l0,0V8.6c0.1-1-0.6-1.8-1.6-1.9C21.4,6.7,21.4,6.7,21.3,6.7z M21,22.3H7.4c-0.1,0-0.2-0.1-0.2-0.2l0,0V10.4 h14.1V22C21.3,22.1,21.2,22.3,21,22.3L21,22.3z"/>
                                                </svg>
                                            </td>
                                            <td>
                                                <span style="vertical-align: middle ">
                                                    {{ $startText }}
                                                </span>
                                            </td>
                                        </tr>
                                        @if ($model->end_date)
                                        <tr style="border-collapse:collapse;">
                                            <td style="width: 30px;"></td>
                                            <td>
                                                <span style="vertical-align: middle ">
                                                    {{ $endText }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                                @if ($model->place)
                                    <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;">
                                        <tbody>
                                            <!--[if mso]>
                                                <tr style="height:10px; width: 100%; min-width: 300px;"></tr>
                                            <![endif]-->
                                            <tr style="height:5px; width: 100%; min-width: 300px;"></tr>
                                            <tr style="border-collapse:collapse;">
                                                <td style="width: 25px;" class="mso-hide">
                                                    <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 28.3 28.3" style="enable-background:new 0 0 28.3 28.3; fill: {{ config('mail.colors.button') }}; width: 25px;vertical-align: middle;" xml:space="preserve">
                                                        <path class="st0" d="M9.3,7.8c2.7-2.7,7.2-2.7,9.9,0s2.7,7.2,0,9.9l0,0l-5,4.9l-4.9-4.8c-2.8-2.7-2.8-7.1-0.1-9.9 C9.2,7.9,9.3,7.9,9.3,7.8z M14.3,14.8c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S13.1,14.8,14.3,14.8C14.2,14.8,14.3,14.8,14.3,14.8z" />
                                                    </svg>
                                                </td>
                                                <td>
                                                    <span style="vertical-align: middle">
                                                        {{ $model->place }}
                                                    </span>
                                                </td>
                                            </tr>
                                            <!--[if mso]>
                                                <tr style="height:6px; width: 100%; min-width: 300px;"></tr>
                                            <![endif]-->
                                        </tbody>
                                    </table>
                                @endif
                            </tr>
                        @endif
                        @if ($image)
                            <!--[if mso]>
                            <tr style="height:10px; width: 100%; min-width: 300px;"></tr>
                            <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word"
                                href="{{ $slug }}" style="width:440px; height:234px; v-text-anchor:middle;" arcsize="10%" stroke="f" fillcolor="none">
                                <v:fill src="{{ $image }}" type="frame" aspect="meet"/>
                                <w:anchorlock/>
                            </v:roundrect>
                            <![endif]-->
                             <!--[if !mso]><!-->
                            <tr valign="top" style="border-collapse:collapse;">
                                <td align="center" style="padding:0; Margin:0;">
                                    <a target="_blank" href="{{ $slug }}" style="-webkit-text-size-adjust:none; -ms-text-size-adjust:none; mso-line-height-rule:exactly; font-family: 'Lato', 'Arial', sans-serif; font-size:14px; text-decoration:none; color:#1F4D8B;">
                                        <img src="{{ $image }}" width="100%" alt style="display:block; border:0; margin-bottom:16px; outline:none; text-decoration:none; -ms-interpolation-mode:bicubic; width: 100%; max-width: 600px; height: auto; border-radius: 20px; box-shadow:1px 1px 6px 1px #c7c7c7; margin-top: 8px;">
                                    </a>
                                </td>
                            </tr>
                            <!--<![endif]-->
                        @endif
                        @if($model->chapo)
                            <!--[if mso]>
                            <tr style="height:10px; width: 100%; min-width: 300px;"></tr>
                            <![endif]-->
                            <tr style="border-collapse:collapse; text-align: left;">
                                <td style="padding:0; Margin:0; text-align: left">
                                    <p style="Margin:0; -webkit-text-size-adjust:none; -ms-text-size-adjust:none; mso-line-height-rule:exactly; font-size:15px; font-family: 'Lato', 'Arial', sans-serif; line-height:21px; text-align: left;">
                                        {!! nl2br($model->chapo) !!}
                                    </p>
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </td>
        </tr>
    </tbody>
</table>
