<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.1
*/function
adminer_errors($Cc,$Ec){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$Ec);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$ad=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($ad||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Ii=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Ii)$$X=$Ii;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$g;return$g;}function
adminer(){global$b;return$b;}function
version(){global$ia;return$ia;}function
idf_unescape($v){if(!preg_match('~^[`\'"]~',$v))return$v;$qe=substr($v,-1);return
str_replace($qe.$qe,$qe,substr($v,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($tg,$ad=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($z,$X)=each($tg)){foreach($X
as$he=>$W){unset($tg[$z][$he]);if(is_array($W)){$tg[$z][stripslashes($he)]=$W;$tg[]=&$tg[$z][stripslashes($he)];}else$tg[$z][stripslashes($he)]=($ad?$W:stripslashes($W));}}}}function
bracket_escape($v,$Na=false){static$ui=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Na?array_flip($ui):$ui));}function
min_version($Zi,$De="",$h=null){global$g;if(!$h)$h=$g;$nh=$h->server_info;if($De&&preg_match('~([\d.]+)-MariaDB~',$nh,$C)){$nh=$C[1];$Zi=$De;}return(version_compare($nh,$Zi)>=0);}function
charset($g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
script($yh,$ti="\n"){return"<script".nonce().">$yh</script>$ti";}function
script_src($Ni){return"<script src='".h($Ni)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($P){return
str_replace("\0","&#0;",htmlspecialchars($P,ENT_QUOTES,'utf-8'));}function
nl_br($P){return
str_replace("\n","<br>",$P);}function
checkbox($D,$Y,$db,$me="",$uf="",$hb="",$ne=""){$I="<input type='checkbox' name='$D' value='".h($Y)."'".($db?" checked":"").($ne?" aria-labelledby='$ne'":"").">".($uf?script("qsl('input').onclick = function () { $uf };",""):"");return($me!=""||$hb?"<label".($hb?" class='$hb'":"").">$I".h($me)."</label>":$I);}function
optionlist($_f,$gh=null,$Ri=false){$I="";foreach($_f
as$he=>$W){$Af=array($he=>$W);if(is_array($W)){$I.='<optgroup label="'.h($he).'">';$Af=$W;}foreach($Af
as$z=>$X)$I.='<option'.($Ri||is_string($z)?' value="'.h($z).'"':'').(($Ri||is_string($z)?(string)$z:$X)===$gh?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($D,$_f,$Y="",$tf=true,$ne=""){if($tf)return"<select name='".h($D)."'".($ne?" aria-labelledby='$ne'":"").">".optionlist($_f,$Y)."</select>".(is_string($tf)?script("qsl('select').onchange = function () { $tf };",""):"");$I="";foreach($_f
as$z=>$X)$I.="<label><input type='radio' name='".h($D)."' value='".h($z)."'".($z==$Y?" checked":"").">".h($X)."</label>";return$I;}function
select_input($Ia,$_f,$Y="",$tf="",$fg=""){$Yh=($_f?"select":"input");return"<$Yh$Ia".($_f?"><option value=''>$fg".optionlist($_f,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$fg'>").($tf?script("qsl('$Yh').onchange = $tf;",""):"");}function
confirm($Ne="",$hh="qsl('input')"){return
script("$hh.onclick = function () { return confirm('".($Ne?js_escape($Ne):lang(0))."'); };","");}function
print_fieldset($u,$ve,$cj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$ve</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($cj?"":" class='hidden'").">\n";}function
bold($Ua,$hb=""){return($Ua?" class='active $hb'":($hb?" class='$hb'":""));}function
odd($I=' class="odd"'){static$t=0;if(!$I)$t=-1;return($t++%2?$I:'');}function
js_escape($P){return
addcslashes($P,"\r\n'\\/");}function
json_row($z,$X=null){static$bd=true;if($bd)echo"{";if($z!=""){echo($bd?"":",")."\n\t\"".addcslashes($z,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$bd=false;}else{echo"\n}\n";$bd=true;}}function
ini_bool($Ud){$X=ini_get($Ud);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($Yi,$M,$V,$F){$_SESSION["pwds"][$Yi][$M][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($P){global$g;return$g->quote($P);}function
get_vals($G,$d=0){global$g;$I=array();$H=$g->query($G);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$d];}return$I;}function
get_key_vals($G,$h=null,$qh=true){global$g;if(!is_object($h))$h=$g;$I=array();$H=$h->query($G);if(is_object($H)){while($J=$H->fetch_row()){if($qh)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($G,$h=null,$n="<p class='error'>"){global$g;$yb=(is_object($h)?$h:$g);$I=array();$H=$yb->query($G);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($h)&&$n&&defined("PAGE_HEADER"))echo$n.error()."\n";return$I;}function
unique_array($J,$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$I=array();foreach($w["columns"]as$z){if(!isset($J[$z]))continue
2;$I[$z]=$J[$z];}return$I;}}}function
escape_key($z){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$z,$C))return$C[1].idf_escape(idf_unescape($C[2])).$C[3];return
idf_escape($z);}function
where($Z,$p=array()){global$g,$y;$I=array();foreach((array)$Z["where"]as$z=>$X){$z=bracket_escape($z,1);$d=escape_key($z);$I[]=$d.($y=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($y=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($p[$z],q($X))));if($y=="sql"&&preg_match('~char|text~',$p[$z]["type"])&&preg_match("~[^ -@]~",$X))$I[]="$d = ".q($X)." COLLATE ".charset($g)."_bin";}foreach((array)$Z["null"]as$z)$I[]=escape_key($z)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$p=array()){parse_str($X,$bb);remove_slashes(array(&$bb));return
where($bb,$p);}function
where_link($t,$d,$Y,$wf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$wf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$p,$L=array()){$I="";foreach($e
as$z=>$X){if($L&&!in_array(idf_escape($z),$L))continue;$Ga=convert_field($p[$z]);if($Ga)$I.=", $Ga AS ".idf_escape($z);}return$I;}function
adminer_cookie($D,$Y,$ye=2592000){global$ba;return
header("Set-Cookie: $D=".urlencode($Y).($ye?"; expires=".gmdate("D, d M Y H:i:s",time()+$ye)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($gd=false){$Qi=ini_bool("session.use_cookies");if(!$Qi||$gd){session_write_close();if($Qi&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($z){return$_SESSION[$z][DRIVER][SERVER][$_GET["username"]];}function
set_session($z,$X){$_SESSION[$z][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Yi,$M,$V,$l=null){global$kc;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($kc))."|username|".($l!==null?"db|":"").session_name()),$C);return"$C[1]?".(sid()?SID."&":"").($Yi!="server"||$M!=""?urlencode($Yi)."=".urlencode($M)."&":"")."username=".urlencode($V).($l!=""?"&db=".urlencode($l):"").($C[2]?"&$C[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
adminer_redirect($B,$Ne=null){if($Ne!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($B!==null?$B:$_SERVER["REQUEST_URI"]))][]=$Ne;}if($B!==null){if($B=="")$B=".";header("Location: $B");exit;}}function
query_redirect($G,$B,$Ne,$Dg=true,$Jc=true,$Tc=false,$gi=""){global$g,$n,$b;if($Jc){$Fh=microtime(true);$Tc=!$g->query($G);$gi=format_time($Fh);}$Ah="";if($G)$Ah=$b->messageQuery($G,$gi,$Tc);if($Tc){$n=error().$Ah.script("messagesPrint();");return
false;}if($Dg)adminer_redirect($B,$Ne.$Ah);return
true;}function
queries($G){global$g;static$yg=array();static$Fh;if(!$Fh)$Fh=microtime(true);if($G===null)return
array(implode("\n",$yg),format_time($Fh));$yg[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return$g->query($G);}function
apply_queries($G,$S,$Fc='table'){foreach($S
as$Q){if(!queries("$G ".$Fc($Q)))return
false;}return
true;}function
queries_redirect($B,$Ne,$Dg){list($yg,$gi)=queries(null);return
query_redirect($yg,$B,$Ne,$Dg,false,!$Dg,$gi);}function
format_time($Fh){return
lang(1,max(0,microtime(true)-$Fh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Qf=""){return
substr(preg_replace("~(?<=[?&])($Qf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($E,$Pb){return" ".($E==$Pb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
get_file($z,$Xb=false){$Zc=$_FILES[$z];if(!$Zc)return
null;foreach($Zc
as$z=>$X)$Zc[$z]=(array)$X;$I='';foreach($Zc["error"]as$z=>$n){if($n)return$n;$D=$Zc["name"][$z];$oi=$Zc["tmp_name"][$z];$Db=file_get_contents($Xb&&preg_match('~\.gz$~',$D)?"compress.zlib://$oi":$oi);if($Xb){$Fh=substr($Db,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Fh,$Jg))$Db=iconv("utf-16","utf-8",$Db);elseif($Fh=="\xEF\xBB\xBF")$Db=substr($Db,3);$I.=$Db."\n\n";}else$I.=$Db;}return$I;}function
upload_error($n){$Ke=($n==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($n?lang(2).($Ke?" ".lang(3,$Ke):""):lang(4));}function
repeat_pattern($cg,$we){return
str_repeat("$cg{0,65535}",$we/65535)."$cg{0,".($we%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($P,$we=80,$Mh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$we).")($)?)u",$P,$C))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$we).")($)?)",$P,$C);return
h($C[1]).$Mh.(isset($C[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($tg,$Jd=array(),$lg=''){$I=false;foreach($tg
as$z=>$X){if(!in_array($z,$Jd)){if(is_array($X))hidden_fields($X,array(),$z);else{$I=true;echo'<input type="hidden" name="'.h($lg?$lg."[$z]":$z).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$Uc=false){$I=table_status($Q,$Uc);return($I?$I:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$I=array();foreach($b->foreignKeys($Q)as$r){foreach($r["source"]as$X)$I[$X][]=$r;}return$I;}function
enum_input($T,$Ia,$o,$Y,$zc=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$o["length"],$Fe);$I=($zc!==null?"<label><input type='$T'$Ia value='$zc'".((is_array($Y)?in_array($zc,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Fe[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$db=(is_int($Y)?$Y==$t+1:(is_array($Y)?in_array($t+1,$Y):$Y===$X));$I.=" <label><input type='$T'$Ia value='".($t+1)."'".($db?' checked':'').'>'.h($b->editVal($X,$o)).'</label>';}return$I;}function
input($o,$Y,$s){global$U,$b,$y;$D=h(bracket_escape($o["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Ea=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$Ea[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$Ea);$s="json";}$Ng=($y=="mssql"&&$o["auto_increment"]);if($Ng&&!$_POST["save"])$s=null;$pd=(isset($_GET["select"])||$Ng?array("orig"=>lang(8)):array())+$b->editFunctions($o);$Ia=" name='fields[$D]'";if($o["type"]=="enum")echo
h($pd[""])."<td>".$b->editInput($_GET["edit"],$o,$Ia,$Y);else{$zd=(in_array($s,$pd)||isset($pd[$s]));echo(count($pd)>1?"<select name='function[$D]'>".optionlist($pd,$s===null||$zd?$s:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($pd))).'<td>';$Wd=$b->editInput($_GET["edit"],$o,$Ia,$Y);if($Wd!="")echo$Wd;elseif(preg_match('~bool~',$o["type"]))echo"<input type='hidden'$Ia value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ia value='1'>";elseif($o["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$o["length"],$Fe);foreach($Fe[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$db=(is_int($Y)?($Y>>$t)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$D][$t]' value='".(1<<$t)."'".($db?' checked':'').">".h($b->editVal($X,$o)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$o["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$D'>";elseif(($ei=preg_match('~text|lob|memo~i',$o["type"]))||preg_match("~\n~",$Y)){if($ei&&$y!="sqlite")$Ia.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Ia.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Ia>".h($Y).'</textarea>';}elseif($s=="json"||preg_match('~^jsonb?$~',$o["type"]))echo"<textarea$Ia cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Me=(!preg_match('~int~',$o["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$o["length"],$C)?((preg_match("~binary~",$o["type"])?2:1)*$C[1]+($C[3]?1:0)+($C[2]&&!$o["unsigned"]?1:0)):($U[$o["type"]]?$U[$o["type"]]+($o["unsigned"]?0:1):0));if($y=='sql'&&min_version(5.6)&&preg_match('~time~',$o["type"]))$Me+=7;echo"<input".((!$zd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$o["type"])&&!preg_match('~\[\]~',$o["full_type"])?" type='number'":"")." value='".h($Y)."'".($Me?" data-maxlength='$Me'":"").(preg_match('~char|binary~',$o["type"])&&$Me>20?" size='40'":"")."$Ia>";}echo$b->editHint($_GET["edit"],$o,$Y);$bd=0;foreach($pd
as$z=>$X){if($z===""||!$X)break;$bd++;}if($bd)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $bd), oninput: function () { this.onchange(); }});");}}function
process_input($o){global$b,$m;$v=bracket_escape($o["field"]);$s=$_POST["function"][$v];$Y=$_POST["fields"][$v];if($o["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($o["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$o["on_update"])?idf_escape($o["field"]):false);if($s=="NULL")return"NULL";if($o["type"]=="set")return
array_sum((array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$o["type"])&&ini_bool("file_uploads")){$Zc=get_file("fields-$v");if(!is_string($Zc))return
false;return$m->quoteBinary($Zc);}return$b->processInput($o,$Y,$s);}function
fields_from_edit(){global$m;$I=array();foreach((array)$_POST["field_keys"]as$z=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$z];$_POST["fields"][$X]=$_POST["field_vals"][$z];}}foreach((array)$_POST["fields"]as$z=>$X){$D=bracket_escape($z,1);$I[$D]=array("field"=>$D,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($z==$m->primary),);}return$I;}function
search_tables(){global$b,$g;$_GET["where"][0]["val"]=$_POST["query"];$jh="<ul>\n";foreach(table_status('',true)as$Q=>$R){$D=$b->tableName($R);if(isset($R["Engine"])&&$D!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$H=$g->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$H||$H->fetch_row()){$pg="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$D</a>";echo"$jh<li>".($H?$pg:"<p class='error'>$pg: ".error())."\n";$jh="";}}}echo($jh?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Hd,$Ve=false){global$b;$I=$b->dumpHeaders($Hd,$Ve);$Mf=$_POST["output"];if($Mf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Hd).".$I".($Mf!="file"&&preg_match('~^[0-9a-z]+$~',$Mf)?".$Mf":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$z=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$J[$z]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$q=@tempnam("","");if(!$q)return
false;$I=dirname($q);unlink($q);}}return$I;}function
file_open_lock($q){$nd=@fopen($q,"r+");if(!$nd){$nd=@fopen($q,"w");if(!$nd)return;chmod($q,0660);}flock($nd,LOCK_EX);return$nd;}function
file_write_unlock($nd,$Rb){rewind($nd);fwrite($nd,$Rb);ftruncate($nd,strlen($Rb));flock($nd,LOCK_UN);fclose($nd);}function
password_file($i){$q=get_temp_dir()."/adminer.key";$I=@file_get_contents($q);if($I||!$i)return$I;$nd=@fopen($q,"w");if($nd){chmod($q,0660);$I=rand_string();fwrite($nd,$I);fclose($nd);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$A,$o,$fi){global$b;if(is_array($X)){$I="";foreach($X
as$he=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($he):"")."<td>".select_value($W,$A,$o,$fi);return"<table cellspacing='0'>$I</table>";}if(!$A)$A=$b->selectLink($X,$o);if($A===null){if(is_mail($X))$A="mailto:$X";if(is_url($X))$A=$X;}$I=$b->editVal($X,$o);if($I!==null){if(!is_utf8($I))$I="\0";elseif($fi!=""&&is_shortable($o))$I=shorten_utf8($I,max(0,+$fi));else$I=h($I);}return$b->selectVal($I,$A,$o,$X);}function
is_mail($wc){$Ha='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$jc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$cg="$Ha+(\\.$Ha+)*@($jc?\\.)+$jc";return
is_string($wc)&&preg_match("(^$cg(,\\s*$cg)*\$)i",$wc);}function
is_url($P){$jc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($jc?\\.)+$jc(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$P);}function
is_shortable($o){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$o["type"]);}function
count_rows($Q,$Z,$ce,$sd){global$y;$G=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($ce&&($y=="sql"||count($sd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$sd).")$G":"SELECT COUNT(*)".($ce?" FROM (SELECT 1$G GROUP BY ".implode(", ",$sd).") x":$G));}function
slow_query($G){global$b,$qi,$m;$l=$b->database();$hi=$b->queryTimeout();$vh=$m->slowQuery($G,$hi);if(!$vh&&support("kill")&&is_object($h=connect())&&($l==""||$h->select_db($l))){$ke=$h->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$ke,'&token=',$qi,'\');
}, ',1000*$hi,');
</script>
';}else$h=null;ob_flush();flush();$I=@get_key_vals(($vh?$vh:$G),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$Ag=rand(1,1e6);return($Ag^$_SESSION["token"]).":$Ag";}function
verify_token(){list($qi,$Ag)=explode(":",$_POST["token"]);return($Ag^$_SESSION["token"])==$qi;}function
lzw_decompress($Ra){$gc=256;$Sa=8;$jb=array();$Pg=0;$Qg=0;for($t=0;$t<strlen($Ra);$t++){$Pg=($Pg<<8)+ord($Ra[$t]);$Qg+=8;if($Qg>=$Sa){$Qg-=$Sa;$jb[]=$Pg>>$Qg;$Pg&=(1<<$Qg)-1;$gc++;if($gc>>$Sa)$Sa++;}}$fc=range("\0","\xFF");$I="";foreach($jb
as$t=>$ib){$vc=$fc[$ib];if(!isset($vc))$vc=$nj.$nj[0];$I.=$vc;if($t)$fc[]=$nj.$vc[0];$nj=$vc;}return$I;}function
on_help($rb,$sh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $rb, $sh) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$p,$J,$Li){global$b,$y,$qi,$n;$Rh=$b->tableName(table_status1($Q,true));page_header(($Li?lang(10):lang(11)),$n,array("select"=>array($Q,$Rh)),$Rh);$b->editRowPrint($Q,$p,$J,$Li);if($J===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$p)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($p
as$D=>$o){echo"<tr><th>".$b->fieldName($o);$Yb=$_GET["set"][bracket_escape($D)];if($Yb===null){$Yb=$o["default"];if($o["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Yb,$Jg))$Yb=$Jg[1];}$Y=($J!==null?($J[$D]!=""&&$y=="sql"&&preg_match("~enum|set~",$o["type"])?(is_array($J[$D])?array_sum($J[$D]):+$J[$D]):(is_bool($J[$D])?+$J[$D]:$J[$D])):(!$Li&&$o["auto_increment"]?"":(isset($_GET["select"])?false:$Yb)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$o);$s=($_POST["save"]?(string)$_POST["function"][$D]:($Li&&preg_match('~^CURRENT_TIMESTAMP~i',$o["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Li&&$Y==$o["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$o["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}input($o,$Y,$s);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($p){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Li?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Li?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($Li?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$p?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$qi,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7t4yZf4iATVVf:Ϧ,:1Qݼb2`#>:7G1sLXD*bv<܌#e@:4!fot:<咾o\ni',a_:iBv|N4.5Nfivphl֚O= OFQk\$id2Tp6-Z6h:a,2#8А#6nJht4O42ok*r@p@!?6r[L:2Bj!HbP=!1V\"0\nSD7DڛC!!Gʌ +=tC.C:+=%c1MR/EȒ42䱠`8(ӹ[W=ySb=-ܹBS+ɯ@pL4Ydq63ĬAc܌Ψk[&>Zpkm]u-c:Ntδpҝ8=#[.ޯ~myPP|I֛Q9v[Q\nr'g+T2Vz48(	Ey*#j2]R)[NR\$<>:>\$;>\rHT\nwN wأ<Gw\\Y_Rt^>\r}S\rz4=\nL%J\",Z8i0u?s3#ى:㽖E]xs^8K^*0w~:iv2w^77cu+U%{P*4̼LX./!1Cqx!HFdLĠ`65fĆ=Hl V1\0a2;6_ه\0&ZSd)KE'n[X\0ZɊF[Pޘ@!Y,`\"ڷ0Ee9yF>9bF5:\0}Ĵ(\$37H MA6R{Mq7GCCm2(Ct>[-t/&C]etG̬4@r><Sq/QhmL#K|6fKP\r%tV=\"SH\$} )w,W\0Fu@b9\rr2#DXyOI>nǢ%'_t\rτz\\1hl]Q5Mp6kqh\$H~|!*4`SS tPP\\g7\n-:袪plB7Өc(wO0\\:wp4{TjO6HÊrq\n%%y']\$aZ.fcq*-FWkzjlg:\$\"N\r#dÂsc̠\"j\rՒPh1/DA)[knp76YR{MP@\n-a6[zJH,dlBho+#Dr^^eE ĜaPJGzt2XVȳB_%K=Eb弾§kU(.!ܮ8I.@Kxn:P32mH		C*:vT\nR0uҧ]P/JQd{L޳:Y2bT 34cV=L4r!BY6MeLio9< GƕЙMhm^UNTr5HiM/n흳T[-<__3/Xr(<uҖGNX20\r\$^:'9O;kfN'ab,V1HI!%6@\$EGڜ1(mUrս`iN+Ü)0lf0[UV-:I^\$sb\reugh~9߈bf+0 hXrݬ!\$e,w+3_Ak\nkrʛcuWdY\\={.čgp8t\rRZvJ:>Y|+@Ct\rjt6%?ǎ>/9F`וv~KRWzlmwL9Y*qxzSeݛ~Dxɟi72Oݻ_{53t_z3d)C\$?KӪP%T&&\0PNA^~p Ϝ\r\$b*+D6궦ψJ\$(olh&KBS>;zxoz>oZ\nʋ[vȜ2OxِV0f2Blbk6ZkhXcd0*KTH=πp0lV\rnm)((:#E:CC\rG\ré0i:`Z1Q\n:\r\0q:`-M#}1;q#|ShlD\0fiDpL``0y1\r=MQ\\%oq\01211 ќbi:\r/Ѣ `)0@I1NCOZ1q1 ,\rdIǦvj1 tB⁒0:01A2V0%fi3!&QRc%q&w%\rV#Qw`% m*ry&i+r{*(rg(#(2()R@i- 1\"\0R.e.r,ry(2Cb!Bޏ3%ҵ,R1&tba\rL-3\0Bp194O'R3*=\$[^iI;/3i5&}17# ѹ8\"789*23!!1\\\08rk9;S23ړ*:q]5S<#383#e=>~9S螳r)T*a@іbes:-*;,ؙ3!iLҲ#1 +n *@3i71_FS;3F\rA3>x: \r0@-/w7SJ3 .F\$OB%4+t'gLq\rJtJM2\r7T@)ⓣd2P>ΰFi಴\nr\0bk(DKQ1\"2tP\r,\$KCt5#)P#Pi.U2C~\"");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	Ojr7F;B̒>ЦV\rĖ|'Jz#PBY5\0NC^\n~LrR[̟RìgeZ\0x^i<Q/)%@ʐfBHf{%P\"\"@)DE(iM2S*yS\"e̒1ט\n4`ʩ>Q*ynTu~%+WXKQ[ʔlPYy#D٬D<FL@6']Ƌ\rF`!%\n0c˩%c8WrpG.TDoUL2*|\$:Xt5XYIp# ^\n:#D@1\r*K7@D\0CCxBhEnK,1\"*y[#!יٙl_/x\05Z4\0005Jh\"2%Yaa1SO4%niPߴq_ʽ6~I\\ddD3g^@^6_HD.ksL@ɈnI~\rb@ӀNt\0s]:uXb@^1\02?T6dLNe+\0:Ёlz6q=̺xN6O,%@s0\n\\)L<C|PbA>I\"	^K4gIXi@PjE&/1@f	Nx0coaߧ,C'y#6F@РH0{z3t|cXMJ.*B)ZDQ\0T-vXa*,*<b#xјdPKG8 yK	\\#=)gȑh&8])C\nô9zW\\gM 7!,9\$T\",%.F!˚ A--g\0002R>KE'U_I9˼j(Q@@4/7'J.RT\0]KSDAp5\rH0!´e	d@Rҝิ9S;7HBbxJ_viU`@SAMXGXiU*':VWJvDN'\$zh\$d_yZ]Y8ؔ]P*h֧e;pe\$kw*7NDTx_ԧGi&PԆt͆b\\EH\$iE\"cr0l?>C(W@322aI{B`ڳiŸGo^6E\rGMp1iIX\00032Kzl&ֆ'IL\\\"7>j(>jFG_& 10IA31=h q\0Fķ_JԳVΖ܆q՚	(/dOC_sm<gx\0\"\n@EkH\0J8(km[S4\nY40+L\n#Bӫb%R֖׭R:<\$!ۥr;	%|ʨ(|H\0]cҡ=0Z\"\"=X)fN6V}F=[ৢhu-\0tbW~QiJL5׭q#kbWnQT!encS[+ִE<-a]ŃYb\n\nJ~|JɃ8 Lpo NܨJ.ŃS2c9jy-`a\0*ֈ@\0+mg61Me\0Q _}!IGLf)Xo,Shx\0000\"h+LM јZ	j\0/\$>u*Z9Ze+JtzRKԯDyq0C-fmBI|HBsQlX.|c[ZhZlx@'mlKrQ26]ҷnd[񎩇d\"GJ9uBoZߖan@nlW|*gX\nn2F|x`DkuPP!Q\rr`W/	1[-o,71bUsN7Gq.\\Q\"CCT\"*?uts]٩Pz[[YFϹFD3\"]u۝)wz:#Iiwpɛ{o0n;\\x\0qm&~79[HqdLO2v|Bt\\ƤHdH\" N\n\0GgFF}\"&QEK{}\ryǎrכt7Nuó[Agh;S.Ҡ¥|y[Ն_bȨ!+RZX@0NP%jD¯z	[U\"{e8>EL4Jн07 d Q^`0`]c<g@hy8p.ef\nehaXmSjBژQ\"\rK3=>ǪAX[,,\"'<%aӴ.\$\0%\0sVpM\$@j>}Ve\$@̈́#(3:`UYu@V#EG/XD\$havxS\"]k18aя9dJROӊs`EJUom{lB8(\n}eib, ;N͇Q\\ǸI5yR\$!>\\ʉguj*?nM޲h\r%U(dNd#}pA:-\\A*42I\r֣ 0h@\\Ե83rq]d8\"Qƙ:cy4	ᑚdaΠ6>UA:@2\$eh2FəN+\rԀ(Ard*\0[#cj>!(SLeTM	9\0W:BD3J_@srue +'B}\"B\"z2rlxF[L˲Ea9cdb^,UC=/2/\$C#8}D6`^;6B0U7_=	,1j1V[.	H9(1ҏLzC	\$.Afh㖫DrY	He~or19م\\߄P)\"Q,eLw0\0;wXǝqo~>9>}dc\0gfq&9-J#3^4m/\0\0006n8>䈴.ӗcph_A@[7|9\$pMh>5KE=hAt^V	\"	cB;iQҠt@,\n)s`;4Iy-0yeʨUBv3HPG5s|\r\$01l3(*oF~PK.,'J/Ӳtd:n\njYz(wZ#Z	Io@1λ\$=VWz	nBaAq@Ip	@5ӖlH{UoXfӿ\\z.,-\\ڗ^y n^BqzX㉡\$*J72D4.!M0DFGLmc*mcI5Ɍ^tjl7替SQ.ihLڱB6Ԅh&Jl\\Wecf%kj pR=i@.(2klHUW\"ojp!S5pL'`\0O *Q3XlJ\08\n\r*a떞r`<&XBh8!x&Bht\$]n߆cL[Ƶd<`\0ςawO%;BCQ\r̭pPQZZAu=N&ia\nmK6I}n	t\nd)bp\"g'07u&@78XNx\$BZB/MgBiѧ\\mmIĀ;5=#&4PՍqA\\,qcޟ\ncBw\0BgjD@;=0mk\rĲ`'5k-{\0_Mu2׆q>)9W\nd+ԧG\rn4O:581:Κ?(yGgWK\r7m5.eHhJAk#L..\\=UЄ:>7W+^yDbGOZ4r(|xPr,y8qaܩO2kn#p2ǈؔ.cUcłj\$8Ĭ~7ZR:׆89Ψw(aL%-,쿌#f%8|c%XW\n}6H˞#&J,'zMMຑ܆ /y6YQںdәd:Ep2gg/,Ո'8^;UWN{OCziKXڔNdGRCJYiy#>zSMUcRORԾ0)0]:=Ϟt'\$srF67	=\$B!qs	1\"v%Il<b!ۮ6(Cd-^<H`~2KzKٜԱy,qA*\0}Cpb\\S5'(|MW5;\$5T|;kt@;9);i.;_F=DM`H\0	 N @%wdPb\$H|k[dCI!:l,<utNeϝW^w'6Dfu ihIZ:~ϣrz3+uoCs2buaXwWK	HԶ27>WyMJrpTL|`f:Atd|i[wjW 7aueA5Q' ʐ\03Ҿ\$\rk)a;H=֐~IGI<\"I1'蠙Gcm\0P\nw#>xB\"Em|2\$}<3PYXgod߶<qE\"`4g8r]\n:qVbTm9K&ғĤm7)@Qz=ߵűH\n}Oi}\r٣.vpJW&u550	5PI\nl\0O5*=	P-H\0f%tぺ*S:tϛ?ȂHq4K@Ԭ܂.O(Z\$]onzA!t85<WR2[8n5\$I浕Z]'}ET\n.&7V@_Do&J64ij\$ELut+IТأ~SSZTXPYz\"\$V_]M(7t_S/tĂmH:\05- _Z'#1P,}(~\0!Җ`-P\ney (`9O!;5\n\${UA7![ YF濴>8&!CLH(\0'Ǐ2d\r%;k抐4_O>5@DҼ\0VA6' AYSrԾ4+h@bOM\0r̛@\rJm0\08O;kӠA(6|	`8 \0&EV\0VwkNKxdpsALAXku\0t Ԣ.>(NK'fldA?++N~kPR\0xʑBK]bU\\̛d\0S@Q͉b\0\0b\0_\\@\nNOAPfԏAj M4<9+`S w3T7XT!\0ePAIb 1!\04' @!8\0/!:K,CASXfeM.::t._d81v`B\"!.^*N.^\n&\r(.O0@Pnjڗ#&rH< !3(i @Aa{ ¬#S6𨘶F@Y[O(./B)L02B؈-ƀqpJ<.Б\0\n\0/@8C4P\r	P)F\$q.]\"B#	#\\84\$s:.(*Oi>|#T'`Bua/CTKaX8`p\0`\0");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%23Hb2&<9R(tTH	z' o>4?\rZwӂ4`Ї鍆NӀ'-I0(Srw,Kr'-2Hlo-U_'W#'/H֟j6̉ȫ\0<j1EQTTrBcm16͈g٫:w6ͯh@1I:2pL/w:őK<E<J76Ӏs.̲sZ/\$AsEyϜrr:w?Չ!?ǙZM9՝\01?ARͦ%7>MARr}sr)\\t-8=ЎU,WOCsՆ#w5ERlM*D1>]gKV\n\\s܇8͹seͧ9so~w4xf@D96\0	@.@9\0C;Ky+J٥u<\\`c{ӋE>yJ=l/-7Z46uC5PΩRVʳlVaNx`մ?U7(HP}jVJzNQJSs-gQ!aV_SwRO3amZXwZo'waOoZ![\n<ZOҶ'Omo[a=Q>:T\n\0=mjATRbu(I:\$vWuS\\V8v\\g!Mжu_&is\\CRVM]tXT7\\UoTo_ԯݛS?alS-LutZGei`	}XZi}QyW[iTYo(ZE\\}nٍifڋWd%Tpu3uTf5)v]UR3VEY]X\n^VqSS}XiGfv>SvJMQvڕ\\g]QYEݵ#1Vl5UEK]\0SU?\\BwSU7mZV5\\Wfէ[eUr{G\\U,W[]xVj5mTVj~u7\0VU'tw?ms5Vvݏq}u-Uq]ݗc]W]Tt:fMke][-p}^I[XDYVdO]	seNZWY[tV?3ǵMݙ`t^wd:qTL@@>]j\rFqv-LvGKwiLwIPMoǹMgv[Uss~	w:BANE{!-do\0}&hXA5%٣fzLH5d Y_%vә!m]%=B>E [#^}hYFa>{gSp[FDa6nx98LI㈫Na=S@bPk.NHl\0:2#Θ;vO}9ik]	&{ 2|a&Q)oفǸ:&.\05q\0JL64hy3ޢaރIzOﮈ\"yBʳ{3%5r(mx.7rb%^eM2\0x!b}.Y6\$qS\"^|xEaXǡ59'TR	c9W1AΔP؏h6'o-pT(\nn\rŐ1RRUgxPe#*kT<<>b;\0gL.<kZvz8~y7Yȁ7wOdn><E3wSۆ@ oW1Һze޽1z\0f=c㊤g{>np\0Α:HBn6FBrW=C>M.1~@3G98q<S|Y8QP`L[qz۫PN<{_-ٮdOd-NB74BN.V9ƨQ3{IcP\$h<R yy?G:ng;Ah!&+>ˀ;Mˌ	6SNڌ=#`T#+n;r,X|#\r#?\nD>|VSeϗ~Jm99\ns{S|r],~˹ qI?\"|w%|j\0rE,kSnqƕd8B.1\"/|؃]EϜNlxI IcŸ.|\$8DFPK3\\jxUC/җA{eܾ\rpU\n՟Wlo­Y{`]'s/|o3r};[nOM7ߣؼqq(_lqsNy;igt:ՙqk{?zMȗo'jcy߄ggkwf8Vc7fAY+Kx=gKAkT,95rd+Gٯ[%Aw柞7ଅ%{m8%_mqV˨_%!Ei~h~C߭~%_rLkDy~?p1O!?v\\Pm\"<E6 EVzk9z~/պ!Q>ONm3r Fle;M߷Ͻ_a!~Cfb}3 Kf. 	}.DX	i5|?=\0???@Õfu~a^nyQ;q)sS,\"G\nu%UYAKl\nBI86VCcO\0`}.x,-N@~TG'dJy1zlæfgABa!M\\<gʃz4ƿ@/CÂ@	Qq)x/.7inD#= *79cFd2(.V3\$g`A᧋rl|mb/qEô!bU@9i;ppdפ=1yxx	=v=(vs_Boɂց#K\r n\\# fPXu-3&	J&,F(9v0&@khZygCԋz Áhi=s9T eT>g3dtF2b&:\0PB-Q8~LSMڷcgTh'f(\$.EVLAIߌrg\r0T1P`1d\r4=6@F F=ɂ6A>NAV	(\$A/;?gf^	\n&KOn{]g˛8cўϷ\n7Lt:ѠhFVO\rJ)b(\"OBm	o\$]TSHZ^Kw\\[A9('لcۑb0 KsrBx\n*Baz6o\ry&tX1p'^M<Cg`48GHzd?gX.@,7w۞:+TiUX16Ls:\rL6fr\r`t67~gxgH9JO=-\$4?r٪4O:z{D`21Fܵ(DM;&́ڭU>I6c߸@\r//ԕ_H\n7z 7aɻ[9D'}BORݟB#s]z!(D@L^	x@ouOD!e`\nak>0`-*8EZ6=f%c㛰K=F\rShyN[v*v\r@#߸퉁Ah*L\$AA\\%*	p\r*==8\$W\r [Jx0yZ+&YHA~A\n,\\(p!F<6S&IP`6Xz+df\rJ£is+&5/rEM^\$R(RQEw3lH*m\0BqarLBQz6~lB\rI®GXٸXVbsmBHc_K\$p-:8Nj:х-#F	\0aiBs\\)<.!\\NbIw8͹tPjW`y\0&0i?Ҕ:Ia)=C,a&Mapƃ\$IIFc\0!Yxa)~C1PZL3TjC\0y`\\W\\t\$2\n+a\0aKb\n]C@?I\rHヮKs%N^9CL/=%ۨh:?&PEY>5n[Gْ%V*w<gJ]*wd]B5^֢OQ>%s{ԅ畫;WzGi*RnG9E,(u*Ւ×XsR:5;)RNvK(RMb_{F<<3:%HVYS\n%L+{o.>Z(QkN!,:rH}nRNkI		[ӧg֤;mYҳg%9V~-J_g\\ɮQ\n!t\\UY-tZnd:Bʽ*]')twɫ[BUm*r4ؖ*yvvZչ+GHZnP܅|\nT %#\\AX\0}5b+wrXwܲ1u%Cg=Iv`cre0`..<h+H̝^\\jyF%]B\0r+>%Zx %C.`Vn1KSk\rX|[;6H	U@D:޻Mj	Ε?]ڤbA+G\0thxbL`64MޛY#hfD=ew=c+H:.%^\$DZrAzjfLl7o\0-Edމyz'V ӞW	ZK+d(AfyP?xR^h'A\0:p\rd(Vdt	SFcHȟ]rrCHY	X_/fͽ 4 7e6D{,<<Z^j\"	\n+ƀMY9A(<Pllp	,>Ѐ{E9&Ghh{(Agg8(@jTngZŰJx@icՋ(p'oJ0MnĀ&\r'\0Ց\rqF4)cL_oJ}5co|6m}Q4Qb[xm( &@;+򘥮f|IR48 {	`k`ur`W㸱`\")fI\n;8Zjg~AΈ!j%TE\\\r3EjjFXZ	AykHXdgCQ΀0dt	zk`@\0001\0nH\04\0g&.\0\0O(P@\rE\0l\0X\rE8x@ԋ\0^z@E\0.^Qq\"YD_p&3\0mZ.Pp\rEϋsv\"0`w,_`\rc/]xq3\0q.pq\0002_iъE\0a1bwJ \0l\01,`1y\09#?0T^q\$F6/\$dFDyJ0b\0	W\0.c{c E\0s3l]@\rbF\"\02`\"7/\0a	^04eQ{c<ьj/_ѐc\0001*28BA\0000xƔiؾ1F50ljH\"F30\\_q\0fTl_0тBEČ#3]sƽ64_X1\0ƽd``\rS_JMV/f1\0005I6tf4F34fF-6d\"4k\$h±#Ě\06_01c@F/d]XQ#G\n5gqEF\nm\\DnqYFv1/4`q4=8bq|\00043mX1e\0.\\QcI	.7\\x`\"\0i^3(籒\"Ev4l_q\$FoȾ\r#UE䍩^9t.\03|r1\069l^xѼPF-]\n0vQy\"G2,sxQq#F+\0/Diq}8[6,j\0cmoN5ehQvGLH<T_Q?Fɋ..\$fyEC2l1s#EDlohѲj8eűbF!9`xqC7hx٣Ŏ7^xK<h	,u鱑G);lu#Eߎ<kb\0sR.wֱ#z~w2|x(\0001':v\0001G挿?|` .2X#G8K@<z1ƹ\"9|j	G/6qGs7/\0001bߍ:|8Q#~FW4g#<F\r 2XQ#Fvk7x1#Ǝ@rhFZ;frcy!\r	_x1\"H10Twٲc\rF1 \n8dXrԌ2Db{d4HrA<~1dBHI[J?q~k0t#F\r#0\\h\rGEttc7U!=D_cN\0y6a Fg!v1q1KǇ@eѳcGo\n/ƲE\"3t`#cH<cqF%?Tb蹱d) r0qcE>3\$tyQңECl`9)VFHMJ7f\$HHQ ;ri7#F-FHQ#\0G!1^&4vG&7gృ\$\0G\rr/dR(s6@'RAǬ&g\0k z=|Hٱ^J]sd,\$1<cqǦJ_bGQvJرH5FpIc[@rvH%3Dc<I\$M.dr1c=F.4c2bG.!L|{Xѳ{INFdxqscݍ#Ea)#GJm.\$=GhAN=sŤE͑GG\\a10HF.tg8ä[Idn8F.TF3E6riqsF6xrL=nFTod>-3|2\$0= :xcHI\"NP\$bQ\$F DĂ}F%?(G3\$O\$^x2T0R#D:E|i/2XG8-\$Hv=d `:laxI:XRJRmxJ#\nGG9!N{cI&IR=I\r&j:8g#H'3_xbH}>7cُ\"&K<x2H\"6@db뱭e;)!.]/dm*f6,vɪL(qAI87d9TtcULX%HI*z:|IXqs-Bq^(Raq(~e9JU+-eq*nT>\$ѫerαp\nռ\$es+VIbeq:#]cc7r\nf,gYTC%	}\0\\*EWPa:E,&Wp)xlM3\0t\0/IipD'\0	k\$TF]fdMȀK\$H(@ɔ(znWҤ_Mݔ*\0elF^H	W*BZPe֘R/dRRʅ\0Ku,yH)\"SXI'Z=LR3\n'[k6@;}RI_)w[ \nnʓbBrl,\$v԰H\\s*.QtBdb@?3S`a@K\\.~f),?|&ӶKZ9.X+S|\0PʼEe/\0V^K\0\n-	:Sز)ת0j9TXBK\"ů²,2'2P,xpKꗪ\"D#TVD1Ao;ؕ/9TH%V`WJ<9aeʰK/V^/Q\nBZ\"9XүM~\$5\$0dIU2^X\n*E7I\nV3+aIiNKKg0az*V#bJyMҦeZ V`U1C.\rF-j&LUp9s鹊+Q&1RmӱgZ	,.XryZ첰032A1ւeN(?Al ,Nue\$|r_%E05E}\$X2%Ze \n\";<9ah㶥a]8*uLdR0+Qm.,GM_2edBݸ,S2>U԰4vl~e22eĵYg2nf=\$%ٖFfa)fTƶGg2W,[X>)tA]R*&Z6j2|\0(p	9 uҪ?`n-lZn!H9zL9VLϹyݢZJhRgEfLU~`4Yx)\$BQR#ÕS,6i#Y,;Cri&X]\nw54Kx\n*&TW+SлqNcyIW\0W5cɫ&+Vr)Kg? |gRhR%K)Z#5,ֵk漻`l:LsC[MUB6ldѓJ1nl:jLߖ\0h *)p/ާ5\\<9V/ޫhTdjrMbx\n]RWR MaU3=`0o,Zl}m월lmLS6\\tΙL\\%JK7oѩefMoCYv慭NV4=RsJ*hhn-m44yHM|isU=A\$ڭiϙ>ppQfq,5sUL8}ݬ٪#XHI9U8c:If7kl5}fLYN2ް}&	ic,I3R6r؉3b͍6>lXYfL)+S,ى*elU\"ed\"Zږ6ZDE9%΂Y9rmtE'.M[4^ɷ;Mw59av+70ld%<3_<lN(v+7YRl΅Ӫ].4I)=փNT]۹'U^?S7XCũӨ1u9EߙkL;NhSqNXk;1[LgpVB1_gs;RlENT8w,s1Pxrq3(;Z	yӾ'{O	_rȪMg|I92eLfO\rYnkuSNv9Vk	3ǧ.̛v9zyd)NY&s\$jd'6͔Q<V)e+:جYjtpu<ʖ3]qMY:9XSgIÝ*mCvGR@֯jT=:e(\0_Vn,?p	3'Π\r|\"igTnP皤\nӔq,Sf.YQ AA,ZeSsE\rvTQZ\"pIsUAϛ\0vZ}rKtfPf9疮{^Jς\n0%NGګ*~lD.Ke6[,%O՘-~쵕jRO;@	˨enb_%sKŜYY0LWjrՐφ!BPvfwګMR22z4rh;#M@}\0|M\0=ځ=f-!6pg[P4C[5:\rCtàu@ۺ<ifNun[!u8j{&9KuFQlRi(CA䮙s4\0Y;fB<{嘼R_I~6|MWTA]4e@JeP|[r5*OΠBt)%-\0Pjm	us}ИBi^*z0YK.`[Y2Ы|XB(?З.\$l,XD\njOD->_<֝\0sh\\ea\\\0e䑙Y`7U\"eCYTzt:V9P_aЕF;݀\0M2eHCZ?V'}cYa脬?Qh8	0QCM`6,JeZZ\"GWuu\r>49KI%LV9։Z{VEOX;oagP\$\nRX@}!-SiRqz	ITH.\nk\n\ndϮT>\n?E`5D+f?#zIZ7T[Qs#D\$PI	3*:9YIHHX0D!u7JmYB}E简r8Q\n}'PS	Q\$`R)^(OP\0aKm3\$H.X)V`9 .Y18eU`X9	\\LcjIE N鍫6WDXB	Z:|Ϥ:	E-P-&)*l)Puy|RLh.p_*QA@ ?,ƧY)tч<P*jVuQ:2\0L?J,TPHLE%\0yP(YJZTHX\r	Q4hO;\\vV#TWw\\`Oҡ?JR2=F]I5TMjI9,(ƤDv|t)Wy-]zea,pQ6\$I-g=%SW#TPܐ)T&]X15jB8Vӥ\nem yh*d4ςbd!0gRJ\\ Mt1R\n\nx._u+Ƽ;*4θ)]\\l(m\"QnT(*\0`1H@2	6hYcH_f?a7=KKdetH2\0/\062@b~`\0.\0v) !~JPĝTO{t\0005/ீ\rJ^0a!)8%KޘPP4~H\r+Lb/24)GKe0eS1B	-0jfSwLΙid L\r1hȩS MJJht)+?Le5n|FHMN5jɩSHL4=TDMn6Zm@I@S`)'7fzSzx~OU1kSFMOU4p٣2\000076k#xSl'K77\nlxSuLR77stxS}GM78*qt#xSOM\"78u)ӏ\09r)Sr2;)7Njm/xӿsNڞ:jy4SgO:1=\ncTSͧ;{Sȧ/ORH\r=tTIݧO\\zx4SM>j|TiSO~\$lO}t٧Oz*%]PPvU\"ݧK@\nojH;P>1FdP.5Bظ\r3uB<L#<QPECʁu*\nۨyPNl\r6?KmBZijHO2}1JM_MmD&KQ6Fzv6ӹQj;jj)*mEʌ9FdQv5eGɵdԄEM\0+D\"j)SDQҤpZfƂmR&HUہ%{Rv0m0z䧟Lƥ@'ER?eJ>ԝMIYTR/Bʕ.UTYRΡL:jNԅRL5ji&,OmJD5,9Q1hTfNޥQ'7Lih\rcjԝSzu\0nԺg9@c\rT%LAfTMT9uQ\n)USuD:jU	ƨPږq*EڪKSbl\\ڤFŪGTzgJHSF	\"Q:1;RꦵL*~EߪoTҦ\\z:]SꕱBU^JuR*kE	TQtRg2UjV\$_SmPHU\\T[Uʫ5Jhٵ\\UpV7a_*=R>\0I*VX:hU8jTKZ\\:)jT8	WZUbJ8R=YUVUR\\:-jѫiV.[zҪ-{TZuojU3 [>E %\\h#bՅWZ-\\CW>]ںg4#KTrZʤwj\$z-RjtjU*Wtp\n4'NMxUX32[x+\$BUS*qUͪqXZ}Sx@-W\n5XZՅJU2=\\F+V0]XXU0-VJ+/Zʮ5sjDU޲%bɵV%Y^u@dբW愔ŲRk&YR\\ŒRkYcVO-\\	kdKoXK/9]VO-U<@嬥Vγ[6U=eϵo4TݭY0eHդ\r96(󮝕+7ybrI |\0:Fz\n|s<R%J]F3jΣYZ^<5XIJM`nO\\B&rsQuzx	TVwJ5g	?vqF49ӝ6zjOV\ru=@ʒfT͚y	֫pKaXU9m\nekMo5\nhTꦦVv:s\\p>L:)O=nk}jS&֮~yeܚZֵ)jtVRVsr:+ao,!TlUϕ*n5\\Udv+M\\)]B|Jl;45pLӵئ7Li[~bmtSe\"Bvd@ͧS4)ؒZ\$)5ic!Ό\\R*SDw\$9tS\nGfPԛʸ*	KDVy5uȦJב\\C\$W,M\\5k^Vs5kֻM^{uϤwFQJHgWNk8ʉ+1br˕VX]dLjYTv6twy˕kvx=5h8]˷x\"c|ufU\0ҧ5jȩ}Pkn̚Rlf٪+ۣ>c4W+TDoqSXb}}hn&<?/3-áhqn	p%)SyP\r͵m-f5[\\=T}y )Ydؤ46#Y>3נm\n09h;40+ae\nȃİȞ!)@xx}\$AFÑ0N R	ӄiܥU?b5!+׭\0Gw{ӤlI )w-4;p8ؤ;@\r\n\rN5ƅF\\ӹhgPE il0X%)\nLk^2<5FdI<FjbMd'	ƲDBmaOYXgg8ZV%mf%F-,\naFwfs0G乑Z\n	1;J1\"iPByCtzӉ;l4ҡJmLX+lᘪ{8\"\nV(\$Y\0d\\݆6D9BHd%16f \"TJ`/>C=c쨱?e!k*3l~i,Az/dMoڲn\"ɽzTr}eٌ{MaC7fiT/6WP8Fa`5Mf2V]['}cn4]heZŧ\r2XllGa`((\0_lOf&f1c8D{Q	S6p\0Y\0\rq3m&*f;p6r^cϳ`ɵ&zn^ڱ;DSoj^=L'g5&Ef&|\nK 6?bX*.fψE~&9!dk@v\"FGx\\=E7XP2[:\0׎X~7X64(\";B\nXhy&DֈZl\nKCp`mS	2U;G8{-WBm\$F\rl&BY2\rmAőwZ6RВ%d_T5``BaGcXK\r\0gN\\;Ns^\nuѲVwzUF\"\0T-,^\02 / EW/\0¼ľ4;\"K-NZMcλRVNeZwj6aÿKVlN?jt2T/[Nj|0t% #\0`5F<X@\nӢZF\\-mcd2p5Gv'B'7{k*'LAZ|Ik\n-.C6k-Sk]_\$+Gנ[^z]k8\\F|?B^B̎|@BzPW/R?[!bBkѠ'	(e:xfr7\r_qMa\0#7|Q&\0Ɂ@)1뮆LA[Pt\0`6\\ezxS݀vՈπU:ڱTϗ>f\nql+K(|\\ѠGU؋@(*iS%F\rR\$CL;dļg-\$m?lhʝ3?PY\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$nd=file_open_lock(get_temp_dir()."/adminer.version");if($nd)file_write_unlock($nd,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$g,$m,$kc,$sc,$Bc,$n,$pd,$vd,$ba,$Vd,$y,$ca,$pe,$sf,$eg,$Jh,$_d,$qi,$wi,$U,$Ki,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Rf=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Rf[]=true;call_user_func_array('session_set_cookie_params',$Rf);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$ad);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$pe=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($v,$hf=null){if(is_string($v)){$hg=array_search($v,get_translations("en"));if($hg!==false)$v=$hg;}global$ca,$wi;$vi=($wi[$v]?$wi[$v]:$v);if(is_array($vi)){$hg=($hf==1?0:($ca=='cs'||$ca=='sk'?($hf&&$hf<5?1:2):($ca=='fr'?(!$hf?0:1):($ca=='pl'?($hf%10>1&&$hf%10<5&&$hf/10%10!=1?1:2):($ca=='sl'?($hf%100==1?0:($hf%100==2?1:($hf%100==3||$hf%100==4?2:3))):($ca=='lt'?($hf%10==1&&$hf%100!=11?0:($hf%10>1&&$hf/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($hf%10==1&&$hf%100!=11?0:($hf%10>1&&$hf%10<5&&$hf/10%10!=1?1:2)):1)))))));$vi=$vi[$hg];}$Ea=func_get_args();array_shift($Ea);$kd=str_replace("%d","%s",$vi);if($kd!=$vi)$Ea[0]=format_number($hf);return
vsprintf($kd,$Ea);}function
switch_lang(){global$ca,$pe;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$pe,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){adminer_cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();adminer_redirect(remove_from_uri());}$ca="en";if(isset($pe[$_COOKIE["adminer_lang"]])){adminer_cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($pe[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$wa=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Fe,PREG_SET_ORDER);foreach($Fe
as$C)$wa[$C[1]]=(isset($C[3])?$C[3]:1);arsort($wa);foreach($wa
as$z=>$xg){if(isset($pe[$z])){$ca=$z;break;}$z=preg_replace('~-.*~','',$z);if(!isset($wa[$z])&&isset($pe[$z])){$ca=$z;break;}}}$wi=$_SESSION["translations"];if($_SESSION["translations_version"]!=578941549){$wi=array();$_SESSION["translations_version"]=578941549;}function
get_translations($oe){switch($oe){case"en":$f="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qB742Lu*/h\nHh\n|Z28\0Cz7JH\nj=-B6pʥ):81#<Ђ9XЀD49Ax^;rA473\0_AУJ\0|63,bׇx481Oӈ#c:9;̶T*<Ua/8&#΁7\0Aq37|*B=6ƍ:ƀޫˌ3#fM׀P:\nL8΀\$D9\0 -CG8nRZ\n\0@ˇ5V6461@&\ruJ|1.m5e6d4/B Z0ʺsǭj\$C\"Jő.\$鈂Qk`R_D:gJ\0Ap;@@U%4N4v\0\nz5/6X3`Y|L+XA\\с=GD:2BEC]<@MW%Յ58Pt	ٔKFQԅ%JRMLM<9TVcuP9[Xp\r(Cx9v\"S0,bR*MJu2߰.S8kBl9~@|4?ἐKɀ@gvOKk'䦡h@L9C#BBC3Qu/Si(Ѡa00#jM簚\0@q\nI\$H\"Pqa4ˑ\"L2@yɉ3H|HÙN\\JG>5KJ13hѺ9Gd!0@\rx){v,ZKBPHIN8d'=:X;-k\$^ ܐk#I !ٕH`Ƀ~2<x=U%ZcO\naQ<38u:ڽnS<qPZ	3\$x'D?\$(ɒ0\$Dvޗ:I/\rV(\n5ʔ\0U\n @ &ZWb7'QN41 vdBizRQ樣Fa(QT_Ns2,!Āys5X[z<'MTOQAY%y?\$0\$0a3 \$,(xģ66tɳΥ@fl\\gmNMU.!Y@+t֪7G*Z\nd9'K[K/ɔ2jxe,P\\`^+-&U%o̓/-h'40cM<\rU	~T!\$	_tS=FNۂv.`^a!0aryE=]BZ\\,9@NQ/Λ*<2Z.lLBtJgIBșfkX.ɸ)cퟣX.ݲSrZ(SD#ҶbF\$9\$(b7*5iAÝw֡2dC,!d]2:-\$ΓOG\"QbYq_m]~;&]ײѳ\rE6GK.QuC-cw7Xji80\"0ų.\0bW9e%OF̨OKI|CvӲ\nv\r\0VN\\2YdZ:;yŏ[CFݹ929KBxKOqn5:Ҋ{پ9!eb5{GMgȚnW)bCw5|..}(7CA.I<;~K*q6|K!QT,  ^&*e~\n~~J˥<QEOr0'n}\\?ʓJ>|vJ?wPN~7չ/YXi\0Kb/5j92\"N6.o..o,*6)FHaH00d\0fuO֋PX&B\0!)Z^\$02W0pF6p.H0^N\nTnN~t		Ƙ,W^4d+\r\r8LBIptGe\nyP%n%\0<D\0J7NP^0ވ2nP\rbL\"c\"cpQH#l#\"-hٰe\rA,ޑ \rV`BF0thx\r tA\"pvv\nppc\\.,Zmll*֏\"f3v4J.㎪&6.lUt\n\0hrU*K\"@e\$: <B\n'.qNXKޫ\$5&K_&Rq\$TF6\$'m'*k`mϏ\$:bcnN2N\rD,F0VN@%2Y\"vj\0=t\0qp\\YDR\0,\0/-\"-LPDD\\\$Ϻs'2'N3\0\\";break;case"ar":$f="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o|7LQi\\ H\"#1|t\n|!Ҝ'e:\n&T=)VKvҨ2\rTBPOp6#oPhYh޳\02\0yq3:x}\rcAPHp_pBJ`|6-+3A#kt4px!ŴUOL3jQ8ddmWKVɣn\"@P0Cu%R#;Ȓ'g|Ye/J]R\n\"]6B6+/sIGʊ'	j>\\zlUHE*D۬WM&dF2Ѱ[GLB666^cJ\$Br)\"bԇk.l5<dNwU;ƼayO[k\\֞\rY֌dluqh9l;k¿FwDx@P!jo	KAߺcJS	@g@e7-V2ɛ:\r* \0Q4\r ҆b033	:BAP7, T:%X \r3Cr!3\"{M7Sv\n)0\\BBU&4ZL¡@͊(tOX XqQ.HdXЮ༗_~/C`	@0\"56J{/b*b\\ \"WT+&a5R@8܈RyUWw_7 `\\#PRIChp5ᵂI.tSXC[C>]H%'환dr=4Jd{x6:@iCq->a1D86⍑aPeX¶K,Ԇi?fjVIijBԙ633C3\\l+NCPxٛ*(oF~f\$lsCN( Czăppˑfc\rL4u(=4:Ih) h*3ӂڐт&r\$BCKb&Uߥx`Q>(bVFRQw֐bQJ99b\nYV\$QfHy3\"<r6g)6k82\rf,z΁CBn!cHkZPbN\0¡\"*?]R̼FQ!6o:ShC}iM*{bi%ڟ\n \n (ۆP!kl*LZ0T\n@746VzwJ#HiGETVʒBRlVPxNT(@.HA\"\\VN,)E?Qa`;\0lW,)TKJLD%t LRQ>\"P^ŔԱ6\r7DjAd,š.i9N/P3aF*!{b\0pAI'kw[қX\\pAK*񋔱W=\$\0#!5C\0PS\r!TiSlHAR%<7HBӍhevN`6r̬Q|W]q'\$Jm*.N2QMV#ͳcD>f_QRoH>aX)>Cmk2_c)' Aa \\!%Y©DLdh]ixJH,Ӌ;PʤR{ł}U(9˴.\$\n2e\$&A%·>,4~YmޑM\"2P\\[WģO\\֑u4QFw!\n	 G}UNǕA	x6<`-KLKe\"yh<O+(h=]:\0V c\0002\nV<bp\$CvbgDendCh!b0*̷IG:\"nO~PBcv~#	\rey:xW6RfnBle\\>>A\nn)~\"fЄ	:?K\rOr1:+\$P˄\0P: @RQp5-(wT-XM\$/w^RIqMPngM\\~1MM\$'\$zpQRLg0Qd|[C#:n]/\"O(+1N\r\n~~0*[kNafԧR1)'S>P#>/P//fZ0ocg4I*H12\0)P?LƧqdV\$D=!D<o !DįQ0qdr~G0mN2el1)mI)~fRPZqx!+Q=Ҳq:rP{9F^\"p\$@SnvfBP\nt:B\r+ppO13,21S1+0/3'P2R1s2;`mLPM]24CIP6,6hPFu430a5cHI39U*3E03:vsi;\"1e;\"H ijU\"m5m54%;qvCSA91S!.ETr:/B#4'<@0#k/.FkCNR'/UA\";\rV `ց\$\\fnxr[fJ\rB\nphHO%#C	>#0G\08(2nI`H&|uxr~s2~\0E7LPS?4	Æ ]Ų8/Q=%%Q=K3Lgfa*3(0Pk~Ep_>PeT-U f4CH\0`	XQNV&lp\$bWc	G.s1l\$'0nT)(Hb	0hX`Z  \08l:O~gpV:c'c'~,!\"N6IX\rnV7e6_2ZTKO:?K@	\0t	@\n`";break;case"bg":$f="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLH,/\r/SYF.Rc[?ILθ/t#\nK<h=[DV9v))#1,գQBŤC*5\\ ʰ2\rHFuG#wπF|cƣ:\rx!9Db@2D49Ax^;pz^@]x729xDlW4V6H7x.6Г\\VdV쭰UN l<;ݴ;N<XPbUr\n7`J2!R҉<?(4!JyA wQS4҄#䃶s@'զ\$/sn].76𝠯jq%ƸE0D)ݪ>QYi\"4\$ҩcf9\0ں~s\$z#P&D)&JnxSIQ>W\r@DYJ<JL!pdu(cۊl˅8,W	\\&	\r9]\rb\0oe\"s38ǵSCaJDLABE̇.DHO46Z\$@EDA)֫PD\r!j[+D:tueћV\$/e:.Cp.(i5LL<J#ADCNI\"2'y^NAF;\082FVp	ZQ)J/2CJk,\$T:Ks.e|KI3q-yg&в\0JAY'3*QF@:Pך^'9C\"c2D3(eL;aB٘rfxS8@4Z|O	ؔ\n&2`Җq\r&:SPvqU`,\"oD9rrՙ'Q:*Y%d쥕_B4fAH@!S@AXS)>h*.e'>Sø3iIǊ/1RJU3 gٮSTwc)\\/FܩrVghF4@Ã`lQ@heq3HJë`: :<4 cJl{HU+%8(·VeJw\n (&-x-?R^jj@׸c,Hv\r13ۦ,sGa[InJ(h銇4ʹ7&Œ*Gg4sWgdh(eOaY(4O!?'t2#\\wʙzM2bēnM}FVXTwJ)AE*Q&sHjM(PD5%Qd^BoeAV%?ej@)\\JtH%ɶtT˧\0[_;0\nw+6Qʂ)\$IXd4E_򊆅qkĖtuEA\nttLui~bO]RO K/&M6RKWeFlϓ-tq'Zj2wln̲J%¹\nUqT\rU\rSHXᰞ½	/`<\"x-}WsB\$ㄇ\"J'3อmZV>bqrӿU;(eE!*KHL 3fB;xyrRƫWaTQflV4dtKs~Dخ4V~WЍdv_܀Jכ\rQ1\rP0?rNdw<o>x*5dsR\0S:;kk6^:\\[ߊ7N ΢	yٟ;\\nv(jB#<jR\0Ŧ%tFk\rd.As.d:8\$l.7Rz,NEW-4 \n 	\0@ E\0G&\0c6G_䐄TD%M>K,@#8hqQ(.F̲%qìzºi*ʣ+0cd\\008cJ-(+	FЪ;+\rp\n8\"Xn\rk#6%Ľ(K ZN-fZPj1~.*Pwj.!</	%śzJ,F-Y)3 L즍Ǆ\r`4ѐ+؟EA;Q3gZX>X&@Bj!Boz%\\B\"Hz,Mz:2(6 ]7g&.5ȁMR.*g&n~CRR0J-U(ʁc\$)Npk/Ա;cn[v\"(GO.\"ڽHQDE@b.bjBr\\K*ŔvRPĉMZ\\.%(`\$.N~lsB<\0PQ@T(UeJg)wn4lk(T@r͒@c'Jn\$N/£*r7p5M(t)~YO(sg%9{5'_:sss}\\39<B*35\r-<\$c+d?0R3S(3-%>V*?6\0q8/5T&\0y;t51)=?B:SsV.31l2tZtR8k>Nx:}@{lg2z|\$?E)FS@iG.hxusX}BD)Rl0iPo;nuJ\\OmN{<F4K\$Ob<7:V+IOIOQEJI4yt[QQOƋ26CS^4	DFA|X\\UHtM'U*QF؈cU%Q)85Fv&e2'\$:ar70\"].6M>H%86SESP?'[33[U+P)ҋVe8[nCU^aMuAfS}_' 6\r`[n+\"Z']BE\\ӫ[Qv4Zh?]Qj3	OvNVScTμT_V(dfr,0O!ppvdږih7NPtF\$BP:.6K^q*u_q%3Wi	Ppd֯m0)jo9uQgB.'mP*̓v[V_^Vlmlүq\nYVB|iX'%lV3id6 W.ܬsS5R0/oQsoL-\"]PU]#b	?A\"9pS{I@7l\$]57ARg273,R!\rf/	Q>oIB\"@7%=;w~5A2\0\0b:bbdsfZ+kHDMnhIAK\0\nq\rh1	?]In)f|1P)m{Xg2~r7	Vֱ|(yT?oy_	'@EDp3cdTa/N'ZK.eTrN4OglqA0db4Ӊ%̧.koR)CnXYMw_yXD>xoR.sMryP)&+0U4,D-v'NGYNO98Yܱ 寀\rgXO~τ)1* %<ic#,\$]XNd%JtLѹIjM|cKڔhOQȐ\$=WN=1Of\rE\0		s0V}z/eUv5U|W\"#";break;case"bn":$f="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9.#\0#2\r78M:c2@L S6\\4Gʂ\0/n:&.Htļ/02TgPEt̥L,L5HLGj%Rt-I04=XK\$GfJzR\$a`(+b0z5qL/\nS5\"P1[R]ԬRW|KkZ^HWҥ\n|8CY|NKՅDJ !B# &M=<?!\01o&e9S;/>/E	CC Xh90z\r8a^(\\0ل7x7BxDlI46#H7xQ(M,Mє|zELPF5dE0DtDJQ}}07-[/RQ(7B9\rBO>gې+A.^ԅUI+S3Dҭ]TUst}~s](\"k#6Oew.<(Ȓ@l=b\n/}й\r  :K~Qp5K2Bض8u)G޹5kővrBH\n?AN\",[64{\0c!\$T1dfq\0h͚'YjYE* ЦcL\\ sD'eRjAG		}،GuAT\n551kR3SZJѼۋ\n)9,.AK\$20?b)/#ic!GUMvRh3O<u72t2n\$ҕp\n;}@0lf\n%\nbX)8AP7w\0 `:| \r3àr!3({e:PL jwhא\npT<)7>MƦiŪ֚^l\r6fM[Xrmp@8\\:0eMq-%&A[ʓv@'{m\015:^ܛQMa8Vm(wl7&\\sp^l&Chp=J )KTC[|PI{ZmbCR*uw!MY13H\r41@)uy3W?\0h<0@@=\r/mF%AQ^TI@\$u1-,6CnR(.@=Qk&0Ŕc{Oxey\09CLa;s>M496{DQo8QVڃ1TC;]VHS+lnD\np@R\rEpZreIHE岺MaDX(JYQS?gdVP*ǈ-Q\rXpzۚ\r!J,*&)Є5?7<at69\$w:\$|q!>dif9	5:N0PgDP.3'0CZ-7lK%phBK&\"ͽrZGLC#WXȹm8|SV7 \nqXlPcMSE7m9i<7_@xӁvbELf\"G@glڻɑ\\αdݗ3Q񈯬#AF[41\\)FDLHs ' X2JB~ћJB^\nqBèȽwkl\$B>]GXWe&JyYF*V1]oSmX̹c:Xԁt%-MMcDԨuE/\\OIaJ.@h5;06ђϥqEFϖ]Gx9ŤǄW*[=ZlUWIiP+\0e=؋A[s-̺~诊ig=D]unwZdd\"ƌ\\ǲ}*HJ>vp!NcwF\$>F*e\rBìHNJT`(e%t!b3P\$+G#X3R#\rAI0JWTpv \n`\rtMOIfnX?E&\$Fǆ)n^z@^6y\n~z1,t 1P'k'*/o}o>}ϜJP1@p0BtB-c*1bZ1gQ÷Rp:M者*\$qôΎrWA\n,O(0Gf4HQP{qpvsPv:Į	0dB1vjP&NDzx#hqe¸1mAcvΐq#&Ubvb#.](/x`wOuܓb&z'Bgv2l-b5OJӧvR#st,Hi'EUd\n& p`U-wx(]\0woJ%O%\$w\"7'!_do-0%Ū]010AW2[R>J24#7!qM.rW4q6/5hF%7M7fnd\"Hdl\$V\0`	#R&.vKs*(V0sjB{Z\rC/?3;6K.K23u5z_P,~V2\\@|*(ao\rb3S[8K0t:t>q.8-7*8PTԨ+,	FNRTV1I;I7T4S\0/%U3X{t\nsHTQ%qJSI|xI)J3u.E@RYIqLrKNws5>0k6@ц.17,)6^]OS1)BO3&(RP355HU\"	C5rDFT!L5EN4D0(G}4UoK5r0iF(HCrE=m+1 \\N۴=Y.R-j1Mܭ[{>5ZSYb}TՐ&M1!8%,0Tt2\"TG409\\eAe=RPIOBS<9K'dtMq7UW6@`DNDXs`U6Vy8u%UTtvn2-/eTYfT%tCVԙW}iee !gjSwe6:Gjjįvֵklwpܭ+hA&/LqA,),s/f6X}qSsvd8)NIWg6aH>HIrid<}vS)uo@f)u|g;tQmXܣWu0vVawyX0.(HcB|hRN ։JWr	\$U,3KzLhWfr_{w{lw1uU|j|D}M%}Svגzwxo=)u%q`%N%\n]׀W5~LV8aղV.h.[Wkx33XJ]Rt2QmVwkMkG #axGQX[%чxeMvHm+p7.Vl)Y'H2DxUDn_wxAQYqW(cd\nqv5bsJBV]<1+Yxt']5;\nmWǆRяu;TYlX'.2D\rLAO26g2	5\rTj\rV`ii\"\rO\npqD.[]:)Su:-B6sX;yRa4+!Y7|v)\$Ј7\092v\\XÈMZrt#0Od\0%~PL8w	\ny#@\0h@RLsi*BRgWRxn!8;YgZ8(6yفͪsB,5%)]8Ri>C<lߘ@_^Z6Cկ8 =g\0ӟԇ\\nC1kY\r\0!%<(|qGK_S@g`NQ`b<d\"ZB)/k_ZrctY[c&up\n/8ceM \r@?N{pDn,DV	\0@	t\n`";break;case"bs":$f="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,	+-+;2t2Q9l:br܀\n@>,\nhԣ4cS=,##J<ծAЀ1mP梌oP\";C5OB#'\n\0xC@:t㽌4˘x	BJh|6hB3.cj>4px!=/	@Bè:! `EF;N2_\n6]'\rOԃ##Pbd=\$@8G`ܿN\"83#2[]#üH,M3Z3nbZh:\"9קȸɡۂMN67kN\"d9.#H:'zRS18}`Hs#6_5ÁP؀ʼMO\"rbv=<?-J_[vW4݌\"6OkBҿ< uGrip5Z̳x72%~£@o57NTA (sVz5QN)d Ip\n)%TSQ22ΟsV(TH3C\r'uJs8X	b,`RYgpOϢ[\0'3ƹI.\nP\nr\"[jNJ!@и.OVkX̠.V +~VX&(Cr}9ȕIpH18%A˙~pT@0r=!ͮ\nj,!\n~(X` 0f UMe&	,VBa113Iw}@BsP##@,\r\0(9Uj\nX 4K*3Xh4VmJ;Ǖ5̙5qyi35n9-TN͘cf3lfh(&/aL)g;S;hkf0u%ٺsIkTk6鄑g'842# hlޝFI\"xwDenՙ0MR\rUMΛ5* MK2e@TʔBG,+Ш3@Ѣ2&x\$\\3\r>\nn2kV\\)jadiB\0Sq=J@B0TE<)Ӌ^Iܵlą2٤j@'@BD!P\"\0PhD̙eF)W@-%ʮo&8VJ/-5iԺ[@Stn`'tj lStE\03Nuv+'.SMż?7KnvPyBix-&\"][AkP͖	=\\/4ӆQLMLxƗ*;\$ SoezqG\n`K<hcz4c.eQt.5P;2(\\әaN5AT:gN!H>!8KHxC~8*!Ebf))6-p0<ݶbO%Gc#ܿ T!\$\nC\nm2U(͠@/lFKH̠Gt IDw#ֽDSщSk6HUܓ9\r܅y10\\	˙sN 9\"s{\0d\"r8K#N!gsrO7A㽂sȈ3\\s\"Zy}ƈ(|<8Ucl;愓R<)T71y7	|sd0tXlmx4`3EK_^QY1g: %/CUm,\$S\$Mu~Oqp<ѫObs_{V\nՆ9`vxlBk\"Ҥ(#\"hP0@\0	-`C3gG^te\"xe\0n'C)l[̎OȂL-CCenǰdOC/o%bO2\\O	Ǣ<FMtNHM'bLGJ\rQP̠\r#(邺0Mb*Pu̍C(nH,'}4\"iz&Te[3f>4\$JHPꛍz(NGhEF \"B &#(8\"\nY)\\l|\$lJO16MylE_DO\n0h`(1q=\r\$Iakf8wQ)ܱ~օ-x q!~lb1>\"V1/RF@]b1h2	%RO!&0&-2ۉI!Rlorq(`xT0SNI>Ą%pl\$ɍҬ/%'Mj!ǆ1g\nCrD&Nd%/^&~(=\$.`Q-QHv82[?/s/\r2-/(31&j7NbR]3ci39.D;3->	%bj1,:'0rA0H7o8SbO7n?E(nphEABd#k~cЕ~dO;8#D 1d\rVV)\0C\"\\M\"PB	\0\np{sj2Xq\r%슬+t\"p~R6i\$f|*+#13DC:/ik?O3f\"NF1MEID@=0K\0H%MB+,Id>hm\nȭ:OT{seBtKsϝM80%e`1*k2>t13qLKPW'pnpT.z0\rDCm2(`tCG|'2P\"#lq'-2laFG?HMc..D Oc\nDAV\n:Ğ*";break;case"ca":$f="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.̀(p4h*; ppi{]\0RL\"r2qT;ÇBHPu&#p3Z&fRM,ը#P2&M\0c|>D\n0c27X44{WAÐD49Ax^;ځr?Rr3_J|63.xB)@X+7Bj/A`N:!L%l.57}\"1,[.+ui& @1-Ly@ڽG)@KFl=WoBnx3,T\n;/cL#TIV.!(20؃zR6\r~'N!7CtPZoRd2RDKZ-V22\0(+RC4ᴎ9+1J8~Oѣ,x(5zhB(WLLei8D[!y=fӔƼj9Nqʏʓ}Q,N	h0MJx81>̀T\rp򆌓VD`3C)K>̱R\n)a>O?ܒ`ϑ]\n@rC0bLLYK1g-Tlz/K, }^+BF+4#˪:*9H Z_eP|k<KY=h50yW1BιPF0|\nb̚ֺRS@I9.N\"t*+H%>3t\r갋]8GJ\0re	P2RUBш\rt#6hlTP3&(FW_z @\$x DjEqGCW\r`i5B*#Ͱ7y	\rەF9e\r,	\0c\rԻNnfٛi\$N}S\nA&@p A9>s\\II9V])#Nfcj%\$6MI=Q&@&D\"M\$dHiF̣ \$5!>uFY~FO0¡R؟h^\nRa[LN3tcN:洹4yVg0RG*Oe<ɉ83WU&A0P^%%>`)Vԩp\0U\n @D0\"SԔf,r r#8rA%DA%'\\S_:#xhI2	/di7ANxzvިo\r¶@<ަ%_9;X۔AY#\$x@	\"\nĽJ4X aILi-J|EBh##*Y;7Q#עzif\r\$!<DʽqOpqqɍpejnȕ&wSRH+zfX#(&@[s@ ceBiDY(NG˫\rͰ01O-`j<\r8\0PRCqQ&SPHhDz!T!\$J]z.O;N\"4 x !\0c5@pcCd|[BIe0Ѧà.;>r80pL 1`ɇ6K	%er}I82)PpVQDs,ʦdȞ3 \$DIˉR&	jpUNXd`\nqibPzL(\\&9?.;=W&l }rI!91dsΡZ\rÆiVb\n5<wW0#љKL\$͜c8oqSޅLje%ɍ.qmR!`!0DcdJJL3	+DWG.7X)L*%DV8lf\$(,fd_@Pmh%RI/Z\",T,,Nl@ܨ%/l`wd(o0BQ+j~wLGLM,>Rvd{G]Bs=pGP2g5\0bN0{\rOP&=@Hl܍Fe=FԈ/PXP\rP&NzmPN.ct̅62d%%9CH\0C+Q/K@unRP߃✳%%R	Q:Fd@\r-J%eLG06I\r:-@_K\0!/}e\$b(k1ưbPv,_p&/ev0oM5\rMpclLMʣ&iLknSQ	\r\rJ &-bt̲ad1~ű20ٲ(9}PK3p(R`;\rwB%y%ck%`R\n/%}&2:{&~Mp:1 \$)(-6ތ\\ղ)<ɉd'R2f`R\"'U-([.Mb\n\\YSH/.ҥ0\r\"b	`2@eBfҔh?@Y\"E<3`\"qMdƠH/4n4,:lepN Zd\rVVZi&.|`B\n@\nZ΀VX'4Э7cx<J\$ P_*sP-%@y==dc\$60u\"L*ib- &L]*6!C\">;1fh'fzUDHlJᬂ\0/>6F3\">BjFGyH0J>UF1Tp\n| 5\n^`&ԃqe(2iFUMcC0p	ܳfop\$\0dJ{\$0&\r\"iGxFdtCD/D;@ bu3  9-/G9H~'_R|PH .pSm'GJD.]~@T 	\0t	@\n`";break;case"cs":$f="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4ƈ65n\r#D8je)\ncʍ\r9(jF\$AH̐P\0(MRD9h*OkPI l=2Lȭxf!\02ÐL~0z\r8a^h\\05Tx9ㄜ9HJ|;&A(K7^0Xn=e#C{R#5]7CkH77`x.޶l:[7\\+0}Pʁ([0dcJ:.o2:(\n%ˉ\"P#BL>9Ŋz`xЉzY@:\\g@FYCX'CH=\"փ#I+cFMBb`Ȉ`WZi.zGH\"&La[@V2̹ZŰNs+{{%\n'K(#s4v#GfEKXR\0;\$+\"S:(]ǶWQEyw8z=Í1H9C2ҟ@_TK=> Qf	pR-F9bv\0mjL10\\UiML|CV(TA`I'H7B%SM\0P[!;BHY0C(#\\W+!>NRQ6AziF5pbgHJoȒ7)PBUA\r!a,ERYB?-0V/@%\0>a8D,Wr#QTR%:MDTΑ҄j52FQBd4D\n++?j_EV:Yk4;t[JܸLm%/(AELx`7`'qBN@sצ`z<*IXAp:nPY8	]IHvQKh\0TQ^YX)qNaxz;IXLGduL>Jp9)8Ԅ\0 4Vj:\n\n)A,z# -PPu%.\r	 (AIUAK \\yA^WG#y\"e(R8_3DF^pI aL)`\\ 8e;D.?虄V\"CcDH<XK3MOӁih!:&<-=BOֱ6F~gDǭ)EL\nդUDfgaC^\n<!@'0iJu/wje<HgFƃRn/+wk)V_\\_1\$؆޻\0F\n\$ߓq\$~Dm>GVHz'|VRP\$IRViM\"M4⪰+Hz\0,7c/1F*['A Ud55LI0)bp9`I1+ AoAuA<歭\"wX0c\n{fqu.w#i8|G\nPO>Rj^ZѠc/`M|aMPux1Sȑ&ńiK\nSy8&}nZ50vgg#f2a(t\"\r@(!~M\\lwg	|3tw_'(k\"n`42C<MfkBerIvAۍiAF@BT!\${I#z\\r\$LQ#k\rl*V.yki.T8DxJ[tX.Yvhcf]<>dx׻]1 ;^u2	˝-2fUU^lv̄2?;G(\\=;>Ysb{Hٶ㋐Tf'QDD<t߂S	4koffVG%`ES\"(\0w!/XEtXN;?ukbFlP`(RL8t1\07:c#~C~lzcDcN75J#'P>/~7yp6A_`dܐB&4w.v\r#4&\"0dN#xrijmAjĂppv `4 'mL,'\r b\n|M+)NrU+/ffj`@L40~FMP ِtΥf\\U`\rF;k,Gڐ#1)J\r^{~HǢ'l{gf0|`(%g}A: }8+Alp4ћF@q4ThDgb7=QeO2ތRnp`OŃ 1 [ ԕL' ުψ7&,Q\\d&'>!.,|x##ȤEjȆh9\"lebX\$\r#N&<'\$\$+0ޒd<0cM(\"l-!P& 0n G,R\"1K^Qx孼a{,sJ/IPu70M\nz3.2C:=x@Fn	b*M\nf<<F9,/45Q5I-O`@F97Ks5^qL7xkÝ8a1%bg@DBC\$x;::0m	;y<1'60S1\":93lR3C4W><rtu%RT#;rtE#!ts\nq+@mt\$OĆI.\nl+CA35O`GDEBO>5`g2'GgT=> 4!/a`T4AHH5JcGIqI:V	b2e\rf924#m\r4(CD1'K+@#CWOGNe\rV;n\"e!W\0Oj|?f|D'2E'f\$Gafo&\npѦ(O4\\VmmqP5tmPLB&\"/E\$zphbrtƘB? f#	b9GHfG&B(9[4F\n/ld'\$ҋ*\$AcPJ(2S&v\0MO468̨XG#aQƄjcg%ct2rH	,<{d#Rl;^9\$CAP\$pׂh(Bf 'IUE1i2\"epJ#eCSLxuka,)ǮmL˦6\rc?k8k->f\n6\rxI@@";break;case"da":$f="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑#j\"<<crRbjhT	@-;\rȘޑ?X\0P\0P2(X j֡{0c.,Ob0;#7o2\0yI	CC.8a^H\\ȻγzC\r:0\"px!N+0cj2=@P5Ta\"0;\r#([RBpж+#hl1]c(%-\$?\r|x\r#{0 3#Ўhم5ȭ4خÄXyt\r9~1!I40cF3BC\$2@K!`Z9l)\"`Z5lr\\2ܻZ09,'3oRp/R\$B*W0-[nZiޢ\"\n=08P2	܃XN&)`B ϴx3j*⎱7ųhuAA89#8µV#(P9=k842I[m#k:UU21#JD@T S]P* 2UJ;Uy-7+}OX%\r(6Pax(\\cBAg67 `΂A1\0e?B2u	rSz5JHwUi`u\nA6)A|A,dL7J\\m@hѹJތ3F|1@@\rX .,P[O=[=<\$:\rA6VFMᤶ#\\*A锸>Dc!s6H\n\0T|P((K2!R/!Ry0ET4@\\K>+Q>>*\$d0~Q7\"I!4&ӱ42.u^UH)FPkיh1CBTK	qafx3^R\r]\n酨С2DC˻/%>'=,}cK\r1ڣ.TY\0¢LsJfh /d\rA\nJe;'@Eq\$jZc k2Dp\\äky9H0T\n{PrXpy\0pROn8PT@-K	7Rqm.iܷSrɫ\$\r%\\EшF\rHE \$#}TQ\n( ^!:D%erM6>he).LkezIӢN\\˹{*:Epp	D9E\neY*RtHzC5ľpXVs(\$\\xtDJq4!IZMbd&IC1:\rF5g!h'̢.2-&5&ޙkGe@:AIH\rEG1v>\r\nP 0)ݡ>STh\$V|l.HA{\0^U1d%})b*	e\$\\\0O	jgPs~rZD%V5tl4:ZjmFPȥZKO=ɫ[k-bvoVw\rĽJA#|Kžy-SQ+P0-H%lIZc\$)Ok\"IK9APZ_fA6u@o7riQ2aRC՘sƍ5<n*J2ϑ;xcEHmȎE2\\9:\"nZcnNǫ@^EޑB#DgQK\"+7o R߁1mvuOo&KrMC΍̻6u/ao/4^=Y ]E} Bc[N\\efg1ח2ɕ}o*\\oS#PqjLlec234ȇ(fo\n\r28, 7.*\"z>#;\")lxOʳ/%\$mFfr\\OjZplOttOHct\$00q	ВFN\n\n\r8k`R,J/lcO	I:EONoe	om	\\Ǣ;)&?+/C41d&:PB'F\0)X:\rq?Ѕ;\nkBG_F1>f\rEJ1O&lˑu\0*}јC4bq̀БK1Q\nd@;qi3C\rpUcQ\"ӱ(I^e\"m %(D \0	fӢLb !:]0׭C#/ـd8\rV\rd\rmpbQ\$(fPWJ\n\nK\$jh M((B@Vn#X\r&nECz67Zj2T\rL\"Q%٣£E\"0r}.@hB0K	|#>cKFD\"Afǌ>i-q2J21Bl\0s\"c(542BBb2+)S2k^dk#&\roi>.~i8H-bBBt;5)-Fl'U\"03J»ܹ`B/@-Je;0B<k@`@-JBb\"";break;case"de":$f="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº\03#dr5\rZ\$4)hˌC/0\"눡DhB`3 U&9`2\r\npCTv1ij7mB4\r{ԔևBDxmZpP}R!xDlOF4^0cݎ5)C:C3+++C@ NHRb.2{.9c+9<HKek؝\$ZM3SÁB7pRjzP-.a)<B3ދT3(yNP11(Kͅ Oֺ773~&2و%j@:/z1آ&^sC~ۺ\$u24]65˔'<Sϡ}\n6e	C\riwJ0MKW6#mkX<v׊07Nu<5Fv4a'waoZi=sWh3e\\#t;+^?%c`ބ\r+:vBp D4LH	 NC`./؏?CgO	D	e pZ'f\nA2'rt?J^A2ȇ\$:Uk}WS&@fʴVCZam-żr\\dlCrqՄ`C[9#{/bgq]pK	(\rƵ@Ț^2~j\ruj]=`uP&2k[+l;Yr⎡r78`ڇn,cdML+Ԭ0r'-h@N[!3@'PỈ\n (Ц\rr\n/D*oipEM6)!+5p0u'oP(d	3:|&QW\0!Nq[ت93uOJN,#A)Hr4Q2@^9W7Rm	n=eL-	xOUN~8,eβh+|cZ3_x00 \nޜS2D:dD<W_g%BM*蜓xAI@ =%\"vA\0FJRqt\nA0a\\CKm}>ЮGbp1h䛇%EhCA3ЄD(kO}-@`RIadc9G)%-Z;x9>V\re 75A5 .z\n0T\n4i	5	Gvnd0#obRp`pAr	*\0BEE\"Yr5%3>r)Bxp\$rzLN?i>'Ͷ:AE_O*G\rH9%6`?7z	3`8iz,Obziӥjdݖ\r]7|pDf<13l`5)`(5DK=_;|3tg\\ZrDLCgH=f*[R|6Z/p Ӣ\n\nb5\\a5'uɺJ\"d¡tkǀRXuw_RTEC{S\",t\$nb'uC?6D]FP 06f@ޅMT󫀕xS3\\4yb}3g\r*C,=2:ޖL!F,	ʰ:6FGuɛ3h^`\rmȵ:BqDS`XbB(}ojP'?lR~q{3F-κ,Nr!~)&fѱ2.61LPǰFc\nIRS`d5窽9\\PyŎ^v )>t8tEAQI0χb#g#⟍n /+p-0,J89Uhi\"ifkĨA {Dr5D0^k,jPh1FdbvY6ܢ6\0Z\nn9oj\0P	,ɬs\04uc\\\rPА\n&NL0c35pu`xyp\nc,gΊC\nN:<,&@O5ξ{΢q&VP\"0#h'pl,ipPό_cπc\r0\0CT4>6THB\0E #ZBiTWK&on+/Z+ Š+_`+paQdM'	\rއF\"-=Caa\0p͹!q}þϒ!%g\"*'\0B)k01A\$P#P(&rL(E&nC%>R#`	JMΈPgȘj10G\"g)5U\"^1pj&DJ2jv1\r2fV#g\nC\"`kGPb#%/Qn}&/;0>/1R#1ros+ҷ33,x\ncH1'5_4275UK6-Z%Ne FsWR)s!9sk#2&`A9\"%B=`\r\$R`i\$e A-m{+2,<Ư)=bf	gm|˘Ʌ.NϚ;H|%,\r#L'qFhf\rW>2`0jj{+\$FtFѶ{ \np4ޙl6&q>/P7=P\"b;E\"M+\"Nf&m5-i0ĥC:|:G874#I4Bt.%fI]H#'S>QT-FjL6:*2# .l<'\$S\\̣#Ib: GU\0u4	TNuQBqQ,0Q\"PÔUM.(oXd#Gr+A\$\0d\$rUdNtQ-##<cRCOIOF\rOvc#,PK0a[q@޾D2(~~ϖ%*#I7/b";break;case"el":$f="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0sOjC;3TA]ҺaOr4vOxB-wJ`#k4L[_\"h-2_ɡUk]ôu*\"Mn?O3)\\̮(R\nB\\\nhg6ʣp7kZ~A@ٝL&.WB\"@I1H@&tg:0Z'1vgʃCB5x7(9\r㒌\"#1#x929(Ȼ[yJx[ʇ+\\FOz\n]&,Cv,[WBk4F9~lD//!D((H@KC╖=APXJPHF[(eHBܚ;\\tC%%%%*d72PuhvĈ,͞,FuӼ4ȤdӇn@gAu0XZ^eAKq8\$􌄗era,# 49N=O\01sT4sl;#7OÝA\0y3:xﻅ}LAt3(;2\r,ߠ(4#x|5pSdqYR`aoF>RYD:>=cajvվ:Prs\$&rX+#ݨ#(C2>NyZb^Ri_x*w)s?Obj31u.P]3 &5T/\$mY\$	(\\:~w!%vg\n)eXFsZm(FkBLaDE@?r@'Y\"\nםHB&Q9FYtNJcuLTb \naD&Đ`hRxgJ;rDUqI)A?1:TH#T^,2V)J=Ĩ>NPE\")MB\$H\"tn2Ѯ\" ii6&*a\rc'I1(x|a`]a\0]-ͳ6j3~]eXkI9\"#ϒ{>%/xT<8FNee*gE)\"!:A:Ap	 !9K'|u@ԱʠTВBTQ'KE	}SqYFLǣt|:%Ԍir	((x@Rtr!V=g96P5HdhM6[{qnmջvc~N2ãp`Xw)ZÚ.^	HbyԝZHϺJVSsSP\0ĀDY6XҾ_1l͡6tnV3Njطa[\")VlKG	qSk0CɅ#sP*.½tJmB!wthȄۊ(P]e\$=bK\r`6Âba2daզ4pl\rᝠa6ZM\0ګn!6Mr@I+ZtƇ !jy7`T4@@P\0\\ϒ>ȩs/!fMh! Lu'0okU/aztk?4Aq\r\\>\r1~~8;KJTI\"traL)idTI\r3BE\$g\nSVs7W#%Q*O4d<2%@F6HjbP\$ZzKjf_Cv	k^D{+ dD MCj53R k0G'!Q囥\$(%@R¨T~:n>R62	-~oFdͧfDJ*_ӾlZ^EvSae`\r%BSD\"^WD߂@i3*W(!/'Iq\"P#/IH>4gYF&|R8>*qTXo)1j)g3(Yte41M*ڻJ+r	5S;i˪g'?#|9H@\"Q\n5;qJJYv)rXJq>Sy1bRQ3k6t+PHN-%᜛%;8CBbL\\ui&/z-`'`t*x,B}L4R#>N9XX\"\rȞc,Bm7k֝Oi05I'dB_@ PO|PuPuЊdp4xJx̏'(\nZ)DB((W,#2cj/f0-	cȉB`P&I:\$!dI8lg*\$x\$\n\")!ixzht \$pG:'H+6tcbJd \n`\0\r\$iF\$fGPgIN	/D4Zg@#'ˢ\"X|T\"6q&+4bs?\\4JZ'P5 W JC!D,/\r2c\"Q\"\"05r4(R8I#1 '9¾b0(Ҿ\"E@ +{UbNp(P=%\$bz)B**&r++hxP %='2l&΢^0T\r^%φ]PX&'~s\0D%:;4e3ǔanIl&-p4dO35n&vcF^XH zTzJ-hIp.EPF<<32[8\ra\n(D3\0:-ǤZ>#s!IG^*q&k?=?9v=,\$>Ќ@ͳ G@OBPC??6B8D\\bOT>:\$h(*JI\$<)Rbf6\n8\\ZZp3H';;%ptx/͐_O~4Fh~%L}%,SE`=\0SCQ>4YieONRaZ5	PCEITE[Q/l<)DS@h])IC4]\$bcQiE>6vtRS.-d+(v5*Y#_&\"&b&(|OGW*Wk-}'u!x7,oY\r'O{)n%/Q8;#1PH<5FU\\dPD)\\?S\$:C^]\0WQWSR8G֩i	&CZ%/\"wrvTO^wBKb#.4.M~f98C7c-l'wLmcE\"\\d(i(K\\V<E0Ȕuiu^oYQMW&@cD^MLvw-M[=4w[5))RU0_BTU!npmv%	SU6VO`nx5܉OuO,Pm<aW@1r5OpVuv@xr	!Q\0r7\\B\"\nhwl:oJK/φͧ5r#WBcYBpY_e_UGY\r֓pUWu uJCV7ut,~WatdF[p5|wb2hAePz] }σX|t¥v\02\"JVS{:xc~EX7ɸC\r?BNv+T1B\"qv\$7|}HuGgl{p7<8x_DMoC<,H/U{V[çxܳVO+f~WGK%1Cx!ZotkK(XQщwB!\rU6߅<ʘl~cxD7:\$_ux'J%D}]Ur!jBS['5c`VD7Iq\$~Ϙ#Q,(?\ngPي9RGQXR'cb)*6i\rV`Ԁ֩StNKa~p	dW>5.=%1hWekBCAy\\4}@\nZ@9-?A5\$9BEM\0r|V|_ȱ\nFTO;8mdJVc[=3s56,QkҞBCz;ĳVobNB͏2]dԖ=o.er\"!63VH.]OStrCG`_sXkB;Dǔn(T+RUx;>_BcjK3;qtXd[TuG[BlQUG0M5H=6vNe6ʇJeyF¾INqe	3ٽhf1'\\ 1zCo;!GoPc\";)w:Ğ+YGckp3͎DwbO!gHNU2b+ M8|hCeX\r	jQ;fwQ.qG^E/3)";break;case"es":$f="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[**.<41h.o0x35>+̩L!ʢ7C|&\r7STyc*# ڴOP(2-Im*Rc:Jc	A#8410z\r8a^]Ts-8^\r9xDjܑ-#2ܜ x!h+F\r=7F4S7:c*,\nåM*0L#߶:<xU\0<\0NQeF\rGg/8S\$%8_=H+B 	d;.x،:1-ALi&Qk4e69*\"(c;(&<0WcS/F&)=7F'.j.)\"`u`Vjv.RSKPxn-)8lf\n9+ցv)?@=\n\r#LĴCv\";،*&ku)d4qB;A#PΫDho7l8Cx\"FGPGJ\npZDVK35>KHsBɀKIl\n)&LKi_@@0I@Od*Fq*C*U}#,c:VZYEiP2?+uo^\r{^\\0bԼ׬+\$#F\nH(L[8Iނ\0	/.\$p\r&1|QYAi-E\"Kyp?`BhЌ\$x`P '!v N0c~gWq\"57a,lDCf	8*Kd4RQp430cȒSȊO̒4@P 4\n\nP))0GCFGm01xfr4#.s;}aC<0D`n\nC0%ȸ,THmCeh^S\nAb\nyp.Yƨɥ7K&Qg4<'\rm8K\"~I'\"0! KuvRB:!*a4	\$L<:)\n!4H!\"ŕJzMdv*jjxO\naQ[rG 1p8\$z0x	k6o(~|ȴLk5\r*a4U`[P\$Z*P+XHA'\$h3Y2V3jO\$6  ` U\$-bnB	H)_CRś#b-0R\n!qaAq3`1f4ݘ@JLxbsɱCfׯG	n1\$0Lj%xbFBN!ƯY37dɯԔ)@CsIYE>U@C\n6XbQ8Ty?'fTVaNt5]Y\0yHgw#w2oNRY+d;Sj}xRvvNwKbleк~[2n%ZN{a!HgFώ*̵%T9bMCu\$A[wIK<r)I4Wœ^Q%/HԷbUrXCROWPCH/+l`˙O\r|,d]C5[<NKC2wl`TԸ1<y\"GǚtG܇\0FtfU&|\"Rq#c!y䌾Ţ>FW:<tE`\noLyM05yDfکmC!7Yy'+Ae\rmEBׂUICu0#h-q+XYiX1H|\r̹Yc	&1C29?9zTz~Ĺyښ,p>	1uOd`p;ȴo3%?#[geu=SiS	_PɱrnblCP'\0`RlPOCo̂#C* |0*OgLV-vm,v\\<E'rdpNwPHbf	:y\nn6&,x.K,N\\d.0+	Rȏh\nd6F+P]D,fBCւ8&,:ʾ]BG Bd^ iCP/&LDpν\rp8O`Y*PkS.'	\0FPO1-ttcmk\r\rF|9or\rITe=Lz&#jܪ0kN܍pqQJuhv7plfh1\"X8bJ\$.rF>ͼ\r&1x1Oa0qqq7*kipүg G;q(j\"*X.r.c)28R3 #)h\r\$Q(Pr!P0\$%gR'#؍lcq'S(N(S_&Ju(NlBU*%FyMD6r'R&h	\rWJveM\n2e#\$ObP.%gmBf13\0L\0d0D\"D#'0@\"iG \r0@ \npc0b&;		o^BH椀#pmфI@lt/hЏe8ȥфmR!4d_e	\n0#h<' 4JjBNľ9D&2#H| .ȥ	JIbt\rB	&Od/,5#<Mx2J8NMT#\$%D0unbOcvo4pLwlp'\$M`0d{d>#xPoNlàDO7`Cs7m!7d'v,XCT&UDu vCM#\\N/-%2H@	\0t	@\n`";break;case"et":$f="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\"Z9D\$(\\ )07prr7rL/N3p:\"`޶\"	Nx QrP9<?Ä\0#'N@ߵkU	T	,`@7D3:xg#H|ׁxDjҔC26H7x&FMj'8*~¨Z,j߲I \"7_@P7H5P&N,T:,.<8;70mKכ6?\nH@P2㮈2C`됻/AEڥiB|ԳCF%,[2#(\r#H	`\r#X֣.\rp.H**1\0&;cuGC\n\"Û'hܿ_9QitbË_bDuf(5Cha_7	#l\0B*s@z(!0m'o6IJ KL0X7k_kQf'20FQp\n@ow80<UR8@7௓\r!\n<0RN&P\rij(ȝ@Fr zc]d*fX%e՞֌>ZYl^~]0]kxEvj6u.{R@gAeQ_ 6{Cd4=\"bC)5&px\r؃~bJY)f,場:Ul>(VxA8[sO *Dz#rVH@CԪCBRbV×9XoU*LLpĶL%li1)|4Ci&A̚RSx#(P2\0hqH@ёN\n (N&cJ\"cf\nS@h!T o6d*@jU\\pp<\0Yh8c[6\\c6.S\nA6JQasCvc8'KRobIS^2	6	I\"*WE!!sbOf>!E%AIhc&\$i	P	L*רk ]5nq4\rFjVh+y.&4YJ@p\rC)[\\a51[h\0Sq5	0TU<f*{\"\$^m1΃(yKER6f\$[xNT(@+aA\"z{3246j\rE3*iHu^H<BVpQ7ȑ`\nC*\r /:QD7U[1b>W2#QF11&z@Vo nZW|i.t\rS}hl )\"S5\nTdX*:n.ej`C!B݆G)cOÛ!*s4!;o	&5JoQ'%DLF\nLa.xd73pQS 0H֧%ZRkI\"\$:@`Շ^m1rxiP\"`SKXq4P 0+\$44SPZiM\"VEW`n2\rgXue%J& o][O\rkz(;Tb`;1NOw\"0HI%la?J%\"a;ۜn]Բ_;B[e,oPrOU`gEvX}tA7J570fMƥc|o%Nr\0;&S\\CƄ)uHoT漨e9z\\43ubq9rǳ7LOΎ&kQV`ڄI?&J#јot'VAzCͅ8fGߊ2Z	r(DnlLNruO#rPl/st'G\\_b#ԬgF1\0o\0P6v0Md\npW\$N8Ǆ4!\$	hPՂ9ZRИKl.tJmU	\0`~k85ZHtX6=⨖\$.BH]h0se}\r\r'Ipc.\$Re\\4\$V	mu]	jխBZ<jf;e`ĨaF0?aOOa&af!p%1u1{N`s0\rM\n|n\nq8	1V}0q\"slrӑ @\"\rf %<\0Q&y\nBڐzPPPx`iu\"p|Tnk]lu!*vLnߨ&=2N\rl5\r%r(cPd0RH7!t	R^tѥpF9LJo\"\$2\$rF&ny,H`Jr:׍bOWʰ-2%RoQDkw,{/\0P\r؍QE\$7ұ(NO\"r)922on:t	\r`,\0 &ڲItl0N515\\,*%6ȉ7qeSrh	`6nnt7F<dW	M:o8ld\rV\rbfb!?\np=܈BJ;JҸ\$eЏPƠHZu/''l\0M`J0Q\"Cjn\\J>V4E>	lV#\\d _&&CLi20d\nd+Afn#1LD#t4#Q>|3#6( `fN\$OKD`XE̍QwCi:BpQK OD&\0VN(k\nN2QFLLfbN\"dW9x>-<*ԅHMI\$40\nNxC9c O-CY(c307j\$^+w	\0@	t\n`";break;case"fa":$f="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&Y[MkLn 3XK#) \r*Fj/lN#鼩5(ƌZT3CTV2zK3 ( k°3\rðB#o`bBt!	B:\rx!F9ı8X90z\r8a^\\05x7ݺ9xDl\n=46H7x9Q5WU3d\$jB3M<\$kᐌ	DD.b,Ȯ0Cu#ɗ@NJ\n􈕲he'3!_d\n[KQ0:zVjD\$D#Yc01::40⿺nf2yy++B'i	Tsyf/(\nb* OwԱsT}]'ѓ7|)ⶹ*GIxvޑ:?F)_?.q?i̤2jάL:wJﬔ*X!zjaHsB\n0@0npCt_k%:zWK!:`l(*ܮtvg(iqG*\$ӆ H)x\r 6aBh8Aa{)]zX9 &RWK:1AC>m!?-.\"Dh\$L%q=E1׆yV0qEa%J&\n\0C,(9\0Oh W\n7 uipƹW:]kw׬^|^PtaPOkbemd=Eܮa!*ɻbtI>2LA>͢RĖ3\\t.ػ^1A\nJ8d(ĈK |Ǆ0p%jS+\"H:0[hq3T%@*s0ZhBU0@`l\n!heh3A)\nêY:Ҡ9L4 1rI0*l>5(\"LM:2u1)q%P	B\\PwD	A0Rq5|rD@޶i=p3%PCAlRL@!8 U\$D*릕KH) Qxk_qf6Ht8SMI.I&Qecd̬ATN/My0Qd3xI#Ak!Y%d\rjY%CC(UG@:k#(v4UdSI1;\$nIF2UUHBy\nHŒ]	G#4\\RI'F;1=6)&qZJ+քDJauB0T16\rU!WUi]tEs=vPn9TTD`p \n@\"sy&\\ai֬3⦞?LhI>_C0nșS?D~D\"kfky\r'>\"R?'֍T*\0<X~2ةQG!hy7og=]oa?4hrhGH*lyZiQ!@`u<%UW\"B'c#UKaGy>sMYp|ASoHUV]MfY&1Uk^>WBng(V\"I>%%|782֜TӍ^IB;4餣G=}\"+yדS\\+SMRtغ2ΥX[P 00\r(ab.KQ*DY\r1#iQȦ4X|Q1)ǹ2P~TaGCzh-r	_ƞx{\\|}˗9/9%:KMrmJnI6n8~\\şw4gvMə\r?	ckzMZԤLчt`O\$㭼Jh\0r&joN 4<k,͌r;OGܻp:ѧL%*63l0dFx\$4Ђd&lP4>HrM&v)nj0Ljc|A^憜F@\r(&RMgh-\r~~bHvjA8#\rJa%Q1 pW&%q*lжkj)J>0)԰rdd*hor眺.+Rk-hgSLPByn,CSRq\n\$}pYQ T2èlq@yoRhP\"vJDap!!	R\$1p!cNcFXNOy!Q<q1Q.NgY!1!E#n2DUNc%&6fFF1>SN\nIh|?a\n,+8@QN84n'?r7i\"d!O\"ѧQ1*%rK+#+p\0˧>jR\r(1/\"RpkҤxns.-.P<Ip*h2f*jlJ=RN20+.ң1r*<4S+J\$&.~S2ʉsl3cF7<rOO6sҽ.ԃQL2jv.lYJiprCq>K3TE@rS^FS:c~5-\"WhBg4 0Dì3f.`7@l\n9>'Q\nphxA,4\">]C\no;m͙-'[ƻEmB)R3o(MFʹ*INV%i9g<GR.,8Ϣ02'p|\n,J}p<&TPF}-V\"8ް-NNrPMDr̂MN&iMlY!C|VFDnM&r(}\nu,06.6CzxyvUQKGZ1Oð&5'1JqT#YQ	wG\0UU(Y-Hu5T<%5f->ceHe'n\$`";break;case"fi":$f="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1eţxo}Z:L9-fS\\5\rJv)jL0M5nKf(ږ390`KPR2i<\r8'\n\r+9\0ϱvԧN+D #zd:'L@4*fŠA\0,0\rr䨰jj%-*%k(%r`AS#JlDp+p)+MM:BBX'9-tBN##L҇\0SH5\"@(@4Ry@sK\0悥#@6a\0x3Рt㽜\$\rzWJp|c|cN	C'Es7c(Hܶ\rc魷R׶,@:*\0Wlv膌x:!.2l@-(<Ƒ)&O|l R.H!߈ãp֢E3C>f4ŔU3X	N +s2)B(n)\"[ЖW\r-ɰ&&Z;#3A0q3Vq*	Cjb(&s*	o; CR[#Mr׳|\\֖m0wB覽bE0圠#3ӘJ2,H4CoNTE\"79/sE.a('!HE\")\$|ΓxS\nmɠ_\$?x~G_驀1@@yE\" `Mc0PAccMU\rf\0P#A4Si\n=V:-џu|X!e,Ŝւ.j-ey6\"8%C@d5Ę\"!t.jbY 7s\nCw]#>o\n!#b,_aUJY=hƸڵe7!TAP|AjS\rᐐTdϊ\\CG)\0̇\$n?@Ѥ`0Ns0oW).IOXP`^{M4a䚗@t&<K¥>P	A	<-4 8E@S-NPV8e.Dh\r׉P<'~kG(?(&\0ʲI)T@s#eʫ(,t\0C\naH#JQ(&z{24T:.qwf]ɋ1l\r4O޸ya-vHA(=]P\rǪA05CS@ \r+I:W;:@'0W[Tmrq\rZ;,Glxd7`\"eʙ\$[L`<0Н bHD#[\$bKMd.l!{%	8\rA@BD!P\"@(LQ=yOI41\nz\n\r,HƨꓗnMxrǼ&e;OMQ789W4bcT'W!+q;:V!\$\"<2\\:z6)Gέ	z/q.U*hv-Ķg\"U14iZNk!͓.~hT<nOd&d:1Hb\0r^Csql]*bΩ15ٸf25\$t8I\r\$})IHhdQhy;EQ3YRVjːZP\n!q4xy\\ȖwyQI\0^8i\r,u-`y/48\08\$|u/? D`yKTӽymɬ`<+7йAE&iiCdACr;qr*2āq9wL:Q'ULE&IjqY|*sEtA;s=~x^\n\n?^qYwF`cYR	'DLv8ZW8.S9/_v_#ʾ 1D暸u}Qn):s~&R/4:c\n~H4PP rg_\"SRq	YemCb fZA&Ife\0eFF^j(&\$n,vJQ\0`l+\" )1\$C@r&o(/dMhpVK\0v8PS4I-ɘ\$nJPhЄ0oJ<OI\n<`̪S\n\nHiG~ ~&J4F\"ʢFp\n\r(d#2AKP\$|EhALR@h=ceMnm~u#b{6mP0MX[bk_Oz0j=*\r-!POP-1gj%1,uI@f(\"`v\"k80l.2P>X	NHoܑBk둦0G&#hƐ9Mj\"r\r!#2',TO#P	\0%zaH\nr:.G\$?CU/j:#1&RhC&Ne)\$Ox\n6\$f(2luMڑH%}\r12k1+ HiEc]/w-IK_oxQ@>0~O@#vc\rR&fb(T2̂KpȆ)\"DE13(<n]'@pKNKDHa0jd\rV6咈ˠpJnKؐQ:,\np#(\n#LSTt Ƃqrb#0#.]<oV\$\$D<')\0a5ˢz\$k1+\"26Q.&Fj%pۯRyL-6\"0QT&Nj)B)rID*7сD\$F/	xM%&&MpXhaM.F1̀g@R\$Q62V7-fPMB3-EJ<3PaOD\nt;JHRcRrI&rLC&/,c\r`-\n3dB>";break;case"fr":$f="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P0rP2\rTBp;#D2NՎ\$;	C(2#K+\0P4&\\£8)QjC'\rhʣD2B4ˀP윲ɬIN2ɦ;'\"c˞a\r)KqEÜGJs *IK7Ph:O.ڵ>UK=uC3(J\nL6	1\r\r%ʋh'\$(Sh4 1ġ`@'C*3t5r%8^2{ZăJ|6B 3%7x'B&\r<7TJaiLS+@;@8D,H2cc&P0Cu @7hݣ6S\$(Hh͕93\0<#&E^b23\n>3V1X%7e*J:O6 :ѲnoV4hbzä־aR([ĺ716@9KBw\nd9٘#k	yϟэu;a&(q+dT?1(:\"J{KJ\n{䝠\$YTgux2BItHH#|3Dѐ`JRFRtM(NFU\n jH<`p[-MqeϕnE^ቅq(&\$#0՛AMJn%!#4XÛ	sT&@\\:HA\$%2H\$1kCHRJL+mnW\\=仗/x|&v`F,ShPkYG\"|AnTS\$\">KDB%V\\r.`So˵w< _!>dea@K4\n\$ҺPeCq1YJNJ>?glԣ'AQ1,BqA{9GStϧ+t1@1\r̬HO7D(ʔQIFA?rYRw3Ч4r\0P	@+A\0(*P:1\rF6c(BO_W ʉ_%y\r5σ7&̾-XHRn{7S\nAT\nRNVE΂\rg3`&y\$RTѕePA )<9nd\r&7vhL\r,ENjMZ+Ù2nuVJZ(:N|qR}0OӀT'ŎhRcH Mb͠cV	*Fv~--9lc!'Ě \0䫔2\n֛{`L]/H̷bDR0va1\0)/UeƼ=䣐CT(Bi,\$012\0PO	*\0BE8\"Pq\nK]Kð!BK\$TA'n`8Q.ĞƀΨ22LIBHm0TL'{^(WcS69^cTSC*8oN%Qg:%-\\K*#L6,! 	rzf}/37yV8J5TMStBJo\09)0څL`o0R鳉7GE=Q;L:Ӽk}RC1l{U	ҍY!iגe\nd})L,n2Ө~uƒp8U2JCSqV(Q5-rGF ³DxH3Aa#cR(Ct`C7#=u!gv\"c	C+Dg3]6PAR\rQb#~J\r*\0mqz.;ckYę,񪕐uN7.݇y\nDiFkwk'\n'nS0,i/ehWMG&Yo;bP\r\"凱\0\n9Wxi>WuZlA:J8ENkFN@@?c\n1bfiX-.ьw͊'3?;IfJ &*VI4w4|&PƮ2pxgȖl\"Nqf\"gb``,ȇR'\0FЄaR&BViL~P27\rpzipӭ\n]-Px'M=p\r;\"ұ'5	!S'§=qè\0'Oyz)1Acqj<\$<N?z,d~NonP`Q/\$1 4NQw#?qD!In0PQOQ1pkR!,i#%x/S5-+\$siJ6(* b \nj=!!JJ<k\0=.<1!.d13M&:'.\"Q ,IpK)+Oo*0bM4ddc&aP/,G5*a-x+Qr.a+	.\\͂0HđF2%&<\$	es*q]0h3Nm53SEH\0P\"F=c+&+&5+*6jS*t\rO)+39#9r53?:=9.SU(Q:ӗ6#'9N,J9-0:S;	R;=sNLN-=`B\0Q*rS@+>>NA.=Ac(GBS`.Ns0lad@\$ S4puRDdD4tYDAC?qf汎Lj7JFg6v+@t\$h<ttC1抌GN!;4FRFI0V6!+.JBb\rVŠV36ebr'bm!bN<1c8lh\npѶf!MЃSt'\$BH.-mPuE[5uPR(|&D\nEVCX8u\08p%\$\r=1p},aqbgN4MC83@cBU:*u7PB\\\\PqEBGU4c-]aԥS*_UJ@SFöW<Қ#o9^b#*g.?lN76<&0<f2o:\n,r<0\0(1A[#ͬ+7&77Y͕攔#\rs<sX%C\0ekCPD\r";break;case"gl":$f="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$V60\0Q!X@1*JD7DP45**H <6<RB8cI+dǊ\nRsPjTM eB@0[Co\$#(]0X(͌D49Ax^;tiY)Ar3\0_ِp^*ڼp̼*r*|\nc*@1HqNb\r,:HK~&j5-bsp7Ș\n)7SPG憌\0<HKm._IھQ6Ry:N<Xd<B	\$3U&*#C3TFB͌!B4ZuK;dƦp(*ne\"	DRT)\\\$ݰN/\\P(U[kN.Tֵ[׷#2S0}xߠs؝\rCUbJI]1(?ηM8Ib x=l.\"FA%Xj*q:ЯSt4n-BP8\nTb;B##\0kJEgfPJ!+Vb	\$	* :\$0j\"H; !9fn!CJd\\TpM>Hu{.ՂK>҆JVPZYl-\0w\\J.UκCp/*}GD=k#\$h9P>\$Wi\r&Gɪe\nU>sHlN<P\\cZemվWm?1u?BEWzzA8\0*aO8OBU)+iC! 	Xq09	6O,`&|Ŋ%iNCW3@C9؛͓ޒSgp	6(X 2a\r\0(o{q7dÈSFl@)\0gKRAUl\r-MuGA*?UJA:nUHg[ȐIܐ\n5PFOP3B*LjnG2H0+fy8Li×A\$\$v(Jvm੊jDȄ*JZ{F~ò`\rI&(ZQfUPL7)88+@ \n<)F[mnI%H2\$3sl;H\$KHAlȑ!*iԊXrVcf0vJ\nd*Q3W%P5^Z!ƙ\"o\\iBx节MC\nT RM<'\0 A\nlxR\nXG	PB`ExO候@ŵP\n	TÅm#wadj钯.U{?nsΫLS`ĆNЎ0	XC7߈O'JNKjȫJh?vzYCVs*tYm~6T߀\nqKND.V\"Nb\$iTʼWaN\\@+(\nNѵ6\r\0PDhgnǉJcۊʓq<~#lzRnԛ\"\rzU\$0A_2!L@XY)U[\rhBT! <\"iD@fu\\jj䃑H/HΙx fǜR;+MTXFg[\\Tg\0Aёpx&BnNz\\ŀ<QClHLGZ*c,WU󸠮:\\ꏼ.ҌpIf,**B|]Ai5ќ(9^볽@ĉ7l%^sGW1Ia!D\"2v=+s_27iNR׌C\"dnc~!sv*wLKp~~^e<2H-H4\\IL!l\$\\}Cp\$%.D02r0^^#>)LB51zpPVۧ>g~0PH p|XmVOfLˇj&+'Ϧ0ͅ\nL\nOoGrd3oNGxoc;8xc'#+\rJ2N&/f/,ꎭ\r nTd0\n\$+/DQC*B.4/vbĞoF)\"&*bz3)6Y↜\$^ #C\".ƄNjqTDjҶ(0ZC&Dehъ+t\rzфh2\$PоAP=\"\"	 wMcp.2z`ðM',KipT#NR>7#%D݃pl2`%2[\$2{K\nl'RO'0h0^vk\0B>\"׃\0MQKЫ)w&2Mr)ҭ!+R\$i+?&җ\$%+./1/j7/P7\r/'0Fw!R.i\$*H3:	&\0QrP2BڇnBX\r(b4.5Z6Khp1~<\$0277sQhO09E\nd\rVej\"C6RkKCH\$P\"cpO\nqH\nZ}\"FcO*/#9G`C&`Cb;_<Cm<.(paC;F`uJMDF<hƀ3>(4\"2<(N0db0ȌCx\0DACHHMi*HP1%\n)\rIuIOexIeԥh3֌\0,tǇΎ4prǥ8\$0bU'A (J6\r:~.1cn2Rl{2,!B5\0#+Fd1()N\n؈U*)G?H /C`2*FC7(qgOXm+";break;case"he":$f="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;.!Rc1)!+mzHiz.DZvGMzwpIHs(fLקr h7;s>1#3ѯsoh4@:@o\0D4C(C@:tt4\rp_RTÐJX|6Om3<Ck4px!9ړ8&)}؃!3PTIRI0Ap+#IA(!1<զLO\"02Ҁi\$t&pNi_wn {PD蹮S <O̩ĀN2#rtn<\$w;G=ڃ\nb\$\\5|k͉\\r7B7yO#oMiTr̖a\"	H#if+~n|Kʦ-|p5(9#cڥ7u{v(:X9Lկc601gi2!B7OΛ}'2wl[rp:VP2瓯;l'l7a4QA(@IgUXV\\+X!aP^{ݠt[`BLX[ku\n59811	N\rq \$S)5PِrvC&f^UV]E~xX}	s\$!7G\n(A'j_T4'ǰ\\?^\rtY-@0AQЉl6` G8he`3;êR!::p4:{]dVElx4kBMqk0@@P\0M\0C[*1 ܥoTa4`<Tg:;rhHgH	U+n\nQph\r!V ά0S؀!6@d㚕q/6DAH	0hf\$؊Z.A1f(#\$E,BHW2@Z *#(Z;JY{3K&1RM0u\n\0¥2#uLkfH	%Wp#y\0[Oz	1:t˓	'*LL@Ĳy8# ^J_DA(XX`RC6!h\\dy*OZɮ,/K\rKQ8\r)flc (Nb'&`M=&rlHbmҗ>BJ<]d@hٶ䚎PHɾ^\\=K/GFG\0DCф\"\"R]-FbLi2CKM0Z+zClXI+9/dk^=\"7IS%o#&VD{lgmΗ=g׏\\61B5&g,buЫh\$a4tH*t<\rofEbJu\$A*@FH0o@H](BtOhH\"a F\"^LǄ䬜9rA<>ˉj-`D7L\nZJ^)KfXhͭdX.'D	y¢ ;7k =GjHe\"դwk2|&[Fe90.,6ӑA/xZBϘI09QAZ/S_ \"(%pO)\\I9m8bv&s@rikUTʊ4VCC'qb\n,6]|)07DoR9[}wṇ|Ǽu`[æ\$<1>!0&/9/n:_u@zVD/)'XKrm>qg4r[az\"lYo\$E]>s݇Mk6'+WDR{\\QkXdfX*~6n]5\$ȖJ2m\0\"8\rNO^n^C\$o0,\$ʹ\09!pp8#\"Lg4l4\$ĲDl\nFm'@M-c\"mp\rwcpkh\nJOmvll*4ìiqm\nca\$B 9\\򆄦\\Mp	 00Ұpϐpf\0ip7Ni/nKGPBzq\nslu+>IyTLciodJs]B8Oc#\"`j\\%d4\">ıMp_OPDB%)I\"dMx#ZJDKclnr{P@T\0q63rcP@lLdq':c2܆\rZ@\$Kq|B^G\$\$3ڌb<1LFd2>&0\$Ǡg#\$Mleڬ\"0yxNIXC2o 0x/**:8zO	f/-x/P\nk!+(Ξ'nXr,/k&e@-X#g xK/dmDn\"!(#l:9mԼH^ eb(y1R@þw-.0&*e02(\0";break;case"hu":$f="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;9ʻF@ޠq<H(0S4Hd=?Af	IC\r\$	B8: P6 =))cj\rJP1l(&L 1BA\0\r=dC\02\0x\n@C@:t㽴N28^!xDl֮46H7x&X#bK5Lk'*i /n/!bM\rI\n:B7=xJ2 ɠyj3f	68bl2l<o:wI꜃K> 3#R2B[fB4#Zp3@1㉾`^T(B碭V5t5B:GYm!5(#Xq6n-Z1#t~( Я S\$3qT-m?RN8zv	ݦ1ڑ`~b:vnzBd>8:P6ǻuN&tTt8Xa\r֔\0ed7+uɸL('liB53bB^>`@kס\r+El:\rZ\nIg%Cb@e.gE~P\nOW\nS%zZU,Ԭ場[h;CAr\\aH׺ѹzξWl0\"RjKdT ]Nq0Xc2IHDK)fE墴֪[+mnƈԹ Tѱu0|Á<d7\$C8FIF=RC* !eYȫk\"I(G)Քcfɀc!_s\"r^A2-VMg8 @\r,QyFMA̜8j\rZ`(B:\"GɸC^*q+l6S&zAIsC4rNCA\r!i?ڭ'&8'#e@C\naH#\0`#,<*|\nF|PZ3=)D̛a<2VgpDCɧU)h!vpH-l9̂T[6ICM~rEZ\n<)B` lL[8Cr}<!ahm:Ws9*׸1VA`I\\*&TɬP0@t,|LB#F\\\rmYkx\nq*p΃xp*a=Y!Xt\$9 gm-uȋgCNBscSj\nh@voT:opO=IdcCxbk93\$GOyT<`111b͵19͆!e\nbɣC<f}P9IS'F\\Or -8<\$xAP2`a܎Ғ\r<Leb|# DB<ڴm lbNibE6k	8Is++=Awj \"El*\$7\"dAP*#AA:P4ǋ2nk:\$3^WىLq8Pf8[qk]YY<f\0VV.85xչ(#\"rU9Kԣry#Xtʺ+0>9އV*z7[5D{!Nd	sI(.hkcz\n-\"QkCouY׮@\\2#AQG%1Bx֐voEdR\$d\naܬH;8BYs#L&YU璆EXl5棜اl|nSae_c[o_9X)[s`?+/HV\"P2F)K9Cm@Al4)\nif^ 0Db\r,T͌=p:l:T։ug%';d|	-fFDg,g*@P(˜-ZBpLvPN\0y<iЎg \n08F6 g~cy\nVg|9\n3AV\r.hNr0䇐NACe2p<\n-3/T`ؠ\r,?0*\r|;\$ ƚ\04@h/C0I&Qn6ƆY\"c!RG\"FvʋBZ1>q^W#k)}KVDq%J1\"1dOL'/L2dG'/asM\\6mb&\nf1%@M7&ݪI#?#LR\$Ul;J#7\"w +@Xk\"RN2\0^:B\rr-'2m)d\$jsFm\r%b\r-~2/%&*!}rU+]-9ED9b_\0}CC/2,/rG,FAr-r>0m(gy0S%236i!\"B\r24mU\rP(*E4U,2;51%甿%mܯlP,8\rH#*Q`?C3rgE4ɩpWf%;,Ȑ\0ʻO/?<liDu<~o+=l<=2@ޤ\nVXAVSqb%(T\$r4BF\n\rV8%W&\repEnؘJx\nZH+Ccn>Hz{x'}4{z<\$D\$@FgB%b/bJ\"JRC0I9~Z<q۳uER+s3\" ޼)tOtn=7\0ibeo:p,Mat\"sJB-?/є+rJ6U<qUBqb|\"ϥS_ÊcV5L2ieLjѵA+&&\"<tU@WD	 _MpX/ytSSAlV`t`\"?x#+d(3	CVb\r2W6qܨH<uV+	Lex-a^Ӷb*\rd+5/D-a8+ ;N񶇤.(-af^@\r";break;case"id":$f="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87 ڠ&#CSk\\1(DCN.\0P\\0\"(6( j\"nc`H@lp4lB6O4C(C@:t<(spܔ@}C ^)1@M\n|ҒPaH?0V˻z.@P7HI2d:Bd77J2\$#%dhܮ7V4x #K\"RC6#c:4B2B3sXHx2I96r:k\"\"r5E|hf20C!J)\"`1L.j5Jv.\rrk!H\rv_i(21@BKV[P)kNv6i{,戂ŭCM;@@pЯ(	/k,,רJL;1x3-5Z%*\r><	<c6\r:9ѐ`0h@A\\ی@iC%f귡Q%`\"R4+K4;O3{SUp^@G.~^c@q23Ij_IU?5G(Sx;(rT9@YUzm/HrA\rt/^%|CԘXP(PŲBnHfzgGW@as)٧wEA2a#1PJB`[LBk(N	 \ncC(!UG>2fT˙ʺt&: S%\n'2A4j7CJRFF1TԱ481eC{Y(!) \$JI%(]/y]g@PP d94!U9DcP\r!!RZHxy1t'E@cyR!ņ!y~S5ܠhI7#&h@xS\n9WM	隌/PLĞ\"ʁ,A3@H0b<B]3mɹ'A a*HrrwP= \0PK\$!~/X+	8PT*\0B`E@('G\"Z}}MHG hR.6)#ЫƅgeCީzG\$\n<ry'f.,%tCJ\\2G%a<5J*\nqgd,)	e`:B<Z+M-༇%M[Ib+tΫvZDb#iˠPVEe{ wDӐsJZY\n|7Q75d0qFDup6rTDCM&=\"\n\nF܄-kOZ]nAa Pƈf\r;#BPGlG @r!]\0ee29Zأ)HR-u4gb	;fР׋3_lsQ(<'yc6yù<Z#zs>0x9%.SIԩT+F;ը&S0`H(tA]Sh/n=Z[h;W|#_	fHN#nZ:q戲2fmkp<ݻYUo۬u[`}Du>Wũ\n3;*BvN/LxYJqH3[4k숗!7ΰں\n\rc0#˶m>k#xsvs.s--.Bu{lLTuN]k]kzteݙN:k95[nu\\59\\5=޿o|m~m?.'0AT\$ՄA\0j^-x4]&>d-nGSqi+yH\rq<x>N^µ'0x0<x,A>ߞBٷh\rhEǯ~6#q#5f/Y0NǆJ;\rAg-NxO[\"v>b2bƓPIbf*kwiJNPDLI-.kjNI&fR0^nH&q|/[njD0=	ÀЊ\n Ю10\$p\\E<\\\$h\\MDǦAphp0P`\rdN;jZLdƆT+ 9,Hj,fx.	5Zd>\rVЦ\"ʩFzcDux'`PZʠ\n\nZR#		0'j=,x`^n ,dgC٢;d&N\$j,7\"@E(!\r	ީ%fR&Xc:Bc4Zτqc,2f͕!\rbtݐM\0MŤ	(j^ʩ@ZNdlr9Xf.V^^j|#d/\0A.&&&Cb]EcX2~q%l\$(Z\r(40oDtfo\\ DeHBDj2\0";break;case"it":$f="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCΤ&C~~Fthts;#Cbl7\r*(椩j\n4QP%\r(*\r##Cv`N::MпN\\)P2.cʍ\rҶ)J:H**^2ÓBC\$^OP vɺ\\7I('#t\r# ڵHսO1l;@XL̶\0x\rC@:tL38^w.xDj2Мi x!Z+5M=TKvYDf&\n/K`*vMb/r;#ʙº!\r:\0<M}_7\"\rã~6TЭc(0c&ЧwM88,(3B8P.R\$TN36Aa`W2#v\0(P0kq[+JL.n\\122ڻeI6ΰH@.NHa.B d+5\n-\n1);͌\nZ](CXԬ2HB739%+	\r<EÌAͣ*x;(P9/	4sl\rPޖÓDޡ0Ts#_u.T<TT*V,ܭ49aT*kU(0V0Hr&đ.T}B?jYL?:\nTTH{t[+	|ɡ'!TS1-	ᓴ*3GY*ma#̘'EaШ2vHz\n4:Q!bI\r3\$pC\$\$#L1;?E]B@\$\r8((9&	-l2hZ\$y|Vjr@A;7ІR5kT(WId*I+8\\Kl1O/C4M8o7BJR9%8-fp`D[`i@9\rDK\r3('.&K^L1_)jMZBf@2y\$1Sj&3Ϣ!H礣	L*O\0C!(~	5!)mW1m2\$cVk\0%3Tz-=J\nYRrFt4\0U\n @ͫD0\"ޏdS`˦) \"NS\n	\rl*cer\\'\$bZ\nuT`OITԂp] uls\0SrfH#&@\$y`tyr,XJ4m1ILQe\"HЛ(U-E:T.eՏQEL|Ft-9\nnFvg;D*!iւC0sbE	mzgTkjsfvȕ곋c	,T3F,4:CqT1L2H'e_Y%Aa Q\"ge>Gc\0yˬt9c5_%07Ӻ֧ \0O	jUI\n9'=,\0 Z;Ey	j%8Ø4<2pR-_FKhR|5'u9~|[A\$\"H)Ͳs;J[RZUA\\2#h2S<EÁ*]p޵naPh ,((1[*}\\Vn\r'g7{2;%͜#K]\"'ƪl%q*L\$^Qs8B܉I](%}@\\ْ?iAX/O\"m6<:@o\r((V)n5ERr7xR,ݬ_)E%0m8!\\	ܡ?ynq;HNrR\nY59z412<|Z(O9#:Qtm-z`B[R0ˎNK1xg!wk?=~Eּhs\$ZOu4|b]2\nC\n4\$ۜb4e~\$:xjtp|rS<Djj2Tn:^ӓf߉*2!NXpbZ&lZ'UNPpJʌ\\,rH4#\0.88>&*J0	dd8G;6Nd#v.7\0UDb`xMLPmC4\r\n+Ўd\nK	Ć[KTG\"\0M䦣dn?E7 c䰖Z\rΪF,-bVDJDb|B4D\rFnD1DUCwpDQq0,xO0wg1jO0BЌqZJ5l\"J\nHO	tC\$DNKef	dkPѬ N/z..B0T</80f2ڪBxp]b1lI^\ni`A 9@jJ  M<Iv``NAX*i\npsr/EM*&dւJP-4Jkz,p@&1bP%GlfG	0;#z)-r%	b# \$֪t&*rH9Md/0B1̌,|q	:!H#4,b&2-oB-C1-CRI=L@5c(\"8vN?o-\"B\\2ep-\$4e겥NhϺA#.n DXfʍ2,\"Yk,b, еD:\"g.-F'\09P(sf#\"p\r,\nALfhl,	\0t	@\n`";break;case"ja":$f="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99##X2\rZ7\0\\28B#bB >h1\\se	^1ReLr?h1FzP B**;@1.%[,;L)K2Aɂ\0MRrZzJzK12#eRiYD#|έN(\\#R8U8NOYsI%`j3A\$rsqP(VO,[(sDSUT\\yQJsøsQDYւR# 4@A\nBt3\r#܎w 7<1B-`45D12\0y|3:x\rrAt3(E\r[YrX#x}u=pANE\$ЎhK3J	seb*WjZt)MtxNA \n7^PJ2D/3F&o8g9+AJEr@1\$DsN'^1HNDeBtu\\pO2mАV3\\tdè67nKm\rc\nb\0pdZ@.s#[Tu][aZIwЗHd6҉'ŵB8'V+x#A(]KWud	&`+AY/eTߨ~U\$~B!yFt+I09C0n^9%leápf4JfpAP7n :%0 \r3@bY!0@A \\a: PLNTQ@AE&\rJ7LUh!8xC\"af1\$cLqH+'B:3Ng!3L *#A6🀉S\"\ncV{Z2K1hu\nf{\r\"pPtiaȕ0*Xbev:,L2Xpɡܧe\$6lY0tφ\rr!̯*YlI<\rmf`H@)Y _#XD\r0ieQF8ʁ7a0>\0cs4I1Fhr`14.F#dp/Hx*\$<?B2D2ē\$[UPф6tCכfmMen:׃\r;,:hyqnՂ2a9)ç0`sҜS¨!0hj)i9D3-2Hjg&ڛxOPLGg0ƁD,'-\$ÔQȣ4n\0EFB!M@)a:2Pm)C[0cBTâpsO\naQ𬔠PI&hj.X)\\3Vv1\nѸij7э/Ki	3X\0@mF\nA|gjayXt8˨qQtBxNT(@(\n \"PtyL*wwLz+<Ǡ.Ki6H2|D}>e1ZhoE2!b\"8'I{rs\"\\ڊ-YW)>jjndsl9*r*-١	jxwUpV]^i%f-TJ#VK!-YPlH~dGĝ˨L\"lN9xQUb4,LV+ʣMm=VA'FbWxkΪ,~m[Rf4*XkU/o_P*K<l}\nì.GW6NWM\r4/3T!\$9qmƱuSڇjŃ&IA^cʪ֢@L޸Rz_BGhp/ZެjaL9>9[\\b\"@>PA300\0@J%X[vXm&K_I.4!|5b-hA\\2%l(ސE4ƸhsmZtoIbbbO!Zjb6Ă2\$2lFȽn8\$ogl&lkGof*0k 20Mt\0000Oa0Рh(ؘ	k͜-vnH0zqgXD~8mgY\r>gBĘ}P#nvE0JdW0h|-j>Nե|bn Rfx͖m\nBgYBMwјz뱅KF!x(,\"kz oKn_ѻ1v~ƠqcF NفUkt\"h0E> ł\r~cD,S\"*LBq4~C\rW>+\$2B0H+̪ԑBLbiFANhi* mr 1,j{!.jAC(^c mAg:1X391q~10{'.N9-1\0ܢ8S΃s4,s>T3BU4m-Q#5>0֒pSu-i83y-[9%)q9w-8EZM%X#rs#-0#r<dMS;:SWsMsRN+<.R9<@tA53'rx*.;1T;<&jӯ>BB*xNa0=a(2kNȎ\"Y4\r7xd.8yJsvEgIvt/&p-/fh\rV `օ_ \n\rȲ`̬\rC*L\np	i9\\ҀYHP}.,a,F:d^S49d2m\rUL2#&n.lELT%6}&>qv ~=c#Tܢz'1j9)0hy*\n5/UNax5RϼB8LPR[{ct5#V&LdKZ40s'VK#a~nzv .`C4 @^ Y!\0qJLA\rZ(2a(bVk. LFM\\ #x\"[燨u\06CQӝ73v}֥\rfXV2Ol!\0";break;case"ka":$f="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-;.JAJK ZmO1Kӿ2mpvK^(.䯴O!FLڪRkjA/9+e|#w/\n❓K+!Ln=,J\0ͭu4AݥN:<Y.\nJMxݯΓ,H00ө΢RvMXO,T[Sg#R8­ڜ֤EUau*s=@k;YOdA3 j+)+tKW[/:X@ h7re_R7pUV\\3ZJ(J\r3:xp9x79c~2@*N\nx8*uJJ.Sk4U\r{PBtV8-=\\[z9l8JVJpd/=!({6:Y4@7t4WRtB-FjNIL«sw}m=R=OI-]\r7p\r>:З[yPkA͚=)_ϋ!BTWT0?}.\n'Y\\sNrz(%[;\$ [>mnRXQ!L(^	W	uSrC) %,ouڝ[AzSr2^CιB>q%:Q@#%]lq4U>\r\n1Dԍ!4<@PݬUx;p)Jd\".WW.YdWpv/\":W \n!\r9<BuQe<8Tz3/1S\"FZNz@nfRG\$st*U:T\nH'ZG 1/+Me Jmǹ1-{u|IoSaT)Kyf\$ÜTJ;&e2`̙6gl~Z/7h#MjUctGIsUÀg\\ Yu_@<jLk:] m\re:&,I1zBnKd@Dv>%e,b٫7ͦ|D:40B#Nt-C\$K-LY)IR\"NA2jeӥО#`&sR<KSF2򌜔\"H,\n915Fq#{TÎ&SjtEM	=8谤%0I:b*r(xid1;L㩖&ݚ>J!,uqc_žGNp |uvު:\0)\0Z*=țYZl@fkӆJ2eJ,#^!3샽o}J~R%6v<εR>:F+m:%n#2D&NtRRڵO|-.b#FNcFzh(}TwGcz`(V)]\n,}5u-(GV=Ua?RfEJCoq?\n<)Kq#94TN-+<΂~Ty?N%oM{.SNe-[\r,^ XMO.Ѽ#@5D>TRӱ2Hlqz'7tMU`|5S!k&skuJձCKVp|qj-+I\\*:9h61*C']Bg|DKYW^t&z?c7[e@ĳ⢉-P	K[\0\\pK[qI*8UtPZ:5'\\y2=?%oXVrI6+CG\\V\"j[1ȩae?֚AvjnХ\$+mu;XGOr:U*\$io9jL@k/fS+zAO=]IFwc^eŝ<d	@+\n#O~e*wbVٲJ.+-\rO?18T\n!06W&m*\nfd~XdWFEpA0Q'\$\0^/\"쾘Ս\nE,8##\$ ,hZeD(/'PdbC<l,|]fL?#+LcX͠s\"vorKHMO^kvl6)DȏNx/:Yb>qk)F|Gܯ\rҀ/BѯHPUK\\1BK(Kǯb2o.4@D#W1O2T1bA1\rS\0:rIzZnN^JB\nW<]f'gtǂ{iQvR+\"|)Q;\$c\"MVh'/nLN@ЯՇ4 HP.vǦ,އ1rN9q!ddD\$\r(OFH31!p\n,\$\nhUR}&;&oHry,&Qhm+Tm\nBȡ!Cw'R[v\$`=4-8Tn]((R8='2cM*/0h-Q܄ʰ1f>\$C.B\$k6):Qt-V*RHG4ݐ\$i3R\"h[c38ETK_]7b	.21E9s-5Jk3.ƦJ]s6nQlF\r,r,ViAQ҇=\r=H=T3=.=fҶs{&tXϾ4{%Aq1%B)0R#ҍB+Cy<o2ECD4Wo@%m7D\\?G1Bo@qgܭOHB1/h]J]?K?2JK4G1bL3;EFEKK8[<\$(So@NFJՏEAEh18o#9kjxBS&S@Ȗ?2'2C)S/<IMO~(*DuOA *=JSJsECTK\$2}N)1W5q!(egR4[NKZTSSY10XF[LHՅCOF&I#/Yr>Y0\nX{a[4Jޘ{Wd!`?l\"TRO]DEy0Y5%-vstkvv\$Xԁ+5_p.ԥ+%+737hi\rVm,\$~gߖE\n2N)3t\$vO@\n`p4H6h8JQ\\b;/\0on狨kl\$\0TKELTxnfy(0|7qX҈KgJ@\n26~gG<	0Avbt-@j1q`THtoh?Յ>/ElZqb6A;Ǉg^ąxIRvJmwdQm^m.KqdΝ<.v	TI:1;98,i>M?淍wļ4RKzc+9DtʯHvr;qK#1;i6ʱ?I'g@:B|2T=\"ZhRuq?.*sx+'Qprn)l&.╇*Wmr\r*5;dIb5a,QԜF\$";break;case"ko":$f="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠈0C2 2a:8H8CC	2JʜBvhLdxR@\0n)0*#Leyp0.CXu<H4\r\rA\0<\nDj /q֫<uz8jrLRX,SǅQvu	\\:ŝmvBZ!%)Sy!eLӚuv\$,5TjLŝu@@yE}GB6|;1K#H0c@98@0ð1\rC:\rxo`F`@]@2D49Ax^;piڰ\$3(2\r8А\r#x|-i[HP;#rD&XB\$Ei?ř\0cyeiU/1NF&%\$?j@1`KՅQ%;5dy2\0: 0OgDJbp³<\n9EBcDP).Ⓔ-KLt H #pd\r1#s(1TM۹rY/\\Tj4AYNDjz{!vhsO{b<(Ǵ̓S2-y	8,z~J\n@\n|nTD\r!!¨\rЕB	(xYr2.S9T;DeeG#VrZ3bTo\rnD˅qg`o9a	[J\r2\nYΉq4Al,N fdC\rh ZQ\rHdZ/\0#a)vrMt=\nã)bJP}c.(0x͈Rk`mH/!	(q!	@P3L,ei_}X`%%rbY(i,	!8<Ńж\0CSd᭑hC\rBH*41C8%*6;ć(r6\\^yFƃWrLTCrDq53\$\05P:@LG`G`!,X6U*C4%z }gnDCo[ײ\"{#D+9jda8/5fi40Hg`48\$xebyBuS\nAfp MО%LI3IEyMD5Z4(V%IH)E0\"dMA#PY[&YTj:R<	TPBI+ɛnq⃚\$D6)P\rq\r;\0+A\n<)CoBXk\"SʍB,T>zߊJE꽌p \"*\niqXJi/&\"q#dlK~@fOrE*Y.ȸb>)Īޛ%L!9i)PU%S!`Lvc&?AR}<tF>aDB%&XYOeւf#[\"{9)Qw2W:>kk;w^U{M}yTP׷(,Bu,_E**UV*6/S7J,K|JWu`-{VQ#R6FDuKP!@7uzr< չMS`iU@KK<0'M\"U/WQI^\"mXOasNkͺ.ۇ]CtarXk,)[@sے/BTҀNaST͌ @BH@[hXc\n/]vdy%a0\0/\r2g\"ZZ<@|eL2yxڇГ[X)x\np{^:Q\\s;.Gfkf7>fPQyO\rFk4j{,=t~~OV	TI~}j##tcCs<#3#63kFʁ,M\\k&T2=b q/p#\$C%F4+tcX儠20Mm\$P1T/PjL9Pb6oNو4_c/fUD\$ND#=\$\"l#F8a7I|*\n\np|nMH08#.`Q\0P\\/lS-iW2-zpA|3i\0MGāpwH+ޤG-mo8֎=n114{Z\$EbnV6Z4QLn͂m~?na0q1!p:b!%bo!2(R6a:S,@ҧ,p*hvL#4W\$+=E}.N||ĺ\$Q9f`iR3p[r0+n*Q\"٣Ea{\$RM:6NmhuLᫎ<D%ЇH:\"b 66Ǣ:Qp)DP㉅2'2D쒥Vf \"'rM9,%n%-R܁0r1-q*I2/,R50aR1R8grC1p3nR,d2H@t//A;(7\ria,sd+2#E7\"64@I82U&~Su6!a`TNn5D68w5%M:yrk;\$%&*( CJL8k<4J83!nr.n ͞%0=h?b=()>:&#^M\n4(t(+,%P1Qfh\rVk:\rhPApCd \r ̊( \r'DJ\npI/Fc oM<#%<#Ch6>gLCNqN'BOhi\$CC'	Ll,GF|!R5GN9j6gx\"gM-w>A\0TPdsL~N2.B|G6kg<cL4KTeK\"<6!ԩ0f60%S4gB;Ud3|\nJD)8,\0%dcW#ڻ%5<ˇ `~ds/18NuGo 0[͎\"V@S640C?k)%:Rjh5	TjBOlb~m6F15lt\"&S1rX#u(*Nd";break;case"lt":$f="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)ht2:H:Rdp;8ʕ4Qn)KP%_\r鬛8.1=-P43[\nB;%DK,Z jp<#ϥ.aTʎACAЀXD49Ax^;pR\\z(2t\r*Vpx!H dDTK_bckx 2a>\$.6͚C\n\nD(=.ʀق3_\r膠c./Q@\$8P29%_#MXJg<\$*uh\nHҿ<]\rSsOR&%Yh8F\"QQ[ 65mk*9c\n\"`@:fOҽN9v oNG42L=\r)Coߌ~툝IG;4ͳB\$DnG/8wwqHy>S~5J-it}s\rĥz@rYDq\"o6*uRl*,JӓaY+@֋xo,-cgCg՚`C((`K!;,JNwm(ɟ^M.LRC\rujd%ZYlu\n\\7Zu@;\$\nf}qJQ*(ز։HYw,ȉ%SJr/RB2Z]l\\a[H\0|Q&uނr\r&AHDtJ !QwG8aP#8eUy\n˳+2b^e33~aj\r`C9Ư;!/^I`\rÖՅ.\0i\r!c,i..:KMQP	APDA:(!RgyBI/5F]`px'\rĂDU;+7leԼ@:М:pʄe;,!0!-'<LDn&iu sI0ΧrRJi/.C\0ڎcA.#m\$5&RtkXy2\nՠDs/5p\rr8*P\\g\"Ws<I/fH+q17|QƆ0XvJb*1ea\rV~pCV\\Aj}M\"[j1[H2ma`G+:{ڔC5pBqI:SSD<9áh#WjM4)حIOľfJP\$ CqR	=f0%\";v+r+8G:w.}Lx:ysL>Kay\"Zrx\"<.WwO5fރRaY;0-A,L(Bİt:&HѺ;='JIJ*K\n=ZM~a,(_f\re&>>%hS\r!WpdyH~RVQ钲HIuttŋ\rԬ{SB cfg\\(%*P[oQД7 k\"}&+\"#8.(R{!y+՘dm\n&v }6f<J;a*@@ <!.iFRQ.)M}Y+'l9Ɍg:uF8y3?Bcyy(\0^K8&I[:>X_:ntKk_Lm\r-&\"GIyv.~lAE3w[G0O~C_+P8~C&'N	x:	Gdc&S\09'QCCP 3ΔGAN\r\rt奨\$XM\ri;VX`l	 nm{e=Nr)Sz_ٟ>@DDr (:`\$+\0Kl%,iycJ Ā7Æ`\r;\0dDP;DBp 0z-#\"B:5b,#ÆT&RĐ[\0Lˏϯ		.Ad\0\n\nP\nn\ng%oL0yEPҠ/n'\\n./Dadm0\$z\$waBb\"/7DQT<qY|ϼ-J7:zL:hi,`B<i\"#ކl7/J1(P),h%N7.\$(oAb^gѠ0cR%3̱,<#\rmƯ\rPDk 	Ox;cjPR&\"+05Obo!,Re?,#!2+\nS`6c1+\rbY\nKq'-<Β|-`rl;r&҈oy!?*E++rR32(\0zGF0 H08\$vÙ%/m-\"ФN!qlR\0,,\"0\$#,.o/4.+1GIb&O2dm,2\\P\0M'32 G3\$\$ /|*gaBfΩ6qhꓥ'df ss)O:\$H:&^fꡀ;S^%NC>s4e\rVh:`րXOkV]jn;\"zJ*@\npH²`\$oH	D=E,;Q1oF#4T0XCmP\$8`o\0+8\"`,b/eL8bcBya3D*496]\",e\r]x4	D\$%JͭFFMH@)6GI6Lp\0>4/Oa@ޔ\$PG\n@c&I̶\"#LՄ\"Q\0Cb<nF'pWm,JGp{pvq\\JR&\0%1QCF\r	\nq4=-;Zs%r&\\\nD%1QL}EA\nʧd\\RM\r.d\" kI`ߣ\n2)͠/c@";break;case"ms":$f="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0PA#Cd2\0P2ɳ'7E%a6\"x::`ޜ+7N6M06.\$/\0@J1IpOH4\r-- 44C(C@:t\\(x|	MC ^)AHB|Jr\nm8h%&5\$:B`'J20˞˞c|MV!\"Z|\r,7V31*2h`P&LT)qƨZɁL:,K+j'\nz\$w-jEӊÓ݊b77\ns*͗4 %(lIѰ:S4@#~Qк5Z m Pi\r. >cxA\\\\<9r`)6-d?# ('#x3-K:2)o	N7-CLS|j#rrtaK(3+{weIw~s12F+&/å\rr0D&=ϣ8kК5<TT*X+epxd-\$T4~d:f,d~AAgĞjuzJc}6?T!NB*U*VbUrVѺWO\0sǌJ\0c\\|@R6̃8eM\0 Y>\$N\r!>}cYFH>OcFq|sÑD`Gbo5 H4Сj]Ip.HPLoei!7a@\$j\0()@<NR\\*Yhy`٘ J\r%F<K|T39F2\n\ryRk7D%āP:42:}R~Q_to'!0I٠MdG\\de3\$4#!J19-A'sYGAAHmT!&2iA3y\n6#`L8 0M?=zRkp|P	L*\$^!F5s]2MN5szl6|;\n,l]IڔQd8̰F\nE_KiTs'W(1\" PO	*\0BE6l\"Pm\n*K&];TR-rFcErI`iH\0ӓMF^IɝVTl94\rk]vUY;.4MvR3_q\r{v+'L8ǭq6\"\"t)@2Xe ZKbrqIp	e\$2E@+HzKᥧJBGjc[\nf#XeԧlbSZIDES.7BW˓Q{E)ǙgZa>Q,ΒR	<4Ħi_CcK K0<T{R\\E!D:\0l*;\n_\0i\nH!2vQy7%N/\$jT:dөeƏS#lnڌ-K5FaTDZF'ڤXm;][`Juwa+\"g^ImNƮeֲ9~K;ȶ#L2s\n@lDҌǆA\$mqw2o.FRKدFdTZ^''+* v29ޔ7q)e,?Sc1,Q/QRF~NP`\\qAM:Y_y1ٗwZh#h&{viJT[zM\r=Gś158~9,'\ru[ṼXd2W̀l^Koc|/hrFG+4w2fUtv^	*s'Wg e}E<D)~7Y~\nF\\صtoF0z0~ȆF\\lJl!	Ηnp:p(`o%JɨC^σ\"b1T&?J/26B\$~U/2,	oEДn[-\\Z[e\0ceff`@\nCf\0dp0VPI[lͭG\r-af\\F\rB-t?p<PH-&Ⱥm:/\"P`cpK8蘱bA~nh0-HMN_I.ZB20%>iz>:*p|!\r<RN&bRd>\rVbgcTbtVBC*3Q~DJ,h\nZJboIO(NmHݎ	\0hS\".ʚ|LJ8~MPq%[n\r}EYXk@LM'v.\"w2p)0H\r3bf2Fjvd1{o苺gr&l T ;@@ Dҩ*û/bB2#B/~(\"\"Z29뾙,;R(Ɠ0 à9f'0 >~od";break;case"nl":$f="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	X2'@m` c9ȚOc.Nc(j*%\n2Jc2DbO[چJPʙahl8:#H\$#\"::01p@,	,' NKjܠX3; \rь?Ø#h)\$k	G0B1S̢H6;l:<5\"|1\r  jPA4PIc@,C:!4E0zQ#txgɍDa}{_xDԬ˰ڡ+x!!7H:2i\\\\1*:=:@PbOmͪ;\rC'+î\n4t+JCVi=#pH(0CrLSUS3ѣ(0b;#`2q#u1K\"-'Zh3\"̗C2Td5\n3t##h%ފb\rhC+.s{GRf=-[q<]ϩpPzQ,6ȈCPنrl\\Rhs5\"ڮQ.}X=]3j&#Ù`,\n%xͭiR2\\pN#WW6{#kߟ3ʊ*%6d2R;i\\΃a>%Mrp8 TLX	,UVZYhFC[(\0G,]	u״S!%5;/T8ĊMp˓tq\r8u%TvÃ 'Yl將/[9\\≘t&%rJY*(\$MSDOHqHD\$`AcK_G3DC`jb%!3/eR{uiJsP1d˃KAF%<xҙeEM	\0\"\$Du\0(*2^Zff4SN*fT4^b`DkDp悕tI톳#D)D>J4\rSpx) O\\X<(&B\$=+f\$MI9'dM\$GeyFEǸ:P\nl*\$@fi+9y\"blpqhm3{<(jnTQ&@'0]y6e@J(Xk.ORGH=2VdCJxeNzb72k	y1VA7V]:*LT]b!52C\nt\".\0U\n @g\0D0\"`IxmPi(IV\n	ʹ&Ss8VC(l~Bxmfx#X9b]Ɲ+g񆣍..K(hTӭ9@>.Ԗ&ȅ2LXS8<H/eOr8\$lDxcs]1THTL!y\\4`חv&݁0L(`R&A<xQTӇE0B~_BAfF0e+\$pGU/a#')(cM\\^ޫ#\0H8B,7T/5C	\0=4@vVA^4#쀔S\"Z PtY	/RPk=R-QH\$cWKto\rHmfJfh2I>4(auzZP]4&N}m-GΦSl:l-\r܋Vk0wLNڄDg:MoE?@\0EE ]6OfFk?c\nŅW`K/\\J9%2F*Y̔WWj}ǜ.]_9ls09\r}5[x[9L;\n`pD>ں&(nͧR\\-{i^T=M玐PdcTm{&'Rwt[]ˣ	:6έVkg˒Ε::sgiךO@K<\0ܺ᜶MWԵwG~}v=YK,,E#&\\2z?'eaȀ'R:-4Aá\n\rU`j\rER2bnSMHҖb:5?\0bN\r(:0B:,e+b;2&o\0`&\n/LjL%noHk&]hXLI6Tհcvl;LtN&o,rGfk^C|);ڽJzτ\$\r/=	OTFmg\r\nE|ɐn\r#0sB`Ц+&oR10&i#^/.\$1BR;L\nS|eYV̹\rn\ntpq|qglφ\ntL#Tx\"Cy1p\"3 <\nEt!bf/cRE!fd#Gb5(\rBo.x\r%\\B~Tek2bn \r0e\rVD&o\$:8NǪ'd!M924X'fʒ\nZLj..9\"R#x'D -\r<(@(m0#B#CV*gP&M ҇6(NN^1Q\$\$8#\0E,F\$%F8aqIJʢMjMl7m+ILN2Hg^IRq.Bc0%Y 6*8GPo\"Μ#5)bj*c838R\0'La3Y`,j~%kDlxm.L9`24# _tࠂ:NF\\),` !/vR3@NUEL0,dg\0m1R}N\"7K\$	\0@	t\n`";break;case"no":$f="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2\n86/˓69k[BC\"9C{f*R<HR;\rP\0s(-̢HS\"t)B6\n\"1o\r'(1>a\04@:Ԍ\09P XПD4&ÀxY]\0Ar3X_O#J(|6ĩ+>L}'7Bo:+RՎH;WT>-'.#\n7-8憌`!-1_&7*EC.64޶\ri\":1(0c;-î8#\"l\\0# 0)ۼ4C:6*8)n8pHN#BC\$2A9XصZ9l(hֲwMRouX2 P3u|(-7*HD\0bZ<\"LW؈.3*_Z(^2	\0܃KPr\$c(ZhН-M.P3k*37xG\n8孃G-¶0%[Ӄ(P9)H:Orz\ry!@MU !GRn5J;UJ:*`P*]ϩm&iibRKZDasl'a@r	_I9n_Дj@6w\"UmVbúO]%xúwb0|䃁ycd* !7ξSNQ;5f0c\$RckѯBvMm8axC\"\nbk\"z!wƨ(l|IK)LsfD`1YKs.%̦)ʅ.H-H#P	@h*p((*#VRDBz\r-pLr2;aR&[j%\0_dR#&H4\0_YA8)JPR49n:AO6JKI!08oi\0#Rs{2&Ia.&E5Oٲ)1IrK!ÈH-!RHyz~bI'œ {	r4Pe@̤B>i.Q4җ	| e֖\"Z/xOĥ8e%Le̿o; ! <M\$.6I4\\D#@irmAJ?HRb쭍JΌ\n3T\0U\n @߮\0D0\"fS:MK]ΚBaKd2&>䁕Ȗ]fBJII:'S1  ,k7T\r)@NV^D| a\r4T_hҚZd;E,<5\\_,,WHzaӑɿ[XD=4iPa` W*[+tLzˉ%Y\\]'j4r'qyڗn. o\n#so\n#-H(Hd[N/VRSt7)A\\PBHP.ijrhRNFMyW(20\0KNisxKTz!JC	'a5͋zŔ976G11}	k{)' %|7|flR' IP8uRR##3A#0oYQ&\0+P]%hL	d\$p]\\[Jb|WZ3'd(8@\\8)m@p>=t{\n(/f-ڔ9ta\"4n!\"r..uR&ţu~F-oʃ/(ifр1-AvF\"|-E(R0\n (']+*|^2d}9)쒚c	:=\"}ݙzYս|iyGҾW9[:m&6'> ;|4#gD'|R3d_'zo\$xP{ڰ(i\$4 dE`Ti	Nv(B-8y&Tdh\$0gc¤'Dp\")fP-]pN̶\\5	)n\$ː\0ξ6lP%,BS/pЭP(M,oϞ0\r.7S8	[.Z K\0d밤'q\0\r#<M1&/as*eĵ80\r:\\00\"xo\n00@Q!p12(1n)e1afaV9^m*N.σЛ41o\rqH1DFƪ~N\$!1i\nLLc}\0c21\nڝirbARN\"Q6TBR/\0a%&@>&DO,\r\$mxm1/ dF\rV\rd!H.8q~5<5j\npx<ޣbS&)G2MRkx-.(se\rXo:Ê1!@Z1(4̮CXf6E[\0j:@\0^уLxC\\S:r2B12Z\$6+s*0#3j54N53D&c\"2,}p_`U\$09.0\\,Tol- bڼ\nf!X@%2c41%=(`T0\nx!@-+0#\n-i Fn\"";break;case"pl":$f="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#H{80\"S4H6\r)mcBNOc \$@Z0skr1\r3Ø幣\n寍d9T2.X#Ƃp(,S\0@Hp4\r`&420z\r8a^\\0ԒN?#8^pBAxD{ \r3򞎃H7x*cx04r)C#jKRRL	Ϣ2C\"40Ό\"LŎNSN]?*;BX6I\nm3 =Pa%bH1K<8эA6Ȱ]B0pD	>X3 bpc\n'`P	J:0H00R\0|I':%0Bk49\nb@+nsߋ.Qit\\\\Y}zO;4sH<tR\0!Pٸ\$w\"^6Ou=4w#8=DaBl:Q`(\00e7)eɳ 6&#AH9	3\$>MyRm\$2Jhuw=P;d1 2t^V&HNU,*}jB8_]4#rtIYab<)q2*D`at1CZeQ\0:BE+AmT~y\$0\nTj\$HwX	\rXLVzZkUk.\$a\\+6FP]@їÔ&W&P\\s%1I)5<Wzp\"R\nPhQ\"rR+],`eYAi-EԠ[҈9. )`Tu.d9.hfX.Øn~0.TA}G4)rA	aA@ \0001KQ5\0	T~\n1ʐPHl\r伃IeA3uNx֕4JaM &iZv\r@+E	QvsEF3G%ęfb%/)=DrvDPTLHH ѝa2v(h5CFBc7CRaadч\" 6~P?W7PB\r&PδieBPМiMD[D\0C\naH#M`4S\0O!rD\n?@~o䝷]	RH\\8RG=`BᯯR˺YLK܁)8>A\0|} 2O_\"<c\rY%9WP/\0f 84B;ZV)Ek\"bK	_)TE\0%bq*VʒAlm̵w9s(w8@Ppd\$̺5e\0ƙr;uldZ.&@\n	sbM~;(9hC LiWxΙ2̔\r@!,q(\rݤ@Q%\$)yNPB{*v6pd9ެÛvFB\rPj\r|*\nJ<>NCz+a=5	^2D\"roXТg%%vj0]xtzV5z6aԠӭӛb,L8ّ|҃\"87NХnRN0Y۶!aǐ<UK@b4w>lǤ)yxWgPmT!IH=g)|N @BH#얇v\${Sqo;LGée@2@2(H<d[b#W% ۽K㼙ky{j2LNod1z\"zWQG;*˦Pƀ)~i}O\0(Z~`~?3\0g!̹Nr#B8*DB0O^̉P<\0 L\nH7d \"z52`ĭa2>_Ɋ5HD(M@كLBJFK0k9 p-Ϊd\"C#8RHz`'. ȀФ0:G֤-(0ΐdFn0xC&\0gt<cF&Á6C\"@d4&UlQ44`\n(({`w\$xgFx\r\"vpRHHQw1Tpא~yiJQeQ1ChY/q\ryD\rcqX	Ŀl\n/ e.ώhf	1 !L!%).3!pfC)fs%%Ч\$ѥ	̱JŅf2lcfg,NqD@%jI'68BY!Z%8p\$Vrolx?%I,\$)Gp@ED 3'd%G-dF05:&(r'*sq\r0&0\0bND/xMb:*9̺*W\rRb\n2BDQ[6m561m16\\%x{9\rJGqf%=C8,T@8rE\nlT2 A2`S7#ο=02Q<?424q@`֕a%!SJ|?@O@2\0b+D2\"him>3=gBB#>d\rt*4\r?3IC	4ӕEJF6P\${((sBTF4\$./oC,7	Ԉ;H_rԊ6_DTVt鴂x'Κ 5z*ԏd\nI[	CTHt&J#v@X-=zRLc#63H<O<:###\$XeU&\r5-R5Sg%C3bn^#aRͧ!U3#oT[%vsVTL@`*?QFrJ\$c)ú),1,O.,\$6)B/^ \np&u\n4,j\$2rm]uu`Z\rk@D#	\0#֪&8(-՞n#XbJ9@WGBj'\$tSP9ef5\$#VO\0C`gА>=MKЁC䢈2B @ތcJg\"ZvV\nbsֆ^06wV/֣^o0j3Q37HB9E{gu:V%\"\n`	ͥOe6I\$p̦v&\rGz-BW,=Ptlpm#-V:MAuǤV	U܃KJ>OMfP36h#hnLbBt[BQ\nby@%";break;case"pt":$f="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%ln1/=m7lnP4ȃRR+1Oq4+J>++8jQRрP2\r\rSpr#<FS4VB)(9`@ C:3:xiѵB7 r3@^8BUJ|33.懁x'J2k;F҃R>]ılk+4kb`07̺϶PHpΊ @1(HKbcx:1=LNtpr2 ok2c-ٜ{5˚ǈ٤ӭl1x፛=F6\rr'	CKc؄)zԍ3b0k#bMZ57g	ܤ&LIl)MX>B6=dr\"cN>tV4(	#l8(rV֌(Z\"OOkہL9(	v\$\\oP9L8a4m*Y0z8 k&HT\r\0@d6!34@XGK?k\n)^L{M JW2nNM96KbֹXM\$\$F\r2Y+-fúT\n\0yH/+, }^+.W5Fa 49wf\rB4,,JYK1g-T[An-Nj\\8#>)'+l`k@w\$J8&!bjh	qp+w:DP'2`4TABɻ@'X*	Xl~DXˆc#	Ġ4\"p'(AA@\$\r@ LXs#\0hsVĻV&Ўk9#N@Q:zSJwW7*β1x2 (C\naH#B\$(S7\nH^Zq,.1НʊZM	Q]1X^s~ -!@	jc'Ii6NI&\$DC&W&ζRisHpz\0¢\$/@ҳ.@BqrN3֨LVpeAI + ]CT@'uԃ5yȒ `i!bvFƢ(\\Ta9('@BD!P\"˼(LAXcv9bX0<d͗ ]1mY}Q,!F`aQAjGP◹)(U!CIJpH!;z%=x¶VtcJi6&B(D̽R\0PV ,6@#h釄M*o̻XQ[!Ѵ)Cbk:LEKBdHHdItah쩶\")MɉPe\$Rqkb5ɓ^UWBCjQbeiװ!wA2{uX0T\$9`\"c SQk<VMrlXu\"I@xN5\n!@ڋ\nuTDI#%*Y`/,,h64Q\r_»kzFf:c_ܔ\rfUtDC%Wp\"'SaēqaR^ӌƳdyrSޕ\n&܊IEVriK<}8fVDHP*(.{AC!2,yaE06c [\r&P\$ol]ZN\\x<\"X?\")b/wwL9+n #?%}~}QFN\$Dk.򯀛	6C{H,|u:gHӈ+y8G@퀫GBo,9Yc,pg	BbxaoL/Z1ξlDOňon9DVo9T70,&Np{*6PDthՉ캂:oLb5\rZ`\r_QREde<d,N|%냞?I`3cp\$b6oXDob&@ OmZRdDDpXC:gfPk0OR0=\rJGBSpц*\0lp1ƢZa=-po]I,ZHf\rq^2\"Dj(`g|\0SB2*Olc(P+qB󍖫qhQ/TXq\0Ǳ`y5#J\nّc#\nj\$2NlOaU&W_/bu^\0Q' q(%b)qD1Nqz!4fd.h(>C'-t%1L2J֑%bb\0=bQ'ĕ 9(jS2%p	\rNg|KÌ8Y~pH_Nm+@Bf_bdШ6/n1XW72N2rc\rVm@@\$AHlE#1%:o ZmXqC06\nZNg4dNO丮.Ԫ㉸)8GjVO`f/\",2^>ͯ\0\rr1F\\涆L]y:w\$rati.Tr50c\n6F(g|Fh1P`b'o2P#G6Pd0i(	VCSR?oR5I\n\0T3Bׇj|E\"6Sov{E|M4h\\#&:D+BSIB1!=R<v%Ip}I. @krsM>,XG(=>";break;case"pt-br":$f="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR43Ґ 30\nD%\r:kCj=p3C!0J\nC,|+/╪r\00e;\nت.3>J,\$2SҼA#\n͉zz7M( 0AM!#!\0@;J\0TBI*9`@UCF3:xgU<ax	c ^+ѻp̾'|=T&O+ۼ*cb\rG	jH8_\07JB^7GC:\"6\nuY4K,1yx5桪cCC5=6L6%hӌw(0I\r	VG٣n:4И*TwKBBibRM-5V\\*&L[>c( H[!PaE<`Ϡ2C+6\\A7殛\r#b<HS(3}\\phYuO8\"@WS+	>>q\r{1:V9lxp3mSXx3NtÌ0IޠBeê634&<0w\0 d O+p\n)~ޱBQ7*n90CN-0䯙*}`ՆV:Yk5guLZ`7`WTE@#һr\$f4\nBm0-D3`NBi`j\n!c\rWebZJ 8_2:}pmYPH\$P75⤑>Mݗ~Sj /êk2e&bH VIRaѮ*	V<LqM6>b2gCB3/z%0ȠJ0whRJ232A̐LJ	&\r`1 nIvٍsppo/J%Ġ[d)rUl[0ǖ<&?ԕ?) SNr(ZuHhLU2NB:)\"Q'L4!HF<!`	0(LrHy5h ,J7d6iD-6\$y[a\0¢1J E:U;1%Hq18mЎUu\\4eL7hb#UodqBI!EYS=PLCs킒@q}㾃C5hȓ7k:&4Er.ϛN<'\0 A\n\\ЈB`Eda1Sh((qnd6@\r-)zO,)GKު}/_@<Qy.m!\n u%\$5Uus2a۳J	˹*EE{sA@4xi(dϼv`qe\\GiY8JRUpu#t:̇<Ns'f06>CҚe@(6A\"Fm纵_RB̘,he(+N[b4;X!%ЪOZ0\rD93%}CyԯqX\0T9{&!`((	4t[\rg%`\r\rIRNtRs'b T!\$_P[ʕSWH9%h&L4lLӲ7ӹdA#ZɊ7qML1^-^&Vczn}iJ,B2k)Ŀ\"{;PSwX9}FmƷcB1Fq-f>+<_ԃpA;y\r'3+ڐ̰a\\B)ۘUBD0\"B8xS|Sh^w(;.uJL&9 cA!g|\\2`m@}>|mï@O!߆DxL|~?y}V%\\9u,c|v%\r?Mr褐L+Af^%pV(hɨpiÄ\"jA־S_]ﳌzqZ\$ٹnvZ_12vRG4ĜL@v2,4\$\004cI7\0P/x/m\0,NCL ^P;UOdpNRDpHҩXx2c\0h\$.Umx`0z4OPcPM458m>\0A\n#`ӫG\0eP\nm=VLj7{B%cGiH*b XW|D#Z\"TQ_\r00,k	MQ\nB\nQ?\r\$MM,l<Lp9l#c3u\rN؋Zo*1p@%/h(_Vc̀pHfIi@pȰSb8ɩB`ŃnOg&pQus<13jҪisłKxd7 RFl/Dt'4.ώn&/P&\r3RFIU\$].2W\$OI%3!3w%ĬR33Y:rxY'Ҡ\$/*BԒQr*+lJT\rO))=,RmOԂt nP\"+0[.)2/2`1KJ-V3h'\"\\FS!bF+/f^46#r1C(f!I3/5Ī!gc\rVk,\r\\9#4:'1p@C1\nZg\$3O	Y3(b	6hp8#Ϯi%#0æOoS`K`!>ʇ#:'(T\r1Xt8|R+J\\e1LQCՂRdat`BnL>q.7p1i3e\$DEI=/|̶6ph=F|ͭE4t!W2lH0Hc\r*b\$/JDAJ>MeI4/0MQl[d#G?.\"`k\$Dl6#Nc3B396Th2A&%oR5qR&Lb̲g'\\;\$Ĩ3>:";break;case"ro":$f="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2l1	C0LK0q6%3̎A06IgA2/\0P!03@Ήxf*Έ*Zʝ\r>9+R9/9l,;CCefJ9`@%C3:xyR^Ar3_ZJ|6	3/\n,x9\$X.P#UBh̥C _<o.E\r93ɍ\rbANJ+r3h\r>ŠP#s;9jSY#J2YF88s:\"56+C:,ͽ)1ţLJɩ!\rp(Dռ\\kR` #:Ѹj:JZ2j2#rꮐ&9 W189xӒP/u=MXMBGiML ʃ˾\rL7|M:\"_'cWJ]]j sHzuSBi¤\nD(	;̞[bh6\$m\\4b'\$yW<Øf(a[Ġa aV҈w(`@L f1z\r)0U^qzaֻWz^az%\r>)'Bp'\$\$XN1K\0uñ׊+|fL='5\nQ2:|8ƹW<^]x/%轖_q~y	)ʧ(m4s{C[\nD*+9P!19q!Q.W%8V\r'p-M7Q1?pb¸Z`V8aۧy9/0#&y2HPdhAfyq,l(xCrKJ_n#G|8䬂Q CK\"*v![d;i\r:0DD%hIC\naH#\00LyEa1<	H3Dr\$JJE(y.VrkRMC\nX\nKOI@^\$qldKGY7KS#RD*gPs+50T-y\$T/.I<rA-WgJI}zQu@BmqJ6?N\nRӪ@)M,P(\ṅh3XrjO@QR+T	cf	M߃~m(z#I۴Yz	Uˠ&A1!3zɀPM(ʳ,\$\$S*ydј۠d,#h#wI{ځɭe(Vk ʝ&Z3`u	(T>/jTl͜oA|5IB\$Zo\$-Ź~zO3SCqԼVvn(wNҲ¦.|Çޞ1:VC&\r7w*Qt<eo{g@7H:d3@\n8cٛ914NJ6|bt,4=5zl%ݼ\0PE'm\n[?բYPeDAa!ֺeK!C)R\rlخ;x 3#:5((HXcrN/ֿ%zdg12<̨Uʒ9d@<O`s6]o?ǫs\$\"6=]ZUûEg	M㲐ٹdĪU\"fzM7=]bH)\0@	c&)\$o3dPvCy|g&#+)SW	^r%ѐf߸{?}\\O3bꢇFx~Xtlk1p>k@R_יj`b*CJNb\"LQnL.kM%|\nsCoENJ&<OFbVKB֐>=@PfrĲjǌU8FL̟\"rLwG+Ob{	LL\n҆	OgZp	30Hlv%t20쮆\$*JhgpoyO7-dJ5̃\"g0~lw'c8k6#i #:P>MPKx^<b,cx%B\\\\\rc;(JZ&( [k(#J&h׍b\rؑ^mJkl\r0O0/U0UdI@W. O\n8c.r\$OD\"M!)GV׫<4ejJԂB:@aDE,'d:j\0v\n<&Aw(QJ\nuҋ  CP)g m\$\$ʲFl<EoAp*b\n!rLw.2W. \"{/.7.R*Ҹ=Ss!,1\"s&K2//\"(d6s834\$oKT!L#135HrC6_\"*I\$g/3jMy0NM3!M@ľH8STd67z\nL3;	 	*x3Wjf\$O?eΨm,°J>1s(lhXWgl/s3p:jo?S;2/@b%\rVFb\rq7p\"WB&R.H\$r\r+IF \npGBN&JhY\$=c,:#B\$g	 fgxgbO\r\0{3GPl%Ҝ);:\$#sb.02AvLh#heLDBjMTPfPC/`rϺfZЫFTu .2#!eI26l2k\$d<G1eRfjjD4x;ljXCF&#DG>22dg8oLp\$@fep/ƧEbF:u&CJ	CW8mz54Tf\r~2')E(#4\$	\0t	@\n`";break;case"ru":$f="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$ٶj4y>N:D.1ܧ\r=T>+h<F.\"]-1d\nþ\\,3:Mbd5N(+2JUC%G#\nT,`#HkΖŵJLjm})TʣU%cĻ7\$qN\r9\0Gj\nu2N\$=\\R2OճuƌnT6HhԿ2O9r0wdVr# 4(`?3S\r\$Bb_EV۸A\rc[ЌG\0x0@2D49Ax^;pÓeP\\7C8^2x0cxD\rFPs臧)*D2\\x.#El@&.#	wd< ;3Urh_2:MZݻD2\$p6a?H5B;`&vO㪯וnCwB)2M/*8*W`#6L5br󭊁	H,HLIKpGPKzp+MBpM9-TLAA&R)!M\0[`KEkX1*P?3ܱ{?,0kZԌSRܠI1\"T.tCuq}'vKXZi(<`WejTkGQXVHgKJ5[\";+-ESӤ\$#\"43&F7ē4]t9/ BqAH9)q`-ĺK@s\r!73\nbA:\$QbUhГ*#xR}YLdLRu'^ĪC8L焂?2[of0\\WJA^T#ʶyHIğ;:XO^gFP2\")\r@е,M]3-;'r6qQ=i~jTie`f#Ɔ\\iM!q3:JeeS_9&IQ,=p^mj%d94I&0rQBǸvZ{QjmUZ{lM6^&`a-&\$XG%WTgy`O4YTbK1Sxi\$\n\\Q)VpݏiA5F\\yW[;idF;'zBmp>0K!<Cgm&xLUIռ\\Ft)pM18%#a.٩qSSi#j\nJa#Z\n2ɰ\"\nP!\n%JOci4(S_ʈD\nKyOf`:Dˮ\"B]LSEѨ\nK#xh^f3wM0`\$Ņ=_Keqn*ML_C]7p)*gs'Z`wL4m+*Y 00-)`Rf0bVQ8J^P<}'m[Xèg}5/3]E'=	u<1;QEvx0\\bq\\eP=r{9?DJkڭrS ҀNcOgQ`-c4DTy@'0Y`*zXP叏MϘT-9~Ш􅳒\ni/Rz/ǈR8@B _EGh`QGU<p4I}'`d\\HIt8ѡ>;x2Li+IWo-靉\nC9AE`&l']J\\؟tBLK\rjԭTND£*OUED?~TD#or3N.YU}ĠrX>5%9lw՟,aC%TY4K\$8z\"v`da2z'XD\0\nbǄ.@tN\n\0\n\rt\"N(\"*.IXF8p\\#+#(ƑDu>vH#ZZ!\0HPR̐t*I##[ODGg	dNt'GGcg.4'ǄB`s400prNL\r^LHu0uWrcO(nTPpsǢ:	;\"-*f[\n-s\0gNQj#!JF*B)AnxNZpb\0KLnV9%\\`\n 	H\rL^(l҄@&.0dK5l \"GykS@y:hA/%~n`+0F\01d!QnvP˯ \n,* / %<r(!DnFU!DV\\Ճ\0,hWX\\b%8&m#azb;,j\$(\$(#((RҒ(O	)QCu({*ho#ܫ	(bc>#2\"b%=N(o-[.%/-.n!#¶R?0\0#%E n(.[.\$b\rLXJt`'أ\$5	u3i~Qcd:v0a#3i\$RgJJ\"2?8,1s9bQ2X-K0k\r'bK/\"(\npn;Ks{7,S#oD'T]=)'f\0R-D*'sab\"0tK\nSCZ?Q?E(=ؤX+?\rM=rVPk@c^ͤ4Ġ/NI@a!*S6au;)D3\\ĸ܍\0_>	\ntKh#1<e:<0=L*Ģ4;E6MJHa:P+/5.\$)Ӥ5OJ 5\"4?L,p@uz*SRTc,+RPġSqoΗQ:R`VT#RQQΩV!8£ {mXuHRsr/Y2XA& %\\&-TPA\$-ChuH~c&%1XG䢲gRbHZ\$~#\\#ri\"_8RʦD)uZ4hu0@0(KP1,T1*gNwh\"tO!9J\n3FWg;/UX3gIw6YKhM4wgzԣ5mMԔ[i*@Z4,5k=(U>N2U\$k1o[qnB{n!A\roBx1i[\"РDqe6`@5wh\nI3\nw#Sarv,75'QhR6gЧefx VS4tr\$1uCwn%w`\$/\$HDcO]AVjt1\0[kX00xu59Bbj\\wf׸b|pi1<:WTҩuwBw7ײ{jo-w퀰\rAwFeOkk6#=zmt{J#[q nY-X.EXX-8]lYR17oAM2xyw͡zKo\$qG\\]\$Zx	U!>W!uzUu(.KZzW9QUcDH/31/Y-KrO(Q0*uuqq2MJgOK5SH3\rYtC{F9L0\n8W-<qTQTvq'T_TYm˓x;j;*gX#a-dXWȴ+&T\ruYcn2~*uv\0n\\â8\n qmoYfxqJ	%rq&ju64O&X_\0P,`źOIUqgVbCo=7řu3A-@HKifZDc\"\$Tzyr92xe-4/e'\rgz4Ws+^3<bTbKU4eTLZ:dpd\n)#MFZ**s;z̉d3ѯ˯QtVy6hxЂE^S;G?\rF.l+q]մ䍵5`HrdDK@ubROձL}Guy0m1SpqbOC4tG0%@L\na뻰{ۜz)~X7Ղ&xB,\0zTSXZ@";break;case"sk":$f="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"iH0{TףC8@ØH\0oڞ>dz=\n1H5*j+P2`2I5eKX<b6 P+P,@P)`2h:3 Pʃu%4D999cʳ\$s@PHElP\$-64ɀr99#dN1Cp jLÜ ~9pִ):\r{TB2\0x\$(C@:t/09Ș!|)`ZC ^)ډ̉c7^0H&JNUk,J6X)LVПr6:Bv7c\\+m AcCh <x֎pbC1B	sJs4H:\0C.>:J:uJ:Xᆱ0Or\03#;y|9@P2Ez~X=(J	u+id*E^5r6\rc\0!7!T-nd=.#l1C2oVN64B=eX	a}~QR6傟ح'	Z`;#l\$\"3w^RLʣV,`m]9L)3q\0YTntI&a'6gJI)3`جHOuU	\r75ts͠M0p]A@hPPL!jV'CeNĄ;*f)\nEXju媋!ipQk\\+ruҬb^f\"v\nw\nU*y`P F䒒VVUB`P[\r8-\"Xǅz񁑦@ p'\rCbR#fֿPM^D\"{Ns\"0vY	&\$ŠSԀ?)3Ӄ_ML0cdE!|1nD\rd\"9Pl佗0@	l* Rի5lbdB)ӥCL\0PSH\nl6c4|2tYAg1_4(	Y7ғ ηu)0RR2gFbbdm	MIJB7v\0i/fA,%B5a'\\^w2SHI!a+XPa9gK26\n HXc\$\$(jPӱ焞)O\naQf4pD՚1sFPiHp\01A]\\-A,@\\\0SuʞɼP8!PuM6RRèdI5!aQ9@p \n@\"p!&\\Ni!-`\$\$t撨Vp1\$6G<!TȁDYE6tNA!WV(c}N-gP{l웆\nc|3/f|daC7[9Nm(ĘȱNS0\092TL=>q-\0>pT03|ClppM:Мf\r\nND2u%F<UsصE\0jHm2AxD=R*/j\$x3呈5(ڽk#nƌ1zVMx\n,e]\nXN\nrݰ\$[8h:xT\n!AkV]R)h>fpA/+\0̠L\r0#qEfXzPuZIҼrsxpL\0gSVpO\\{9[`ǩD\"M\$ܐKIcG <:\$Hk\n̗a`tye0y=^ғ;(<==0SU@܆I)Sc1CE>	G_\"YƜK!B)\0ɘ H!HeP}cҁd\$zX(c蓂B7b6F0JCMbb\"θ; =b.4̈́Ԃ;napp'vBMf۰,\"6-Lۂn\"\rFc\$@}\\ (\"~HLY\$OW\0b  Gc.PGI(#p˅\$IƾܨXI4c(I*Ɔj\\3 S@gxpeVoxBI'09-q'mgu:~zqMPzzB{,go10f16cFQhJk-\r!t\$;81<tQQb&|&b`,CQQޡZE1q[\0\rF\\IB,n!lfiS,=bբfI6&\\&fu!}#e\",jL\"Zȧ[B.Xl:Tr.,F²O\"O-R\\'MdV&+2\$i&1'+M +\n-d:8(B2lc.C1=Rrr_92(c&yD(0z/@jEƠ	bLs	-\$Tu:DlQ.K.?51uapu,	8fnevqpcς7A7C-i/3\$BP'VYL@Et3o-JY;'3/Gy<89d:9F\nR.-<ne1:F.m+[?tV\$ߴ(11?ӂ}?Ӗ}BeJ/JAӹ@tT\\+p'EdF7\nYB1f4Rӝmdh[4+ʭfЅ~oHc&	4EOJ\0Wc]JO&\$\n1G(%\n\nqԫ\"E,\$#@|\rV\rh>?++,(%cB&TGG@K\"*@ZEb6<\0LWh1lU\$%HY)KCVFV_tmh)),#\nB#>&	JĜ\nRFI_\0r>)#dgC	ҊVrrE<.	gEl'J/iL)4JdJe:Uo)v-ӻih0p͢(&ޥtaQ;q`'V4zr`Ed3`-h+2az:S\r0rv({&1ed5CZGNZ\$Pd5\"g1ED1[m\n-Ur#j*է9<6S<&\nTugWo\nK	\0@	t\n`";break;case"sl":$f="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!\"l;*1#Jh_!\\LLTA(\$izF()ϐ*5R<l|h jB?H~0r8@/ h\0C\$&`3:xY͵Ar43x^Q\0J@|8̍\rH7^0{,:%P7c\nDC;Z2KH[d]r.H77e&BR(K\nI5.xf\r8_\"T6(;ŠP%A## =2OfF8:d6U/0s-qNZ9'ӉE\r3&#~`	BIxqib6\rˢ\\-(PȃCX^a#zv\"}[< qn.=MP,5\n}KN!slh4jj;6s\rwcޏTS *#0̝*	x2N*\r앚7,:Ѭ3g@T0haꀅRS&9ӮGxT1ǔͬ P\n CK*xJƐUPbV\nZ+eUڽ\rJ >9H%ɱE G¬)=AЕ Ѐ|HX<D\\^p ZՊ@utVC>	!8u!>xi,:)(gViD\$>6J7`@	b\$%ׄk.=I8^rpa@䖅f\$Q(_yS1ѐ RX e钆>7С,TzB_. AH\$t'Dny/k@I\"gH93e6iOn;6z,yjqÃS*sH悂QQ.NdZrS\nA,n	! @xk5^#dqFA!YQd<H|1D8	\nbk0b<'7GHf(qgcG ' 1/g30bvV@'0B\rG]*dipHdf]Rk9Hj!Ad)6[{	v#\0M0T-\n O^IOx95r&\rf:\0u3MDm4,jhu,d껃pca)rl|5ճ6hI\n`'vGl8&a8y4d^*\\>6&q/E[ cÕA{'IB\\@q<pdzc+@\0ErR]hro)z\0xr	t8'2fPZFŚEeӜS:?˳ +-`KDTd\$2R,+B\0002u%|αs\r{6EHC®wI7@ٛn4L%(A4lL+zBJrb:qL&p\\˘\n0|Â+\\2j%1O	[&}2&Aa U}SQ'{Ivt\r01mIZ.0@2-a/z\n`:h[ i7+irV]2(		h6{vn]iTCYovP]~j^Go}w;5S%#oM÷\\SS6b#\$ռ<Q§	\"x>w%7Rߜf7ψH͖9(qϝDS^zHbZ\$6O`w\"8J#vr]^ooL҆Sٗ@xNf+ɸC\n\"~\"G}`KڋnvGͺ.,\rձ|OPR>Nu+a0UexG̜Un.M>I,Yhb*\rWoBr5\$Cu\$\n-\\@ܧ\0ҁ\$Z8F\0l:i>\$b<\"`;MPϞ!|PDM(!lpFϻ`v'5\0#Tʏu\$#VvM@'Kl	btnÐ\$n#:\rnI|ٍ	\n\"\nkz%P06N\r۰\n(pA-p07%\nJiA\r,ϫjw*A(ϋiovDH\"L67Թf<6h[K6BJ	.bl\$X5\$9jL>chDtYzk*T]a:n(|Υw.❑0)B['(K	d&(q#)oͱQBlI?@q!\$uTB\$ fXdNc: 1pd[!O 4		\r+reR!(L}Ng±%r'\nh`h+p/Z1hd,\rbf\r+)!q+,&ʲz\r,e!-Ҵ- 1_.,P%qk.2+0l(\$ ȾKu3\\m'r\r#T!12!\0D2G22.M1G&D0*3I/Y2Rg1B;[6u,qBɢx/cb-2U&+{`sdqGd\ri=8|s3P:b:4__	Š,\nrJ?v`996и2ojI02\";.s62N/Q_@nJ_=Ikg2I\07t%~.\nZ{.R\"tO>}FNn'B\$tmdF#4]:Ի@mECi<dN#|en%- OC%\r*Y=MZ:\$nF.*,.ӯnKPn.^QP'/QQr3c2-@\$U*u9&&aD.̀\n'.c5l'Up)\r>+QG\0	TGi=\"Zf\\@5\08T&*΋ؐ#dC&.ss#&Ί@2-A]\r#v?+n";break;case"sr":$f="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\ne3jڱ{TR\n,!\"D	3FK,Вzs3UD<o>@2\r`G r#p|^#rP2\0y3:x\rwFp_#rLK@|6n\$3Fck4px!D3L[jh#4TM\0\\QRYr޾z8'6]tb9\rF#>N(/^X:\$Ƶhbv^+G.:0\nfG*5?ɺĪnST@;c\$ \"[z\$wU7\"m>I(7戮H&fsPRʖb|5jf[JA`()yK@Q<<gۓLZU:֘m!Tۅ#4e 44Ln]jm1p\0?+Yx\0004 #iu0z B\$M\$A@ Fh7Fcc\\iCk)IXRɻ_Z5`qkmX8#>\rXWΠАsb!9I@\nN(`2\"Ob+zFr\r*99IU8C\"bf14 dLLR[-6Fˁ>	6Zޤ/ d܋1ne\"\"QbzECMG'^bdxx\$\$&cluF+'\r2XˣuXmewsoD3Β20T&(t]bO\"Z=/wk t\r|f0l\r1&%2o3Pą&YrzP\"vN[\$A\0Eiiu!aWy%{ĺ)S2!A\0P	BŴ\\SX.ի/JCh41iO19G02Ԉ;hV ZF簰ܫEe,c1a;)in::-eDBS\nA&\0\\Avl,Wʑ	]	UK\$>5H*CY턈Ti<%\nV%iBdd2vv{.9̌lɤK\"'yiJ!<)K%IȖ,Y>ē5h2)X(HTrTdݴ5\$B7F\"'3\0Wh@X 9,,#K8Cs}\r4{pA~9GA#C:OdʇĨAWp \n@\"A\0(KTH\0R &]ou\"OK^D^!j|P	P(wVҾjRo<b_yyjB\"JQF;BU\"%z\$g_,+\"ƕqJk=0).YB*YBmJUnxQ\nE\\oh?	&'Aޮr0LWy7~bVi%rlӟR V\0cJLVstἩĠ+\\JoT-OldtK;؜XHS\r!ڪ_,xS.X\"QsZ>>T\$#\";}9!;ʕ|܌4<!h&S>\$.v{\$CPYd/lQx=̒y42KdCNeHZTs4!J%\nh\n6e7+=y_z3+^ݮ޶\n!A>ny I?*nNB<kb:o^6H0p \$y#S,!v␗BE2\"b'l6?B04:.r1DHLoHnAB?l(0_\"nPSipC氄{p&o.-p13\n0⨿ij(PN̵	\"-k	\$+\rD\ri	C0\n\r\"I'P	p@YP_b@	&dF\$~H%)AmM%+WW|஠t&->N҂D&AbXqhj/TnwHQ\r-y\0C,\0jOMPQOrƠ&(@L#pQ?&.1sepdq\\OD\n.M #!Q~bdcZ!d%5\n03xx\$\$F@9H\"JTM('#V\$j%&'ʃ?LOoBQeG႖K&=>M(Β3\rZ˱rԊnl&dT2f*з\$(j.<q#{\0N+010k\"q!c!%!-\"o~m=.b3!\"\"(Ğ*sW/<k,QC\nPQF0'sВkfݳlN?*r&0_(h7e8\n68YH\"3G.B3;e\\xmK<RO O<1bKP\"?,*?ꔀ F\"3?k@\$tt	A*\"y4%S%[H ¯B>1k&#*:!B?O>>S=ofFmtJ\\\$-D8OBm҆lL12CYQ%Ԕ3NMJ3yJci>KC԰n\"QIqkP<ކneIO2s-MKA1IjW۔LvDo?QEK(i\")`mϽ8'4EJ>\$7:\"NINSS#Rl}{HT)k^S=Vv '1HVx0?\"A~VHM.JA[pduKվ)5V/pUS]]!+UL?#6U=8[j5{_`'&	O[Nv\"O\\PObr7K>\"a\$Y@obD\0\$m9NP,HV!Աfuf)IZ\$f_NaKT5EUcLz):E5wZ	\rSV?@9GkPd=KEBMpJk6	V\\?9/N}BF\$泱9*	w4iH\rVvCqVL.ꨆr(@ j@ZؙTBp:ml@j)pWlĂp0+:kMrRA@j*NTD@\rTB[s9t.fGACRTn,)+tl&Eq~2YF1Igy/h,eTbn.Av3m=O2/stQMx\$u,kF!x-p?MJ~I6V1/	\nC;~\r\0|4\$%Tv2Z \rU-|rݴ6M3~EVP.@_ jSqf'*̒HZKS\\)j*D\n%d\"t\r\$3-H5#K/\r::QlEske.`";break;case"sv":$f="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5Nu)ɝH'o2&60#rB\"0ʚ~R<9(A02^7*Z0nH9<<P9Bp6mv֍/8Cb*ҋ3B6'R:608܎-\"34P<2j7Bbn1>SlPdr<# ڎ?@Т\06x\nLԬ@R480z\r\r9Ax^;ցrECr3^c	k9O7x@(@5 o+\r#X:sC\\\"p/\04C>2`P7ғ[`Lj_B\r*6DM3QV2E#mP#u43*gMn&*(9-xC.bx۰2<\n:#%&E޽c\\A\nbxv<7dX;B\\M7:`\0003H3w0i\r>C>L46\"Y{׮;\"NO6E0jL,^WEAc6۫C(:삓7#0W);Rτj46&<zҦaac<[H9l@\$*>lU`ǴP>f37Z_c\rTB\nk [{\0_8D\"@\nQ\0A	s)>桜 U:Uj:*bժ`]\"b=b肮LbZfɂ6X?aHL`x@d?i`AU\05R*hbV\nZumD<J_4>UbzX<8iJLdjZ	\$~pFzOxC}H4Mu\nT	Mñѩ5B}3eF)Y\$c\\3ID z%z#H0RsKA]f\$RH\n\0hGt>2`PSK N᪗HNIRjVa;@eɛ\r&	bv@aRRc2CXR0g*2pY\n\"ycp	dcn'S\nAnL\r2ެƲR4\\&ܜh,Y>(V\nD:HLtQeH'5Dl!sk2 .jhB2\n}PDPBO\naPk%wʐ&ֻ%Ȼ F[UP_CIeiا1#%&B[/\r4:9AX]YerL#1A\0nDZZX[a\$\"\0D!P\" =ø' G	>v\n	ׅJmdz0M:^׽lۓN;4Vl_Om\$aIs=	XNqfjeNK[81ě2v1:+q<H\r&ۛЦHI'mŸ&rRZXmfaB8(l<\$*Kip>@hn	p[20<63cZĘ4\\WaȾtJ{Vmݺ{%dFCwhy|qS|d]\0kJfa\n86[ ȭܻ@-[}):X `	&F9kJItAo*+O1X&&4mcpTԭ,F:l{ޚ)n\rLhAomhVq*%9Ifi25\rm^L%2DLvOwd{KrjKa/Wfj33ZpVʤ\"I7zaͧKsξpCkê6ԳJku`m\r1C, Ĕ&On-]u~Y쑫w:I4;w\r<3@Ro&naа>^p@*yv=!웥c⺐St}wuCCś/wWJOءϚp'craKwCwLo39oOmD*aO\r\nܿy:@bh\n\rZGkbb4\$cBEġi ط\"!d*9<=7)NCL-ښL'ֻ^ox@0z믈,4]-DԂ.΂K*d/\n\"R0S0.9%(HE@hd~/WKF3Lq\r\",@\n.p/	Ze&Vp:3`iF2\\jdA&6'FL`Ԃ\n?\nHberTC1(qa-b`EΪ|DZPab[n11r5-M8C\rkѩpAnZu11ѱF\n{-JE.ĩ\"wDn}4\"<\0e*	2CðJ\nF1`0m\0Ɖ<X#:<SΤ	dm'j`-\nkڥ@2,p^K&'P>hdF\rV\rd\$5+**>P\r+\nX\rdӏ\\ة~\0ҵ/2BKΟ%(TJsgjMhCn ˂.&<^\n,yNFSnQ Gt&CɔJHN*'AE&K'JBv쬏-lqi5lxފ.-80D],f(pF\0b(\"Mm<܇NP=2<BK~/ë0`5kd'tAk@1>K0f7'0\rg.7QHFw#[@z<r\r@";break;case"ta":$f="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-@Z6|YL\"#s*Myp& )#6jZdy*cLt2hZV'\n)IJ6l\"D,nrVYҲY%괙w)m;uucy%\0P2\rDNs<s#rOMKO?#44C(C@:td(3Pp_?tL\0|6O3MCkR\r^0&)X \n~\"-SernÎط%-_0S\rw)݀sZO\$B+3R[q7Wi ^PjR\\*B](W!7\$HA(dFK\0S\nTfa7@_\n9kT雖Pj` :r\nM\n#!6'C`u|/gRo!:!9h={x_@A҆wY]`%oH{ShU'\\l_X3\0!2B'ipB\$AKnv1@|O\$0BaH&-};ȹ\\ĤAkq	8 N^&)!\"p̈\$`&:g	HHaM-'z!6Et_suEu46lFa#>Y@/)˧֮QҘ,nCrmABPDui9F	(/d}N:<S_d\")C̘o}6JTM|*8C*OMI7T|*Zު5JEoaC\n;gv 0lo\0ϗ&XT\r#+qN03E@@P:Hn:pPMl|0ЪDfZ]7\\+{cea>09W{vɝ:C#tGyҺwRkv.ڷNu64*W[I/I -9jUH?D`M~_A#AB.3m&79ՙ^	׀f4U]u:`샻o܇'v]TTOA<j.P3PT@\\*>X0S=uWZQ\n밈Q46uT.%;V*'sS+\r1 cA3_^\r}9S|CAa\0ǁi`)vEST!݊\$Z	B<ޘ@H\n#|}y+\ru+,jxL|O)='XTÐt>;9þؓ惚~qv%2so ~h3AsA╁8F)Nxkj5k=,dHs咑CLܗѪ`ق\r5~BV4l@7W3'/Ȝ؅w1u<KuxgGpV{t-3`@Hm8M|CCN9V'p'2R|٘TBO\naSDDLmS3asB͚,,g\\tb\r (3le2à͔\n&.u+)A(eǆ-44эSbSHb94+\$LfK<P.ἄP*P\0D0\"эa{p6JjfpǺ@Py&}%<i2Yg=o8%BCXd:\$Nb&\r0\n_QBKl _ĤJ*\\ɂx0Of%]N\"IPTJsJ\"-|f_\"Іp>C&\n.Z\\u	/	\0ĥ%,n,JB<FKj@+*,M(FP\nFC=r K,D&%1>ͨ5nN-LL?\$\rl/~<Z\$0ldf'tJ`g/7mnN\n`HcN\n`=Ϯ\r#F4	l{>e#\n,\rȮHT\nm4² kJT=@U\$VpvH'0b\0\rrD* o 1\"`B1\$.U@(al!_\"0qc%Bb1\$DFSTچ>r+,g\neb\0yg%(BDݭ\0F\"#qja\ri	?!\nNfȥp 	\0@\r\$ꬮzpPlSpTnj7H^B6Ja:]3'60}	F*c]	F/@3!%݇LCSb|<di1pXqm	qrD3k3З7{QQ3FB)bR&֦Ie7PϮel5\"93Y9s\\\rX3:s?P{,7Q<a*S4i<R;Ì	Zr@M IV\0+#~B(0M&&+7hȊX(T^#FGSMAC-#B§n-Ϩ6lp@άjF\nJKIdUe(:jp)nk)\rA\r~-(dAɫ=\0^kMS67h)+%Pc؄fr599\nHD-481d]fBt!8/.U;7tUG;;NUiN~nP\ntT81TN#+Wt:XSU;I7YmY2WRY[8p1ֆ0<.5rBS\ruuVȦ uvh+M 5MSAR~9,p򓰆gaNO9r	4r\rs4TQ[\\\\r:\"!\0,rm\$`QT4Vfc,'	mƗOЁ\\T@u6uq\05vs]ee5UK@MAIܦi/59iVu]	k<plefkoʦdTCjjeZ(	q/nT?Pukmw#phq7Vp6[4)k7\n+H0/|O2ꆩsWӾ!֊9lW5Ά35g8o+KebvqvuI%ww4vGEf5Ja^֓W\$!Uz9[o}WRExR!ZOCSeuw|'UVwWfr/\"4:Q\rzp;Qy 2A|esUu*G11QLzqhTrHk&LIAK<1&xԙX	I-hFD2#Rv羓.w'5R8s	x{3'p6| ~5kJS!UuXZ&7@\$8!i9X.-\$	|Z'vӐW HGzQ;UU7Qnw1ԋ~sAG,_PC,^Cz\0< qUn}72ȢRpVず(kf|r痴ρҿكu)57Jyޟ9Şp^97rU+I#PC'|g,/JSfɌa6/+6ܨiXUbuuv+)sykI7y+WMyOH!azYcvمƣJP?GQJ88ڈK\nUZH%)qN[5JZ`Dx̧dc+i7mC}q	:ۃ:qZ7Ց!W(9i+c!'Y_.*56~uEi9?g1@Zq̟N[Ch[;m[_%RhfIZYm&x&ۏ\$zh󸛞G;[aWc?;y{ǻ8ǸZ9Y@cjTWu)P%W+vhZEE2Zڱzx 	 u)yG)Ǵj.2+A\nCxI@\r	>4yZSN	=p'T[-7ʅ?52nT#GE6(5@{,#FPBWŐ\rV `sQM@`̮,+ڄ\nZ\nI\"y(j!d3Aa)mUQ[j#\$cqgo]SsUI0][#\n2x\n.IM2l5v	Y\$wd1L{Ӧ@AU3ϗC(}w;qnRUɹPE,֣?b?{f_yrQ9:䣬C{fY089PmI9QuzYeZ+uf0ZcnU[e6\n><-{QCf[.,,`yVɷf^m6h&^;cB~oi7\"Co\$?@Jw>@\r=s24'lğ~ @SaIbغ0/E݄\n=gΉ6̜\$Ë0'\n|ȝ>qma)6\0h@=܁07ηs2\$^T	\0@	t\n`";break;case"th":$f="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NTE^m0AIKW\0EV#*\\`e94t!J]ÕP+\"xvV;GM ֈg%'幧eӃ,Ŋg(# *>>38Pc0c9ʣ8@0S;;C#4C(C@:tL;v9N#8^2}9P^188 7^0-ޟKt\nd\\x+Uf\rˇ[2͌7WL1NEԵn#VK WgXpsd2cs1`},vc2.jtJTF孇\$BN[-8=V7HÂ-\0PDsA:l%\nNB',Ffza\r0(J6%u]]1#GIB~vVCۅ-a5dZONCkTlqq\nMrvI+l\$FkkpҺ@F a\reZ\0S\n!1+\"WnB^R\"Q+}-tS҄2F22ޔ1IlpB5w;LOrS!A0J<.r,	\\\n,Dx[0|h\\zcp!%)1FycbqM+pe78 D	,CA7`I)(\0ѹ\n<A\0uվA\0l\r*7(8!0PAS,\rm:PPM*y8?`og~,d@X\n4DJ4\r!c\\۝sѺWNkNCv X3+M%SZ,'\$,it`R6¸/jz0F;W%`&tDrI<\0T[r9@#kv4JQk&BHm6\0fA2@C[P^e-\n[0pge\rxb80d^  qAJ#uo40k~)~vJT*R?9ȼ уoQҫ;MΒ{]QI܃@\$\0@\n@)U(R^zN߹܀7SUJ\no`w>XCA)6M@桛OMކU\\{r04;{Hgsb3&keyQ#h- aL)hNIL\"%z%0SݹWTWUijEXǭIaSdDXWKav8FV3vu<MuzW`\$Pz[{͊^\\qa?dkn96:1kPϔZVM+8V=*4\\cL6\nU\$jM̞x\0pcZsEO,pC*V}bT'pI؀jpz3DF6d`\r\r7BTۻ r=NШ!3jDENˉ\n.p \n@\"{?i&^ 0Qy9G%pQc^]>(]Z4MXFV6?ěQ~3)2JQKxK7Ot%7xi>zmh6\"IvVSx~iz:*Jlk\\Ѷq\\\$j	eLP.+9|,0h&( \0b)'p(ʄo-\r 􈌶J8?,İ7\0c:ό/|XKzX:^	L'.b`gޕ|_Xb{op0TZ2'	apHBfDITS|HJ\"t?DSEúf,VäҠgE8b^Ɇ[v8\"\nirǶf\"̦&N\n`\rMOFfT6Q<H\0^3\nöI\"[&'e\\D&qrC5H%R;^d6.n8@PC1OKdE&+)<c)0ϖADeg&og;9WmXD`OcP\"+dfJW#֢9e].\nDF)/FxBJ[\$5#I\$1'kǥf\"[V\"?\n)zP9hke)Z9~G28[CPaf}DJ9HE	Tm.Vhjh2[QǶ<Y²;\nRIeRDLs}DK&(E 8-+p.1Z<3;/Ǯ]2:DY4Nm	\n:)EH+rN\0W~+2B:F+gSә8Y)IIU9e7C[n	I	z8fbX@AB=Y=nE*Vh0S\n./\0G	6	Ds%./<Iz;p3pU2Dli6ov낡A}hTBBW11}At\\irII?DsF	FQP:I`8SFI|9u%OnLBS%MI0Q%^Si<dF+aDIt!IH8}4HM<+NNgOcLi+=\"O4^Wf>H?fC0H<,u=L4YBÚz԰SHT\r	Q=Dd*DRCC{bgTH4KM+nYn'93C]BTo}cOH<5 ;N/AVG*7GsG^1\\0lq(q/(\rNF``O]HP54(Cq3aQ}_N-P49<bt2VY`AbQ57Vs~e`:#hv>U`jaw;_1zLtb%`<%Z@qHRa}C^O<v1]ԓR+kt{aOeI	\$\r̼xP	cnc\rs6bVlk4cNp(/r9BjFRgЍ_n^IK9stVImE<wAmS<]}uk7uatJvvSowmcw;tCwdA/['tV\"I+yUQR73-) u0[[pi|CygIKR8\0v7pW7lbixURu{VMvPjA0|Aa_6kf}1FLvTOl5}ś_GXO	\r!JoW.Mh-'+/K%:\$ZQ45BT_G^2\\6g5}%oA-DKG0t<ҋQd;ezj\rV`b\093%-N`΄\rO\npj8ёtBϴR6b10Ǯ&lߒ@.?fVT9D 	ULd6XLM{µCy]rYDx9C\" \rtwg2pYu'KX.z)oE,uf6\r4@ʫ/Z@\n~TXܝ)@-{v\0=рv\n\"mr#Qw^B/7VXL\"#6St6zbg[@r6	?iUqӣ5Bz4e*@osz'w̛:l[z|:#\"zdn;;%l2enF9Fv+9d9i}y:edǋ `>x\\Nv+eoC1㶅[	\0t	@\n`";break;case"tr":$f="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`H<4m @3N)#:6c:T*Qb\nPB^-\\/#BJĦ.832 #r<790Ɏh03=p4@ި\"*C X90z\r8a^\\0Ј<\$8^3\r+\\,x:\r.x!O9#́B8'b=##C\"\rlDάrx*-rϰdX\"-.J2&ԉs{E*J:x\$#K0 \nx<-{xqPh2HF]\$NVP0CC4SÒ#ZhB`Ҁ\"k>It:+-/R1x9X&BrN7 7NBa|f)<`\\M:{иMZmZRWzS'\\\"״I(}I~|oǀSr@I+t7w#@C(39Cdd:'LO.=\$|5Ä0=A<bv9d762.<.b@\"FLEÙ8m2҈&' O[AaxG	'PjCDQ\0\n>|fd͒:XkE莑FAV*ZurwWCep/&ol\\)%xx,^嶷`~L`d6('EBHoP q^+#P.6&YChCdWJ_,IY)<蒳>@E0ƤL0srGWr7FIO&l\"|*ߒTA,\"HX]/FKg)1tJ<\r\$.&Ё'\n7 u]HDC0Ȟbg<\n\n()-rS\0*</ŉ(qFb bx]PAq!hEA,v\$r>0 32@\n\r,PFhujMu1<:NgrJ\005\rF|YÐm1p6cI\"%Z`eLY\0A\0L&\0GASsfeTa OWd'8ӌh<eE~pn|*^P	L*>A]#jeٗTH0Qϑ<T3'N\$UFpXl'\$\r+=h{J\nmDg3Y ~}SOA\rKЩPQ1>^\"AL47p[	`E܄P*ZrG@@*xE	|\\`.\$R.c%ȁڛ[QV\nf\0Xk9lИ%b/.P}Xa	\r''*FǗ7&\nq%2\rzNnuj%qL3,\n 		^xD,E/h:xʭOyj]8>[pRN[рAW/ekZ3!eD}f(Ka9#5z#Rg/P32qcGC6t`;HG|\riY*574DA51sM!I4O=hޓ2(˭fçAa J\\dƒ C\r'1P^Uثw]LM>DO\rwF!Ɍ/\"} x圹{5(s.\r6oii~T\rmT OB<\rQOzN0r~oze\"Ӗ^heG2WI&dR\$L5@Pؖd(p)g3TX!9+eG6;K˫.R\n{ܤ\"Y6:kԉ>\rf.3+Ϻo\$?\\Ь'4u-ם1mZ,Ȳ\\.fDѷ@#OJl\0\$<\rE_b@m#NZ/TcB\0*`Gdr/LHTHopV̪f+	gQp\"\nHPSL\"p!NCR7`a\0,FAr0NCx&\r0܊&#/	/7PņS o̬E\n2\":xWc#a498&òLQ*(c~`\$D1(t&	ͧM^\rMpo1}QyM\0O-0Q~q1	\"͹J*CGdz-xJcp\"~\"Mp\nш\$pbqqn;*[\$#I\$HfpgC P!\"̤\\ ! %q\rC\"rDrIgz%kW%%~JrniQ%&9!y!Rw#M[1\"2e(M%)u)m.1Q;\$,rr\$O+bݲor'ʲ;d,Ʊ`x.CBNb=-₭Y/D8>3 \"dmQ\n/P.pv4 f)c.8 c`%\0I`i/O@&\npn A11Z<\\+0n0J3Luf9%5g:GĂ,z:r:/,SK\"\r4&&S6mܢ|0X]hM,Sl\"쬻!k\$b~7(<(,ZzB1s-,),vOD[)c~\0EEL	@\$p=\r\0e>l\0@辀8@N\0\\R{\"4E/ PԞq4t1 t?CMbf3C\rb>CFK\$j\r`jjh@";break;case"uk":$f="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвH)Lxݦ(kfBK{))ƯFHm\\F \$jH!d*B郴՗.C\$.)D\nlb9kjķ\\̐ʾD\rZ\rqd隅1#D&?l&@1M1\\`hr@:,΢[\nC*(kYCO9	\"%iKQ%\nYD!5ҰM.ȣD'-(b5jClhGUN/Ҙ;s?Kp h7*.6e,4ky2^8(|!\090z\r8a^\\08^\rp^8#; ^,f]Ԝ%/|\$i\rIq-}\r\0ըҡpjIP݄Yikؽ\r6\n&4 F\$Q,ė=EU/C'2}MP\n5Ge!s=]!SNլ(<m1ܤ#8}3sI12*{REcW*.xmTGF{u1FmPLғ|4ÓbB	[m!Ap[\n\0\"1\n(a5x2u.Cuì=/0@dh棑P\"yNh!%t!CluЈ%2 f`0ъQnEl\"ֈ\$\rNy#Buvލd:ܺ 0QŞtV\\a^P)z@bDCaA2@AIRRKI&Cti!4ܠL6@74*^mف\$ГRQ!hr .D:e2V)hIv&%=v;>arZ3)eLś3Mk'/<sK,BuK8RT㜲ι|f.34fJYs6|Qؠ&JmAVT\$XQCC/VqOg;TشJk8w*MrAĬr\n`a)\$g;hX˙2fٜ3xϚLhm^%0a&OBn-,!!H*S_L*q:J%]&Mԅ7o\")oGP\\&]Xu-3/f,͚vrwgFPe2564\r1\n(9<-k>DP*% EVS\\\$`U+@AʂI	NJ:<8)PT 9]OhzJ6YlyBUSSiH Ng*ՄUcC EɐSٳOpӰP	@G\00NR9bE\r*#\n*aYrZ462RH#~Obq]t\"=MN7XŬQDRU ,TuRQ#J`:~4\$RǙٜmetevƖǃj[|hrD:d\r᫆R ty ީ[2)h\$R2p9G֔EtoCYCr	;TSSŔ\nM==΂B\nUxM*!xO\naQHH1~3]M-U!\$_xc4TbY4,9@60Yӝ`C\n(F\n@#ÜG,|I[q֛qn<ȑ\01}C7;4:D67Y b	!&Ƅs#x̤RYy4j1/IZjϲZV2OTxMmoQ*㋷%2WN#aq2SK11-p6Fd\\y\$\$_pW\n/qb{UGc=D%Xb!xg\n[BS4'O>9IʽV(VxѦ#f8\$ff`!Hj1(0-b||7ˆ7RBkpR7o;pH!hnhBRF\$LLH2qGʂCp2!nkCɧnJgVP`%tbpb츻ʨ{dd-.(^D/Κ&f|Bh쥎x(M.ʈZ\\\$V`\n 	P8G-Jb*|x\nHd-LpGT7PQVWqZSD%m&)%\$#+gDOG*(d%lǻL)1XQl6r&ў1z~J-meBu7iCr'MqwQqWXQƜqSQ1,	m68syJR,+qg\$NFz2O!̼4L>[x\$\$%Fb'+%#`2L,cc.0J:q:\n|Ն?*D~\$k\"oF%Lq\$5%,B(<DQlqi.oZq&?/Q)?/`#BQq._.1OCD^ILQ1q1pLq3#n(OTN4g򍂻2lꧬ\"<{R[#{:\0,\$رhς?-SG>\"fD)0dss#\r3q\".w\";B;;>FL\0Pbp.5.^̳;_2r]|W2s/7EKA4(-4?T 5t;%Ȣ#2J+?D;HLtF^1<Szd-CE W*SO!g+/cC GQ=FNiFur	/gCGtFH|tIJ'C&m8lKj`E3FNM\$X	#OIn		k\nɕET'Ei=Dk*E\r\$. cP[J<EMܴ&iR.7Pc<NY\"\nxY\$k皿UZnaqPCQ+	5VEm5pNWﰊnT!b:'\n7u	FS9N{G\r]%/i\0]!]B\$+?Ou`&]4B۵ƿDշf\nUV6,qTn%']b1Oػ%P\n.nyއR?!EOTKFfԃg&aRMf!h\$hvsLp\\p2J|lG!bv+Of1jj־ckvohwE`.,~6:mO]gb^V>i)D\0,o0ԓh+kWnpKly*6q7* +mEDtWb4qȱT70\$&tQР6	gheiqwEvcPNqrW\nsW[r,vה:Lg1zvE(YCoqzʊQ	3tD׽SscׅQQ]J>VӒvLRӎ|&Ik%L\"Zy\r`jT6X'5óԧfmwe~ĉ8~7wU[,(~qϘ<rL7qKM-UhчM8|SBxi\\\rWQl*X)zgˢ6z\rNUX.w`0.CS\0@\nZ젱O>uxThZ)7moxQQ?EX'pöL(-k2cp 7BS,\$ EDYO;2в90tu[):YSGyn\$9u%v`R/b)CGwF#\0FY?xts?U%yq/v\"=y4C\$tS+XY\\QPo)\r\0h\$eVbTo-<UV ]+lQ¢!Z@\n`ǐ1}(txgֲu\0uβ5LK&kC<Z1w#Y`Zua<6n\09EF5Lv=";break;case"vi":$f="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤH(\";mh#\njh-aC3&IO>%*l΢jVJzT\"Pib2dC&! bk:V\0P(2\raYSiD_+3## \$\rACPP1p0j;(:\"9pX90z\r8a^\\0Vcx7]9xDkc36LP|+T2\$Uh ƀaHl\nxYee|ú@P0Cu\"<(P92DH:7TC'I9h&L5v'-%\rP0dP!)R<Q֢zn	~/E,eLaM]@ֳBEŵM\$\r2H;Wkߕ-a13P tiP3ʥ*ol)\"`<dP0@3lH!b'w\"iL©>]f(gwMQv~MJ\nO\n%\nx]*߃X}\"FʲLnB B:<J7A@~A?pC(xj!mxh4=\"\r!Pn,4B\rLZ5G9ӻH]Q\rwqFeb+AAʆ\\j;(<\"0k@jU]JˉAw8lC\"^ yUW_;6\"saL02\":>@ȉpPu\$@tM'i!!~#*A{EJ.SBNE>f:)༗_~/\0\$>҄90¡10|aQ\$ȢKy^ sǝĖBEB3Pcĵ5(X \\6\raz[h3Z*zh D^D7Q\rˡQHt]!ܩNw\\зAA@\$hȜ\$\"dBE(1XpAB@GR@hD:(|L>a0V ;tRBB::12k'閂F`yfC[/)@AF.Xu)FiY}=*蘐\\DxHAIFۤF?+z'jj(.*N!DM^;L@mH)%\$\$m@Aؽ\rBAA9s.\nt#YUFdKxP	L*EӾI		b9r	RItv|LCyWgӛ./GoD#Js%=HrU=Uv\$7ZI8Fb%eM,I#RPtJbUȐQFvbNV\$9k-uԏ@YM'ܴeBD94X \"^NoDCL.(3<>g!-&vi9L\n*eN0uf=z,|n)E<<g6DjM\rpµ,q[NoEI4(deUPzh2s͞X\$p\"ifƽ\0:cTGzNS1\"&ϒl=SO8s7ZH?Dۡ/EDWvSV\0	Re2*o\\u,@T\n!|DKMB7ZM~Q!o s dX\"ĝ.}-kb앎iR,I<b|A	.<g4Ti]2Tbce+~}8TK6o҂NA&6/rI5	EUS=yR>FUbKYk{viJÖq''ĂmD*L#8d.{\$߂6\"F-6)mfh@8BR92D&\n~T?P)\0~'(eRh!t\"ؖPFl'R\$9l.P*T.oRp8\0\0\$0lNNjhAKrOGuj^X\$\0\r HӍ3g\0{pg|pcz|bHh8lO\"]]|Gc\"\"\$dʪ9^% 1*0\rԠPL9~rH\rSr]XP0xDXpeh\\\$Ąh&n|{N<TĔg}A015ga\nɍ0GԋM}\r\rC[/	byP0.	!&Zol\nN7.X8DL\"SAv,g.N:&j]g\nIs \$`Ydlf'\$XJ.'o\"pV,Fm#b9V/OB' Ϻ[Ү-I'L)G-(\$OqK&.2eY-&[\rQj\",N	0Nr0 gNE(&\$Xw\"n0q\"̥11\"RMXlf[+4VMzLf`%PCX0&'s5e :KR\\;zj)s!Ɲ|1\0\\	:-\n*\rM\n\$G0HXJIE> \nqڵJ̮/RqX\$ts\"0tX,rP(s{=m*6(jnLkT,UŌ6dV,\0Iw̎M#+0æFa/%ԋ\0:x\r,HԜhQB|\$qKup\n8T)AJoI\"!#xډMde@i8r+Mf. .Nh'\n@@zTBk*D\n	2BߤEb\$́A,U̞lUIӨ!4@j2,\rf#:X%3oΠ\04b";break;case"zh":$f="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3Wq*'Os%dbʯC9Mnr;NP)Z'1T*J;)nY59XS#%Ans%O-30*\\OĹlt0]6r^-8\0J|r\nÑ)VYm*QBr.IlY,T^C@<# 4(tdlR>\\.D/r/i&\r3:xY\rBPp9x79cv2:e1AANIP|GI\0DYS1,ZZL9H]6\$O]&J6\r&דzi,Xur=ZS8tIdKLWeE9TrPDOZ}Dg)\0^[Tnw D%8sN]\"^9zW%s]d̲:Da&I\\VE]2Ą!dD#ECGmL)\"fnI57NSMy'1Q14\\	oSGAM7l/61+->]4sOtOdIJ0DW*?hDݗi6D:Ijst_\r-O:>aHXdV.LC<C\$@(lC\$Hֲ6WKKD1!>:@lCt:ȑ(	X\"U\nV*`]~ o\r:TA3_:X'PQ'E l0/5]8-ߑi૑TOQ4N	*U*VbúV!]+|(x9倲́h) 舶\$p\"Jd+r\n9D`CbBT\$\$1\$W|ϩs	1\n*ݐ	8\$F)\\SI\nr#iR*qS`(LdTCb0Dԛ<9pHse8G3@Kt0r,\\@<%s\nxq	+Ht!1-ZM4\"S\nAqI9f+?E\"v5-丘)M:CWUJQ\nd܂8ީI.tWʓR9Y(>\\(&,|R\nzҰ(\"EƻX# tV}is \"M2P(B(	m0^Ir`d	2w2`ؤǕO+\n	8PT@--\"KjHK*/Әe&Zqe0&EEw`qvtq\rts̤Gts&|9@bnv	JYDQ	NQЄ23BA:ΉHs9AiMaB9sWtaߐ)ե\$W:B{㤿Yn忯hM1@!թWchģHZL Gws/&R&CIa'e۱!~/Pz':U͘p6ObC	1DcthOXx E/e*\0Ju@XYM0f=n#Q6/\r!%	姢Ԭ:\\o_&!\nH	)8kAV1tRUf_A\\2-gz%P	<[QRk>bץOAiG!.\$/%쾶Q 9B^6	3W&QetKq,^hE^v?H&)Ds'QBR2Yy΃5{őgDtDt\\KK+-(_/)ieg\r\"ƹSD\"H|'ǟoM]fzwb\\cGy{?h;g#\0gwSjsf{I\\>z..RSJZ 咒Xa-,e.\n=e%E@RoHȔuM?gPɤ-6d̜!U-5<NqNCHkӞo_~R/\0n`-eF~NN*ȴz/E*0B/iJdُЦL\0?Ff'<A6|/bo&	K	gC\nT&&0pΐ-oaHjLH^\rd	0˰\0P\rPy\rGu\0HD0n*X`Dj	(-!t׃BbbH\"B}0DIa`zխ^~\$\0y\07VIh>B|Bm,\nZl*x+̡\"6#eۥJL.A76͌ܜ/ed6Ad3Gq RŪ䤦\$]n/RCIm\$Pdx*lq%j\\OX4igL!nr\$SĹ.N']#dpDMD\\ \r\$2\\Έ]G\"^BbMr3#c@@+-2ֻ2kr(R#|rL";break;case"zh-tw":$f="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ]EJ4\$yhr2^?[eCr^[#k֑g1')T'9jB)#,%')n䪪hVd=Oa@IBOs¦KJ12A\$&8mQdlYr%\0JԀD&Hi/\rUw.x].2ft(t	KS?2]*X!rB]# 4(tek\0Tr{4Ǒ42zF@4C(C@:t㽔49Ox3(9JP|t)!B1/B|GI\\CD=z%yRQ s-~W?JQ]\$:A(\\{1(MZS\0<(P9*iXBJy<EAvtCdY+{GePmj{_^6C↸vs|sGOޢD1T\\yjzP2@tS%\0N%+	6kA~)\"`As\$6f\rbeUxN*`X'@]0WVTu-jvGϥ.r9tv?ebݿQ<^GXZx.|1ġDa?)^׹P=DD#i`92AML4rD3-Jў.Ϙ( 	sDF\n\0M+qЂK%Bt/`5r\ndN\"	{Y\"q'@2r@9\n+2xD։rX+\rbul0ZIj-`^xn!40`b_:\\su@ H`^z0ʶnr\$f٨4P:*QN	X	b,eYh5)\r8Jư|\n#W	2\0Kh\"PED*\rDR!*fXEhiHBl9:O\0X09D21J\$:\n#1q܈L(3\"/U)/&\$\n6)P%9(90BTʬ*@!Y0v !GSZ&,L0!2`@R:ֵJĩQxj~XWlD&Țd9pH\rY'(Ah%ٜ()s	893eo	^ÕNsH4DiHFX(&htm#\"VVbZht50T\n2P	ȝOt>S% 4Z@(JU	8PT*\0B`ELҤ\$h&dGop]8FƘ9DRvEE/O\0#4Z:dޛH@,SxȕA\nڐy\"\$0\"\0]aO='|ӡW\0aB,UcEn	UْQdA4*wpLBVGf_؉2цa,SES8<2Ň8M=01tзHs F.sӺ\\T딟1!tL>ԊĄjc6tض;QJ\0OC	K'N`8}EQIfE%ӄmxKVop>\"|_zDbN	ŸMt\rPDg=ɸ`5ۘT['@[n\\l\n BHec_Q'&:	V#,㧎]N4uPV\"\\`\\#H L>sH0V'2cbArIw.EfӘ54f\$9\\{Xp;<0lX|Od_t\"\rQZƍ%uަt1Ǐ%ŧ%6~E#fhƒ]㯛}w7y\\|w#ރ9;O[gDEA#{X]x8lva˼w[~\nKAҺ&\0N'0э!C!P5\"vT%n3hPl%nnLb:6\\\r7>\"lV_⨙ciW,H4,D/Z&a\nCg-C\n,\nkpl\rptkM}\rmr0PAP^,\nu:!梙b'7bpf\r&*a!m}Q(tij/T~*2װp]eB7Jx\$pNf<`B1-1!\0w\nt1n̍Cq1fqf1LAQm<Oqzbԭ?'emMm9@)I1Fq10pA,	\r\0hl~4gN݄0\rƍ+2D<AH_AF0b\$0#k#!\\\$\rD\"\0}9rr:#ق~5ƌJC(\$N\$8P\nZ@w*)ƧL&#~^,%A8mVz\r3)Jt_r좬Ό⚭	/8\"uRz,1ZvnBG#\$/Za`_OV0-OyAk&%Mv/ox0~p'62~.p)*LX \r|.\0 }48amti.12\$Bi^y3S8]!&t~HO%®B1L";break;}$wi=array();foreach(explode("\n",lzw_decompress($f))as$X)$wi[]=(strpos($X,"\t")?explode("\t",$X):$X);return$wi;}if(!$wi){$wi=get_translations($ca);$_SESSION["translations"]=$wi;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$hg=array_search("SQL",$b->operators);if($hg!==false)unset($b->operators[$hg]);}function
dsn($pc,$V,$F,$_f=array()){$_f[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$_f[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($pc,$V,$F,$_f);}catch(Exception$Hc){auth_error(h($Hc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($P){return$this->pdo->quote($P);}function
query($G,$Ei=false){$H=$this->pdo->query($G);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($H);return$H;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($G,$o=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch();return$J[$o];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$kc=array();function
add_driver($u,$D){global$kc;$kc[$u]=$D;}class
Min_SQL{var$_conn;function
__construct($g){$this->_conn=$g;}function
select($Q,$L,$Z,$sd,$Bf=array(),$_=1,$E=0,$pg=false){global$b,$y;$ce=(count($sd)<count($L));$G=$b->selectQueryBuild($L,$Z,$sd,$Bf,$_,$E);if(!$G)$G="SELECT".limit(($_GET["page"]!="last"&&$_!=""&&$sd&&$ce&&$y=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($sd&&$ce?"\nGROUP BY ".implode(", ",$sd):"").($Bf?"\nORDER BY ".implode(", ",$Bf):""),($_!=""?+$_:null),($E?$_*$E:0),"\n");$Fh=microtime(true);$I=$this->_conn->query($G);if($pg)echo$b->selectQuery($G,$Fh,!$I);return$I;}function
delete($Q,$zg,$_=0){$G="FROM ".table($Q);return
queries("DELETE".($_?limit1($Q,$G,$zg):" $G$zg"));}function
update($Q,$N,$zg,$_=0,$kh="\n"){$Wi=array();foreach($N
as$z=>$X)$Wi[]="$z = $X";$G=table($Q)." SET$kh".implode(",$kh",$Wi);return
queries("UPDATE".($_?limit1($Q,$G,$zg,$kh):" $G$zg"));}function
insert($Q,$N){return
queries("INSERT INTO ".table($Q).($N?" (".implode(", ",array_keys($N)).")\nVALUES (".implode(", ",$N).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$K,$ng){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$hi){}function
convertSearch($v,$X,$o){return$v;}function
value($X,$o){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$o):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($ah){return
q($ah);}function
warnings(){return'';}function
tableHelp($D){}}$kc["sqlite"]="SQLite 3";$kc["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($q){$this->_link=new
SQLite3($q);$Zi=$this->_link->version();$this->server_info=$Zi["versionString"];}function
query($G){$H=@$this->_link->query($G);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($P){return(is_utf8($P)?"'".$this->_link->escapeString($P)."'":"x'".reset(unpack('H*',$P))."'");}function
store_result(){return$this->_result;}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J[$o];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->_offset++;$T=$this->_result->columnType($d);return(object)array("name"=>$this->_result->columnName($d),"type"=>$T,"charsetnr"=>($T==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($q){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($q);}function
query($G,$Ei=false){$Se=($Ei?"unbufferedQuery":"query");$H=@$this->_link->$Se($G,SQLITE_BOTH,$n);$this->error="";if(!$H){$this->error=$n;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($P){return"'".sqlite_escape_string($P)."'";}function
store_result(){return$this->_result;}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$o];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$z=>$X)$I[idf_unescape($z)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$D=$this->_result->fieldName($this->_offset++);$cg='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($cg\\.)?$cg\$~",$D,$C)){$Q=($C[3]!=""?$C[3]:idf_unescape($C[2]));$D=($C[5]!=""?$C[5]:idf_unescape($C[4]));}return(object)array("name"=>$D,"orgname"=>$D,"orgtable"=>$Q,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($q){$this->dsn(DRIVER.":$q","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($q){if(is_readable($q)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$q)?$q:dirname($_SERVER["SCRIPT_FILENAME"])."/$q")." AS a")){parent::__construct($q);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($G){return$this->_result=$this->query($G);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$ng){$Wi=array();foreach($K
as$N)$Wi[]="(".implode(", ",$N).")";return
queries("REPLACE INTO ".table($Q)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$Wi));}function
tableHelp($D){if($D=="sqlite_sequence")return"fileformat2.html#seqtab";if($D=="sqlite_master")return"fileformat2.html#$D";}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($G,$Z,$_,$kf=0,$kh=" "){return" $G$Z".($_!==null?$kh."LIMIT $_".($kf?" OFFSET $kf":""):"");}function
limit1($Q,$G,$Z,$kh="\n"){global$g;return(preg_match('~^INTO~',$G)||$g->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$kh):" $G WHERE rowid = (SELECT rowid FROM ".table($Q).$Z.$kh."LIMIT 1)");}function
db_collation($l,$nb){global$g;return$g->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($k){return
array();}function
table_status($D=""){global$g;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($D!=""?"AND name = ".q($D):"ORDER BY name"))as$J){$J["Rows"]=$g->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($D!=""?$I[$D]:$I);}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){global$g;return!$g->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($Q){global$g;$I=array();$ng="";foreach(get_rows("PRAGMA table_info(".table($Q).")")as$J){$D=$J["name"];$T=strtolower($J["type"]);$Yb=$J["dflt_value"];$I[$D]=array("field"=>$D,"type"=>(preg_match('~int~i',$T)?"integer":(preg_match('~char|clob|text~i',$T)?"text":(preg_match('~blob~i',$T)?"blob":(preg_match('~real|floa|doub~i',$T)?"real":"numeric")))),"full_type"=>$T,"default"=>(preg_match("~'(.*)'~",$Yb,$C)?str_replace("''","'",$C[1]):($Yb=="NULL"?null:$Yb)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($ng!="")$I[$ng]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$T))$I[$D]["auto_increment"]=true;$ng=$D;}}$Ah=$g->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Ah,$Fe,PREG_SET_ORDER);foreach($Fe
as$C){$D=str_replace('""','"',preg_replace('~^"|"$~','',$C[1]));if($I[$D])$I[$D]["collation"]=trim($C[3],"'");}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Ah=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Ah,$C)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$C[1],$Fe,PREG_SET_ORDER);foreach($Fe
as$C){$I[""]["columns"][]=idf_unescape($C[2]).$C[4];$I[""]["descs"][]=(preg_match('~DESC~i',$C[5])?'1':null);}}if(!$I){foreach(fields($Q)as$D=>$o){if($o["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($D),"lengths"=>array(),"descs"=>array(null));}}$Dh=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($Q),$h);foreach(get_rows("PRAGMA index_list(".table($Q).")",$h)as$J){$D=$J["name"];$w=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($D).")",$h)as$Zg){$w["columns"][]=$Zg["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($D).' ON '.idf_escape($Q),'~').' \((.*)\)$~i',$Dh[$D],$Jg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Jg[2],$Fe);foreach($Fe[2]as$z=>$X){if($X)$w["descs"][$z]='1';}}if(!$I[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$I[""]["columns"]||$w["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$D))$I[$D]=$w;}return$I;}function
foreign_keys($Q){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($Q).")")as$J){$r=&$I[$J["id"]];if(!$r)$r=$J;$r["source"][]=$J["from"];$r["target"][]=$J["to"];}return$I;}function
adminer_view($D){global$g;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$g->result("SELECT sql FROM sqlite_master WHERE name = ".q($D))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($l){return
false;}function
error(){global$g;return
h($g->error);}function
check_sqlite_name($D){global$g;$Qc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Qc)\$~",$D)){$g->error=lang(23,str_replace("|",", ",$Qc));return
false;}return
true;}function
create_database($l,$mb){global$g;if(file_exists($l)){$g->error=lang(24);return
false;}if(!check_sqlite_name($l))return
false;try{$A=new
Min_SQLite($l);}catch(Exception$Hc){$g->error=$Hc->getMessage();return
false;}$A->query('PRAGMA encoding = "UTF-8"');$A->query('CREATE TABLE adminer (i)');$A->query('DROP TABLE adminer');return
true;}function
drop_databases($k){global$g;$g->__construct(":memory:");foreach($k
as$l){if(!@unlink($l)){$g->error=lang(24);return
false;}}return
true;}function
rename_database($D,$mb){global$g;if(!check_sqlite_name($D))return
false;$g->__construct(":memory:");$g->error=lang(24);return@rename(DB,$D);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){global$g;$Pi=($Q==""||$hd);foreach($p
as$o){if($o[0]!=""||!$o[1]||$o[2]){$Pi=true;break;}}$c=array();$Kf=array();foreach($p
as$o){if($o[1]){$c[]=($Pi?$o[1]:"ADD ".implode($o[1]));if($o[0]!="")$Kf[$o[0]]=$o[1][0];}}if(!$Pi){foreach($c
as$X){if(!queries("ALTER TABLE ".table($Q)." $X"))return
false;}if($Q!=$D&&!queries("ALTER TABLE ".table($Q)." RENAME TO ".table($D)))return
false;}elseif(!recreate_table($Q,$D,$c,$Kf,$hd,$La))return
false;if($La){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $La WHERE name = ".q($D));if(!$g->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($D).", $La)");queries("COMMIT");}return
true;}function
recreate_table($Q,$D,$p,$Kf,$hd,$La,$x=array()){global$g;if($Q!=""){if(!$p){foreach(fields($Q)as$z=>$o){if($x)$o["auto_increment"]=0;$p[]=process_field($o,$o);$Kf[$z]=idf_escape($z);}}$og=false;foreach($p
as$o){if($o[6])$og=true;}$nc=array();foreach($x
as$z=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$z]);}}foreach(indexes($Q)as$ie=>$w){$e=array();foreach($w["columns"]as$z=>$d){if(!$Kf[$d])continue
2;$e[]=$Kf[$d].($w["descs"][$z]?" DESC":"");}if(!$nc[$ie]){if($w["type"]!="PRIMARY"||!$og)$x[]=array($w["type"],$ie,$e);}}foreach($x
as$z=>$X){if($X[0]=="PRIMARY"){unset($x[$z]);$hd[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($Q)as$ie=>$r){foreach($r["source"]as$z=>$d){if(!$Kf[$d])continue
2;$r["source"][$z]=idf_unescape($Kf[$d]);}if(!isset($hd[" $ie"]))$hd[]=" ".format_foreign_key($r);}queries("BEGIN");}foreach($p
as$z=>$o)$p[$z]="  ".implode($o);$p=array_merge($p,array_filter($hd));$bi=($Q==$D?"adminer_$D":$D);if(!queries("CREATE TABLE ".table($bi)." (\n".implode(",\n",$p)."\n)"))return
false;if($Q!=""){if($Kf&&!queries("INSERT INTO ".table($bi)." (".implode(", ",$Kf).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Kf)))." FROM ".table($Q)))return
false;$Bi=array();foreach(triggers($Q)as$_i=>$ii){$zi=trigger($_i);$Bi[]="CREATE TRIGGER ".idf_escape($_i)." ".implode(" ",$ii)." ON ".table($D)."\n$zi[Statement]";}$La=$La?0:$g->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($Q));if(!queries("DROP TABLE ".table($Q))||($Q==$D&&!queries("ALTER TABLE ".table($bi)." RENAME TO ".table($D)))||!alter_indexes($D,$x))return
false;if($La)queries("UPDATE sqlite_sequence SET seq = $La WHERE name = ".q($D));foreach($Bi
as$zi){if(!queries($zi))return
false;}queries("COMMIT");}return
true;}function
index_sql($Q,$T,$D,$e){return"CREATE $T ".($T!="INDEX"?"INDEX ":"").idf_escape($D!=""?$D:uniqid($Q."_"))." ON ".table($Q)." $e";}function
alter_indexes($Q,$c){foreach($c
as$ng){if($ng[0]=="PRIMARY")return
recreate_table($Q,$Q,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($Q,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($S){return
apply_queries("DELETE FROM",$S);}function
drop_views($bj){return
apply_queries("DROP VIEW",$bj);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
move_tables($S,$bj,$Zh){return
false;}function
trigger($D){global$g;if($D=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Ai=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$Ai["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$g->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($D)),$C);$jf=$C[3];return
array("Timing"=>strtoupper($C[1]),"Event"=>strtoupper($C[2]).($jf?" OF":""),"Of"=>idf_unescape($jf),"Trigger"=>$D,"Statement"=>$C[4],);}function
triggers($Q){$I=array();$Ai=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Ai["Timing"]).')\s*(.*?)\s+ON\b~i',$J["sql"],$C);$I[$J["name"]]=array($C[1],$C[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ROWID()");}function
explain($g,$G){return$g->query("EXPLAIN QUERY PLAN $G");}function
found_rows($R,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($dh){return
true;}function
create_sql($Q,$La,$Kh){global$g;$I=$g->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($Q));foreach(indexes($Q)as$D=>$w){if($D=='')continue;$I.=";\n\n".index_sql($Q,$w['type'],$D,"(".implode(", ",array_map('idf_escape',$w['columns'])).")");}return$I;}function
truncate_sql($Q){return"DELETE FROM ".table($Q);}function
use_sql($j){}function
trigger_sql($Q){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q)));}function
show_variables(){global$g;$I=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$z)$I[$z]=$g->result("PRAGMA $z");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$zf){list($z,$X)=explode("=",$zf,2);$I[$z]=$X;}return$I;}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Vc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Vc);}function
driver_config(){$U=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);return
array('possible_drivers'=>array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite"),'jush'=>"sqlite",'types'=>$U,'structured_types'=>array_keys($U),'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL"),'functions'=>array("hex","length","lower","round","unixepoch","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",)),);}}$kc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($Cc,$n){if(ini_bool("html_errors"))$n=html_entity_decode(strip_tags($n));$n=preg_replace('~^[^:]*: ~','',$n);$this->error=$n;}function
connect($M,$V,$F){global$b;$l=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$l!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$Zi=pg_version($this->_link);$this->server_info=$Zi["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($P){return"'".pg_escape_string($this->_link,$P)."'";}function
value($X,$o){return($o["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
quoteBinary($P){return"'".pg_escape_bytea($this->_link,$P)."'";}function
select_db($j){global$b;if($j==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($j,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($G,$Ei=false){$H=@pg_query($this->_link,$G);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$o);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$d);$I->name=pg_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$d);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($M,$V,$F){global$b;$l=$b->database();$this->dsn("pgsql:host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' client_encoding=utf8 dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",$V,$F);return
true;}function
select_db($j){global$b;return($b->database()==$j);}function
quoteBinary($ah){return
q($ah);}function
query($G,$Ei=false){$I=parent::query($G,$Ei);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$ng){global$g;foreach($K
as$N){$Li=array();$Z=array();foreach($N
as$z=>$X){$Li[]="$z = $X";if(isset($ng[idf_unescape($z)]))$Z[]="$z = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Li)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}function
slowQuery($G,$hi){$this->_conn->query("SET statement_timeout = ".(1000*$hi));$this->_conn->timeout=1000*$hi;return$G;}function
convertSearch($v,$X,$o){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$o["type"])?$v:"CAST($v AS text)");}function
quoteBinary($ah){return$this->_conn->quoteBinary($ah);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($D){$ze=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$A=$ze[$_GET["ns"]];if($A)return"$A-".str_replace("_","-",$D).".html";}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b,$U,$Jh;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2])){if(min_version(9,0,$g)){$g->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$g)){$Jh[lang(25)][]="json";$U["json"]=4294967295;if(min_version(9.4,0,$g)){$Jh[lang(25)][]="jsonb";$U["jsonb"]=4294967295;}}}return$g;}return$g->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($G,$Z,$_,$kf=0,$kh=" "){return" $G$Z".($_!==null?$kh."LIMIT $_".($kf?" OFFSET $kf":""):"");}function
limit1($Q,$G,$Z,$kh="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$kh):" $G".(is_view(table_status1($Q))?$Z:" WHERE ctid = (SELECT ctid FROM ".table($Q).$Z.$kh."LIMIT 1)"));}function
db_collation($l,$nb){global$g;return$g->result("SELECT datcollate FROM pg_database WHERE datname = ".q($l));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$G.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($k){return
array();}function
table_status($D=""){$I=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", ".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($D!=""?"AND relname = ".q($D):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($D!=""?$I[$D]:$I);}function
is_view($R){return
in_array($R["Engine"],array("view","materialized view"));}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Ca=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment".(min_version(10)?", a.attidentity":"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($Q)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$C);list(,$T,$we,$J["length"],$xa,$Fa)=$C;$J["length"].=$Fa;$cb=$T.$xa;if(isset($Ca[$cb])){$J["type"]=$Ca[$cb];$J["full_type"]=$J["type"].$we.$Fa;}else{$J["type"]=$T;$J["full_type"]=$J["type"].$we.$xa.$Fa;}if(in_array($J['attidentity'],array('a','d')))$J['default']='GENERATED '.($J['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$J["null"]=!$J["attnotnull"];$J["auto_increment"]=$J['attidentity']||preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$J["default"],$C))$J["default"]=($C[1]=="NULL"?null:idf_unescape($C[1]).$C[2]);$I[$J["field"]]=$J;}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Sh=$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($Q));$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Sh AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Sh AND ci.oid = i.indexrelid",$h)as$J){$Kg=$J["relname"];$I[$Kg]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$Kg]["columns"]=array();foreach(explode(" ",$J["indkey"])as$Rd)$I[$Kg]["columns"][]=$e[$Rd];$I[$Kg]["descs"]=array();foreach(explode(" ",$J["indoption"])as$Sd)$I[$Kg]["descs"][]=($Sd&1?'1':null);$I[$Kg]["lengths"]=array();}return$I;}function
foreign_keys($Q){global$sf;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($Q)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$C)){$J['source']=array_map('idf_unescape',array_map('trim',explode(',',$C[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$C[2],$Ee)){$J['ns']=idf_unescape($Ee[2]);$J['table']=idf_unescape($Ee[4]);}$J['target']=array_map('idf_unescape',array_map('trim',explode(',',$C[3])));$J['on_delete']=(preg_match("~ON DELETE ($sf)~",$C[4],$Ee)?$Ee[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($sf)~",$C[4],$Ee)?$Ee[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
constraints($Q){global$sf;$I=array();foreach(get_rows("SELECT conname, consrc
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($Q)."
ORDER BY connamespace, conname")as$J)$I[$J['conname']]=$J['consrc'];return$I;}function
adminer_view($D){global$g;return
array("select"=>trim($g->result("SELECT pg_get_viewdef(".$g->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($D)).")")));}function
collations(){return
array();}function
information_schema($l){return($l=="information_schema");}function
error(){global$g;$I=h($g->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$C))$I=$C[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($C[3]).'})(.*)~','\1<b>\2</b>',$C[2]).$C[4];return
nl_br($I);}function
create_database($l,$mb){return
queries("CREATE DATABASE ".idf_escape($l).($mb?" ENCODING ".idf_escape($mb):""));}function
drop_databases($k){global$g;$g->close();return
apply_queries("DROP DATABASE",$k,'idf_escape');}function
rename_database($D,$mb){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($D));}function
auto_increment(){return"";}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){$c=array();$yg=array();if($Q!=""&&$Q!=$D)$yg[]="ALTER TABLE ".table($Q)." RENAME TO ".table($D);foreach($p
as$o){$d=idf_escape($o[0]);$X=$o[1];if(!$X)$c[]="DROP $d";else{$Vi=$X[5];unset($X[5]);if($o[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$c[]=($Q!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$c[]=($Q!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$yg[]="ALTER TABLE ".table($D)." RENAME $d TO $X[0]";$c[]="ALTER $d TYPE$X[1]";if(!$X[6]){$c[]="ALTER $d ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($o[0]!=""||$Vi!="")$yg[]="COMMENT ON COLUMN ".table($D).".$X[0] IS ".($Vi!=""?substr($Vi,9):"''");}}$c=array_merge($c,$hd);if($Q=="")array_unshift($yg,"CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($yg,"ALTER TABLE ".table($Q)."\n".implode(",\n",$c));if($Q!=""||$tb!="")$yg[]="COMMENT ON TABLE ".table($D)." IS ".q($tb);if($La!=""){}foreach($yg
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($Q,$c){$i=array();$lc=array();$yg=array();foreach($c
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$lc[]=idf_escape($X[1]);else$yg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($i)array_unshift($yg,"ALTER TABLE ".table($Q).implode(",",$i));if($lc)array_unshift($yg,"DROP INDEX ".implode(", ",$lc));foreach($yg
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($S){return
queries("TRUNCATE ".implode(", ",array_map('table',$S)));return
true;}function
drop_views($bj){return
drop_tables($bj);}function
drop_tables($S){foreach($S
as$Q){$O=table_status($Q);if(!queries("DROP ".strtoupper($O["Engine"])." ".table($Q)))return
false;}return
true;}function
move_tables($S,$bj,$Zh){foreach(array_merge($S,$bj)as$Q){$O=table_status($Q);if(!queries("ALTER ".strtoupper($O["Engine"])." ".table($Q)." SET SCHEMA ".idf_escape($Zh)))return
false;}return
true;}function
trigger($D,$Q){if($D=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q)." AND trigger_name = ".q($D);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$J)$e[]=$J["event_object_column"];$I=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement" FROM information_schema.triggers '."$Z ORDER BY event_manipulation DESC")as$J){if($e&&$J["Event"]=="UPDATE")$J["Event"].=" OF";$J["Of"]=implode(", ",$e);if($I)$J["Event"].=" OR $I[Event]";$I=$J;}return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q))as$J){$zi=trigger($J["trigger_name"],$Q);$I[$zi["Trigger"]]=array($zi["Timing"],$zi["Event"]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($D,$T){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($D));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($D).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($D,$J){$I=array();foreach($J["fields"]as$o)$I[]=$o["type"];return
idf_escape($D)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($g,$G){return$g->query("EXPLAIN $G");}function
found_rows($R,$Z){global$g;if(preg_match("~ rows=([0-9]+)~",$g->result("EXPLAIN SELECT * FROM ".idf_escape($R["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Jg))return$Jg[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$g;return$g->result("SELECT current_schema()");}function
set_schema($ch,$h=null){global$g,$U,$Jh;if(!$h)$h=$g;$I=$h->query("SET search_path TO ".idf_escape($ch));foreach(types()as$T){if(!isset($U[$T])){$U[$T]=0;$Jh[lang(26)][]=$T;}}return$I;}function
foreign_keys_sql($Q){$I="";$O=table_status($Q);$ed=foreign_keys($Q);ksort($ed);foreach($ed
as$dd=>$cd)$I.="ALTER TABLE ONLY ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." ADD CONSTRAINT ".idf_escape($dd)." $cd[definition] ".($cd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($I?"$I\n":$I);}function
create_sql($Q,$La,$Kh){global$g;$I='';$Sg=array();$mh=array();$O=table_status($Q);if(is_view($O)){$aj=adminer_view($Q);return
rtrim("CREATE VIEW ".idf_escape($Q)." AS $aj[select]",";");}$p=fields($Q);$x=indexes($Q);ksort($x);$Cb=constraints($Q);if(!$O||empty($p))return
false;$I="CREATE TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." (\n    ";foreach($p
as$Xc=>$o){$Tf=idf_escape($o['field']).' '.$o['full_type'].default_value($o).($o['attnotnull']?" NOT NULL":"");$Sg[]=$Tf;if(preg_match('~nextval\(\'([^\']+)\'\)~',$o['default'],$Fe)){$lh=$Fe[1];$_h=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($lh):"SELECT * FROM $lh"));$mh[]=($Kh=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $lh;\n":"")."CREATE SEQUENCE $lh INCREMENT $_h[increment_by] MINVALUE $_h[min_value] MAXVALUE $_h[max_value]".($La&&$_h['last_value']?" START $_h[last_value]":"")." CACHE $_h[cache_value];";}}if(!empty($mh))$I=implode("\n\n",$mh)."\n\n$I";foreach($x
as$Md=>$w){switch($w['type']){case'UNIQUE':$Sg[]="CONSTRAINT ".idf_escape($Md)." UNIQUE (".implode(', ',array_map('idf_escape',$w['columns'])).")";break;case'PRIMARY':$Sg[]="CONSTRAINT ".idf_escape($Md)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$w['columns'])).")";break;}}foreach($Cb
as$zb=>$Ab)$Sg[]="CONSTRAINT ".idf_escape($zb)." CHECK $Ab";$I.=implode(",\n    ",$Sg)."\n) WITH (oids = ".($O['Oid']?'true':'false').");";foreach($x
as$Md=>$w){if($w['type']=='INDEX'){$e=array();foreach($w['columns']as$z=>$X)$e[]=idf_escape($X).($w['descs'][$z]?" DESC":"");$I.="\n\nCREATE INDEX ".idf_escape($Md)." ON ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." USING btree (".implode(', ',$e).");";}}if($O['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." IS ".q($O['Comment']).";";foreach($p
as$Xc=>$o){if($o['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($O['nspname']).".".idf_escape($O['Name']).".".idf_escape($Xc)." IS ".q($o['comment']).";";}return
rtrim($I,';');}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
trigger_sql($Q){$O=table_status($Q);$I="";foreach(triggers($Q)as$yi=>$xi){$zi=trigger($yi,$O['Name']);$I.="\nCREATE TRIGGER ".idf_escape($zi['Trigger'])." $zi[Timing] $zi[Event] ON ".idf_escape($O["nspname"]).".".idf_escape($O['Name'])." $zi[Type] $zi[Statement];;\n";}return$I;}function
use_sql($j){return"\connect ".idf_escape($j);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Vc){return
preg_match('~^(database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Vc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$g;return$g->result("SHOW max_connections");}function
driver_config(){$U=array();$Jh=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$z=>$X){$U+=$X;$Jh[$z]=array_keys($X);}return
array('possible_drivers'=>array("PgSQL","PDO_PgSQL"),'jush'=>"pgsql",'types'=>$U,'structured_types'=>$Jh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("char_length","lower","round","to_hex","to_timestamp","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",)),);}}$kc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;var$_current_db;function
_error($Cc,$n){if(ini_bool("html_errors"))$n=html_entity_decode(strip_tags($n));$n=preg_replace('~^[^:]*: ~','',$n);$this->error=$n;}function
connect($M,$V,$F){$this->_link=@oci_new_connect($V,$F,$M,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$n=oci_error();$this->error=$n["message"];return
false;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($j){$this->_current_db=$j;return
true;}function
query($G,$Ei=false){$H=oci_parse($this->_link,$G);$this->error="";if(!$H){$n=oci_error($this->_link);$this->errno=$n["code"];$this->error=$n["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);oci_free_statement($H);}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=1){$H=$this->query($G);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$o);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$z=>$X){if(is_a($X,'OCI-Lob'))$J[$z]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$d);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";var$_current_db;function
connect($M,$V,$F){$this->dsn("oci:dbname=//$M;charset=AL32UTF8",$V,$F);return
true;}function
select_db($j){$this->_current_db=$j;return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}function
insertUpdate($Q,$K,$ng){global$g;foreach($K
as$N){$Li=array();$Z=array();foreach($N
as$z=>$X){$Li[]="$z = $X";if(isset($ng[idf_unescape($z)]))$Z[]="$z = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Li)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces ORDER BY 1");}function
limit($G,$Z,$_,$kf=0,$kh=" "){return($kf?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($_+$kf).") WHERE rnum > $kf":($_!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($_+$kf):" $G$Z"));}function
limit1($Q,$G,$Z,$kh="\n"){return" $G$Z";}function
db_collation($l,$nb){global$g;return$g->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT USER FROM DUAL");}function
get_current_db(){global$g;$l=$g->_current_db?$g->_current_db:DB;unset($g->_current_db);return$l;}function
where_owner($lg,$Nf="owner"){if(!$_GET["ns"])return'';return"$lg$Nf = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$Nf=where_owner('');return"(SELECT $e FROM all_views WHERE ".($Nf?$Nf:"rownum < 0").")";}function
tables_list(){$aj=views_table("view_name");$Nf=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Nf
UNION SELECT view_name, 'view' FROM $aj
ORDER BY 1");}function
count_tables($k){global$g;$I=array();foreach($k
as$l)$I[$l]=$g->result("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($l));return$I;}function
table_status($D=""){$I=array();$eh=q($D);$l=get_current_db();$aj=views_table("view_name");$Nf=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($l).$Nf.($D!=""?" AND table_name = $eh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $aj".($D!=""?" WHERE view_name = $eh":"")."
ORDER BY 1")as$J){if($D!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Nf=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($Q)."$Nf ORDER BY column_id")as$J){$T=$J["DATA_TYPE"];$we="$J[DATA_PRECISION],$J[DATA_SCALE]";if($we==",")$we=$J["CHAR_COL_DECL_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$T.($we?"($we)":""),"type"=>strtolower($T),"length"=>$we,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($Q,$h=null){$I=array();$Nf=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($Q)."$Nf
ORDER BY ac.constraint_type, aic.column_position",$h)as$J){$Md=$J["INDEX_NAME"];$qb=$J["DATA_DEFAULT"];$qb=($qb?trim($qb,'"'):$J["COLUMN_NAME"]);$I[$Md]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$Md]["columns"][]=$qb;$I[$Md]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$Md]["descs"][]=($J["DESCEND"]&&$J["DESCEND"]=="DESC"?'1':null);}return$I;}function
adminer_view($D){$aj=views_table("view_name, text");$K=get_rows('SELECT text "select" FROM '.$aj.' WHERE view_name = '.q($D));return
reset($K);}function
collations(){return
array();}function
information_schema($l){return
false;}function
error(){global$g;return
h($g->error);}function
explain($g,$G){$g->query("EXPLAIN PLAN FOR $G");return$g->query("SELECT * FROM plan_table");}function
found_rows($R,$Z){}function
auto_increment(){return"";}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){$c=$lc=array();$Hf=($Q?fields($Q):array());foreach($p
as$o){$X=$o[1];if($X&&$o[0]!=""&&idf_escape($o[0])!=$X[0])queries("ALTER TABLE ".table($Q)." RENAME COLUMN ".idf_escape($o[0])." TO $X[0]");$Gf=$Hf[$o[0]];if($X&&$Gf){$mf=process_field($Gf,$Gf);if($X[2]==$mf[2])$X[2]="";}if($X)$c[]=($Q!=""?($o[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($Q!=""?")":"");else$lc[]=idf_escape($o[0]);}if($Q=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($Q)."\n".implode("\n",$c)))&&(!$lc||queries("ALTER TABLE ".table($Q)." DROP (".implode(", ",$lc).")"))&&($Q==$D||queries("ALTER TABLE ".table($Q)." RENAME TO ".table($D)));}function
alter_indexes($Q,$c){$lc=array();$yg=array();foreach($c
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($yg,"ALTER TABLE ".table($Q).$i);}elseif($X[2]=="DROP")$lc[]=idf_escape($X[1]);else$yg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($lc)array_unshift($yg,"DROP INDEX ".implode(", ",$lc));foreach($yg
as$G){if(!queries($G))return
false;}return
true;}function
foreign_keys($Q){$I=array();$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($Q);foreach(get_rows($G)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($bj){return
apply_queries("DROP VIEW",$bj);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
last_id(){return
0;}function
schemas(){$I=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($I?$I:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){global$g;return$g->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($dh,$h=null){global$g;if(!$h)$h=$g;return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($dh));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Vc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Vc);}function
driver_config(){$U=array();$Jh=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$z=>$X){$U+=$X;$Jh[$z]=array_keys($X);}return
array('possible_drivers'=>array("OCI8","PDO_OCI"),'jush'=>"oracle",'types'=>$U,'structured_types'=>$Jh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("length","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",)),);}}$kc["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$n){$this->errno=$n["code"];$this->error.="$n[message]\n";}$this->error=rtrim($this->error);}function
connect($M,$V,$F){global$b;$l=$b->database();$_b=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");if($l!="")$_b["Database"]=$l;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$M),$_b);if($this->_link){$Td=sqlsrv_server_info($this->_link);$this->server_info=$Td['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($j){return$this->query("USE ".idf_escape($j));}function
query($G,$Ei=false){$H=sqlsrv_query($this->_link,$G);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($G){$this->_result=sqlsrv_query($this->_link,$G);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$o];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$z=>$X){if(is_a($X,'DateTime'))$J[$z]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$o=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$o["Name"];$I->orgname=$o["Name"];$I->type=($o["Type"]==1?254:0);return$I;}function
seek($kf){for($t=0;$t<$kf;$t++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($M,$V,$F){$this->_link=@mssql_connect($M,$V,$F);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($j){return
mssql_select_db($j);}function
query($G,$Ei=false){$H=@mssql_query($G,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$o);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($kf){mssql_data_seek($this->_result,$kf);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($M,$V,$F){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F);return
true;}function
select_db($j){return$this->query("USE ".idf_escape($j));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$ng){foreach($K
as$N){$Li=array();$Z=array();foreach($N
as$z=>$X){$Li[]="$z = $X";if(isset($ng[idf_unescape($z)]))$Z[]="$z = $X";}if(!queries("MERGE ".table($Q)." USING (VALUES(".implode(", ",$N).")) AS source (c".implode(", c",range(1,count($N))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Li)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
connect(){global$b;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($G,$Z,$_,$kf=0,$kh=" "){return($_!==null?" TOP (".($_+$kf).")":"")." $G$Z";}function
limit1($Q,$G,$Z,$kh="\n"){return
limit($G,$Z,1,0,$kh);}function
db_collation($l,$nb){global$g;return$g->result("SELECT collation_name FROM sys.databases WHERE name = ".q($l));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($k){global$g;$I=array();foreach($k
as$l){$g->select_db($l);$I[$l]=$g->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($D=""){$I=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($D!=""?"AND name = ".q($D):"ORDER BY name"))as$J){if($D!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="VIEW";}function
fk_support($R){return
true;}function
fields($Q){$vb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($Q).", 'column', NULL)");$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($Q))as$J){$T=$J["type"];$we=(preg_match("~char|binary~",$T)?$J["max_length"]:($T=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$T.($we?"($we)":""),"type"=>$T,"length"=>$we,"default"=>$J["default"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],"comment"=>$vb[$J["name"]],);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($Q),$h)as$J){$D=$J["name"];$I[$D]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$D]["lengths"]=array();$I[$D]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$D]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
adminer_view($D){global$g;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$g->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($D))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$mb)$I[preg_replace('~_.*~','',$mb)][]=$mb;return$I;}function
information_schema($l){return
false;}function
error(){global$g;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$g->error)));}function
create_database($l,$mb){return
queries("CREATE DATABASE ".idf_escape($l).(preg_match('~^[a-z0-9_]+$~i',$mb)?" COLLATE $mb":""));}function
drop_databases($k){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$k)));}function
rename_database($D,$mb){if(preg_match('~^[a-z0-9_]+$~i',$mb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $mb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($D));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){$c=array();$vb=array();foreach($p
as$o){$d=idf_escape($o[0]);$X=$o[1];if(!$X)$c["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$vb[$o[0]]=$X[5];unset($X[5]);if($o[0]=="")$c["ADD"][]="\n  ".implode("",$X).($Q==""?substr($hd[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($Q).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($Q=="")return
queries("CREATE TABLE ".table($D)." (".implode(",",(array)$c["ADD"])."\n)");if($Q!=$D)queries("EXEC sp_rename ".q(table($Q)).", ".q($D));if($hd)$c[""]=$hd;foreach($c
as$z=>$X){if(!queries("ALTER TABLE ".idf_escape($D)." $z".implode(",",$X)))return
false;}foreach($vb
as$z=>$X){$tb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($D).", @level2type = N'Column', @level2name = ".q($z));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$tb.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($D).", @level2type = N'Column', @level2name = ".q($z));}return
true;}function
alter_indexes($Q,$c){$w=array();$lc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$lc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($Q);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q):"ALTER TABLE ".table($Q)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$lc||queries("ALTER TABLE ".table($Q)." DROP ".implode(", ",$lc)));}function
last_id(){global$g;return$g->result("SELECT SCOPE_IDENTITY()");}function
explain($g,$G){$g->query("SET SHOWPLAN_ALL ON");$I=$g->query($G);$g->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($R,$Z){}function
foreign_keys($Q){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($Q))as$J){$r=&$I[$J["FK_NAME"]];$r["db"]=$J["PKTABLE_QUALIFIER"];$r["table"]=$J["PKTABLE_NAME"];$r["source"][]=$J["FKCOLUMN_NAME"];$r["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($bj){return
queries("DROP VIEW ".implode(", ",array_map('table',$bj)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$bj,$Zh){return
apply_queries("ALTER SCHEMA ".idf_escape($Zh)." TRANSFER",array_merge($S,$bj));}function
trigger($D){if($D=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($D));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($Q))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$g;if($_GET["ns"]!="")return$_GET["ns"];return$g->result("SELECT SCHEMA_NAME()");}function
set_schema($ch){return
true;}function
use_sql($j){return"USE ".idf_escape($j);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Vc){return
preg_match('~^(comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Vc);}function
driver_config(){$U=array();$Jh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$z=>$X){$U+=$X;$Jh[$z]=array_keys($X);}return
array('possible_drivers'=>array("SQLSRV","MSSQL","PDO_DBLIB"),'jush'=>"mssql",'types'=>$U,'structured_types'=>$Jh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("len","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",)),);}}$kc["mongo"]="MongoDB (alpha)";if(isset($_GET["mongo"])){define("DRIVER","mongo");if(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Mi,$_f){try{$this->_link=new
MongoClient($Mi,$_f);if($_f["password"]!=""){$_f["password"]="";try{new
MongoClient($Mi,$_f);$this->error=lang(22);}catch(Exception$rc){}}}catch(Exception$rc){$this->error=$rc->getMessage();}}function
query($G){return
false;}function
select_db($j){try{$this->_db=$this->_link->selectDB($j);return
true;}catch(Exception$Hc){$this->error=$Hc->getMessage();return
false;}}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$fe){$J=array();foreach($fe
as$z=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$z]=63;$J[$z]=(is_a($X,'MongoId')?"ObjectId(\"$X\")":(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?"$X":(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$z=>$X){if(!isset($this->_rows[0][$z]))$this->_rows[0][$z]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$z=>$X)$I[$z]=$J[$z];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$je=array_keys($this->_rows[0]);$D=$je[$this->_offset++];return(object)array('name'=>$D,'charsetnr'=>$this->_charset[$D],);}}class
Min_Driver
extends
Min_SQL{public$ng="_id";function
select($Q,$L,$Z,$sd,$Bf=array(),$_=1,$E=0,$pg=false){$L=($L==array("*")?array():array_fill_keys($L,true));$xh=array();foreach($Bf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Ib);$xh[$X]=($Ib?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($Q)->find(array(),$L)->sort($xh)->limit($_!=""?+$_:0)->skip($E*$_));}function
insert($Q,$N){try{$I=$this->_conn->_db->selectCollection($Q)->insert($N);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$N['_id'];return!$I['err'];}catch(Exception$Hc){$this->_conn->error=$Hc->getMessage();return
false;}}}function
get_databases($fd){global$g;$I=array();$Wb=$g->_link->listDBs();foreach($Wb['databases']as$l)$I[]=$l['name'];return$I;}function
count_tables($k){global$g;$I=array();foreach($k
as$l)$I[$l]=count($g->_link->selectDB($l)->getCollectionNames(true));return$I;}function
tables_list(){global$g;return
array_fill_keys($g->_db->getCollectionNames(true),'table');}function
drop_databases($k){global$g;foreach($k
as$l){$Og=$g->_link->selectDB($l)->drop();if(!$Og['ok'])return
false;}return
true;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->_db->selectCollection($Q)->getIndexInfo()as$w){$ec=array();foreach($w["key"]as$d=>$T)$ec[]=($T==-1?'1':null);$I[$w["name"]]=array("type"=>($w["name"]=="_id_"?"PRIMARY":($w["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($w["key"]),"lengths"=>array(),"descs"=>$ec,);}return$I;}function
fields($Q){return
fields_from_edit();}function
found_rows($R,$Z){global$g;return$g->_db->selectCollection($_GET["select"])->count($Z);}$xf=array("=");}elseif(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$affected_rows,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Mi,$_f){$hb='MongoDB\Driver\Manager';$this->_link=new$hb($Mi,$_f);$this->executeCommand('admin',array('ping'=>1));}function
executeCommand($l,$rb){$hb='MongoDB\Driver\Command';try{return$this->_link->executeCommand($l,new$hb($rb));}catch(Exception$rc){$this->error=$rc->getMessage();return
array();}}function
executeBulkWrite($Ze,$Xa,$Jb){try{$Rg=$this->_link->executeBulkWrite($Ze,$Xa);$this->affected_rows=$Rg->$Jb();return
true;}catch(Exception$rc){$this->error=$rc->getMessage();return
false;}}function
query($G){return
false;}function
select_db($j){$this->_db_name=$j;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$fe){$J=array();foreach($fe
as$z=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$z]=63;$J[$z]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'."$X\")":(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->getData():(is_a($X,'MongoDB\BSON\Regex')?"$X":(is_object($X)||is_array($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$z=>$X){if(!isset($this->_rows[0][$z]))$this->_rows[0][$z]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$z=>$X)$I[$z]=$J[$z];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$je=array_keys($this->_rows[0]);$D=$je[$this->_offset++];return(object)array('name'=>$D,'charsetnr'=>$this->_charset[$D],);}}class
Min_Driver
extends
Min_SQL{public$ng="_id";function
select($Q,$L,$Z,$sd,$Bf=array(),$_=1,$E=0,$pg=false){global$g;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$xh=array();foreach($Bf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Ib);$xh[$X]=($Ib?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$_=$_GET['limit'];$_=min(200,max(1,(int)$_));$uh=$E*$_;$hb='MongoDB\Driver\Query';try{return
new
Min_Result($g->_link->executeQuery("$g->_db_name.$Q",new$hb($Z,array('projection'=>$L,'limit'=>$_,'skip'=>$uh,'sort'=>$xh))));}catch(Exception$rc){$g->error=$rc->getMessage();return
false;}}function
update($Q,$N,$zg,$_=0,$kh="\n"){global$g;$l=$g->_db_name;$Z=sql_query_where_parser($zg);$hb='MongoDB\Driver\BulkWrite';$Xa=new$hb(array());if(isset($N['_id']))unset($N['_id']);$Lg=array();foreach($N
as$z=>$Y){if($Y=='NULL'){$Lg[$z]=1;unset($N[$z]);}}$Li=array('$set'=>$N);if(count($Lg))$Li['$unset']=$Lg;$Xa->update($Z,$Li,array('upsert'=>false));return$g->executeBulkWrite("$l.$Q",$Xa,'getModifiedCount');}function
delete($Q,$zg,$_=0){global$g;$l=$g->_db_name;$Z=sql_query_where_parser($zg);$hb='MongoDB\Driver\BulkWrite';$Xa=new$hb(array());$Xa->delete($Z,array('limit'=>$_));return$g->executeBulkWrite("$l.$Q",$Xa,'getDeletedCount');}function
insert($Q,$N){global$g;$l=$g->_db_name;$hb='MongoDB\Driver\BulkWrite';$Xa=new$hb(array());if($N['_id']=='')unset($N['_id']);$Xa->insert($N);return$g->executeBulkWrite("$l.$Q",$Xa,'getInsertedCount');}}function
get_databases($fd){global$g;$I=array();foreach($g->executeCommand('admin',array('listDatabases'=>1))as$Wb){foreach($Wb->databases
as$l)$I[]=$l->name;}return$I;}function
count_tables($k){$I=array();return$I;}function
tables_list(){global$g;$ob=array();foreach($g->executeCommand($g->_db_name,array('listCollections'=>1))as$H)$ob[$H->name]='table';return$ob;}function
drop_databases($k){return
false;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->executeCommand($g->_db_name,array('listIndexes'=>$Q))as$w){$ec=array();$e=array();foreach(get_object_vars($w->key)as$d=>$T){$ec[]=($T==-1?'1':null);$e[]=$d;}$I[$w->name]=array("type"=>($w->name=="_id_"?"PRIMARY":(isset($w->unique)?"UNIQUE":"INDEX")),"columns"=>$e,"lengths"=>array(),"descs"=>$ec,);}return$I;}function
fields($Q){global$m;$p=fields_from_edit();if(!$p){$H=$m->select($Q,array("*"),null,null,array(),10);if($H){while($J=$H->fetch_assoc()){foreach($J
as$z=>$X){$J[$z]=null;$p[$z]=array("field"=>$z,"type"=>"string","null"=>($z!=$m->primary),"auto_increment"=>($z==$m->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}}return$p;}function
found_rows($R,$Z){global$g;$Z=where_to_query($Z);$pi=$g->executeCommand($g->_db_name,array('count'=>$R['Name'],'query'=>$Z))->toArray();return$pi[0]->n;}function
sql_query_where_parser($zg){$zg=preg_replace('~^\sWHERE \(?\(?(.+?)\)?\)?$~','\1',$zg);$lj=explode(' AND ',$zg);$mj=explode(') OR (',$zg);$Z=array();foreach($lj
as$jj)$Z[]=trim($jj);if(count($mj)==1)$mj=array();elseif(count($mj)>1)$Z=array();return
where_to_query($Z,$mj);}function
where_to_query($hj=array(),$ij=array()){global$b;$Rb=array();foreach(array('and'=>$hj,'or'=>$ij)as$T=>$Z){if(is_array($Z)){foreach($Z
as$Nc){list($kb,$vf,$X)=explode(" ",$Nc,3);if($kb=="_id"&&preg_match('~^(MongoDB\\\\BSON\\\\ObjectID)\("(.+)"\)$~',$X,$C)){list(,$hb,$X)=$C;$X=new$hb($X);}if(!in_array($vf,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$vf,$C)){$X=(float)$X;$vf=$C[1];}elseif(preg_match('~^\(date\)(.+)~',$vf,$C)){$Tb=new
DateTime($X);$hb='MongoDB\BSON\UTCDatetime';$X=new$hb($Tb->getTimestamp()*1000);$vf=$C[1];}switch($vf){case'=':$vf='$eq';break;case'!=':$vf='$ne';break;case'>':$vf='$gt';break;case'<':$vf='$lt';break;case'>=':$vf='$gte';break;case'<=':$vf='$lte';break;case'regex':$vf='$regex';break;default:continue
2;}if($T=='and')$Rb['$and'][]=array($kb=>array($vf=>$X));elseif($T=='or')$Rb['$or'][]=array($kb=>array($vf=>$X));}}}return$Rb;}$xf=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);}function
table($v){return$v;}function
idf_escape($v){return$v;}function
table_status($D="",$Uc=false){$I=array();foreach(tables_list()as$Q=>$T){$I[$Q]=array("Name"=>$Q);if($D==$Q)return$I[$Q];}return$I;}function
create_database($l,$mb){return
true;}function
last_id(){global$g;return$g->last_id;}function
error(){global$g;return
h($g->error);}function
collations(){return
array();}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();$_f=array();if($V.$F!=""){$_f["username"]=$V;$_f["password"]=$F;}$l=$b->database();if($l!="")$_f["db"]=$l;if(($Ka=getenv("MONGO_AUTH_SOURCE")))$_f["authSource"]=$Ka;$g->connect("mongodb://$M",$_f);if($g->error)return$g->error;return$g;}function
alter_indexes($Q,$c){global$g;foreach($c
as$X){list($T,$D,$N)=$X;if($N=="DROP")$I=$g->_db->command(array("deleteIndexes"=>$Q,"index"=>$D));else{$e=array();foreach($N
as$d){$d=preg_replace('~ DESC$~','',$d,1,$Ib);$e[$d]=($Ib?-1:1);}$I=$g->_db->selectCollection($Q)->ensureIndex($e,array("unique"=>($T=="UNIQUE"),"name"=>$D,));}if($I['errmsg']){$g->error=$I['errmsg'];return
false;}}return
true;}function
support($Vc){return
preg_match("~database|indexes|descidx~",$Vc);}function
db_collation($l,$nb){}function
information_schema(){}function
is_view($R){}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
foreign_keys($Q){return
array();}function
fk_support($R){}function
engines(){return
array();}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){global$g;if($Q==""){$g->_db->createCollection($D);return
true;}}function
drop_tables($S){global$g;foreach($S
as$Q){$Og=$g->_db->selectCollection($Q)->drop();if(!$Og['ok'])return
false;}return
true;}function
truncate_tables($S){global$g;foreach($S
as$Q){$Og=$g->_db->selectCollection($Q)->remove();if(!$Og['ok'])return
false;}return
true;}function
driver_config(){global$xf;return
array('possible_drivers'=>array("mongo","mongodb"),'jush'=>"mongo",'operators'=>$xf,'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),);}}$kc["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url,$_db;function
rootQuery($ag,$Db=array(),$Se='GET'){@ini_set('track_errors',1);$Zc=@file_get_contents("$this->_url/".ltrim($ag,'/'),false,stream_context_create(array('http'=>array('method'=>$Se,'content'=>$Db===null?$Db:json_encode($Db),'header'=>'Content-Type: application/json','ignore_errors'=>1,))));if(!$Zc){$this->error=$php_errormsg;return$Zc;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$I=json_decode($Zc,true);if($I===null){$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$Bb=get_defined_constants(true);foreach($Bb['json']as$D=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$D)){$this->error=$D;break;}}}}return$I;}function
query($ag,$Db=array(),$Se='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($ag,'/'),$Db,$Se);}function
connect($M,$V,$F){preg_match('~^(https?://)?(.*)~',$M,$C);$this->_url=($C[1]?$C[1]:"http://")."$V:$F@$C[2]";$I=$this->query('');if($I)$this->server_info=$I['version']['number'];return(bool)$I;}function
select_db($j){$this->_db=$j;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows;function
__construct($K){$this->num_rows=count($K);$this->_rows=$K;reset($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);next($this->_rows);return$I;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($Q,$L,$Z,$sd,$Bf=array(),$_=1,$E=0,$pg=false){global$b;$Rb=array();$G="$Q/_search";if($L!=array("*"))$Rb["fields"]=$L;if($Bf){$xh=array();foreach($Bf
as$kb){$kb=preg_replace('~ DESC$~','',$kb,1,$Ib);$xh[]=($Ib?array($kb=>"desc"):$kb);}$Rb["sort"]=$xh;}if($_){$Rb["size"]=+$_;if($E)$Rb["from"]=($E*$_);}foreach($Z
as$X){list($kb,$vf,$X)=explode(" ",$X,3);if($kb=="_id")$Rb["query"]["ids"]["values"][]=$X;elseif($kb.$X!=""){$ci=array("term"=>array(($kb!=""?$kb:"_all")=>$X));if($vf=="=")$Rb["query"]["filtered"]["filter"]["and"][]=$ci;else$Rb["query"]["filtered"]["query"]["bool"]["must"][]=$ci;}}if($Rb["query"]&&!$Rb["query"]["filtered"]["query"]&&!$Rb["query"]["ids"])$Rb["query"]["filtered"]["query"]=array("match_all"=>array());$Fh=microtime(true);$eh=$this->_conn->query($G,$Rb);if($pg)echo$b->selectQuery("$G: ".json_encode($Rb),$Fh,!$eh);if(!$eh)return
false;$I=array();foreach($eh['hits']['hits']as$Ed){$J=array();if($L==array("*"))$J["_id"]=$Ed["_id"];$p=$Ed['_source'];if($L!=array("*")){$p=array();foreach($L
as$z)$p[$z]=$Ed['fields'][$z];}foreach($p
as$z=>$X){if($Rb["fields"])$X=$X[0];$J[$z]=(is_array($X)?json_encode($X):$X);}$I[]=$J;}return
new
Min_Result($I);}function
update($T,$Cg,$zg,$_=0,$kh="\n"){$Yf=preg_split('~ *= *~',$zg);if(count($Yf)==2){$u=trim($Yf[1]);$G="$T/$u";return$this->_conn->query($G,$Cg,'POST');}return
false;}function
insert($T,$Cg){$u="";$G="$T/$u";$Og=$this->_conn->query($G,$Cg,'POST');$this->_conn->last_id=$Og['_id'];return$Og['created'];}function
delete($T,$zg,$_=0){$Id=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$Id[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$bb){$Yf=preg_split('~ *= *~',$bb);if(count($Yf)==2)$Id[]=trim($Yf[1]);}}$this->_conn->affected_rows=0;foreach($Id
as$u){$G="{$T}/{$u}";$Og=$this->_conn->query($G,'{}','DELETE');if(is_array($Og)&&$Og['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();if($F!=""&&$g->connect($M,$V,""))return
lang(22);if($g->connect($M,$V,$F))return$g;return$g->error;}function
support($Vc){return
preg_match("~database|table|columns~",$Vc);}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
get_databases(){global$g;$I=$g->rootQuery('_aliases');if($I){$I=array_keys($I);sort($I,SORT_STRING);}return$I;}function
collations(){return
array();}function
db_collation($l,$nb){}function
engines(){return
array();}function
count_tables($k){global$g;$I=array();$H=$g->query('_stats');if($H&&$H['indices']){$Qd=$H['indices'];foreach($Qd
as$Pd=>$Gh){$Od=$Gh['total']['indexing'];$I[$Pd]=$Od['index_total'];}}return$I;}function
tables_list(){global$g;if(min_version(6))return
array('_doc'=>'table');$I=$g->query('_mapping');if($I)$I=array_fill_keys(array_keys($I[$g->_db]["mappings"]),'table');return$I;}function
table_status($D="",$Uc=false){global$g;$eh=$g->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$I=array();if($eh){$S=$eh["aggregations"]["count_by_type"]["buckets"];foreach($S
as$Q){$I[$Q["key"]]=array("Name"=>$Q["key"],"Engine"=>"table","Rows"=>$Q["doc_count"],);if($D!=""&&$D==$Q["key"])return$I[$D];}}return$I;}function
error(){global$g;return
h($g->error);}function
information_schema(){}function
is_view($R){}function
indexes($Q,$h=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($Q){global$g;$Be=array();if(min_version(6)){$H=$g->query("_mapping");if($H)$Be=$H[$g->_db]['mappings']['properties'];}else{$H=$g->query("$Q/_mapping");if($H){$Be=$H[$Q]['properties'];if(!$Be)$Be=$H[$g->_db]['mappings'][$Q]['properties'];}}$I=array();if($Be){foreach($Be
as$D=>$o){$I[$D]=array("field"=>$D,"full_type"=>$o["type"],"type"=>$o["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($o["properties"]){unset($I[$D]["privileges"]["insert"]);unset($I[$D]["privileges"]["update"]);}}}return$I;}function
foreign_keys($Q){return
array();}function
table($v){return$v;}function
idf_escape($v){return$v;}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
fk_support($R){}function
found_rows($R,$Z){return
null;}function
create_database($l){global$g;return$g->rootQuery(urlencode($l),null,'PUT');}function
drop_databases($k){global$g;return$g->rootQuery(urlencode(implode(',',$k)),array(),'DELETE');}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){global$g;$vg=array();foreach($p
as$Sc){$Xc=trim($Sc[1][0]);$Yc=trim($Sc[1][1]?$Sc[1][1]:"text");$vg[$Xc]=array('type'=>$Yc);}if(!empty($vg))$vg=array('properties'=>$vg);return$g->query("_mapping/{$D}",$vg,'PUT');}function
drop_tables($S){global$g;$I=true;foreach($S
as$Q)$I=$I&&$g->query(urlencode($Q),array(),'DELETE');return$I;}function
last_id(){global$g;return$g->last_id;}function
driver_config(){$U=array();$Jh=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$z=>$X){$U+=$X;$Jh[$z]=array_keys($X);}return
array('possible_drivers'=>array("json + allow_url_fopen"),'jush'=>"elastic",'operators'=>array("=","query"),'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),'types'=>$U,'structured_types'=>$Jh,);}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($M){return
h($M);}function
database(){return
DB;}function
databases($fd=true){return
get_databases($fd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$q="adminer.css";if(file_exists($q))$I[]="$q?v=".crc32(file_get_contents($q));return$I;}function
loginForm(){global$kc;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(33).'<td>',html_select("auth[driver]",$kc,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(34).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(35).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(36).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(37).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(38)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(39))."\n";}function
loginFormField($D,$Bd,$Y){return$Bd.$Y;}function
login($_e,$F){if($F=="")return
lang(40,target_blank());return
true;}function
tableName($Qh){return
h($Qh["Name"]);}function
fieldName($o,$Bf=0){return'<span title="'.h($o["full_type"]).'">'.h($o["field"]).'</span>';}function
selectLinks($Qh,$N=""){global$y,$m;echo'<p class="links">';$ze=array("select"=>lang(41));if(support("table")||support("indexes"))$ze["table"]=lang(42);if(support("table")){if(is_view($Qh))$ze["view"]=lang(43);else$ze["create"]=lang(44);}if($N!==null)$ze["edit"]=lang(45);$D=$Qh["Name"];foreach($ze
as$z=>$X)echo" <a href='".h(ME)."$z=".urlencode($D).($z=="edit"?$N:"")."'".bold(isset($_GET[$z])).">$X</a>";echo
doc_link(array($y=>$m->tableHelp($D)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$Ph){return
array();}function
backwardKeysPrint($Oa,$J){}function
selectQuery($G,$Fh,$Tc=false){global$y,$m;$I="</p>\n";if(!$Tc&&($ej=$m->warnings())){$u="warnings";$I=", <a href='#$u'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$I<div id='$u' class='hidden'>\n$ej</div>\n";}return"<p><code class='jush-$y'>".h(str_replace("\n"," ",$G))."</code> <span class='time'>(".format_time($Fh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($G)."'>".lang(10)."</a>":"").$I;}function
sqlCommandQuery($G){return
shorten_utf8(trim($G),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($K,$id){return$K;}function
selectLink($X,$o){}function
selectVal($X,$A,$o,$Jf){$I=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$o["type"])&&!preg_match("~var~",$o["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$o["type"])&&!is_utf8($X))$I="<i>".lang(47,strlen($Jf))."</i>";if(preg_match('~json~',$o["type"]))$I="<code class='jush-js'>$I</code>";return($A?"<a href='".h($A)."'".(is_url($A)?target_blank():"").">$I</a>":$I);}function
editVal($X,$o){return$X;}function
tableStructurePrint($p){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(48)."<td>".lang(49).(support("comment")?"<td>".lang(50):"")."</thead>\n";foreach($p
as$o){echo"<tr".odd()."><th>".h($o["field"]),"<td><span title='".h($o["collation"])."'>".h($o["full_type"])."</span>",($o["null"]?" <i>NULL</i>":""),($o["auto_increment"]?" <i>".lang(51)."</i>":""),(isset($o["default"])?" <span title='".lang(52)."'>[<b>".h($o["default"])."</b>]</span>":""),(support("comment")?"<td>".h($o["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($x){echo"<table cellspacing='0'>\n";foreach($x
as$D=>$w){ksort($w["columns"]);$pg=array();foreach($w["columns"]as$z=>$X)$pg[]="<i>".h($X)."</i>".($w["lengths"][$z]?"(".$w["lengths"][$z].")":"").($w["descs"][$z]?" DESC":"");echo"<tr title='".h($D)."'><th>$w[type]<td>".implode(", ",$pg)."\n";}echo"</table>\n";}function
selectColumnsPrint($L,$e){global$pd,$vd;print_fieldset("select",lang(53),$L);$t=0;$L[""]=array();foreach($L
as$z=>$X){$X=$_GET["columns"][$z];$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($z!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($pd||$vd?"<select name='columns[$t][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(54)=>$pd,lang(55)=>$vd)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($z!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$x){print_fieldset("search",lang(56),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}}$Za="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(57).")"),html_select("where[$t][op]",$this->operators,$X["op"],$Za),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Za }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($Bf,$e,$x){print_fieldset("sort",lang(58),$Bf);$t=0;foreach((array)$_GET["order"]as$z=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$z]),lang(59))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(59))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($_){echo"<fieldset><legend>".lang(60)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($_)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($fi){if($fi!==null){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($fi)."'>","</div></fieldset>\n";}}function
selectActionPrint($x){echo"<fieldset><legend>".lang(62)."</legend><div>","<input type='submit' value='".lang(53)."'>"," <span id='noindex' title='".lang(63)."'></span>","<script".nonce().">\n","var indexColumns = ";$e=array();foreach($x
as$w){$Qb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Qb)$e[$Qb]=1;}$e[""]=1;foreach($e
as$z=>$X)json_row($z);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($xc,$e){}function
selectColumnsProcess($e,$x){global$pd,$vd;$L=array();$sd=array();foreach((array)$_GET["columns"]as$z=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$pd)||in_array($X["fun"],$vd)))){$L[$z]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$vd))$sd[]=$L[$z];}}return
array($L,$sd);}function
selectSearchProcess($p,$x){global$g,$m;$I=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$I[]="MATCH (".implode(", ",array_map('idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$z=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$lg="";$wb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Ld=process_length($X["val"]);$wb.=" ".($Ld!=""?$Ld:"(NULL)");}elseif($X["op"]=="SQL")$wb=" $X[val]";elseif($X["op"]=="LIKE %%")$wb=" LIKE ".$this->processInput($p[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$wb=" ILIKE ".$this->processInput($p[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$lg="$X[op](".q($X["val"]).", ";$wb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$wb.=" ".$this->processInput($p[$X["col"]],$X["val"]);if($X["col"]!="")$I[]=$lg.$m->convertSearch(idf_escape($X["col"]),$X,$p[$X["col"]]).$wb;else{$pb=array();foreach($p
as$D=>$o){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$o["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$o["type"]))&&(!preg_match('~date|timestamp~',$o["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$pb[]=$lg.$m->convertSearch(idf_escape($D),$X,$o).$wb;}$I[]=($pb?"(".implode(" OR ",$pb).")":"1 = 0");}}}return$I;}function
selectOrderProcess($p,$x){$I=array();foreach((array)$_GET["order"]as$z=>$X){if($X!="")$I[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$z])?" DESC":"");}return$I;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$id){return
false;}function
selectQueryBuild($L,$Z,$sd,$Bf,$_,$E){return"";}function
messageQuery($G,$gi,$Tc=false){global$y,$m;restart_session();$Cd=&get_session("queries");if(!$Cd[$_GET["db"]])$Cd[$_GET["db"]]=array();if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n…";$Cd[$_GET["db"]][]=array($G,time(),$gi);$Ch="sql-".count($Cd[$_GET["db"]]);$I="<a href='#$Ch' class='toggle'>".lang(64)."</a>\n";if(!$Tc&&($ej=$m->warnings())){$u="warnings-".count($Cd[$_GET["db"]]);$I="<a href='#$u' class='toggle'>".lang(46)."</a>, $I<div id='$u' class='hidden'>\n$ej</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $I<div id='$Ch' class='hidden'><pre><code class='jush-$y'>".shorten_utf8($G,1000)."</code></pre>".($gi?" <span class='time'>($gi)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Cd[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($Q,$p,$J,$Li){}function
editFunctions($o){global$sc;$I=($o["null"]?"NULL/":"");$Li=isset($_GET["select"])||where($_GET);foreach($sc
as$z=>$pd){if(!$z||(!isset($_GET["call"])&&$Li)){foreach($pd
as$cg=>$X){if(!$cg||preg_match("~$cg~",$o["type"]))$I.="/$X";}}if($z&&!preg_match('~set|blob|bytea|raw|file|bool~',$o["type"]))$I.="/SQL";}if($o["auto_increment"]&&!$Li)$I=lang(51);return
explode("/",$I);}function
editInput($Q,$o,$Ia,$Y){if($o["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Ia value='-1' checked><i>".lang(8)."</i></label> ":"").($o["null"]?"<label><input type='radio'$Ia value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$Ia,$o,$Y,0);return"";}function
editHint($Q,$o,$Y){return"";}function
processInput($o,$Y,$s=""){if($s=="SQL")return$Y;$D=$o["field"];$I=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$I="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$I=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$I=idf_escape($D)." $s $I";elseif(preg_match('~^[+-] interval$~',$s))$I=idf_escape($D)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$I);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$I="$s(".idf_escape($D).", $I)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$I="$s($I)";return
unconvert_field($o,$I);}function
dumpOutput(){$I=array('text'=>lang(65),'file'=>lang(66));if(function_exists('gzencode'))$I['gz']='gzip';return$I;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($l){}function
dumpTable($Q,$Kh,$ee=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Kh)dump_csv(array_keys(fields($Q)));}else{if($ee==2){$p=array();foreach(fields($Q)as$D=>$o)$p[]=idf_escape($D)." $o[full_type]";$i="CREATE TABLE ".table($Q)." (".implode(", ",$p).")";}else$i=create_sql($Q,$_POST["auto_increment"],$Kh);set_utf8mb4($i);if($Kh&&$i){if($Kh=="DROP+CREATE"||$ee==1)echo"DROP ".($ee==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($ee==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($Q,$Kh,$G){global$g,$y;$He=($y=="sqlite"?0:1048576);if($Kh){if($_POST["format"]=="sql"){if($Kh=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$p=fields($Q);}$H=$g->query($G,1);if($H){$Xd="";$Wa="";$je=array();$Mh="";$Wc=($Q!=''?'fetch_assoc':'fetch_row');while($J=$H->$Wc()){if(!$je){$Wi=array();foreach($J
as$X){$o=$H->fetch_field();$je[]=$o->name;$z=idf_escape($o->name);$Wi[]="$z = VALUES($z)";}$Mh=($Kh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Wi):"").";\n";}if($_POST["format"]!="sql"){if($Kh=="table"){dump_csv($je);$Kh="INSERT";}dump_csv($J);}else{if(!$Xd)$Xd="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$je)).") VALUES";foreach($J
as$z=>$X){$o=$p[$z];$J[$z]=($X!==null?unconvert_field($o,preg_match(number_type(),$o["type"])&&!preg_match('~\[~',$o["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$ah=($He?"\n":" ")."(".implode(",\t",$J).")";if(!$Wa)$Wa=$Xd.$ah;elseif(strlen($Wa)+4+strlen($ah)+strlen($Mh)<$He)$Wa.=",$ah";else{echo$Wa.$Mh;$Wa=$Xd.$ah;}}}if($Wa)echo$Wa.$Mh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$g->error)."\n";}}function
dumpFilename($Hd){return
friendly_url($Hd!=""?$Hd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Hd,$Ve=false){$Mf=$_POST["output"];$Oc=(preg_match('~sql~',$_POST["format"])?"sql":($Ve?"tar":"csv"));header("Content-Type: ".($Mf=="gz"?"application/x-gzip":($Oc=="tar"?"application/x-tar":($Oc=="sql"||$Mf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Mf=="gz")ob_start('ob_gzencode',1e6);return$Oc;}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(67)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(68):lang(69))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(70)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(71)."</a>\n":"");return
true;}function
navigation($Ue){global$ia,$y,$kc,$g;echo'<h1>
',$this->name(),' <span class="version">',$ia,'</span>
<a href="https://www.adminer.org/#download"',target_blank(),' id="version">',(version_compare($ia,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($Ue=="auth"){$Mf="";foreach((array)$_SESSION["pwds"]as$Yi=>$oh){foreach($oh
as$M=>$Ti){foreach($Ti
as$V=>$F){if($F!==null){$Wb=$_SESSION["db"][$Yi][$M][$V];foreach(($Wb?array_keys($Wb):array(""))as$l)$Mf.="<li><a href='".h(auth_url($Yi,$M,$V,$l))."'>($kc[$Yi]) ".h($V.($M!=""?"@".$this->serverName($M):"").($l!=""?" - $l":""))."</a>\n";}}}}if($Mf)echo"<ul id='logins'>\n$Mf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$S=array();if($_GET["ns"]!==""&&!$Ue&&DB!=""){$g->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.8.1");if(support("sql")){echo'<script',nonce(),'>
';if($S){$ze=array();foreach($S
as$Q=>$T)$ze[]=preg_quote($Q,'/');echo"var jushLinks = { $y: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$ze).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$y;\n";}$nh=$g->server_info;echo'bodyLoad(\'',(is_object($g)?preg_replace('~^(\d\.?\d).*~s','\1',$nh):""),'\'',(preg_match('~MariaDB~',$nh)?", true":""),');
</script>
';}$this->databasesPrint($Ue);if(DB==""||!$Ue){echo"<p class='links'>".(support("sql")?"<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(64)."</a>\n<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(72)."</a>\n":"")."";if(support("dump"))echo"<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(73)."</a>\n";}if($_GET["ns"]!==""&&!$Ue&&DB!=""){echo'<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(74)."</a>\n";if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($Ue){global$b,$g;$k=$this->databases();if(DB&&$k&&!in_array(DB,$k))array_unshift($k,DB);echo'<form action="">
<p id="dbs">
';hidden_fields_get();$Ub=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(75)."'>".lang(76)."</span>: ".($k?"<select name='db'>".optionlist(array(""=>"")+$k,DB)."</select>$Ub":"<input name='db' value='".h(DB)."' autocapitalize='off'>\n"),"<input type='submit' value='".lang(20)."'".($k?" class='hidden'":"").">\n";if(support("scheme")){if($Ue!="db"&&DB!=""&&$g->select_db(DB)){echo"<br>".lang(77).": <select name='ns'>".optionlist(array(""=>"")+$b->schemas(),$_GET["ns"])."</select>$Ub";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}echo"</p></form>\n";}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$O){$D=$this->tableName($O);if($D!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(41)."'>".lang(78)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($O)?"view":"structure"))." title='".lang(42)."'>$D</a>":"<span>$D</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$kc=array("server"=>"MySQL")+$kc;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($M="",$V="",$F="",$j=null,$gg=null,$wh=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Fd,$gg)=explode(":",$M,2);$Eh=$b->connectSsl();if($Eh)$this->ssl_set($Eh['key'],$Eh['cert'],$Eh['ca'],'','');$I=@$this->real_connect(($M!=""?$Fd:ini_get("mysqli.default_host")),($M.$V!=""?$V:ini_get("mysqli.default_user")),($M.$V.$F!=""?$F:ini_get("mysqli.default_pw")),$j,(is_numeric($gg)?$gg:ini_get("mysqli.default_port")),(!is_numeric($gg)?$gg:$wh),($Eh?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($ab){if(parent::set_charset($ab))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $ab");}function
result($G,$o=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch_array();return$J[$o];}function
quote($P){return"'".$this->escape_string($P)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($M,$V,$F){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(79,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($M!=""?$M:ini_get("mysql.default_host")),("$M$V"!=""?$V:ini_get("mysql.default_user")),("$M$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($ab){if(function_exists('mysql_set_charset')){if(mysql_set_charset($ab,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $ab");}function
quote($P){return"'".mysql_real_escape_string($P,$this->_link)."'";}function
select_db($j){return
mysql_select_db($j,$this->_link);}function
query($G,$Ei=false){$H=@($Ei?mysql_unbuffered_query($G,$this->_link):mysql_query($G,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$o);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($M,$V,$F){global$b;$_f=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Eh=$b->connectSsl();if($Eh){if(!empty($Eh['key']))$_f[PDO::MYSQL_ATTR_SSL_KEY]=$Eh['key'];if(!empty($Eh['cert']))$_f[PDO::MYSQL_ATTR_SSL_CERT]=$Eh['cert'];if(!empty($Eh['ca']))$_f[PDO::MYSQL_ATTR_SSL_CA]=$Eh['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F,$_f);return
true;}function
set_charset($ab){$this->query("SET NAMES $ab");}function
select_db($j){return$this->query("USE ".idf_escape($j));}function
query($G,$Ei=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Ei);return
parent::query($G,$Ei);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$N){return($N?parent::insert($Q,$N):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$K,$ng){$e=array_keys(reset($K));$lg="INSERT INTO ".table($Q)." (".implode(", ",$e).") VALUES\n";$Wi=array();foreach($e
as$z)$Wi[$z]="$z = VALUES($z)";$Mh="\nON DUPLICATE KEY UPDATE ".implode(", ",$Wi);$Wi=array();$we=0;foreach($K
as$N){$Y="(".implode(", ",$N).")";if($Wi&&(strlen($lg)+$we+strlen($Y)+strlen($Mh)>1e6)){if(!queries($lg.implode(",\n",$Wi).$Mh))return
false;$Wi=array();$we=0;}$Wi[]=$Y;$we+=strlen($Y)+2;}return
queries($lg.implode(",\n",$Wi).$Mh);}function
slowQuery($G,$hi){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$hi FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$C))return"$C[1] /*+ MAX_EXECUTION_TIME(".($hi*1000).") */ $C[2]";}}function
convertSearch($v,$X,$o){return(preg_match('~char|text|enum|set~',$o["type"])&&!preg_match("~^utf8~",$o["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->_conn).")":$v);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($D){$Ce=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Ce?"information-schema-$D-table/":str_replace("_","-",$D)."-table.html"));if(DB=="mysql")return($Ce?"mysql$D-table/":"system-database.html");}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
connect(){global$b,$U,$Jh;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2])){$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$g)){$Jh[lang(25)][]="json";$U["json"]=4294967295;}return$g;}$I=$g->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($ah=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$ah;return$I;}function
get_databases($fd){$I=get_session("dbs");if($I===null){$G=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($fd?slow_query($G):get_vals($G));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($G,$Z,$_,$kf=0,$kh=" "){return" $G$Z".($_!==null?$kh."LIMIT $_".($kf?" OFFSET $kf":""):"");}function
limit1($Q,$G,$Z,$kh="\n"){return
limit($G,$Z,1,0,$kh);}function
db_collation($l,$nb){global$g;$I=null;$i=$g->result("SHOW CREATE DATABASE ".idf_escape($l),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$C))$I=$C[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$C))$I=$nb[$C[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$g;return$g->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($k){$I=array();foreach($k
as$l)$I[$l]=count(get_vals("SHOW TABLES IN ".idf_escape($l)));return$I;}function
table_status($D="",$Uc=false){$I=array();foreach(get_rows($Uc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($D!=""?"AND TABLE_NAME = ".q($D):"ORDER BY Name"):"SHOW TABLE STATUS".($D!=""?" LIKE ".q(addcslashes($D,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($D!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$C);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$C[1],"length"=>$C[2],"unsigned"=>ltrim($C[3].$C[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$C[1])?(preg_match('~text~',$C[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$J["Default"])):$J["Default"]):null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$C)?$C[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$J["Extra"]),);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$h)as$J){$D=$J["Key_name"];$I[$D]["type"]=($D=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$D]["columns"][]=$J["Column_name"];$I[$D]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$D]["descs"][]=null;}return$I;}function
foreign_keys($Q){global$g,$sf;static$cg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$I=array();$Kb=$g->result("SHOW CREATE TABLE ".table($Q),1);if($Kb){preg_match_all("~CONSTRAINT ($cg) FOREIGN KEY ?\\(((?:$cg,? ?)+)\\) REFERENCES ($cg)(?:\\.($cg))? \\(((?:$cg,? ?)+)\\)(?: ON DELETE ($sf))?(?: ON UPDATE ($sf))?~",$Kb,$Fe,PREG_SET_ORDER);foreach($Fe
as$C){preg_match_all("~$cg~",$C[2],$yh);preg_match_all("~$cg~",$C[5],$Zh);$I[idf_unescape($C[1])]=array("db"=>idf_unescape($C[4]!=""?$C[3]:$C[4]),"table"=>idf_unescape($C[4]!=""?$C[4]:$C[3]),"source"=>array_map('idf_unescape',$yh[0]),"target"=>array_map('idf_unescape',$Zh[0]),"on_delete"=>($C[6]?$C[6]:"RESTRICT"),"on_update"=>($C[7]?$C[7]:"RESTRICT"),);}}return$I;}function
adminer_view($D){global$g;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$g->result("SHOW CREATE VIEW ".table($D),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$z=>$X)asort($I[$z]);return$I;}function
information_schema($l){return(min_version(5)&&$l=="information_schema")||(min_version(5.5)&&$l=="performance_schema");}function
error(){global$g;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$g->error));}function
create_database($l,$mb){return
queries("CREATE DATABASE ".idf_escape($l).($mb?" COLLATE ".q($mb):""));}function
drop_databases($k){$I=apply_queries("DROP DATABASE",$k,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($D,$mb){$I=false;if(create_database($D,$mb)){$S=array();$bj=array();foreach(tables_list()as$Q=>$T){if($T=='VIEW')$bj[]=$Q;else$S[]=$Q;}$I=(!$S&&!$bj)||move_tables($S,$bj,$D);drop_databases($I?array(DB):array());}return$I;}function
auto_increment(){$Ma=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ma="";break;}if($w["type"]=="PRIMARY")$Ma=" UNIQUE";}}return" AUTO_INCREMENT$Ma";}function
alter_table($Q,$D,$p,$hd,$tb,$_c,$mb,$La,$Wf){$c=array();foreach($p
as$o)$c[]=($o[1]?($Q!=""?($o[0]!=""?"CHANGE ".idf_escape($o[0]):"ADD"):" ")." ".implode($o[1]).($Q!=""?$o[2]:""):"DROP ".idf_escape($o[0]));$c=array_merge($c,$hd);$O=($tb!==null?" COMMENT=".q($tb):"").($_c?" ENGINE=".q($_c):"").($mb?" COLLATE ".q($mb):"").($La!=""?" AUTO_INCREMENT=$La":"");if($Q=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)$O$Wf");if($Q!=$D)$c[]="RENAME TO ".table($D);if($O)$c[]=ltrim($O);return($c||$Wf?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$c).$Wf):true);}function
alter_indexes($Q,$c){foreach($c
as$z=>$X)$c[$z]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$c));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($bj){return
queries("DROP VIEW ".implode(", ",array_map('table',$bj)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$bj,$Zh){global$g;$Mg=array();foreach($S
as$Q)$Mg[]=table($Q)." TO ".idf_escape($Zh).".".table($Q);if(!$Mg||queries("RENAME TABLE ".implode(", ",$Mg))){$bc=array();foreach($bj
as$Q)$bc[table($Q)]=adminer_view($Q);$g->select_db($Zh);$l=idf_escape(DB);foreach($bc
as$D=>$aj){if(!queries("CREATE VIEW $D AS ".str_replace(" $l."," ",$aj["select"]))||!queries("DROP VIEW $l.$D"))return
false;}return
true;}return
false;}function
copy_tables($S,$bj,$Zh){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$D=($Zh==DB?table("copy_$Q"):idf_escape($Zh).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $D"))||!queries("CREATE TABLE $D LIKE ".table($Q))||!queries("INSERT INTO $D SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J){$zi=$J["Trigger"];if(!queries("CREATE TRIGGER ".($Zh==DB?idf_escape("copy_$zi"):idf_escape($Zh).".".idf_escape($zi))." $J[Timing] $J[Event] ON $D FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($bj
as$Q){$D=($Zh==DB?table("copy_$Q"):idf_escape($Zh).".".table($Q));$aj=adminer_view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $D"))||!queries("CREATE VIEW $D AS $aj[select]"))return
false;}return
true;}function
trigger($D){if($D=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($D));return
reset($K);}function
triggers($Q){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($D,$T){global$g,$Bc,$Vd,$U;$Ca=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$zh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Di="((".implode("|",array_merge(array_keys($U),$Ca)).")\\b(?:\\s*\\(((?:[^'\")]|$Bc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$cg="$zh*(".($T=="FUNCTION"?"":$Vd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Di";$i=$g->result("SHOW CREATE $T ".idf_escape($D),2);preg_match("~\\(((?:$cg\\s*,?)*)\\)\\s*".($T=="FUNCTION"?"RETURNS\\s+$Di\\s+":"")."(.*)~is",$i,$C);$p=array();preg_match_all("~$cg\\s*,?~is",$C[1],$Fe,PREG_SET_ORDER);foreach($Fe
as$Qf)$p[]=array("field"=>str_replace("``","`",$Qf[2]).$Qf[3],"type"=>strtolower($Qf[5]),"length"=>preg_replace_callback("~$Bc~s",'normalize_enum',$Qf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Qf[8] $Qf[7]"))),"null"=>1,"full_type"=>$Qf[4],"inout"=>strtoupper($Qf[1]),"collation"=>strtolower($Qf[9]),);if($T!="FUNCTION")return
array("fields"=>$p,"definition"=>$C[11]);return
array("fields"=>$p,"returns"=>array("type"=>$C[12],"length"=>$C[13],"unsigned"=>$C[15],"collation"=>$C[16]),"definition"=>$C[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($D,$J){return
idf_escape($D);}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ID()");}function
explain($g,$G){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$G);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($ch,$h=null){return
true;}function
create_sql($Q,$La,$Kh){global$g;$I=$g->result("SHOW CREATE TABLE ".table($Q),1);if(!$La)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($j){return"USE ".idf_escape($j);}function
trigger_sql($Q){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($o){if(preg_match("~binary~",$o["type"]))return"HEX(".idf_escape($o["field"]).")";if($o["type"]=="bit")return"BIN(".idf_escape($o["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$o["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($o["field"]).")";}function
unconvert_field($o,$I){if(preg_match("~binary~",$o["type"]))$I="UNHEX($I)";if($o["type"]=="bit")$I="CONV($I, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$o["type"]))$I=(min_version(8)?"ST_":"")."GeomFromText($I, SRID($o[field]))";return$I;}function
support($Vc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$Vc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$g;return$g->result("SELECT @@max_connections");}function
driver_config(){$U=array();$Jh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(80)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$z=>$X){$U+=$X;$Jh[$z]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$U,'structured_types'=>$Jh,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$xb=driver_config();$kg=$xb['possible_drivers'];$y=$xb['jush'];$U=$xb['types'];$Jh=$xb['structured_types'];$Ki=$xb['unsigned'];$xf=$xb['operators'];$pd=$xb['functions'];$vd=$xb['grouping'];$sc=$xb['edit_functions'];if($b->operators===null)$b->operators=$xf;define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ia="4.8.1";function
page_header($ji,$n="",$Va=array(),$ki=""){global$ca,$ia,$b,$kc,$y;page_headers();if(is_ajax()&&$n){page_messages($n);exit;}$li=$ji.($ki!=""?": $ki":"");$mi=strip_tags($li.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$mi,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.1"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.1");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.1"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.1"),'">
';foreach($b->css()as$Ob){echo'<link rel="stylesheet" type="text/css" href="',h($Ob),'">
';}}echo'
<body class="',lang(81),' nojs">
';$q=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($q)&&filemtime($q)+86400>time()){$Zi=unserialize(file_get_contents($q));$wg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Zi["version"],base64_decode($Zi["signature"]),$wg)==1)$_COOKIE["adminer_version"]=$Zi["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(82)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$y,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Va!==null){$A=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($A?$A:".").'">'.$kc[DRIVER].'</a> &raquo; ';$A=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$M=$b->serverName(SERVER);$M=($M!=""?$M:lang(34));if($Va===false)echo"$M\n";else{echo"<a href='".h($A)."' accesskey='1' title='Alt+Shift+1'>$M</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Va)))echo'<a href="'.h($A."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Va)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Va
as$z=>$X){$dc=(is_array($X)?$X[1]:h($X));if($dc!="")echo"<a href='".h(ME."$z=").urlencode(is_array($X)?$X[0]:$X)."'>$dc</a> &raquo; ";}}echo"$ji\n";}}echo"<h2>$li</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($n);$k=&get_session("dbs");if(DB!=""&&$k&&!in_array(DB,$k,true))$k=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Nb){$Ad=array();foreach($Nb
as$z=>$X)$Ad[]="$z $X";header("Content-Security-Policy: ".implode("; ",$Ad));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$ef;if(!$ef)$ef=base64_encode(rand_string());return$ef;}function
page_messages($n){$Mi=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Re=$_SESSION["messages"][$Mi];if($Re){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Re)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Mi]);}if($n)echo"<div class='error'>$n</div>\n";}function
page_footer($Ue=""){global$b,$qi;echo'</div>

';switch_lang();if($Ue!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(83),'" id="logout">
<input type="hidden" name="token" value="',$qi,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($Ue);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($Xe){while($Xe>=2147483648)$Xe-=4294967296;while($Xe<=-2147483649)$Xe+=4294967296;return(int)$Xe;}function
long2str($W,$dj){$ah='';foreach($W
as$X)$ah.=pack('V',$X);if($dj)return
substr($ah,0,end($W));return$ah;}function
str2long($ah,$dj){$W=array_values(unpack('V*',str_pad($ah,4*ceil(strlen($ah)/4),"\0")));if($dj)$W[]=strlen($ah);return$W;}function
xxtea_mx($pj,$oj,$Nh,$he){return
int32((($pj>>5&0x7FFFFFF)^$oj<<2)+(($oj>>3&0x1FFFFFFF)^$pj<<4))^int32(($Nh^$oj)+($he^$pj));}function
encrypt_string($Ih,$z){if($Ih=="")return"";$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($Ih,true);$Xe=count($W)-1;$pj=$W[$Xe];$oj=$W[0];$xg=floor(6+52/($Xe+1));$Nh=0;while($xg-->0){$Nh=int32($Nh+0x9E3779B9);$rc=$Nh>>2&3;for($Of=0;$Of<$Xe;$Of++){$oj=$W[$Of+1];$We=xxtea_mx($pj,$oj,$Nh,$z[$Of&3^$rc]);$pj=int32($W[$Of]+$We);$W[$Of]=$pj;}$oj=$W[0];$We=xxtea_mx($pj,$oj,$Nh,$z[$Of&3^$rc]);$pj=int32($W[$Xe]+$We);$W[$Xe]=$pj;}return
long2str($W,false);}function
decrypt_string($Ih,$z){if($Ih=="")return"";if(!$z)return
false;$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($Ih,false);$Xe=count($W)-1;$pj=$W[$Xe];$oj=$W[0];$xg=floor(6+52/($Xe+1));$Nh=int32($xg*0x9E3779B9);while($Nh){$rc=$Nh>>2&3;for($Of=$Xe;$Of>0;$Of--){$pj=$W[$Of-1];$We=xxtea_mx($pj,$oj,$Nh,$z[$Of&3^$rc]);$oj=int32($W[$Of]-$We);$W[$Of]=$oj;}$pj=$W[$Xe];$We=xxtea_mx($pj,$oj,$Nh,$z[$Of&3^$rc]);$oj=int32($W[0]-$We);$W[0]=$oj;$Nh=int32($Nh-0x9E3779B9);}return
long2str($W,true);}$g='';$_d=$_SESSION["token"];if(!$_d)$_SESSION["token"]=rand(1,1e6);$qi=get_token();$eg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($z)=explode(":",$X);$eg[$z]=$X;}}function
add_invalid_login(){global$b;$nd=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$nd)return;$ae=unserialize(stream_get_contents($nd));$gi=time();if($ae){foreach($ae
as$be=>$X){if($X[0]<$gi)unset($ae[$be]);}}$Zd=&$ae[$b->bruteForceKey()];if(!$Zd)$Zd=array($gi+30*60,0);$Zd[1]++;file_write_unlock($nd,serialize($ae));}function
check_invalid_login(){global$b;$ae=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$Zd=($ae?$ae[$b->bruteForceKey()]:array());$df=($Zd[1]>29?$Zd[0]-time():0);if($df>0)auth_error(lang(84,ceil($df/60)));}$Ja=$_POST["auth"];if($Ja){session_regenerate_id();$Yi=$Ja["driver"];$M=$Ja["server"];$V=$Ja["username"];$F=(string)$Ja["password"];$l=$Ja["db"];set_password($Yi,$M,$V,$F);$_SESSION["db"][$Yi][$M][$V][$l]=true;if($Ja["permanent"]){$z=base64_encode($Yi)."-".base64_encode($M)."-".base64_encode($V)."-".base64_encode($l);$qg=$b->permanentLogin(true);$eg[$z]="$z:".base64_encode($qg?encrypt_string($F,$qg):"");adminer_cookie("adminer_permanent",implode(" ",$eg));}if(count($_POST)==1||DRIVER!=$Yi||SERVER!=$M||$_GET["username"]!==$V||DB!=$l)adminer_redirect(auth_url($Yi,$M,$V,$l));}elseif($_POST["logout"]&&(!$_d||verify_token())){foreach(array("pwds","db","dbs","queries")as$z)set_session($z,null);unset_permanent();adminer_redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($eg&&!$_SESSION["pwds"]){session_regenerate_id();$qg=$b->permanentLogin();foreach($eg
as$z=>$X){list(,$gb)=explode(":",$X);list($Yi,$M,$V,$l)=array_map('base64_decode',explode("-",$z));set_password($Yi,$M,$V,decrypt_string(base64_decode($gb),$qg));$_SESSION["db"][$Yi][$M][$V][$l]=true;}}function
unset_permanent(){global$eg;foreach($eg
as$z=>$X){list($Yi,$M,$V,$l)=array_map('base64_decode',explode("-",$z));if($Yi==DRIVER&&$M==SERVER&&$V==$_GET["username"]&&$l==DB)unset($eg[$z]);}adminer_cookie("adminer_permanent",implode(" ",$eg));}function
auth_error($n){global$b,$_d;$ph=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$ph]||$_GET[$ph])&&!$_d)$n=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$n.=($n?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$ph]&&$_GET[$ph]&&ini_bool("session.use_only_cookies"))$n=lang(89);$Rf=session_get_cookie_params();adminer_cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Rf["lifetime"]);page_header(lang(38),$n,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(91),lang(92,implode(", ",$kg)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Fd,$gg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$gg,$C)&&($C[1]<1024||$C[1]>65535))auth_error(lang(93));check_invalid_login();$g=connect();$m=new
Min_Driver($g);}$_e=null;if(!is_object($g)||($_e=$b->login($_GET["username"],get_password()))!==true){$n=(is_string($g)?h($g):(is_string($_e)?$_e:lang(32)));auth_error($n.(preg_match('~^ | $~',get_password())?'<br>'.lang(94):''));}if($_POST["logout"]&&$_d&&!verify_token()){page_header(lang(83),lang(95));page_footer("db");exit;}if($Ja&&$_POST["token"])$_POST["token"]=$qi;$n='';if($_POST){if(!verify_token()){$Ud="max_input_vars";$Le=ini_get($Ud);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$z){$X=ini_get($z);if($X&&(!$Le||$X<$Le)){$Ud=$z;$Le=$X;}}}$n=(!$_POST["token"]&&$Le?lang(96,"'$Ud'"):lang(95).' '.lang(97));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$n=lang(98,"'post_max_size'");if(isset($_GET["sql"]))$n.=' '.lang(99);}function
select($H,$h=null,$Ef=array(),$_=0){global$y;$ze=array();$x=array();$e=array();$Ta=array();$U=array();$I=array();odd('');for($t=0;(!$_||$t<$_)&&($J=$H->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($ge=0;$ge<count($J);$ge++){$o=$H->fetch_field();$D=$o->name;$Df=$o->orgtable;$Cf=$o->orgname;$I[$o->table]=$Df;if($Ef&&$y=="sql")$ze[$ge]=($D=="table"?"table=":($D=="possible_keys"?"indexes=":null));elseif($Df!=""){if(!isset($x[$Df])){$x[$Df]=array();foreach(indexes($Df,$h)as$w){if($w["type"]=="PRIMARY"){$x[$Df]=array_flip($w["columns"]);break;}}$e[$Df]=$x[$Df];}if(isset($e[$Df][$Cf])){unset($e[$Df][$Cf]);$x[$Df][$Cf]=$ge;$ze[$ge]=$Df;}}if($o->charsetnr==63)$Ta[$ge]=true;$U[$ge]=$o->type;echo"<th".($Df!=""||$o->name!=$Cf?" title='".h(($Df!=""?"$Df.":"").$Cf)."'":"").">".h($D).($Ef?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($D),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($J
as$z=>$X){$A="";if(isset($ze[$z])&&!$e[$ze[$z]]){if($Ef&&$y=="sql"){$Q=$J[array_search("table=",$ze)];$A=ME.$ze[$z].urlencode($Ef[$Q]!=""?$Ef[$Q]:$Q);}else{$A=ME."edit=".urlencode($ze[$z]);foreach($x[$ze[$z]]as$kb=>$ge)$A.="&where".urlencode("[".bracket_escape($kb)."]")."=".urlencode($J[$ge]);}}elseif(is_url($X))$A=$X;if($X===null)$X="<i>NULL</i>";elseif($Ta[$z]&&!is_utf8($X))$X="<i>".lang(47,strlen($X))."</i>";else{$X=h($X);if($U[$z]==254)$X="<code>$X</code>";}if($A)$X="<a href='".h($A)."'".(is_url($A)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$I;}function
referencable_primary($ih){$I=array();foreach(table_status('',true)as$Rh=>$Q){if($Rh!=$ih&&fk_support($Q)){foreach(fields($Rh)as$o){if($o["primary"]){if($I[$Rh]){unset($I[$Rh]);break;}$I[$Rh]=$o;}}}}return$I;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$rh);return$rh;}function
adminer_setting($z){$rh=adminer_settings();return$rh[$z];}function
set_adminer_settings($rh){return
adminer_cookie("adminer_settings",http_build_query($rh+adminer_settings()));}function
textarea($D,$Y,$K=10,$pb=80){global$y;echo"<textarea name='$D' rows='$K' cols='$pb' class='sqlarea jush-$y' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($z,$o,$nb,$jd=array(),$Rc=array()){global$Jh,$U,$Ki,$sf;$T=$o["type"];echo'<td><select name="',h($z),'[type]" class="type" aria-labelledby="label-type">';if($T&&!isset($U[$T])&&!isset($jd[$T])&&!in_array($T,$Rc))$Rc[]=$T;if($jd)$Jh[lang(100)]=$jd;echo
optionlist(array_merge($Rc,$Jh),$T),'</select><td><input name="',h($z),'[length]" value="',h($o["length"]),'" size="3"',(!$o["length"]&&preg_match('~var(char|binary)$~',$T)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($z)."[collation]'".(preg_match('~(char|text|enum|set)$~',$T)?"":" class='hidden'").'><option value="">('.lang(101).')'.optionlist($nb,$o["collation"]).'</select>',($Ki?"<select name='".h($z)."[unsigned]'".(!$T||preg_match(number_type(),$T)?"":" class='hidden'").'><option>'.optionlist($Ki,$o["unsigned"]).'</select>':''),(isset($o['on_update'])?"<select name='".h($z)."[on_update]'".(preg_match('~timestamp|datetime~',$T)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(102).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$o["on_update"])?"CURRENT_TIMESTAMP":$o["on_update"])).'</select>':''),($jd?"<select name='".h($z)."[on_delete]'".(preg_match("~`~",$T)?"":" class='hidden'")."><option value=''>(".lang(103).")".optionlist(explode("|",$sf),$o["on_delete"])."</select> ":" ");}function
process_length($we){global$Bc;return(preg_match("~^\\s*\\(?\\s*$Bc(?:\\s*,\\s*$Bc)*+\\s*\\)?\\s*\$~",$we)&&preg_match_all("~$Bc~",$we,$Fe)?"(".implode(",",$Fe[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$we)));}function
process_type($o,$lb="COLLATE"){global$Ki;return" $o[type]".process_length($o["length"]).(preg_match(number_type(),$o["type"])&&in_array($o["unsigned"],$Ki)?" $o[unsigned]":"").(preg_match('~char|text|enum|set~',$o["type"])&&$o["collation"]?" $lb ".q($o["collation"]):"");}function
process_field($o,$Ci){return
array(idf_escape(trim($o["field"])),process_type($Ci),($o["null"]?" NULL":" NOT NULL"),default_value($o),(preg_match('~timestamp|datetime~',$o["type"])&&$o["on_update"]?" ON UPDATE $o[on_update]":""),(support("comment")&&$o["comment"]!=""?" COMMENT ".q($o["comment"]):""),($o["auto_increment"]?auto_increment():null),);}function
default_value($o){$Yb=$o["default"];return($Yb===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$o["type"])||preg_match('~^(?![a-z])~i',$Yb)?q($Yb):$Yb));}function
type_class($T){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$z=>$X){if(preg_match("~$z|$X~",$T))return" class='$z'";}}function
edit_fields($p,$nb,$T="TABLE",$jd=array()){global$Vd;$p=array_values($p);$Zb=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$ub=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($T=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($T=="TABLE"?lang(104):lang(105)),'<td id="label-type">',lang(49),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(106),'<td>',lang(107);if($T=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(51),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype.html#DATATYPE-SERIAL",'mssql'=>"ms186775.aspx",)),'<td id="label-default"',$Zb,'>',lang(52),(support("comment")?"<td id='label-comment'$ub>".lang(50):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($p))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(108)."'>".script("row_count = ".count($p).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($p
as$t=>$o){$t++;$Ff=$o[($_POST?"orig":"field")];$hc=(isset($_POST["add"][$t-1])||(isset($o["field"])&&!$_POST["drop_col"][$t]))&&(support("drop_col")||$Ff=="");echo'<tr',($hc?"":" style='display: none;'"),'>
',($T=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",$Vd),$o["inout"]):""),'<th>';if($hc){echo'<input name="fields[',$t,'][field]" value="',h($o["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$t,'][orig]" value="',h($Ff),'">';edit_type("fields[$t]",$o,$nb,$jd);if($T=="TABLE"){echo'<td>',checkbox("fields[$t][null]",1,$o["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$t,'"';if($o["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$Zb,'>',checkbox("fields[$t][has_default]",1,$o["has_default"],"","","","label-default"),'<input name="fields[',$t,'][default]" value="',h($o["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$ub><input name='fields[$t][comment]' value='".h($o["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(108)."'> "."<input type='image' class='icon' name='up[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.8.1")."' alt='↑' title='".lang(109)."'> "."<input type='image' class='icon' name='down[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.8.1")."' alt='↓' title='".lang(110)."'> ":""),($Ff==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.1")."' alt='x' title='".lang(111)."'>":"");}}function
process_fields(&$p){$kf=0;if($_POST["up"]){$qe=0;foreach($p
as$z=>$o){if(key($_POST["up"])==$z){unset($p[$z]);array_splice($p,$qe,0,array($o));break;}if(isset($o["field"]))$qe=$kf;$kf++;}}elseif($_POST["down"]){$ld=false;foreach($p
as$z=>$o){if(isset($o["field"])&&$ld){unset($p[key($_POST["down"])]);array_splice($p,$kf,0,array($ld));break;}if(key($_POST["down"])==$z)$ld=$o;$kf++;}}elseif($_POST["add"]){$p=array_values($p);array_splice($p,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($C){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($C[0][0].$C[0][0],$C[0][0],substr($C[0],1,-1))),'\\'))."'";}function
grant($qd,$sg,$e,$rf){if(!$sg)return
true;if($sg==array("ALL PRIVILEGES","GRANT OPTION"))return($qd=="GRANT"?queries("$qd ALL PRIVILEGES$rf WITH GRANT OPTION"):queries("$qd ALL PRIVILEGES$rf")&&queries("$qd GRANT OPTION$rf"));return
queries("$qd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$sg).$e).$rf);}function
drop_create($lc,$i,$mc,$di,$oc,$B,$Qe,$Oe,$Pe,$of,$bf){if($_POST["drop"])query_redirect($lc,$B,$Qe);elseif($of=="")query_redirect($i,$B,$Pe);elseif($of!=$bf){$Lb=queries($i);queries_redirect($B,$Oe,$Lb&&queries($lc));if($Lb)queries($mc);}else
queries_redirect($B,$Oe,queries($di)&&queries($oc)&&queries($lc)&&queries($i));}function
create_trigger($rf,$J){global$y;$ii=" $J[Timing] $J[Event]".(preg_match('~ OF~',$J["Event"])?" $J[Of]":"");return"CREATE TRIGGER ".idf_escape($J["Trigger"]).($y=="mssql"?$rf.$ii:$ii.$rf).rtrim(" $J[Type]\n$J[Statement]",";").";";}function
create_routine($Wg,$J){global$Vd,$y;$N=array();$p=(array)$J["fields"];ksort($p);foreach($p
as$o){if($o["field"]!="")$N[]=(preg_match("~^($Vd)\$~",$o["inout"])?"$o[inout] ":"").idf_escape($o["field"]).process_type($o,"CHARACTER SET");}$ac=rtrim("\n$J[definition]",";");return"CREATE $Wg ".idf_escape(trim($J["name"]))." (".implode(", ",$N).")".(isset($_GET["function"])?" RETURNS".process_type($J["returns"],"CHARACTER SET"):"").($J["language"]?" LANGUAGE $J[language]":"").($y=="pgsql"?" AS ".q($ac):"$ac;");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($r){global$sf;$l=$r["db"];$ff=$r["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$r["source"])).") REFERENCES ".($l!=""&&$l!=$_GET["db"]?idf_escape($l).".":"").($ff!=""&&$ff!=$_GET["ns"]?idf_escape($ff).".":"").table($r["table"])." (".implode(", ",array_map('idf_escape',$r["target"])).")".(preg_match("~^($sf)\$~",$r["on_delete"])?" ON DELETE $r[on_delete]":"").(preg_match("~^($sf)\$~",$r["on_update"])?" ON UPDATE $r[on_update]":"");}function
tar_file($q,$ni){$I=pack("a100a8a8a8a12a12",$q,644,0,0,decoct($ni->size),decoct(time()));$fb=8*32;for($t=0;$t<strlen($I);$t++)$fb+=ord($I[$t]);$I.=sprintf("%06o",$fb)."\0 ";echo$I,str_repeat("\0",512-strlen($I));$ni->send();echo
str_repeat("\0",511-($ni->size+511)%512);}function
ini_bytes($Ud){$X=ini_get($Ud);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($bg,$ei="<sup>?</sup>"){global$y,$g;$nh=$g->server_info;$Zi=preg_replace('~^(\d\.?\d).*~s','\1',$nh);$Oi=array('sql'=>"https://dev.mysql.com/doc/refman/$Zi/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$Zi/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$nh)."&id=",);if(preg_match('~MariaDB~',$nh)){$Oi['sql']="https://mariadb.com/kb/en/library/";$bg['sql']=(isset($bg['mariadb'])?$bg['mariadb']:str_replace(".html","/",$bg['sql']));}return($bg[$y]?"<a href='".h($Oi[$y].$bg[$y])."'".target_blank().">$ei</a>":"");}function
ob_gzencode($P){return
gzencode($P);}function
db_size($l){global$g;if(!$g->select_db($l))return"?";$I=0;foreach(table_status()as$R)$I+=$R["Data_length"]+$R["Index_length"];return
format_number($I);}function
set_utf8mb4($i){global$g;static$N=false;if(!$N&&preg_match('~\butf8mb4~i',$i)){$N=true;echo"SET NAMES ".charset($g).";\n\n";}}function
connect_error(){global$b,$g,$qi,$n,$kc;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(37).": ".h(DB),lang(112),true);}else{if($_POST["db"]&&!$n)queries_redirect(substr(ME,0,-1),lang(113),drop_databases($_POST["db"]));page_header(lang(114),$n,false);echo"<p class='links'>\n";foreach(array('database'=>lang(115),'privileges'=>lang(71),'processlist'=>lang(116),'variables'=>lang(117),'status'=>lang(118),)as$z=>$X){if(support($z))echo"<a href='".h(ME)."$z='>$X</a>\n";}echo"<p>".lang(119,$kc[DRIVER],"<b>".h($g->server_info)."</b>","<b>$g->extension</b>")."\n","<p>".lang(120,"<b>".h(logged_user())."</b>")."\n";$k=$b->databases();if($k){$dh=support("scheme");$nb=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(37)." - <a href='".h(ME)."refresh=1'>".lang(121)."</a>"."<td>".lang(122)."<td>".lang(123)."<td>".lang(124)." - <a href='".h(ME)."dbsize=1'>".lang(125)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$k=($_GET["dbsize"]?count_tables($k):array_flip($k));foreach($k
as$l=>$S){$Vg=h(ME)."db=".urlencode($l);$u=h("Db-".$l);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$l,in_array($l,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Vg' id='$u'>".h($l)."</a>";$mb=h(db_collation($l,$nb));echo"<td>".(support("database")?"<a href='$Vg".($dh?"&amp;ns=":"")."&amp;database=' title='".lang(67)."'>$mb</a>":$mb),"<td align='right'><a href='$Vg&amp;schema=' id='tables-".h($l)."' title='".lang(70)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($l)."'>".($_GET["dbsize"]?db_size($l):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(127)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$qi'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$g->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))adminer_redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(77).": ".h($_GET["ns"]),lang(128),true);page_footer("ns");exit;}}}$sf="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Eb){$this->size+=strlen($Eb);fwrite($this->handler,$Eb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$Bc="'(?:''|[^'\\\\]|\\\\.)*'";$Vd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$p=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$m->select($a,$L,array(where($_GET,$p)),$L);$J=($H?$H->fetch_row():array());echo$m->value($J[0],$p[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$p=fields($a);if(!$p)$n=error();$R=table_status1($a,true);$D=$b->tableName($R);page_header(($p&&is_view($R)?$R['Engine']=='materialized view'?lang(129):lang(130):lang(131)).": ".($D!=""?$D:h($a)),$n);$b->selectLinks($R);$tb=$R["Comment"];if($tb!="")echo"<p class='nowrap'>".lang(50).": ".h($tb)."\n";if($p)$b->tableStructurePrint($p);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(132)."</h3>\n";$x=indexes($a);if($x)$b->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(133)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(100)."</h3>\n";$jd=foreign_keys($a);if($jd){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(134)."<td>".lang(135)."<td>".lang(103)."<td>".lang(102)."<td></thead>\n";foreach($jd
as$D=>$r){echo"<tr title='".h($D)."'>","<th><i>".implode("</i>, <i>",array_map('h',$r["source"]))."</i>","<td><a href='".h($r["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($r["db"]),ME):($r["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($r["ns"]),ME):ME))."table=".urlencode($r["table"])."'>".($r["db"]!=""?"<b>".h($r["db"])."</b>.":"").($r["ns"]!=""?"<b>".h($r["ns"])."</b>.":"").h($r["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$r["target"]))."</i>)","<td>".h($r["on_delete"])."\n","<td>".h($r["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($D)).'">'.lang(136).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(137)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(138)."</h3>\n";$Bi=triggers($a);if($Bi){echo"<table cellspacing='0'>\n";foreach($Bi
as$z=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($z)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($z))."'>".lang(136)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(139)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(70),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Th=array();$Uh=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$Fe,PREG_SET_ORDER);foreach($Fe
as$t=>$C){$Th[$C[1]]=array($C[2],$C[3]);$Uh[]="\n\t'".js_escape($C[1])."': [ $C[2], $C[3] ]";}$ri=0;$Qa=-1;$ch=array();$Hg=array();$ue=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$hg=0;$ch[$Q]["fields"]=array();foreach(fields($Q)as$D=>$o){$hg+=1.25;$o["pos"]=$hg;$ch[$Q]["fields"][$D]=$o;}$ch[$Q]["pos"]=($Th[$Q]?$Th[$Q]:array($ri,0));foreach($b->foreignKeys($Q)as$X){if(!$X["db"]){$se=$Qa;if($Th[$Q][1]||$Th[$X["table"]][1])$se=min(floatval($Th[$Q][1]),floatval($Th[$X["table"]][1]))-1;else$Qa-=.1;while($ue[(string)$se])$se-=.0001;$ch[$Q]["references"][$X["table"]][(string)$se]=array($X["source"],$X["target"]);$Hg[$X["table"]][$Q][(string)$se]=$X["target"];$ue[(string)$se]=true;}}$ri=max($ri,$ch[$Q]["pos"][0]+2.5+$hg);}echo'<div id="schema" style="height: ',$ri,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$Uh)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$ri,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($ch
as$D=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($D).'"><b>'.h($D)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$o){$X='<span'.type_class($o["type"]).' title="'.h($o["full_type"].($o["null"]?" NULL":'')).'">'.h($o["field"]).'</span>';echo"<br>".($o["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$ai=>$Ig){foreach($Ig
as$se=>$Eg){$te=$se-$Th[$D][1];$t=0;foreach($Eg[0]as$yh)echo"\n<div class='references' title='".h($ai)."' id='refs$se-".($t++)."' style='left: $te"."em; top: ".$Q["fields"][$yh]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$te)."em;'></div></div>";}}foreach((array)$Hg[$D]as$ai=>$Ig){foreach($Ig
as$se=>$e){$te=$se-$Th[$D][1];$t=0;foreach($e
as$Zh)echo"\n<div class='references' title='".h($ai)."' id='refd$se-".($t++)."' style='left: $te"."em; top: ".$Q["fields"][$Zh]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.8.1")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$te)."em;'></div></div>";}}echo"\n</div>\n";}foreach($ch
as$D=>$Q){foreach((array)$Q["references"]as$ai=>$Ig){foreach($Ig
as$se=>$Eg){$Te=$ri;$Je=-10;foreach($Eg[0]as$z=>$yh){$ig=$Q["pos"][0]+$Q["fields"][$yh]["pos"];$jg=$ch[$ai]["pos"][0]+$ch[$ai]["fields"][$Eg[1][$z]]["pos"];$Te=min($Te,$ig,$jg);$Je=max($Je,$ig,$jg);}echo"<div class='references' id='refl$se' style='left: $se"."em; top: $Te"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Je-$Te)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(140),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$n){$Hb="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$z)$Hb.="&$z=".urlencode($_POST[$z]);adminer_cookie("adminer_export",substr($Hb,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Oc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$de=preg_match('~sql~',$_POST["format"]);if($de){echo"-- Adminer $ia ".$kc[DRIVER]." ".str_replace("\n"," ",$g->server_info)." dump\n\n";if($y=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$g->query("SET time_zone = '+00:00'");$g->query("SET sql_mode = ''");}}$Kh=$_POST["db_style"];$k=array(DB);if(DB==""){$k=$_POST["databases"];if(is_string($k))$k=explode("\n",rtrim(str_replace("\r","",$k),"\n"));}foreach((array)$k
as$l){$b->dumpDatabase($l);if($g->select_db($l)){if($de&&preg_match('~CREATE~',$Kh)&&($i=$g->result("SHOW CREATE DATABASE ".idf_escape($l),1))){set_utf8mb4($i);if($Kh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($l).";\n";echo"$i;\n";}if($de){if($Kh)echo
use_sql($l).";\n\n";$Lf="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$Wg){foreach(get_rows("SHOW $Wg STATUS WHERE Db = ".q($l),null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE $Wg ".idf_escape($J["Name"]),2));set_utf8mb4($i);$Lf.=($Kh!='DROP+CREATE'?"DROP $Wg IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE EVENT ".idf_escape($J["Name"]),3));set_utf8mb4($i);$Lf.=($Kh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}if($Lf)echo"DELIMITER ;;\n\n$Lf"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$bj=array();foreach(table_status('',true)as$D=>$R){$Q=(DB==""||in_array($D,(array)$_POST["tables"]));$Rb=(DB==""||in_array($D,(array)$_POST["data"]));if($Q||$Rb){if($Oc=="tar"){$ni=new
TmpFile;ob_start(array($ni,'write'),1e5);}$b->dumpTable($D,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$bj[]=$D;elseif($Rb){$p=fields($D);$b->dumpData($D,$_POST["data_style"],"SELECT *".convert_fields($p,$p)." FROM ".table($D));}if($de&&$_POST["triggers"]&&$Q&&($Bi=trigger_sql($D)))echo"\nDELIMITER ;;\n$Bi\nDELIMITER ;\n";if($Oc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$l/")."$D.csv",$ni);}elseif($de)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$D=>$R){$Q=(DB==""||in_array($D,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($D);}}foreach($bj
as$aj)$b->dumpTable($aj,$_POST["table_style"],1);if($Oc=="tar")echo
pack("x512");}}}if($de)echo"-- ".$g->result("SELECT NOW()")."\n";exit;}page_header(lang(73),$n,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$Vb=array('','USE','DROP+CREATE','CREATE');$Vh=array('','DROP+CREATE','CREATE');$Sb=array('','TRUNCATE+INSERT','INSERT');if($y=="sql")$Sb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$J);if(!$J)$J=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($J["events"])){$J["routines"]=$J["events"]=($_GET["dump"]=="");$J["triggers"]=$J["table_style"];}echo"<tr><th>".lang(141)."<td>".html_select("output",$b->dumpOutput(),$J["output"],0)."\n";echo"<tr><th>".lang(142)."<td>".html_select("format",$b->dumpFormat(),$J["format"],0)."\n";echo($y=="sqlite"?"":"<tr><th>".lang(37)."<td>".html_select('db_style',$Vb,$J["db_style"]).(support("routine")?checkbox("routines",1,$J["routines"],lang(143)):"").(support("event")?checkbox("events",1,$J["events"],lang(144)):"")),"<tr><th>".lang(123)."<td>".html_select('table_style',$Vh,$J["table_style"]).checkbox("auto_increment",1,$J["auto_increment"],lang(51)).(support("trigger")?checkbox("triggers",1,$J["triggers"],lang(138)):""),"<tr><th>".lang(145)."<td>".html_select('data_style',$Sb,$J["data_style"]),'</table>
<p><input type="submit" value="',lang(73),'">
<input type="hidden" name="token" value="',$qi,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$mg=array();if(DB!=""){$db=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$db>".lang(123)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(145)."<input type='checkbox' id='check-data'$db></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$bj="";$Wh=tables_list();foreach($Wh
as$D=>$T){$lg=preg_replace('~_.*~','',$D);$db=($a==""||$a==(substr($a,-1)=="%"?"$lg%":$D));$pg="<tr><td>".checkbox("tables[]",$D,$db,$D,"","block");if($T!==null&&!preg_match('~table~i',$T))$bj.="$pg\n";else
echo"$pg<td align='right'><label class='block'><span id='Rows-".h($D)."'></span>".checkbox("data[]",$D,$db)."</label>\n";$mg[$lg]++;}echo$bj;if($Wh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(37)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$k=$b->databases();if($k){foreach($k
as$l){if(!information_schema($l)){$lg=preg_replace('~_.*~','',$l);echo"<tr><td>".checkbox("databases[]",$l,$a==""||$a=="$lg%",$l,"","block")."\n";$mg[$lg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$bd=true;foreach($mg
as$z=>$X){if($z!=""&&$X>1){echo($bd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$z%")."'>".h($z)."</a>";$bd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(71));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(146)."</a>";$H=$g->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$qd=$H;if(!$H)$H=$g->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($qd?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(35)."<th>".lang(34)."<th></thead>\n";while($J=$H->fetch_assoc())echo'<tr'.odd().'><td>'.h($J["User"])."<td>".h($J["Host"]).'<td><a href="'.h(ME.'user='.urlencode($J["User"]).'&host='.urlencode($J["Host"])).'">'.lang(10)."</a>\n";if(!$qd||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$n&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$Dd=&get_session("queries");$Cd=&$Dd[DB];if(!$n&&$_POST["clear"]){$Cd=array();adminer_redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(72):lang(64)),$n);if(!$n&&$_POST){$nd=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$Bh=$b->importServerPath();$nd=@fopen((file_exists($Bh)?$Bh:"compress.zlib://$Bh.gz"),"rb");$G=($nd?fread($nd,1e6):false);}else$G=get_file("sql_file",true);if(is_string($G)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$xg=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$Cd||reset(end($Cd))!=$xg){restart_session();$Cd[]=array($xg,time());set_session("queries",$Dd);stop_session();}}$zh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$cc=";";$kf=0;$zc=true;$h=connect();if(is_object($h)&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$sb=0;$Dc=array();$Sf='[\'"'.($y=="sql"?'`#':($y=="sqlite"?'`[':($y=="mssql"?'[':''))).']|/\*|-- |$'.($y=="pgsql"?'|\$[^$]*\$':'');$si=microtime(true);parse_str($_COOKIE["adminer_export"],$ya);$qc=$b->dumpFormat();unset($qc["sql"]);while($G!=""){if(!$kf&&preg_match("~^$zh*+DELIMITER\\s+(\\S+)~i",$G,$C)){$cc=$C[1];$G=substr($G,strlen($C[0]));}else{preg_match('('.preg_quote($cc)."\\s*|$Sf)",$G,$C,PREG_OFFSET_CAPTURE,$kf);list($ld,$hg)=$C[0];if(!$ld&&$nd&&!feof($nd))$G.=fread($nd,1e5);else{if(!$ld&&rtrim($G)=="")break;$kf=$hg+strlen($ld);if($ld&&rtrim($ld)!=$cc){while(preg_match('('.($ld=='/*'?'\*/':($ld=='['?']':(preg_match('~^-- |^#~',$ld)?"\n":preg_quote($ld)."|\\\\."))).'|$)s',$G,$C,PREG_OFFSET_CAPTURE,$kf)){$ah=$C[0][0];if(!$ah&&$nd&&!feof($nd))$G.=fread($nd,1e5);else{$kf=$C[0][1]+strlen($ah);if($ah[0]!="\\")break;}}}else{$zc=false;$xg=substr($G,0,$hg);$sb++;$pg="<pre id='sql-$sb'><code class='jush-$y'>".$b->sqlCommandQuery($xg)."</code></pre>\n";if($y=="sqlite"&&preg_match("~^$zh*+ATTACH\\b~i",$xg,$C)){echo$pg,"<p class='error'>".lang(147)."\n";$Dc[]=" <a href='#sql-$sb'>$sb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$pg;ob_flush();flush();}$Fh=microtime(true);if($g->multi_query($xg)&&is_object($h)&&preg_match("~^$zh*+USE\\b~i",$xg))$h->query($xg);do{$H=$g->store_result();if($g->error){echo($_POST["only_errors"]?$pg:""),"<p class='error'>".lang(148).($g->errno?" ($g->errno)":"").": ".error()."\n";$Dc[]=" <a href='#sql-$sb'>$sb</a>";if($_POST["error_stops"])break
2;}else{$gi=" <span class='time'>(".format_time($Fh).")</span>".(strlen($xg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($xg))."'>".lang(10)."</a>":"");$_a=$g->affected_rows;$ej=($_POST["only_errors"]?"":$m->warnings());$fj="warnings-$sb";if($ej)$gi.=", <a href='#$fj'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$fj');","");$Lc=null;$Mc="explain-$sb";if(is_object($H)){$_=$_POST["limit"];$Ef=select($H,$h,array(),$_);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$gf=$H->num_rows;echo"<p>".($gf?($_&&$gf>$_?lang(149,$_):"").lang(150,$gf):""),$gi;if($h&&preg_match("~^($zh|\\()*+SELECT\\b~i",$xg)&&($Lc=explain($h,$xg)))echo", <a href='#$Mc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Mc');","");$u="export-$sb";echo", <a href='#$u'>".lang(73)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",$b->dumpOutput(),$ya["output"])." ".html_select("format",$qc,$ya["format"])."<input type='hidden' name='query' value='".h($xg)."'>"." <input type='submit' name='export' value='".lang(73)."'><input type='hidden' name='token' value='$qi'></span>\n"."</form>\n";}}else{if(preg_match("~^$zh*+(CREATE|DROP|ALTER)$zh++(DATABASE|SCHEMA)\\b~i",$xg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($g->info)."'>".lang(151,$_a)."$gi\n";}echo($ej?"<div id='$fj' class='hidden'>\n$ej</div>\n":"");if($Lc){echo"<div id='$Mc' class='hidden'>\n";select($Lc,$h,$Ef);echo"</div>\n";}}$Fh=microtime(true);}while($g->next_result());}$G=substr($G,$kf);$kf=0;}}}}if($zc)echo"<p class='message'>".lang(152)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(153,$sb-count($Dc))," <span class='time'>(".format_time($si).")</span>\n";}elseif($Dc&&$sb>1)echo"<p class='error'>".lang(148).": ".implode("",$Dc)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Jc="<input type='submit' value='".lang(154)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$xg=$_GET["sql"];if($_POST)$xg=$_POST["query"];elseif($_GET["history"]=="all")$xg=$Cd;elseif($_GET["history"]!="")$xg=$Cd[$_GET["history"]][0];echo"<p>";textarea("query",$xg,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$Jc\n",lang(155).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(156)."</legend><div>";$wd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$wd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Jc":lang(157)),"</div></fieldset>\n";$Kd=$b->importServerPath();if($Kd){echo"<fieldset><legend>".lang(158)."</legend><div>",lang(159,"<code>".h($Kd)."$wd</code>"),' <input type="submit" name="webfile" value="'.lang(160).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(161))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(162))."\n","<input type='hidden' name='token' value='$qi'>\n";if(!isset($_GET["import"])&&$Cd){print_fieldset("history",lang(163),$_GET["history"]!="");for($X=end($Cd);$X;$X=prev($Cd)){$z=key($Cd);list($xg,$gi,$uc)=$X;echo'<a href="'.h(ME."sql=&history=$z").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$gi)."'>".@date("H:i:s",$gi)."</span>"." <code class='jush-$y'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$xg)))),80,"</code>").($uc?" <span class='time'>($uc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(164)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(165)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$p=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$p):""):where($_GET,$p));$Li=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($p
as$D=>$o){if(!isset($o["privileges"][$Li?"update":"insert"])||$b->fieldName($o)==""||$o["generated"])unset($p[$D]);}if($_POST&&!$n&&!isset($_GET["select"])){$B=$_POST["referer"];if($_POST["insert"])$B=($Li?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$B))$B=ME."select=".urlencode($a);$x=indexes($a);$Gi=unique_array($_GET["where"],$x);$_g="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($B,lang(166),$m->delete($a,$_g,!$Gi));else{$N=array();foreach($p
as$D=>$o){$X=process_input($o);if($X!==false&&$X!==null)$N[idf_escape($D)]=$X;}if($Li){if(!$N)adminer_redirect($B);queries_redirect($B,lang(167),$m->update($a,$N,$_g,!$Gi));if(is_ajax()){page_headers();page_messages($n);exit;}}else{$H=$m->insert($a,$N);$re=($H?last_id():0);queries_redirect($B,lang(168,($re?" $re":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($p
as$D=>$o){if(isset($o["privileges"]["select"])){$Ga=convert_field($o);if($_POST["clone"]&&$o["auto_increment"])$Ga="''";if($y=="sql"&&preg_match("~enum|set~",$o["type"]))$Ga="1*".idf_escape($D);$L[]=($Ga?"$Ga AS ":"").idf_escape($D);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$m->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$n=error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$p){if(!$Z){$H=$m->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($m->primary=>"");}if($J){foreach($J
as$z=>$X){if(!$Z)$J[$z]=null;$p[$z]=array("field"=>$z,"null"=>($z!=$m->primary),"auto_increment"=>($z==$m->primary));}}}edit_form($a,$p,$J,$Li);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Uf=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$z)$Uf[$z]=$z;$Gg=referencable_primary($a);$jd=array();foreach($Gg
as$Rh=>$o)$jd[str_replace("`","``",$Rh)."`".str_replace("`","``",$o["field"])]=$Rh;$Hf=array();$R=array();if($a!=""){$Hf=fields($a);$R=table_status($a);if(!$R)$n=lang(9);}$J=$_POST;$J["fields"]=(array)$J["fields"];if($J["auto_increment_col"])$J["fields"][$J["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($J["fields"])&&!$n){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(169),drop_tables(array($a)));else{$p=array();$Da=array();$Pi=false;$hd=array();$Gf=reset($Hf);$Ba=" FIRST";foreach($J["fields"]as$z=>$o){$r=$jd[$o["type"]];$Ci=($r!==null?$Gg[$r]:$o);if($o["field"]!=""){if(!$o["has_default"])$o["default"]=null;if($z==$J["auto_increment_col"])$o["auto_increment"]=true;$ug=process_field($o,$Ci);$Da[]=array($o["orig"],$ug,$Ba);if(!$Gf||$ug!=process_field($Gf,$Gf)){$p[]=array($o["orig"],$ug,$Ba);if($o["orig"]!=""||$Ba)$Pi=true;}if($r!==null)$hd[idf_escape($o["field"])]=($a!=""&&$y!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$jd[$o["type"]],'source'=>array($o["field"]),'target'=>array($Ci["field"]),'on_delete'=>$o["on_delete"],));$Ba=" AFTER ".idf_escape($o["field"]);}elseif($o["orig"]!=""){$Pi=true;$p[]=array($o["orig"]);}if($o["orig"]!=""){$Gf=next($Hf);if(!$Gf)$Ba="";}}$Wf="";if($Uf[$J["partition_by"]]){$Xf=array();if($J["partition_by"]=='RANGE'||$J["partition_by"]=='LIST'){foreach(array_filter($J["partition_names"])as$z=>$X){$Y=$J["partition_values"][$z];$Xf[]="\n  PARTITION ".idf_escape($X)." VALUES ".($J["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Wf.="\nPARTITION BY $J[partition_by]($J[partition])".($Xf?" (".implode(",",$Xf)."\n)":($J["partitions"]?" PARTITIONS ".(+$J["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$R["Create_options"]))$Wf.="\nREMOVE PARTITIONING";$Ne=lang(170);if($a==""){adminer_cookie("adminer_engine",$J["Engine"]);$Ne=lang(171);}$D=trim($J["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($D),$Ne,alter_table($a,$D,($y=="sqlite"&&($Pi||$hd)?$Da:$p),$hd,($J["Comment"]!=$R["Comment"]?$J["Comment"]:null),($J["Engine"]&&$J["Engine"]!=$R["Engine"]?$J["Engine"]:""),($J["Collation"]&&$J["Collation"]!=$R["Collation"]?$J["Collation"]:""),($J["Auto_increment"]!=""?number($J["Auto_increment"]):""),$Wf));}}page_header(($a!=""?lang(44):lang(74)),$n,array("table"=>$a),h($a));if(!$_POST){$J=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($U["int"])?"int":(isset($U["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$J=$R;$J["name"]=$a;$J["fields"]=array();if(!$_GET["auto_increment"])$J["Auto_increment"]="";foreach($Hf
as$o){$o["has_default"]=isset($o["default"]);$J["fields"][]=$o;}if(support("partitioning")){$od="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$H=$g->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $od ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($J["partition_by"],$J["partitions"],$J["partition"])=$H->fetch_row();$Xf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $od AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$Xf[""]="";$J["partition_names"]=array_keys($Xf);$J["partition_values"]=array_values($Xf);}}}$nb=collations();$Ac=engines();foreach($Ac
as$_c){if(!strcasecmp($_c,$J["Engine"])){$J["Engine"]=$_c;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(172),': <input name="name" data-maxlength="64" value="',h($J["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($Ac?"<select name='Engine'>".optionlist(array(""=>"(".lang(173).")")+$Ac,$J["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($nb&&!preg_match("~sqlite|mssql~",$y)?html_select("Collation",array(""=>"(".lang(101).")")+$nb,$J["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($J["fields"],$nb,"TABLE",$jd);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(51),': <input type="number" name="Auto_increment" size="6" value="',h($J["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(174),"columnShow(this.checked, 5)","jsonly"),(support("comment")?checkbox("comments",1,($_POST?$_POST["comments"]:adminer_setting("comments")),lang(50),"editingCommentsClick(this, true);","jsonly").' <input name="Comment" value="'.h($J["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'">':''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$a));}if(support("partitioning")){$Vf=preg_match('~RANGE|LIST~',$J["partition_by"]);print_fieldset("partition",lang(176),$J["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$Uf,$J["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($J["partition"]),'">)
',lang(177),': <input type="number" name="partitions" class="size',($Vf||!$J["partition_by"]?" hidden":""),'" value="',h($J["partitions"]),'">
<table cellspacing="0" id="partition-table"',($Vf?"":" class='hidden'"),'>
<thead><tr><th>',lang(178),'<th>',lang(179),'</thead>
';foreach($J["partition_names"]as$z=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($z==count($J["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($J["partition_values"][$z]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Nd=array("PRIMARY","UNIQUE","INDEX");$R=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$Nd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$Nd[]="SPATIAL";$x=indexes($a);$ng=array();if($y=="mongo"){$ng=$x["_id_"];unset($Nd[0]);unset($x["_id_"]);}$J=$_POST;if($_POST&&!$n&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($J["indexes"]as$w){$D=$w["name"];if(in_array($w["type"],$Nd)){$e=array();$xe=array();$ec=array();$N=array();ksort($w["columns"]);foreach($w["columns"]as$z=>$d){if($d!=""){$we=$w["lengths"][$z];$dc=$w["descs"][$z];$N[]=idf_escape($d).($we?"(".(+$we).")":"").($dc?" DESC":"");$e[]=$d;$xe[]=($we?$we:null);$ec[]=$dc;}}if($e){$Kc=$x[$D];if($Kc){ksort($Kc["columns"]);ksort($Kc["lengths"]);ksort($Kc["descs"]);if($w["type"]==$Kc["type"]&&array_values($Kc["columns"])===$e&&(!$Kc["lengths"]||array_values($Kc["lengths"])===$xe)&&array_values($Kc["descs"])===$ec){unset($x[$D]);continue;}}$c[]=array($w["type"],$D,$N);}}}foreach($x
as$D=>$Kc)$c[]=array($Kc["type"],$D,"DROP");if(!$c)adminer_redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(180),alter_indexes($a,$c));}page_header(lang(132),$n,array("table"=>$a),h($a));$p=array_keys(fields($a));if($_POST["add"]){foreach($J["indexes"]as$z=>$w){if($w["columns"][count($w["columns"])]!="")$J["indexes"][$z]["columns"][]="";}$w=end($J["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$J["indexes"][]=array("columns"=>array(1=>""));}if(!$J){foreach($x
as$z=>$w){$x[$z]["name"]=$z;$x[$z]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$J["indexes"]=$x;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(181),'<th><input type="submit" class="wayoff">',lang(182),'<th id="label-name">',lang(183),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(108)."'>",'</noscript>
</thead>
';if($ng){echo"<tr><td>PRIMARY<td>";foreach($ng["columns"]as$z=>$d){echo
select_input(" disabled",$p,$d),"<label><input disabled type='checkbox'>".lang(59)."</label> ";}echo"<td><td>\n";}$ge=1;foreach($J["indexes"]as$w){if(!$_POST["drop_col"]||$ge!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$ge][type]",array(-1=>"")+$Nd,$w["type"],($ge==count($J["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$z=>$d){echo"<span>".select_input(" name='indexes[$ge][columns][$t]' title='".lang(48)."'",($p?array_combine($p,$p):$p),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($y=="sql"?"":$_GET["indexes"]."_")."')"),($y=="sql"||$y=="mssql"?"<input type='number' name='indexes[$ge][lengths][$t]' class='size' value='".h($w["lengths"][$z])."' title='".lang(106)."'>":""),(support("descidx")?checkbox("indexes[$ge][descs][$t]",1,$w["descs"][$z],lang(59)):"")," </span>";$t++;}echo"<td><input name='indexes[$ge][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$ge]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.1")."' alt='x' title='".lang(111)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$ge++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["database"])){$J=$_POST;if($_POST&&!$n&&!isset($_POST["add_x"])){$D=trim($J["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(184),drop_databases(array(DB)));}elseif(DB!==$D){if(DB!=""){$_GET["db"]=$D;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($D),lang(185),rename_database($D,$J["collation"]));}else{$k=explode("\n",str_replace("\r","",$D));$Lh=true;$qe="";foreach($k
as$l){if(count($k)==1||$l!=""){if(!create_database($l,$J["collation"]))$Lh=false;$qe=$l;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($qe),lang(186),$Lh);}}else{if(!$J["collation"])adminer_redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($D).(preg_match('~^[a-z0-9_]+$~i',$J["collation"])?" COLLATE $J[collation]":""),substr(ME,0,-1),lang(187));}}page_header(DB!=""?lang(67):lang(115),$n,array(),h(DB));$nb=collations();$D=DB;if($_POST)$D=$J["name"];elseif(DB!="")$J["collation"]=db_collation(DB,$nb);elseif($y=="sql"){foreach(get_vals("SHOW GRANTS")as$qd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$qd,$C)&&$C[1]){$D=stripcslashes(idf_unescape("`$C[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($D,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($D).'</textarea><br>':'<input name="name" id="name" value="'.h($D).'" data-maxlength="64" autocapitalize="off">')."\n".($nb?html_select("collation",array(""=>"(".lang(101).")")+$nb,$J["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"ms187963.aspx",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(108)."'>\n";echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["scheme"])){$J=$_POST;if($_POST&&!$n){$A=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$A,lang(188));else{$D=trim($J["name"]);$A.=urlencode($D);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($D),$A,lang(189));elseif($_GET["ns"]!=$D)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($D),$A,lang(190));else
adminer_redirect($A);}}page_header($_GET["ns"]!=""?lang(68):lang(69),$n);if(!$J)$J["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" id="name" value="',h($J["name"]),'" autocapitalize="off">
',script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$_GET["ns"]))."\n";echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(191).": ".h($da),$n);$Wg=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Ld=array();$Lf=array();foreach($Wg["fields"]as$t=>$o){if(substr($o["inout"],-3)=="OUT")$Lf[$t]="@".idf_escape($o["field"])." AS ".idf_escape($o["field"]);if(!$o["inout"]||substr($o["inout"],0,2)=="IN")$Ld[]=$t;}if(!$n&&$_POST){$Ya=array();foreach($Wg["fields"]as$z=>$o){if(in_array($z,$Ld)){$X=process_input($o);if($X===false)$X="''";if(isset($Lf[$z]))$g->query("SET @".idf_escape($o["field"])." = $X");}$Ya[]=(isset($Lf[$z])?"@".idf_escape($o["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$Ya).")";$Fh=microtime(true);$H=$g->multi_query($G);$_a=$g->affected_rows;echo$b->selectQuery($G,$Fh,!$H);if(!$H)echo"<p class='error'>".error()."\n";else{$h=connect();if(is_object($h))$h->select_db(DB);do{$H=$g->store_result();if(is_object($H))select($H,$h);else
echo"<p class='message'>".lang(192,$_a)." <span class='time'>".@date("H:i:s")."</span>\n";}while($g->next_result());if($Lf)select($g->query("SELECT ".implode(", ",$Lf)));}}echo'
<form action="" method="post">
';if($Ld){echo"<table cellspacing='0' class='layout'>\n";foreach($Ld
as$z){$o=$Wg["fields"][$z];$D=$o["field"];echo"<tr><th>".$b->fieldName($o);$Y=$_POST["fields"][$D];if($Y!=""){if($o["type"]=="enum")$Y=+$Y;if($o["type"]=="set")$Y=array_sum($Y);}input($o,$Y,(string)$_POST["function"][$D]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(191),'">
<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$D=$_GET["name"];$J=$_POST;if($_POST&&!$n&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$Ne=($_POST["drop"]?lang(193):($D!=""?lang(194):lang(195)));$B=ME."table=".urlencode($a);if(!$_POST["drop"]){$J["source"]=array_filter($J["source"],'strlen');ksort($J["source"]);$Zh=array();foreach($J["source"]as$z=>$X)$Zh[$z]=$J["target"][$z];$J["target"]=$Zh;}if($y=="sqlite")queries_redirect($B,$Ne,recreate_table($a,$a,array(),array(),array(" $D"=>($_POST["drop"]?"":" ".format_foreign_key($J)))));else{$c="ALTER TABLE ".table($a);$lc="\nDROP ".($y=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($D);if($_POST["drop"])query_redirect($c.$lc,$B,$Ne);else{query_redirect($c.($D!=""?"$lc,":"")."\nADD".format_foreign_key($J),$B,$Ne);$n=lang(196)."<br>$n";}}}page_header(lang(197),$n,array("table"=>$a),h($a));if($_POST){ksort($J["source"]);if($_POST["add"])$J["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$J["target"]=array();}elseif($D!=""){$jd=foreign_keys($a);$J=$jd[$D];$J["source"][]="";}else{$J["table"]=$a;$J["source"]=array("");}echo'
<form action="" method="post">
';$yh=array_keys(fields($a));if($J["db"]!="")$g->select_db($J["db"]);if($J["ns"]!="")set_schema($J["ns"]);$Fg=array_keys(array_filter(table_status('',true),'fk_support'));$Zh=array_keys(fields(in_array($J["table"],$Fg)?$J["table"]:reset($Fg)));$tf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(198).": ".html_select("table",$Fg,$J["table"],$tf)."\n";if($y=="pgsql")echo
lang(77).": ".html_select("ns",$b->schemas(),$J["ns"]!=""?$J["ns"]:$_GET["ns"],$tf);elseif($y!="sqlite"){$Wb=array();foreach($b->databases()as$l){if(!information_schema($l))$Wb[]=$l;}echo
lang(76).": ".html_select("db",$Wb,$J["db"]!=""?$J["db"]:$_GET["db"],$tf);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(199),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(134),'<th id="label-target">',lang(135),'</thead>
';$ge=0;foreach($J["source"]as$z=>$X){echo"<tr>","<td>".html_select("source[".(+$z)."]",array(-1=>"")+$yh,$X,($ge==count($J["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$z)."]",$Zh,$J["target"][$z],1,"label-target");$ge++;}echo'</table>
<p>
',lang(103),': ',html_select("on_delete",array(-1=>"")+explode("|",$sf),$J["on_delete"]),' ',lang(102),': ',html_select("on_update",array(-1=>"")+explode("|",$sf),$J["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"ms174979.aspx",'oracle'=>"https://docs.oracle.com/cd/B19306_01/server.102/b14200/clauses002.htm#sthref2903",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(200),'"></noscript>
';if($D!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$D));}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$J=$_POST;$If="VIEW";if($y=="pgsql"&&$a!=""){$O=table_status($a);$If=strtoupper($O["Engine"]);}if($_POST&&!$n){$D=trim($J["name"]);$Ga=" AS\n$J[select]";$B=ME."table=".urlencode($D);$Ne=lang(201);$T=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$D&&$y!="sqlite"&&$T=="VIEW"&&$If=="VIEW")query_redirect(($y=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($D).$Ga,$B,$Ne);else{$bi=$D."_adminer_".uniqid();drop_create("DROP $If ".table($a),"CREATE $T ".table($D).$Ga,"DROP $T ".table($D),"CREATE $T ".table($bi).$Ga,"DROP $T ".table($bi),($_POST["drop"]?substr(ME,0,-1):$B),lang(202),$Ne,lang(203),$a,$D);}}if(!$_POST&&$a!=""){$J=adminer_view($a);$J["name"]=$a;$J["materialized"]=($If!="VIEW");if(!$n)$n=error();}page_header(($a!=""?lang(43):lang(204)),$n,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(183),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$J["materialized"],lang(129)):""),'<p>';textarea("select",$J["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$a));}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Yd=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Hh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$J=$_POST;if($_POST&&!$n){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(205));elseif(in_array($J["INTERVAL_FIELD"],$Yd)&&isset($Hh[$J["STATUS"]])){$bh="\nON SCHEDULE ".($J["INTERVAL_VALUE"]?"EVERY ".q($J["INTERVAL_VALUE"])." $J[INTERVAL_FIELD]".($J["STARTS"]?" STARTS ".q($J["STARTS"]):"").($J["ENDS"]?" ENDS ".q($J["ENDS"]):""):"AT ".q($J["STARTS"]))." ON COMPLETION".($J["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(206):lang(207)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$bh.($aa!=$J["EVENT_NAME"]?"\nRENAME TO ".idf_escape($J["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($J["EVENT_NAME"]).$bh)."\n".$Hh[$J["STATUS"]]." COMMENT ".q($J["EVENT_COMMENT"]).rtrim(" DO\n$J[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(208).": ".h($aa):lang(209)),$n);if(!$J&&$aa!=""){$K=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$J=reset($K);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(183),'<td><input name="EVENT_NAME" value="',h($J["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(210),'<td><input name="STARTS" value="',h("$J[EXECUTE_AT]$J[STARTS]"),'">
<tr><th title="datetime">',lang(211),'<td><input name="ENDS" value="',h($J["ENDS"]),'">
<tr><th>',lang(212),'<td><input type="number" name="INTERVAL_VALUE" value="',h($J["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Yd,$J["INTERVAL_FIELD"]),'<tr><th>',lang(118),'<td>',html_select("STATUS",$Hh,$J["STATUS"]),'<tr><th>',lang(50),'<td><input name="EVENT_COMMENT" value="',h($J["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$J["ON_COMPLETION"]=="PRESERVE",lang(213)),'</table>
<p>';textarea("EVENT_DEFINITION",$J["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$aa));}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Wg=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$J=$_POST;$J["fields"]=(array)$J["fields"];if($_POST&&!process_fields($J["fields"])&&!$n){$Ff=routine($_GET["procedure"],$Wg);$bi="$J[name]_adminer_".uniqid();drop_create("DROP $Wg ".routine_id($da,$Ff),create_routine($Wg,$J),"DROP $Wg ".routine_id($J["name"],$J),create_routine($Wg,array("name"=>$bi)+$J),"DROP $Wg ".routine_id($bi,$J),substr(ME,0,-1),lang(214),lang(215),lang(216),$da,$J["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(217):lang(218)).": ".h($da):(isset($_GET["function"])?lang(219):lang(220))),$n);if(!$_POST&&$da!=""){$J=routine($_GET["procedure"],$Wg);$J["name"]=$da;}$nb=get_vals("SHOW CHARACTER SET");sort($nb);$Xg=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(183),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',($Xg?lang(19).": ".html_select("language",$Xg,$J["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($J["fields"],$nb,$Wg);if(isset($_GET["function"])){echo"<tr><td>".lang(221);edit_type("returns",$J["returns"],$nb,array(),($y=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$J["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$da));}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$J=$_POST;if($_POST&&!$n){$A=substr(ME,0,-1);$D=trim($J["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$A,lang(222));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($D),$A,lang(223));elseif($fa!=$D)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($D),$A,lang(224));else
adminer_redirect($A);}page_header($fa!=""?lang(225).": ".h($fa):lang(226),$n);if(!$J)$J["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$fa))."\n";echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$J=$_POST;if($_POST&&!$n){$A=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$A,lang(227));else
query_redirect("CREATE TYPE ".idf_escape(trim($J["name"]))." $J[as]",$A,lang(228));}page_header($ga!=""?lang(229).": ".h($ga):lang(230),$n);if(!$J)$J["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$ga))."\n";else{echo"<input name='name' value='".h($J['name'])."' autocapitalize='off'>\n";textarea("as",$J["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$D=$_GET["name"];$Ai=trigger_options();$J=(array)trigger($D,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$n&&in_array($_POST["Timing"],$Ai["Timing"])&&in_array($_POST["Event"],$Ai["Event"])&&in_array($_POST["Type"],$Ai["Type"])){$rf=" ON ".table($a);$lc="DROP TRIGGER ".idf_escape($D).($y=="pgsql"?$rf:"");$B=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($lc,$B,lang(231));else{if($D!="")queries($lc);queries_redirect($B,($D!=""?lang(232):lang(233)),queries(create_trigger($rf,$_POST)));if($D!="")queries(create_trigger($rf,$J+array("Type"=>reset($Ai["Type"]))));}}$J=$_POST;}page_header(($D!=""?lang(234).": ".h($D):lang(235)),$n,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(236),'<td>',html_select("Timing",$Ai["Timing"],$J["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(237),'<td>',html_select("Event",$Ai["Event"],$J["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Ai["Event"])?" <input name='Of' value='".h($J["Of"])."' class='hidden'>":""),'<tr><th>',lang(49),'<td>',html_select("Type",$Ai["Type"],$J["Type"]),'</table>
<p>',lang(183),': <input name="Trigger" value="',h($J["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$J["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($D!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$D));}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$sg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$J){foreach(explode(",",($J["Privilege"]=="Grant option"?"":$J["Context"]))as$Fb)$sg[$Fb][$J["Privilege"]]=$J["Comment"];}$sg["Server Admin"]+=$sg["File access on server"];$sg["Databases"]["Create routine"]=$sg["Procedures"]["Create routine"];unset($sg["Procedures"]["Create routine"]);$sg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$sg["Columns"][$X]=$sg["Tables"][$X];unset($sg["Server Admin"]["Usage"]);foreach($sg["Tables"]as$z=>$X)unset($sg["Databases"][$z]);$af=array();if($_POST){foreach($_POST["objects"]as$z=>$X)$af[$X]=(array)$af[$X]+(array)$_POST["grants"][$z];}$rd=array();$pf="";if(isset($_GET["host"])&&($H=$g->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($J=$H->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$J[0],$C)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$C[1],$Fe,PREG_SET_ORDER)){foreach($Fe
as$X){if($X[1]!="USAGE")$rd["$C[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$J[0]))$rd["$C[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$J[0],$C))$pf=$C[1];}}if($_POST&&!$n){$qf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $qf",ME."privileges=",lang(238));else{$cf=q($_POST["user"])."@".q($_POST["host"]);$Zf=$_POST["pass"];if($Zf!=''&&!$_POST["hashed"]&&!min_version(8)){$Zf=$g->result("SELECT PASSWORD(".q($Zf).")");$n=!$Zf;}$Lb=false;if(!$n){if($qf!=$cf){$Lb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $cf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Zf));$n=!$Lb;}elseif($Zf!=$pf)queries("SET PASSWORD FOR $cf = ".q($Zf));}if(!$n){$Tg=array();foreach($af
as$if=>$qd){if(isset($_GET["grant"]))$qd=array_filter($qd);$qd=array_keys($qd);if(isset($_GET["grant"]))$Tg=array_diff(array_keys(array_filter($af[$if],'strlen')),$qd);elseif($qf==$cf){$nf=array_keys((array)$rd[$if]);$Tg=array_diff($nf,$qd);$qd=array_diff($qd,$nf);unset($rd[$if]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$if,$C)&&(!grant("REVOKE",$Tg,$C[2]," ON $C[1] FROM $cf")||!grant("GRANT",$qd,$C[2]," ON $C[1] TO $cf"))){$n=true;break;}}}if(!$n&&isset($_GET["host"])){if($qf!=$cf)queries("DROP USER $qf");elseif(!isset($_GET["grant"])){foreach($rd
as$if=>$Tg){if(preg_match('~^(.+)(\(.*\))?$~U',$if,$C))grant("REVOKE",array_keys($Tg),$C[2]," ON $C[1] FROM $cf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(239):lang(240)),!$n);if($Lb)$g->query("DROP USER $cf");}}page_header((isset($_GET["host"])?lang(35).": ".h("$ha@$_GET[host]"):lang(146)),$n,array("privileges"=>array('',lang(71))));if($_POST){$J=$_POST;$rd=$af;}else{$J=$_GET+array("host"=>$g->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$J["pass"]=$pf;if($pf!="")$J["hashed"]=true;$rd[(DB==""||$rd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(34),'<td><input name="host" data-maxlength="60" value="',h($J["host"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="user" data-maxlength="80" value="',h($J["user"]),'" autocapitalize="off">
<tr><th>',lang(36),'<td><input name="pass" id="pass" value="',h($J["pass"]),'" autocomplete="new-password">
';if(!$J["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$J["hashed"],lang(241),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(71).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($rd
as$if=>$qd){echo'<th>'.($if!="*.*"?"<input name='objects[$t]' value='".h($if)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$t]' value='*.*' size='10'>*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(34),"Databases"=>lang(37),"Tables"=>lang(131),"Columns"=>lang(48),"Procedures"=>lang(242),)as$Fb=>$dc){foreach((array)$sg[$Fb]as$rg=>$tb){echo"<tr".odd()."><td".($dc?">$dc<td":" colspan='2'").' lang="en" title="'.h($tb).'">'.h($rg);$t=0;foreach($rd
as$if=>$qd){$D="'grants[$t][".h(strtoupper($rg))."]'";$Y=$qd[strtoupper($rg)];if($Fb=="Server Admin"&&$if!=(isset($rd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$D><option><option value='1'".($Y?" selected":"").">".lang(243)."<option value='0'".($Y=="0"?" selected":"").">".lang(244)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$D value='1'".($Y?" checked":"").($rg=="All privileges"?" id='grants-$t-all'>":">".($rg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";}$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,"$ha@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$n){$le=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$le++;}queries_redirect(ME."processlist=",lang(245,$le),$le||!$_POST["kill"]);}}page_header(lang(116),$n);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$J){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($J
as$z=>$X)echo"<th>$z".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($z),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$J[$y=="sql"?"Id":"pid"],0):"");foreach($J
as$z=>$X)echo"<td>".(($y=="sql"&&$z=="Info"&&preg_match("~Query|Killed~",$J["Command"])&&$X!="")||($y=="pgsql"&&$z=="current_query"&&$X!="<IDLE>")||($y=="oracle"&&$z=="sql_text"&&$X!="")?"<code class='jush-$y'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($J["db"]!=""?"db=".urlencode($J["db"])."&":"")."sql=".urlencode($X)).'">'.lang(246).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($t+1)."/".lang(247,max_connections()),"<p><input type='submit' value='".lang(248)."'>\n";}echo'<input type="hidden" name="token" value="',$qi,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$x=indexes($a);$p=fields($a);$jd=column_foreign_keys($a);$lf=$R["Oid"];parse_str($_COOKIE["adminer_import"],$za);$Ug=array();$e=array();$fi=null;foreach($p
as$z=>$o){$D=$b->fieldName($o);if(isset($o["privileges"]["select"])&&$D!=""){$e[$z]=html_entity_decode(strip_tags($D),ENT_QUOTES);if(is_shortable($o))$fi=$b->selectLengthProcess();}$Ug+=$o["privileges"];}list($L,$sd)=$b->selectColumnsProcess($e,$x);$ce=count($sd)<count($L);$Z=$b->selectSearchProcess($p,$x);$Bf=$b->selectOrderProcess($p,$x);$_=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Hi=>$J){$Ga=convert_field($p[key($J)]);$L=array($Ga?$Ga:idf_escape(key($J)));$Z[]=where_check($Hi,$p);$I=$m->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$ng=$Ji=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$ng=array_flip($w["columns"]);$Ji=($L?$ng:array());foreach($Ji
as$z=>$X){if(in_array(idf_escape($z),$L))unset($Ji[$z]);}break;}}if($lf&&!$ng){$ng=$Ji=array($lf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($lf));}if($_POST&&!$n){$kj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$eb=array();foreach($_POST["check"]as$bb)$eb[]=where_check($bb,$p);$kj[]="((".implode(") OR (",$eb)."))";}$kj=($kj?"\nWHERE ".implode(" AND ",$kj):"");if($_POST["export"]){adminer_cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$od=($L?implode(", ",$L):"*").convert_fields($e,$p,$L)."\nFROM ".table($a);$ud=($sd&&$ce?"\nGROUP BY ".implode(", ",$sd):"").($Bf?"\nORDER BY ".implode(", ",$Bf):"");if(!is_array($_POST["check"])||$ng)$G="SELECT $od$kj$ud";else{$Fi=array();foreach($_POST["check"]as$X)$Fi[]="(SELECT".limit($od,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$p).$ud,1).")";$G=implode(" UNION ALL ",$Fi);}$b->dumpData($a,"table",$G);exit;}if(!$b->selectEmailProcess($Z,$jd)){if($_POST["save"]||$_POST["delete"]){$H=true;$_a=0;$N=array();if(!$_POST["delete"]){foreach($e
as$D=>$X){$X=process_input($p[$D]);if($X!==null&&($_POST["clone"]||$X!==false))$N[idf_escape($D)]=($X!==false?$X:idf_escape($D));}}if($_POST["delete"]||$N){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($N)).")\nSELECT ".implode(", ",$N)."\nFROM ".table($a);if($_POST["all"]||($ng&&is_array($_POST["check"]))||$ce){$H=($_POST["delete"]?$m->delete($a,$kj):($_POST["clone"]?queries("INSERT $G$kj"):$m->update($a,$N,$kj)));$_a=$g->affected_rows;}else{foreach((array)$_POST["check"]as$X){$gj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$p);$H=($_POST["delete"]?$m->delete($a,$gj,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$gj)):$m->update($a,$N,$gj,1)));if(!$H)break;$_a+=$g->affected_rows;}}}$Ne=lang(249,$_a);if($_POST["clone"]&&$H&&$_a==1){$re=last_id();if($re)$Ne=lang(168," $re");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Ne,$H);if(!$_POST["delete"]){edit_form($a,$p,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$n=lang(250);else{$H=true;$_a=0;foreach($_POST["val"]as$Hi=>$J){$N=array();foreach($J
as$z=>$X){$z=bracket_escape($z,1);$N[idf_escape($z)]=(preg_match('~char|text~',$p[$z]["type"])||$X!=""?$b->processInput($p[$z],$X):"NULL");}$H=$m->update($a,$N," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Hi,$p),!$ce&&!$ng," ");if(!$H)break;$_a+=$g->affected_rows;}queries_redirect(remove_from_uri(),lang(249,$_a),$H);}}elseif(!is_string($Zc=get_file("csv_file",true)))$n=upload_error($Zc);elseif(!preg_match('~~u',$Zc))$n=lang(251);else{adminer_cookie("adminer_import","output=".urlencode($za["output"])."&format=".urlencode($_POST["separator"]));$H=true;$pb=array_keys($p);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Zc,$Fe);$_a=count($Fe[0]);$m->begin();$kh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($Fe[0]as$z=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$kh]*)$kh~",$X.$kh,$Ge);if(!$z&&!array_diff($Ge[1],$pb)){$pb=$Ge[1];$_a--;}else{$N=array();foreach($Ge[1]as$t=>$kb)$N[idf_escape($pb[$t])]=($kb==""&&$p[$pb[$t]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$kb))));$K[]=$N;}}$H=(!$K||$m->insertUpdate($a,$K,$ng));if($H)$H=$m->commit();queries_redirect(remove_from_uri("page"),lang(252,$_a),$H);$m->rollback();}}}$Rh=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(53).": $Rh",$n);$N=null;if(isset($Ug["insert"])||!support("table")){$N="";foreach((array)$_GET["where"]as$X){if($jd[$X["col"]]&&count($jd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$N.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($R,$N);if(!$e&&support("table"))echo"<p class='error'>".lang(253).($p?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($L,$e);$b->selectSearchPrint($Z,$e,$x);$b->selectOrderPrint($Bf,$e,$x);$b->selectLimitPrint($_);$b->selectLengthPrint($fi);$b->selectActionPrint($x);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$md=$g->result(count_rows($a,$Z,$ce,$sd));$E=floor(max(0,$md-1)/$_);}$fh=$L;$td=$sd;if(!$fh){$fh[]="*";$Gb=convert_fields($e,$p,$L);if($Gb)$fh[]=substr($Gb,2);}foreach($L
as$z=>$X){$o=$p[idf_unescape($X)];if($o&&($Ga=convert_field($o)))$fh[$z]="$Ga AS $X";}if(!$ce&&$Ji){foreach($Ji
as$z=>$X){$fh[]=idf_escape($z);if($td)$td[]=idf_escape($z);}}$H=$m->select($a,$fh,$Z,$td,$Bf,$_,$E,true);if(!$H)echo"<p class='error'>".error()."\n";else{if($y=="mssql"&&$E)$H->seek($_*$E);$yc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($E&&$y=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$_!=""&&$sd&&$ce&&$y=="sql")$md=$g->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(12)."\n";else{$Pa=$b->backwardKeys($a,$Rh);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$sd&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(254)."</a>");$Ye=array();$pd=array();reset($L);$Bg=1;foreach($K[0]as$z=>$X){if(!isset($Ji[$z])){$X=$_GET["columns"][key($L)];$o=$p[$L?($X?$X["col"]:current($L)):$z];$D=($o?$b->fieldName($o,$Bg):($X["fun"]?"*":$z));if($D!=""){$Bg++;$Ye[$z]=$D;$d=idf_escape($z);$Gd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($z);$dc="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($z))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Gd.($Bf[0]==$d||$Bf[0]==$z||(!$Bf&&$ce&&$sd[0]==$d)?$dc:'')).'">';echo
apply_sql_function($X["fun"],$D)."</a>";echo"<span class='column hidden'>","<a href='".h($Gd.$dc)."' title='".lang(59)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(56).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($z)."');");}echo"</span>";}$pd[$z]=$X["fun"];next($L);}}$xe=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$z=>$X)$xe[$z]=max($xe[$z],min(40,strlen(utf8_decode($X))));}}echo($Pa?"<th>".lang(255):"")."</thead>\n";if(is_ajax()){if($_%2==1&&$E%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($K,$jd)as$Xe=>$J){$Gi=unique_array($K[$Xe],$x);if(!$Gi){$Gi=array();foreach($K[$Xe]as$z=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$z))$Gi[$z]=$X;}}$Hi="";foreach($Gi
as$z=>$X){if(($y=="sql"||$y=="pgsql")&&preg_match('~char|text|enum|set~',$p[$z]["type"])&&strlen($X)>64){$z=(strpos($z,'(')?$z:idf_escape($z));$z="MD5(".($y!='sql'||preg_match("~^utf8~",$p[$z]["collation"])?$z:"CONVERT($z USING ".charset($g).")").")";$X=md5($X);}$Hi.="&".($X!==null?urlencode("where[".bracket_escape($z)."]")."=".urlencode($X):"null%5B%5D=".urlencode($z));}echo"<tr".odd().">".(!$sd&&$L?"":"<td>".checkbox("check[]",substr($Hi,1),in_array(substr($Hi,1),(array)$_POST["check"])).($ce||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Hi)."' class='edit'>".lang(256)."</a>"));foreach($J
as$z=>$X){if(isset($Ye[$z])){$o=$p[$z];$X=$m->value($X,$o);if($X!=""&&(!isset($yc[$z])||$yc[$z]!=""))$yc[$z]=(is_mail($X)?$Ye[$z]:"");$A="";if(preg_match('~blob|bytea|raw|file~',$o["type"])&&$X!="")$A=ME.'download='.urlencode($a).'&field='.urlencode($z).$Hi;if(!$A&&$X!==null){foreach((array)$jd[$z]as$r){if(count($jd[$z])==1||end($r["source"])==$z){$A="";foreach($r["source"]as$t=>$yh)$A.=where_link($t,$r["target"][$t],$K[$Xe][$yh]);$A=($r["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($r["db"]),ME):ME).'select='.urlencode($r["table"]).$A;if($r["ns"])$A=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($r["ns"]),$A);if(count($r["source"])==1)break;}}}if($z=="COUNT(*)"){$A=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Gi))$A.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($Gi
as$he=>$W)$A.=where_link($t++,$he,$W);}$X=select_value($X,$A,$o,$fi);$u=h("val[$Hi][".bracket_escape($z)."]");$Y=$_POST["val"][$Hi][bracket_escape($z)];$tc=!is_array($J[$z])&&is_utf8($X)&&$K[$Xe][$z]==$J[$z]&&!$pd[$z];$ei=preg_match('~text|lob~',$o["type"]);echo"<td id='$u'";if(($_GET["modify"]&&$tc)||$Y!==null){$xd=h($Y!==null?$Y:$J[$z]);echo">".($ei?"<textarea name='$u' cols='30' rows='".(substr_count($J[$z],"\n")+1)."'>$xd</textarea>":"<input name='$u' value='$xd' size='$xe[$z]'>");}else{$Ae=strpos($X,"<i>…</i>");echo" data-text='".($Ae?2:($ei?1:0))."'".($tc?"":" data-warning='".h(lang(257))."'").">$X</td>";}}}if($Pa)echo"<td>";$b->backwardKeysPrint($Pa,$K[$Xe]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($K||$E){$Ic=true;if($_GET["page"]!="last"){if($_==""||(count($K)<$_&&($K||!$E)))$md=($E?$E*$_:0)+count($K);elseif($y!="sql"||!$ce){$md=($ce?false:found_rows($R,$Z));if($md<max(1e4,2*($E+1)*$_))$md=reset(slow_query(count_rows($a,$Z,$ce,$sd)));else$Ic=false;}}$Pf=($_!=""&&($md===false||$md>$_||$E));if($Pf){echo(($md===false?count($K)+1:$md-$E*$_)>$_?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(258).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$_).", '".lang(259)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$E){if($Pf){$Ie=($md===false?$E+(count($K)>=$_?2:1):floor(($md-1)/$_));echo"<fieldset>";if($y!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(260)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(260)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($t=max(1,$E-4);$t<min($Ie,$E+5);$t++)echo
pagination($t,$E);if($Ie>0){echo($E+5<$Ie?" …":""),($Ic&&$md!==false?pagination($Ie,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Ie'>".lang(261)."</a>");}}else{echo"<legend>".lang(260)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Ie>$E?pagination($E+1,$E).($Ie>$E+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(262)."</legend>";$ic=($Ic?"":"~ ").$md;echo
checkbox("all",1,0,($md!==false?($Ic?"":"~ ").lang(150,$md):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$ic' : checked); selectCount('selected2', this.checked || !checked ? '$ic' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(254),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(250).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(126),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(246),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$kd=$b->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($kd['sql']);break;}}if($kd){print_fieldset("export",lang(73)." <span id='selected2'></span>");$Mf=$b->dumpOutput();echo($Mf?html_select("output",$Mf,$za["output"])." ":""),html_select("format",$kd,$za["format"])," <input type='submit' name='export' value='".lang(73)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($yc,'strlen'),$e);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(72)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$za["format"],1);echo" <input type='submit' name='import' value='".lang(72)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$qi'>\n","</form>\n",(!$sd&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$O=isset($_GET["status"]);page_header($O?lang(118):lang(117));$Xi=($O?show_status():show_variables());if(!$Xi)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($Xi
as$z=>$X){echo"<tr>","<th><code class='jush-".$y.($O?"status":"set")."'>".h($z)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Oh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$D=>$R){json_row("Comment-$D",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$z)json_row("$z-$D",h($R[$z]));foreach($Oh+array("Auto_increment"=>0,"Rows"=>0)as$z=>$X){if($R[$z]!=""){$X=format_number($R[$z]);json_row("$z-$D",($z=="Rows"&&$X&&$R["Engine"]==($Ah=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Oh[$z]))$Oh[$z]+=($R["Engine"]!="InnoDB"||$z!="Data_free"?$R[$z]:0);}elseif(array_key_exists($z,$R))json_row("$z-$D");}}}foreach($Oh
as$z=>$X)json_row("sum-$z",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$g->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$l=>$X){json_row("tables-$l",$X);json_row("size-$l",db_size($l));}json_row("");}exit;}else{$Xh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Xh&&!$n&&!$_POST["search"]){$H=true;$Ne="";if($y=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$H=truncate_tables($_POST["tables"]);$Ne=lang(263);}elseif($_POST["move"]){$H=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ne=lang(264);}elseif($_POST["copy"]){$H=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ne=lang(265);}elseif($_POST["drop"]){if($_POST["views"])$H=drop_views($_POST["views"]);if($H&&$_POST["tables"])$H=drop_tables($_POST["tables"]);$Ne=lang(266);}elseif($y!="sql"){$H=($y=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Ne=lang(267);}elseif(!$_POST["tables"])$Ne=lang(9);elseif($H=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($J=$H->fetch_assoc())$Ne.="<b>".h($J["Table"])."</b>: ".h($J["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Ne,$H);}page_header(($_GET["ns"]==""?lang(37).": ".h(DB):lang(77).": ".h($_GET["ns"])),$n,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(268)."</h3>\n";$Wh=tables_list();if(!$Wh)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(269)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(56)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]="LIKE %%";search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(131),'<td>'.lang(270).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(122).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(271).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(272).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(273).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(51).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(274).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(50).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$S=0;foreach($Wh
as$D=>$T){$aj=($T!==null&&!preg_match('~table|sequence~i',$T));$u=h("Table-".$D);echo'<tr'.odd().'><td>'.checkbox(($aj?"views[]":"tables[]"),$D,in_array($D,$Xh,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($D)."' title='".lang(42)."' id='$u'>".h($D).'</a>':h($D));if($aj){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($D).'" title="'.lang(43).'">'.(preg_match('~materialized~i',$T)?lang(129):lang(130)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($D).'" title="'.lang(41).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(44)),"Index_length"=>array("indexes",lang(133)),"Data_free"=>array("edit",lang(45)),"Auto_increment"=>array("auto_increment=1&create",lang(44)),"Rows"=>array("select",lang(41)),)as$z=>$A){$u=" id='$z-".h($D)."'";echo($A?"<td align='right'>".(support("table")||$z=="Rows"||(support("indexes")&&$z!="Data_length")?"<a href='".h(ME."$A[0]=").urlencode($D)."'$u title='$A[1]'>?</a>":"<span$u>?</span>"):"<td id='$z-".h($D)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($D)."'>":"");}echo"<tr><td><th>".lang(247,count($Wh)),"<td>".h($y=="sql"?$g->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$z)echo"<td align='right' id='sum-$z'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Ui="<input type='submit' value='".lang(275)."'> ".on_help("'VACUUM'");$yf="<input type='submit' name='optimize' value='".lang(276)."'> ".on_help($y=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>".($y=="sqlite"?$Ui:($y=="pgsql"?$Ui.$yf:($y=="sql"?"<input type='submit' value='".lang(277)."'> ".on_help("'ANALYZE TABLE'").$yf."<input type='submit' name='check' value='".lang(278)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(279)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(280)."'> ".on_help($y=="sqlite"?"'DELETE'":"'TRUNCATE".($y=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(127)."'>".on_help("'DROP TABLE'").confirm()."\n";$k=(support("scheme")?$b->schemas():$b->databases());if(count($k)!=1&&$y!="sqlite"){$l=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(281).": ",($k?html_select("target",$k,$l):'<input name="target" value="'.h($l).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(282)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(283)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(284)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$qi'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo'<p class="links"><a href="'.h(ME).'create=">'.lang(74)."</a>\n",(support("view")?'<a href="'.h(ME).'view=">'.lang(204)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(143)."</h3>\n";$Yg=routines();if($Yg){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(183).'<td>'.lang(49).'<td>'.lang(221)."<td></thead>\n";odd('');foreach($Yg
as$J){$D=($J["SPECIFIC_NAME"]==$J["ROUTINE_NAME"]?"":"&name=".urlencode($J["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($J["SPECIFIC_NAME"]).$D).'">'.h($J["ROUTINE_NAME"]).'</a>','<td>'.h($J["ROUTINE_TYPE"]),'<td>'.h($J["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($J["SPECIFIC_NAME"]).$D).'">'.lang(136)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(220).'</a>':'').'<a href="'.h(ME).'function=">'.lang(219)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(285)."</h3>\n";$mh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($mh){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."</thead>\n";odd('');foreach($mh
as$X)echo"<tr".odd()."><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(226)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(26)."</h3>\n";$Si=types();if($Si){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."</thead>\n";odd('');foreach($Si
as$X)echo"<tr".odd()."><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(230)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(144)."</h3>\n";$K=get_rows("SHOW EVENTS");if($K){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."<td>".lang(286)."<td>".lang(210)."<td>".lang(211)."<td></thead>\n";foreach($K
as$J){echo"<tr>","<th>".h($J["Name"]),"<td>".($J["Execute at"]?lang(287)."<td>".$J["Execute at"]:lang(212)." ".$J["Interval value"]." ".$J["Interval field"]."<td>$J[Starts]"),"<td>$J[Ends]",'<td><a href="'.h(ME).'event='.urlencode($J["Name"]).'">'.lang(136).'</a>';}echo"</table>\n";$Gc=$g->result("SELECT @@event_scheduler");if($Gc&&$Gc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Gc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(209)."</a>\n";}if($Wh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();
