<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Services\FaviconsGeneratorService;

final class InitDefaultFavicon extends Migration
{
    public function up(): void
    {
        $files = [
            'android-chrome-192x192.png',
            'android-chrome-512x512.png',
            'apple-touch-icon.png',
            'favicon-16x16.png',
            'favicon-32x32.png',
            'favicon-48x48.png',
            'favicon.ico',
            'site.webmanifest',
        ];

        foreach ($files as $file) {
            $origin = cms_base_path('themes/custom/inside-drupal-theme/assets/app-logo/'.$file);
            $dest = storage_path('app/'.FaviconsGeneratorService::PATH.'/'.$file);

            if (file_exists($origin)) {
                copy($origin, $dest);
            }
        }
    }
}
