<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddEmailLogoFieldInSettings extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(
            ['key' => 'email_logo', 'group' => 'email'],
            ['value' => null]
        );
    }

    public function down(): void
    {
        Setting::where(
            ['key' => 'email_logo', 'group' => 'email']
        )->delete();
    }
}
