<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;

class AddListingTypeOption extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach (InsideSchema::getContentTypes() as $content) {
            $options = InsideSchema::getModelOptions($content);

            if (array_key_exists('permissible', $options) && $options['permissible']) {
                $listing_type = array_key_exists('categorizable', $options) && $options['categorizable'] ? 'taxo' : 'content';
            } else {
                $listing_type = 'hidden';
            }
            InsideSchema::setModelOption($content, 'listing_type', $listing_type);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
