<?php

use Inside\Settings\Models\Setting;

return [
    'driver' => setting('email', 'email_sending_enabled', false) ? env('MAIL_DRIVER', 'smtp') : 'log',
    'host' => env('MAIL_HOST', 'mailhog'),
    'port' => env('MAIL_PORT', 1025),
    'from' => [
        'address' => setting('email', 'from_address', env('MAIL_FROM_ADDRESS', env('APP_CODE', 'no-reply').'@maecia.com')),
        'name' => setting('email', 'from_name', env('MAIL_FROM_NAME', 'Intranet '.env('APP_CODE', 'Inside'))),
    ],
    'username' => env('MAIL_USERNAME'),
    'password' => env('MAIL_PASSWORD'),
    'sendmail' => env('MAIL_SENDMAIL', '/usr/sbin/sendmail -bs'),
    'encryption' => env('MAIL_ENCRYPTION', null),
    'markdown' => [
        'theme' => 'default',
        'paths' => [
            back_path('resources/views'),
            resource_path('custom/views'),
            back_path('resources/views/vendor/mail'),
            resource_path('custom/views/vendor/mail'),
        ],
    ],
    'colors' => [
        'header_border' => env(
            'MAIL_HEADER_BORDER_COLOR',
            setting('general', 'color_secondary', env('WEBAPP_COLOR', '#fbb3a7'))
        ),
        'button' => setting('general', 'color_primary') ?? env('MAIL_BUTTON_COLOR', setting('_theme', 'colorPrimary', env('WEBAPP_COLOR', '#fbb3a7'))),
    ],
    'logo' => env('MAIL_LOGO', get_mail_logo()),
];
