<?php

$local = storage_path('app');
if (config('app.app_storage_path')) {
    $local = cms_base_path(str_replace('/', DIRECTORY_SEPARATOR, config('app.app_storage_path')));
}

$localPrivateFilePermission = config('app.disable_protected_files', false) ? 0664 : 0660;
$localPrivateDirPermission = config('app.disable_protected_files', false) ? 0775 : 0770;

return [
    'default' => env('FILESYSTEM_DRIVER', 'local'),
    'cloud'   => env('FILESYSTEM_CLOUD', 's3'),
    'disks'   => [
        'local'     => [
            'driver'      => 'local',
            'root'        => $local,
            'url'         => env('APP_URL').'/files',
            'permissions' => [
                'file' => [
                    'public'  => 0664,
                    'private' => $localPrivateFilePermission,
                ],
                'dir'  => [
                    'public'  => 0775,
                    'private' => $localPrivateDirPermission,
                ],
            ],
        ],
        'protected' => [
            'driver'     => 'local',
            'root'       => $local.'/protected',
            'url'        => env('APP_URL').'/protected_files',
            'visibility' => 'public',
        ],
        'assets'    => [
            'driver'     => 'local',
            'visibility' => 'public',
            'root'       => $local.'/assets',
            'url'        => env('APP_URL').'/assets',
        ],
        'public'    => [
            'driver'     => 'local',
            'root'       => $local.'/public',
            'url'        => env('APP_URL').'/images',
            'visibility' => 'public',
        ],
        'wysiwyg_images' => [
            'driver' => 'local',
            'root' => $local.'/wysiwyg/images/',
            'url' => env('APP_URL').'/wysiwyg/images/',
            'permissions' => [
                'file' => [
                    'public' => 0664,
                    'private' => $localPrivateFilePermission,
                ],
                'dir' => [
                    'public' => 0775,
                    'private' => $localPrivateDirPermission,
                ],
            ],
        ],
        's3'        => [
            'driver' => 's3',
            'key'    => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url'    => env('AWS_URL'),
        ],
    ],
];
