<?php

return [
    'defaults'        => [
        'guard'     => 'api',
        'passwords' => 'users',
    ],
    'guards'          => [
        'api' => [
            'driver'   => 'api',
            'provider' => 'users',
        ],
        'jwt' => [
            'driver'   => 'jwt',
            'provider' => 'clients',
        ],
    ],
    'providers'       => [
        'users'   => [
            'driver' => 'eloquent',
            'model'  => Inside\Authentication\Models\User::class,
        ],
        'clients' => [
            'driver' => 'eloquent',
            'model'  => Inside\Authentication\Models\ApplicationClient::class,
        ],
    ],
    'passwords'       => [
        'users' => [
            'provider' => 'users',
            'table'    => 'inside_password_resets',
            'expire'   => env('INSIDE_PASSWORD_RESET_EXPIRE', 7 * 24 * 60),
            'throttle' => env('INSIDE_PASSWORD_RESET_THROTTLE', 7 * 24 * 60),
        ],
        'users_welcome' => [
            'provider' => 'users',
            'table' => 'inside_password_resets',
            'expire' => env('INSIDE_PASSWORD_CREATE_EXPIRE', 7 * 24 * 60),
            'throttle' => env('INSIDE_PASSWORD_CREATE_THROTTLE', 7 * 24 * 60),
        ],
    ],
    'login_throttles' => [
        'max_attempts'  => env('INSIDE_LOGIN_THROTTLES_MAX_ATTEMPTS', 5),
        'decay_minutes' => env('INSIDE_LOGIN_THROTTLES_DECAY_MINUTES', 30),
    ],
];
