<?php

use Inside\Kernel\Environment\Facades\AppEnvironment;

return [
    'technical_mail' => 'technique@maecia.com',
    'env' => env('APP_ENV', 'production'),
    'debug' => env('APP_DEBUG', false),
    'url' => env('APP_URL', 'http://localhost'),
    'timezone' => 'UTC',
    'default_user_timezone' => 'Europe/Paris',
    'key' => env('APP_KEY', 'SomeRandomString!!!'),
    'newsletter_key' => env('APP_NEWSLETTER_KEY', env('APP_KEY', 'SomeRandomString!!!')),
    'cipher' => 'AES-256-CBC',
    'locale' => env('APP_LOCALE', 'fr'),
    'fallback_locale' => env('APP_FALLBACK_LOCALE', 'fr'),
    'name' => env('APP_NAME', 'Inside'),
    'workers' => env('APP_WORKERS', preg_match('/intranet-inside\.com/', env('APP_URL')) ? 1 : 3),
    'code' => env('APP_CODE', 'inside'),
    'secured_email_validation' => env('SECURED_EMAIL_VALIDATION', false),
    'debugging_events' => env('INSIDE_DEBUGING_EVENTS', false),
    'debug_blacklist' => [
        '_COOKIE' => array_keys($_COOKIE),
        '_SERVER' => array_keys($_SERVER),
        '_ENV' => array_keys($_ENV),
        '_POST' => [
            'password',
        ],
    ],
    'log_rotate' => intval(env('LOG_ROTATE', 15)),
    'disable_protected_files' => AppEnvironment::isProtectedFilesDisabled(),
    'app_storage_path' => config('app.app_storage_path', 'storage/app'),
];
