<?php

namespace Inside\Validation;

trait ValidateRequests
{
    /**
     * validate data $data
     *
     * @param array $data
     * @param array $rules
     * @param array $messages
     * @param array $customAttributes
     * @return array
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function validateData(array $data, array $rules, array $messages = [], array $customAttributes = []): array
    {
        $factory = $this->getValidationFactory();
        $factory->resolver(
            function ($translator, $data, $rules, $messages, $customAttributes) {
                return new Validator($translator, $data, $rules, $messages, $customAttributes);
            }
        );

        return $factory->make(
            $data,
            $rules,
            $messages,
            $customAttributes
        )->validate();
    }

    /**
     * Get validation factory
     *
     * @return Validator
     */
    protected function getValidationFactory()
    {
        return app('validator');
    }
}
