<?php

namespace Inside\Support;

use Illuminate\Support\Facades\File;
use Inside\Application;
use PharIo\Version\InvalidVersionException;
use PHLAK\SemVer;
use Symfony\Component\Yaml\Yaml;

class Version
{
    public function __construct(
        protected Application $app
    ) {
    }

    public function get(): object
    {
//        $version = $this->getVersionFromInsideDashboard();
//        if ($version !== null) {
//            return $version;
//        }
//
        $content = (object) Yaml::parseFile(cms_base_path('version.yml'));

        return (object) $content->version;
    }

    protected function getVersionFromInsideDashboard(): ?object
    {
        $version = null;
        // Does inside.json exists ?
        if (File::exists(cms_base_path('inside.json'))) {
            // Load from phlak/semver
            $insideInfo = json_decode(file_get_contents(cms_base_path('inside.json')), true);
            $instance = $insideInfo['instance'] ?? null;
            $environment = $insideInfo['environment'] ?? null;
            $installedVersion = $insideInfo['installed-version'] ?? null;
            $forcedBranch = $insideInfo['forced-branch'] ?? null;
            $frontOnly = $insideInfo['front-only'] ?? false;
            if ($installedVersion === null) {
                return null; // Dashboard installation not correct
            }
            if ($frontOnly) {
                return null; // front only, back is not really relevant
            }
            if ($instance !== config('app.code')) {
                return null; // Wrong inside.json
            }
            try {
                $version = new SemVer\Version($installedVersion);
                if ($environment === 'dev') {
                    $version->setPreRelease('dev');
                }
            } catch (SemVer\Exceptions\InvalidVersionException $e) {
                return null;
            }
        } else {
            try {
                $content = (object) Yaml::parseFile(cms_base_path('version.yml'));
                $version = (object) $content->version;
            } catch (\Exception $e) {
                return null;
            }
        }
        $result = new \stdClass();
        $result->major = $version->major;
        $result->minor = $version->minor;
        $result->patch = $version->patch;
        if (! empty($version->preRelease)) {
            $result->patch .= '-'.$version->preRelease;
        }

        return $result;
    }
}
