<?php

namespace Inside\Support;

use ArrayIterator;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Inside\Contracts\Support\ValidatedData;
use stdClass;
use Traversable;

class ValidatedInput implements ValidatedData
{
    public function __construct(
        protected array $input
    ) {
    }

    /**
     * @param mixed $keys
     * @return array
     */
    public function only($keys): array
    {
        $results = [];

        $input = $this->input;

        $placeholder = new stdClass();

        foreach (is_array($keys) ? $keys : func_get_args() as $key) {
            $value = data_get($input, $key, $placeholder);

            if ($value !== $placeholder) {
                Arr::set($results, $key, $value);
            }
        }

        return $results;
    }

    /**
     * @param mixed $keys
     * @return array
     */
    public function except($keys): array
    {
        $keys = is_array($keys) ? $keys : func_get_args();

        $results = $this->input;

        Arr::forget($results, $keys);

        return $results;
    }

    public function merge(array $items): self
    {
        return new static(array_merge($this->input, $items));
    }

    public function collect(): Collection
    {
        return new Collection($this->input);
    }

    public function all(): array
    {
        return $this->input;
    }

    public function toArray(): array
    {
        return $this->all();
    }

    /**
     * @param mixed $name
     * @return mixed
     */
    public function __get($name)
    {
        return $this->input[$name];
    }

    /**
     * @param mixed $name
     * @param mixed $value
     * @return void
     */
    public function __set($name, $value): void
    {
        $this->input[$name] = $value;
    }

    /**
     * @param mixed $name
     * @return bool
     */
    public function __isset($name): bool
    {
        return isset($this->input[$name]);
    }

    /**
     * @param mixed $name
     * @return void
     */
    public function __unset($name): void
    {
        unset($this->input[$name]);
    }

    /**
     * @param mixed $offset
     * @return bool
     */
    public function offsetExists($offset): bool
    {
        return isset($this->input[$offset]);
    }

    /**
     * @param mixed $offset
     * @return mixed
     */
    public function offsetGet($offset): mixed
    {
        return $this->input[$offset];
    }

    /**
     * @param mixed|null $offset
     * @param mixed $value
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->input[] = $value;
        } else {
            $this->input[$offset] = $value;
        }
    }

    /**
     * @param $offset
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->input[$offset]);
    }

    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->input);
    }
}
