<?php

namespace Inside\Support\SerializableClosure\Signers;

use Inside\Contracts\Support\SerializerSigner;

class Hmac implements SerializerSigner
{
    /**
     * Creates a new signer instance.
     */
    public function __construct(
        protected string $secret
    ) {
    }

    /**
     * Sign the given serializable.
     */
    public function sign(string $serialized): array
    {
        return [
            'serializable' => $serialized,
            'hash' => base64_encode(hash_hmac('sha256', $serialized, $this->secret, true)),
        ];
    }

    /**
     * Verify the given signature.
     */
    public function verify(array $signature): bool
    {
        return hash_equals(base64_encode(
            hash_hmac('sha256', $signature['serializable'], $this->secret, true)
        ), $signature['hash']);
    }
}
