<?php

namespace Inside\Support\Requirements;

use Illuminate\Support\Facades\File;
use Inside\Support\InsidePackage;

class FrontRequirement
{
    /**
     * @param InsidePackage $package
     * @param \Closure $next
     * @param string $params
     * @return mixed
     */
    public function handle(InsidePackage $package, \Closure $next, string $params)
    {
        if (! File::exists(theme_path('assets/inside.installed.json'))) {
            // Front is not compiled yet !
            return false;
        }

        $frontModules = json_decode(file_get_contents(theme_path('assets/inside.installed.json')));
        if (is_null($frontModules) || ! in_array('inside-'.$params, $frontModules)) {
            return false;
        }

        return $next($package);
    }
}
