<?php

namespace Inside\Support;

use Jenssegers\Agent\Agent;

class AgentDetect extends Agent
{
    public function detectDevice(): array
    {
        return [
            'type'      => $this->getDeviceTypeName(),
            'model'     => $this->device(),
            'is_mobile' => $this->isMobile(),
            'is_robot'  => $this->isRobot(),
            'language'  => [
                'preference' => $this->getLanguagePreference(),
                'range'      => $this->getLanguageRange(),
            ],
        ];
    }

    public function getDeviceTypeName(): string
    {
        $type = 'unavailable';

        if ($this->isTablet()) {
            $type = 'Tablet';
        } elseif ($this->isPhone()) {
            $type = 'Phone';
        } elseif ($this->isComputer()) {
            $type = 'Computer';
        }

        return $type;
    }

    public function isComputer(): bool
    {
        return ! $this->isMobile();
    }

    public function isPhone($userAgent = null, $httpHeaders = null): bool
    {
        return ! $this->isTablet() && ! $this->isComputer();
    }

    public function getLanguagePreference(): string
    {
        $languages = $this->languages();

        return count($languages) ? $languages[0] : 'en';
    }

    public function getLanguageRange(): string
    {
        return implode(',', $this->languages());
    }
}
