<?php

namespace Inside\Services\Monitor;

use Inside\Services\Monitor\Checkers\Checker;
use Inside\Services\Monitor\Checkers\CheckerInterface;

class Monitoring
{
    /**
     * @var array<string, CheckerInterface>
     */
    protected $checkers = [];

    /**
     * @param string|CheckerInterface $checker
     * @return void
     */
    public function register($checker)
    {
        if (! $checker instanceof CheckerInterface) {
            /** @var CheckerInterface $checker */
            $checker = new $checker();
        }

        if (array_key_exists($checkerName = get_class($checker), $this->checkers)) {
            return;
        }

        $this->checkers[$checkerName] = $checker;
    }

    public function getMonitorResult(array $filters = []): array
    {
        $checkers = [];
        foreach ($this->checkers as $checker) {
            if (empty($filters) || in_array($checker->getName(), $filters)) {
                $checkers[] = $checker;
            }
        }

        $result = [];
        foreach ($checkers as $checker) {
            $checker->prepareCheck($checkers);
            if ($checker->isSupported()) {
                $checker->runCheck();
                $result[$checker->getName()] = $checker->getCheckResult();
            }
        }

        return $result;
    }
}
