<?php

namespace Inside\Services\Monitor\Checkers;

class SystemChecker extends Checker implements CheckerInterface
{
    public function isSupported(): bool
    {
        return ! windows_os();
    }

    public function processRunCheck(): bool
    {
        /** @var array $loadAverage */
        $loadAverage = sys_getloadavg();
        $this->lastCheckData['load_average'] = $loadAverage;

        if (app()->environment() != 'production') {
            $execCores = (int) trim(shell_exec("grep -P '^processor' /proc/cpuinfo|wc -l") ?: '');
            $this->lastCheckData['cpu'] =
                round(($this->lastCheckData['load_average'][1]) / ($execCores + 1) * 100, 3).'%';
        }

        return true;
    }

    public function isHealthy(): bool
    {
        return true;
    }
}
