<?php

namespace Inside\Services\Monitor\Checkers;

use Faker\Factory;
use Illuminate\Support\Str;

class PublicAccessChecker extends Checker implements CheckerInterface
{
    use MakesHttpRequests;

    public function processRunCheck(): bool
    {
        $this->lastCheckData['public_endpoint_accessible'] = $this->getJson('api/v1/settings');
        $faker = Factory::create();
        $this->lastCheckData['login_should_fail'] = $this->post(
            'api/v1/authentication/login',
            [
                'email'    => $faker->email,
                'password' => Str::random(50),
            ]
        );

        return true;
    }

    public function isHealthy(): bool
    {
        return json_decode($this->lastCheckData['public_endpoint_accessible']['response']['system']['version'], true)
            !== null && $this->lastCheckData['login_should_fail']['code'] === 401;
    }
}
