<?php

namespace Inside\Services\Monitor\Checkers;

use Illuminate\Support\Str;

class PartitionChecker extends Checker implements CheckerInterface
{
    use HasCommand;
    use HasLimit;

    /**
     * @var int
     */
    protected $limit = 70;

    public function isSupported(): bool
    {
        return app()->environment() != 'production';
    }

    public function prepareCheck(array $checkers): void
    {
        parent::prepareCheck($checkers);

        $this->setCommand('df --block-size=1 . | tail -1 | awk \'{print $2 " " $4 " " $5}\'');
    }

    public function isHealthy(): bool
    {
        return isset($this->lastCheckData['disk_used_percent']) && $this->lastCheckData['disk_used_percent'] < ($this->getLimit() / 100.0);
    }

    public function processRunCheck(): bool
    {
        if (! $this->commandRun()) {
            $this->failing(' on ['.$this->getCommandResult().']');

            return false;
        }
        [$totalDiskSpace, $freeDiskSpace, $percentageUsedDiskSpace] = explode(' ', $this->getCommandResult());

        $this->lastCheckData['disk_free_space'] = $freeDiskSpace;
        $this->lastCheckData['disk_total_space'] = $totalDiskSpace;
        $this->lastCheckData['disk_used_percent'] = number_format((float) Str::before($percentageUsedDiskSpace, '%') / 100, 3);

        return true;
    }
}
