<?php

namespace Inside\Services\Monitor\Checkers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

trait HasLimit
{
    public function getLimit(): int
    {
        /** @var Request $request */
        $request = request();

        $key = 'MONITORING_'.Str::upper(Str::snake((new \ReflectionClass($this))->getShortName())).'_LIMIT';
        if ($request->has(Str::lower($key))) {
            return $request->get(Str::lower($key));
        }

        return env($key, $this->limit);
    }
}
