<?php

namespace Inside\Services\Monitor\Checkers;

class DiskChecker extends Checker implements CheckerInterface
{
    use HasLimit;

    /**
     * @var int
     */
    protected $limit = 70;

    public function isHealthy(): bool
    {
        return isset($this->lastCheckData['disk_used_percent']) &&
            $this->lastCheckData['disk_used_percent'] < ($this->getLimit() / 100.0);
    }

    public function processRunCheck(): bool
    {
        // Get free disk space
        $diskFreeSpace = disk_free_space(cms_base_path());
        if ($diskFreeSpace === false) {
            $this->failing('disk_free_space failed on ['.cms_base_path().']');

            return false;
        }
        $this->lastCheckData['disk_free_space'] = $diskFreeSpace;

        // Get total disk space
        $diskTotalSpace = disk_total_space(cms_base_path());
        if ($diskTotalSpace === false) {
            $this->failing('disk_total_space on ['.cms_base_path().']');

            return false;
        }
        $this->lastCheckData['disk_total_space'] = $diskTotalSpace;

        $this->lastCheckData['disk_used_percent'] =
            number_format(($diskTotalSpace - $diskFreeSpace) / $diskTotalSpace, 3);

        return true;
    }
}
