<?php

namespace Inside\Services;

use Inside\Application;
use Symfony\Component\HttpFoundation\Request as SymfonyRequest;

/**
 * Inside application service.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class InsideService
{
    /**
     * The unique instance
     */
    private static InsideService|null $_instance = null;

    private mixed $app;

    /**
     * Create a new Inside instance
     */
    public function __construct()
    {
        $this->app = require_once __DIR__.'/../../../bootstrap/app.php';
        if ($this->app === true) {
            // Inside already existing
            $this->app = app();
        } else {
            // Fresh new inside app, let's boot !
            $this->app->boot();
        }
    }

    /**
     * Run the inside application.
     *
     * @param SymfonyRequest|null $request
     * @return void
     */
    public function run(?SymfonyRequest $request = null): void
    {
        if ($this->app instanceof \Laravel\Lumen\Application) {
            $this->app->run($request);
        }
    }

    /**
     * Get the instance if already exist
     */
    public static function getInstance(): self
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}
