<?php

namespace Inside\Routing;

use Inside\Support\Str;
use Laravel\Lumen\Routing\Router as BaseRouter;

class Router extends BaseRouter
{
    public function setRoutes(array $routes): void
    {
        foreach ($routes as $route) {
            unset($route->key);
            $route = (array) $route;
            if ($this->actionIsSerializedClosure($route['action'])) {
                $route['action'][0] = unserialize($route['action']['uses'])->getClosure();
                unset($route['action']['uses']);
            }
            $this->addRoute($route['method'], $route['uri'], $route['action']);
        }
    }

    protected function actionIsSerializedClosure(array $action): bool
    {
        return is_string($action['uses']) && Str::startsWith($action['uses'], [
            'O:54:"Inside\\Support\\SerializableClosure\\SerializableClosure',
        ]) !== false;
    }
}
