<?php

namespace Inside\Providers;

use Illuminate\Console\Events\CommandStarting;
use Illuminate\Contracts\Queue\Factory as QueueFactoryContract;
use Inside\Events\Dispatcher;
use Inside\Listeners\AddInsideInfoOnCommands;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

class EventServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        CommandStarting::class => [
            AddInsideInfoOnCommands::class,
        ],
    ];

    public function register(): void
    {
        $this->app->singleton(
            'events',
            function ($app) {
                return (new Dispatcher($app))->setQueueResolver(
                    function () use ($app) {
                        return $app->make(QueueFactoryContract::class);
                    }
                );
            }
        );
    }
}
