<?php

namespace Inside;

use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\HtmlString;
use Illuminate\Support\Str;

class Mix
{
    /**
     * @param mixed $type
     * @param string $manifestDirectory
     * @return Collection
     * @throws Exception
     */
    public function __invoke($type, string $manifestDirectory = 'assets'): Collection
    {
        static $manifests = [];
        if ($manifestDirectory && ! Str::startsWith($manifestDirectory, '/')) {
            $manifestDirectory = "/{$manifestDirectory}";
        }
        $manifestPath = theme_path($manifestDirectory.'/inside-manifest.json');
        if (! isset($manifests[$manifestPath])) {
            if (! file_exists($manifestPath)) {
                throw new Exception('The Mix manifest does not exist.');
            }
            $manifests[$manifestPath] = json_decode(file_get_contents($manifestPath), true);
        }
        $manifest = $manifests[$manifestPath];

        if (! isset($manifest[$type])) {
            $exception = new Exception("Unable to locate Mix type: {$type}.");
            if (! app('config')->get('app.debug')) {
                // report($exception); // TODO remplacer/recoder report()
                return collect();
            } else {
                throw $exception;
            }
        }

        return collect($manifest[$type])->filter(
            function ($path) {
                return ! empty($path);
            }
        )->transform(
            function ($path) {
                if (isset($path) && $path[0] != '/') {
                    $path = '/'.$path;
                }

                return new HtmlString(app('config')->get('app.url').$path);
            }
        );
    }
}
