<?php

namespace Inside\Listeners;

use Illuminate\Console\Events\CommandStarting;
use Illuminate\Support\Facades\App;
use Inside\Facades\Inside;
use Inside\Facades\Version;
use Inside\Support\Str;
use stdClass;

class AddInsideInfoOnCommands
{
    public function handle(CommandStarting $event): void
    {
        if (! Inside::isInstalled() || ! Str::startsWith($event->command, 'inside:') || ! App::runningInConsole()) {
            return;
        }
        $version = $this->getVersion();
        $event->output?->writeln(
            'Inside v2 - <fg=cyan>'.config('app.code').'</> ('.
            '<fg=magenta> '.$version->major.'.'.$version->minor.'.'.$version->patch.' </>'.
            ')'
        );
        $event->output?->writeln('<fg=white>'.str_repeat('-', 80).'</>');
    }

    protected function getVersion(): stdClass
    {
        $version = json_decode(setting('system', 'version', '{"major": 0, "minor": 0, "patch": 0}'));
        if (! isset($version->major) || ! isset($version->minor) || ! isset($version->patch)) {
            $version = Version::get();
            setting('system', ['version' => json_encode($version)]);
            $version = json_decode(setting('system', 'version', '{}'));
        }

        return $version;
    }
}
