<?php

namespace Inside\Jobs;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Carbon;

/**
 * Class TmpCleaner
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TmpCleaner extends Job
{
    /**
     * @var Filesystem
     */
    protected $fileSystem;

    /**
     * @var string
     */
    protected $tempDirectory = 'tmp';

    /**
     * @var Carbon
     */
    protected $timeInPast;

    public function __construct()
    {
        $this->fileSystem = new Filesystem();
        $this->timeInPast = Carbon::now()->subDay();
    }

    public function handle(): void
    {
        collect($this->fileSystem->files(storage_path($this->tempDirectory), true))->filter(
            function ($file) {
                return get_date((int) filemtime($file))?->lt($this->timeInPast);
            }
        )->each(
            function ($file) {
                $this->fileSystem->delete($file);
            }
        );
    }
}
