<?php

namespace Inside\Jobs;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Testing\Fakes\MailFake;
use Inside\Authentication\Models\User;
use Inside\Mail\InsideMail;

/**
 * Class TestMail
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TestMail extends Job
{
    /**
     * @var User
     */
    public $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function handle(): void
    {
        // Send a fake mail
        Mail::to($this->user->email)->send(new InsideMail());
    }

    public function failed(\Exception $exception): void
    {
        Log::error('TestMail job failed');
    }
}
