<?php

namespace Inside\Jobs\Queue\Connectors;

use Inside\Jobs\Queue\RedisQueue;

class RedisConnector extends \Illuminate\Queue\Connectors\RedisConnector
{
    public function connect(array $config): RedisQueue
    {
        return new RedisQueue(
            $this->redis,
            $config['queue'],
            $config['connection'] ?? $this->connection,
            $config['retry_after'] ?? 60
        );
    }
}
