<?php

namespace Inside\Jobs;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Carbon;
use Inside\Jobs\Job;

/**
 * Class LogCleaner
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class LogCleaner extends Job
{
    protected Filesystem$fileSystem;

    public function __construct()
    {
        $this->fileSystem = new Filesystem();
    }

    /**
     * Clean old logs
     */
    public function handle(): void
    {
        $logFiles = collect(
            $this->fileSystem->allFiles(cms_base_path(env('APP_LOG_PATH', 'storage/logs')))
        )->sortBy('mtime');

        $before = Carbon::today()->subDays(config('app.log_rotate', 15));

        $logFiles->each(
            function ($file) use ($before) {
                $matches = [];
                // Only keep inside & imports logs for X days ( scheduler, should be delete )
                if (preg_match('/([0-9]{4}-[0-9]{2}-[0-9]{2})-(inside|import)\.log$/is', $file->getFilename(), $matches)) {
                    $date = get_date($matches[1], 'Y-m-d');
                    if ($date && $date->isAfter($before)) {
                        return;
                    }
                }

                $this->fileSystem->delete($file);
            }
        );
    }
}
