<?php

namespace Inside\Http\Middleware;

class TrimStrings extends TransformsRequest
{
    /**
     * The attributes that should not be trimmed.
     */
    protected array $except = [//
    ];

    /**
     * Transform the given value.
     */
    protected function transform(string $key, mixed $value): mixed
    {
        if (in_array($key, $this->except, true)) {
            return $value;
        }

        return is_string($value) ? trim($value) : $value;
    }
}
