<?php

namespace Inside\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Inside\Content\Facades\ContentHelper;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class TransformResponseAndRequest
 */
abstract class TransformResponseAndRequest
{
    protected array $paths = [];

    /**
     * @var null|array
     * @deprecated use $paths
     */
    protected $pathes = null;

    public function __construct()
    {
        if (empty($this->paths) && is_array($this->pathes)) {
            $this->paths = $this->pathes;
        }
    }

    /**
     * handle things
     */
    public function handle(Request $request, Closure $next): mixed
    {
        if (isset($this->paths[$request->getMethod()])) {
            foreach ($this->paths[$request->getMethod()] as $match) {
                $matches = [];
                if (strlen($match) > 2 && $match[0] === '#'
                    && preg_match(
                        $match,
                        $request->path(),
                        $matches
                    ) > 0
                ) {
                    $response = $next($this->patchRequest($request));
                    if ($response instanceof Response && $response->getStatusCode() != 200) {
                        return $response;
                    }

                    return $this->patch($request, $response, $matches);
                } elseif ($match === $request->path()) {
                    $response = $next($this->patchRequest($request));
                    if ($response instanceof Response && $response->getStatusCode() != 200) {
                        return $response;
                    }

                    return $this->patch($request, $response);
                }
            }
        }

        return $next($request);
    }

    /**
     * Patch request
     */
    protected function patchRequest(Request $request): Request
    {
        return $request;
    }

    /**
     * Patch response
     */
    abstract protected function patch(Request $request, mixed $response, array $data = []): mixed;

    /**
     * Get fields or $key field from request
     *
     * @param Request $request
     * @param string|null $key
     * @return array|mixed|string[]|null
     */
    protected function fields(Request $request, ?string $key = null): mixed
    {
        if (empty($fields = ContentHelper::extractFieldsInputFromRequest($request))) {
            return [];
        }
        $result = [];
        foreach ($fields as $field) {
            if (is_array($field)) {
                $result[array_key_first($field)] = Arr::first($field);
            } else {
                $result[$field] = ['*'];
            }
        }

        return is_string($key) ? ($result[$key] ?? null) : $fields;
    }
}
