<?php

namespace Inside\Http\Middleware\Headers;

use Closure;
use Illuminate\Http\Request;

/**
 * Service Worker middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceWorkerMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $headers = [
            'Service-Worker-Allowed' => '/',
        ];

        $response = $next($request);

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value);
        }

        return $response;
    }
}
