<?php

namespace Inside\Http\Middleware\Headers;

use Closure;
use Illuminate\Http\Request;
use Inside\Kernel\Environment\EnvironmentService;

/**
 * CORS middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AccessControlMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        if (! (new EnvironmentService())->isDebugEnabled()) {
            $headers = [
                'Access-Control-Allow-Origin' => request()->getSchemeAndHttpHost(),
                'Access-Control-Allow-Credentials' => 'true',
                'Access-Control-Allow-Methods' => 'GET, POST, PATCH, PUT, DELETE, OPTIONS',

            ];
        } else {
            $headers = [
                'Access-Control-Allow-Origin' => '*',
                'Access-Control-Allow-Methods' => 'GET, POST, PATCH, PUT, DELETE, OPTIONS',
                'Access-Control-Allow-Headers' => 'Content-Type, Authorization, Api-Token',
            ];
        }

        if ($request->isMethod('OPTIONS')) {
            return response()->json('{"method":"OPTIONS"}', 200, $headers);
        }

        $response = $next($request);

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value);
        }

        return $response;
    }
}
