<?php

namespace Inside\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ConvertEmptyStringsToNull extends TransformsRequest
{
    /**
     * @var Closure[]
     */
    protected static array $skipCallbacks = [];

    public function handle(Request $request, Closure $next): mixed
    {
        foreach (static::$skipCallbacks as $callback) {
            if ($callback($request)) {
                return $next($request);
            }
        }

        return parent::handle($request, $next);
    }

    protected function transform(string $key, mixed $value): mixed
    {
        return $value === '' ? null : $value;
    }

    public static function skipWhen(Closure $callback): void
    {
        static::$skipCallbacks[] = $callback;
    }
}
