<?php

namespace Inside\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Inside\Application;
use Inside\Exceptions\MaintenanceModeException;

/**
 * Class CheckForFrontendRebuild
 *
 * Make inside in maintenance mode if frontend is not build
 */
class CheckForFrontendRebuild
{
    public function __construct(
        protected Application $app
    ) {
    }

    public function handle(Request $request, Closure $next): mixed
    {
        if (! $this->isApiRoute($request) && ! file_exists(theme_path('assets/inside-manifest.json'))) {
            throw new MaintenanceModeException(Carbon::now()->getTimestamp());
        }

        return $next($request);
    }

    private function isApiRoute(Request $request): bool
    {
        return Str::startsWith($request->path(), 'api/v1');
    }
}
