<?php

namespace Inside\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Exceptions\AuthenticationException;
use Inside\Authentication\Models\User;
use Inside\Facades\Monitor;
use Laravel\Lumen\Routing\Controller;

class MonitorController extends Controller
{
    public function check(Request $request): JsonResponse
    {
        /** @var User $application */
        $application = Auth::user();

        if ($application->name !== 'monitoring') {
            throw new AuthenticationException();
        }

        $filters = $request->get('filters', []);

        return response()->json(Monitor::getMonitorResult($filters));
    }

    public function yes(Request $request): JsonResponse
    {
        return response()->json(['yes' => 'ok']);
    }
}
