<?php

declare(strict_types=1);

namespace Inside\Http\Controllers;

use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Inside\Authentication\Facades\Authentication;
use Inside\Authentication\Models\User;
use Inside\Kernel\Authentication\Facades\SingleSingOnRedirection;
use Inside\Kernel\Authentication\StoreIntendedPathService;
use Laravel\Lumen\Routing\Controller;

final class Fallback extends Controller
{
    public function __invoke(Request $request, string $path): View|RedirectResponse
    {
        if (Str::startsWith($path, 'api/v1')) {
            abort(404, 'Wrong url');
        }

        $user = Authentication::getUserFromMagicCookie($request);

        if (array_key_exists('fromDrupal', $GLOBALS) && $GLOBALS['fromDrupal'] === true) {
            if (! is_null($user) && $user->hasRole('super_administrator')) {
                return redirect('/admin');
            }
        }

        if (is_null($user) && SingleSingOnRedirection::isProtected($request->getRequestUri()) && SingleSingOnRedirection::isEnabled()) {
            if (! StoreIntendedPathService::exists()) {
                StoreIntendedPathService::store($request->getRequestUri());
            }

            return redirect()->to(SingleSingOnRedirection::getLoginUrl());
        }

        return view('frontend.layout', []);
    }
}
