<?php

namespace Inside\Exceptions;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Arr;
use Illuminate\Support\HigherOrderTapProxy;
use Whoops\Handler\PrettyPageHandler;

class WhoopsHandler
{
    public function forDebug(): PrettyPageHandler
    {
        return tap(
            new PrettyPageHandler(),
            function ($handler) {
                $handler->handleUnconditionally(true);

                $this->registerApplicationPaths($handler)
                    ->registerBlacklist($handler)
                    ->registerEditor($handler);
            }
        );
    }

    protected function registerApplicationPaths(PrettyPageHandler $handler): self
    {
        $handler->setApplicationPaths(
            array_flip($this->directoriesExceptVendor())
        );

        return $this;
    }

    protected function directoriesExceptVendor(): array
    {
        return Arr::except(
            array_flip((new Filesystem())->directories(base_path())),
            [base_path('vendor')]
        );
    }

    protected function registerBlacklist(PrettyPageHandler $handler): self
    {
        foreach (config('app.debug_blacklist', []) as $key => $secrets) {
            foreach ($secrets as $secret) {
                $handler->blacklist($key, $secret);
            }
        }

        return $this;
    }

    protected function registerEditor(PrettyPageHandler $handler): self
    {
        if (config('app.editor', false)) {
            $handler->setEditor(config('app.editor'));
        }

        return $this;
    }
}
