<?php

namespace Inside\Exceptions;

use Exception;
use Illuminate\Support\Carbon;
use Symfony\Component\HttpKernel\Exception\ServiceUnavailableHttpException;

class MaintenanceModeException extends ServiceUnavailableHttpException
{
    /**
     * @var Carbon|null
     */
    public $wentDownAt;

    /**
     * @var int
     */
    public $retryAfter;

    /**
     * @var Carbon|null
     */
    public $willBeAvailableAt;

    /**
     * @param int $time
     * @param int|string|null $retryAfter
     * @param string|null $message
     * @param Exception|null $previous
     * @param int $code
     */
    public function __construct(int $time, $retryAfter = null, ?string $message = null, ?Exception $previous = null, int $code = 0)
    {
        parent::__construct($retryAfter, $message, $previous, $code);

        $this->wentDownAt = get_date($time);

        if ($retryAfter) {
            $this->retryAfter = (int) $retryAfter;

            $this->willBeAvailableAt =
                get_date($time)?->addRealSeconds((int) $this->retryAfter);
        }
    }
}
