<?php

namespace Inside\Exceptions;

use ErrorException;
use ParseError;
use Throwable;
use TypeError;

class FatalThrowableError extends FatalErrorException
{
    private string $originalClassName;

    public function __construct(Throwable $exception)
    {
        $this->originalClassName = get_class($exception);

        if ($exception instanceof ParseError) {
            $severity = E_PARSE;
        } elseif ($exception instanceof TypeError) {
            $severity = E_RECOVERABLE_ERROR;
        } else {
            $severity = E_ERROR;
        }

        ErrorException::__construct(
            $exception->getMessage(),
            $exception->getCode(),
            $severity,
            $exception->getFile(),
            $exception->getLine(),
            $exception->getPrevious()
        );

        $this->setTrace($exception->getTrace());
    }

    public function getOriginalClassName(): string
    {
        return $this->originalClassName;
    }
}
