<?php

namespace Inside\Events;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;

/**
 * Class PageVisited
 *
 * User visit page of url $path
 */
class PageVisited implements ShouldQueue
{
    use SerializesModels;
    use Dispatchable;

    public ?Authenticatable $user;

    /**
     * PageVisited constructor.
     */
    public function __construct(
        public string $path
    ) {
        $this->user = Auth::user();
    }
}
