<?php

namespace Inside\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Queue\SerializesModels;

class InsideIsGoingDown implements ShouldBroadcastNow
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function broadcastOn(): Channel
    {
        return new Channel('inside');
    }

    public function broadcastAs(): string
    {
        return 'inside.down';
    }

    public function broadcastWith(): array
    {
        return [
            'time' => now(),
        ];
    }
}
